program     CDEMO;
(**********************   CDEMO.PAS   ***********************************
*                                                                        *
*                Simple Demo Program for                                 *
*                       C M A T H                                        *
*                                                                        *
*       Copyright 1996-1999 by Martin Sander                             *
*                                                                        *
*       This sample program provides a very basic test                   *
*       for the correct installation of CMATH and for                    *
*       correct error handling.                                          *
*                                                                        *
**************************************************************************)

(*  The units search path must contain
    \YourCMATHDirectory\units;
    in addition to the compiler's default settings.
    For command-line compiles, this must be added in the files
    DCC32.CFG  or  BPC.CFG.

    Delphi:
       Compile on the command-line by typing: DCC32 -cc cdemo.pas
       Don't wonder about the math error message being displayed
       in a message box, rather than being printed to the console.
       This is because there is only one version of CMATH, simultaneously
       for GUI and console applications.
*)

{$E-} {$N+} {$D+}
uses CMATH {, VecLib};
{ if you got CMATH as a part of OptiVec, you must remove the comment braces
  around "VecLib" to "use" also Veclib! }

var  x, y: fComplex;
begin
    x.Re := 3;
    x.Im := 5;   {first method of initialization}
    fcplx( y, 0, 0 );  {second method of initialization}
    cf_sin( x, x );
    cf_inv( y, y );  { will produce an error message}
    writeln( 'The sine of  { 3.0, 5.0 } is {', x.Re, ', ', x.Im, '}' );
    writeln( 'Complex 1/0 situations yield {', y.Re, ', ', y.Im, '}' );
end.
