##############################################################################
#
#    File Killer by Jens Luedicke <morpheus@irs-net.com>
#    Copyright (C) 1999/2000  <Jens Luedicke>
#    "Fisher Yates Shuffle" by Perl Core FAQ
#
#    Web: http://www.irs-net.com/
#    Public-PGP-Keys: pgp-keys@irs-net.com <AUTORESPONDER>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# any later version.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL 
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR 
# OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
# ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR 
# OTHER DEALINGS IN THE SOFTWARE. 
#
##############################################################################

$version = "v 0.0.8 dev";
$year = "2000";

############## Messages to be displayed:

$message_code1 = "Error: File isn't readable or doesn't exist!\n";
$message_code2 = "Error: Your Recycle Bin is empty!\n";
$message_code3 = "Error: Can't find any $ARGV[0] - Files!\n";
$message_code4 = "Error: Can't find any files on floppy! Empty?\n";
$message_code5 = "Please insert floppy into drive A:\n";
$message_code6 = "Press <ENTER>";
$message_code7 = "Aborting...\n";
$message_code8 = "Starting the overwriting sequence...\n";
$message_code9 = "Deleting...";
$message_code10 = "Floppy overwritten!\n";
$message_code11 = "Overwriting...";
$message_code12 = "YOUR LAST CHANCE!! Continue?? (\[y\]es or \[n\]o) ";
$message_code13 = "Couldn't change to drive A:";

############## Script starts here:
use File::DosGlob 'glob';
srand(time());

if ($ARGV[0] eq "") {
system("cls");
&header("$version", "$year");
print <<PROGRAM_INFO;

Usage: kill [files] [-y]
            [-trash] [-y]
            [-floppy] [-y]

files:   filename.xxx: deletes/wipes a single file
         *.xxx:        deletes/wipes files with the given extension
         *.*:          deletes/wipes all files in the current directory
-trash:  Erases all files in the Win9X-Recycle Bin
-floppy: Erases all files on a floppy in drive A: and
         overwrites the floppy with 1,38 MB (1457664 bytes) of zeros
-y:      Disables confirmation question

PROGRAM_INFO
exit;

} elsif ($ARGV[0] eq "-c") {
	&smallheader("$version", "$year");
	&copyright;
	exit;

} elsif ($ARGV[0] eq "-w") {
	&smallheader("$version", "$year");
	&warranty;
	exit;

} elsif ($ARGV[0] eq "*.*") {
        &smallheader("$version", "$year");
        &filelist("$message_code3", "$message_code7");
        &command_line_arguments("$message_code7", "$message_code12");

        foreach $file (@flist) { &firststep("$file", "$message_code11"); }

} elsif ($ARGV[0] =~ /[\*\.]/) {
        &smallheader("$version", "$year");
        &file_list_2("$message_code3", "$message_code7");
        &command_line_arguments("$message_code7", "$message_code12");

        foreach $file (@flist) { &firststep("$file", "$message_code11"); }

} elsif ($ARGV[0] eq "-trash") {
	
		&smallheader("$version", "$year");
                &command_line_arguments("$message_code7", "$message_code12");

		chdir("\\RECYCLED");

                $INFO = glob "INFO";
                if (-w $INFO && -r $INFO) { } else
                {
                        print "$message_code2";
                        print "$message_code7";
                        exit;
                }

		system("attrib", "-a -h desktop.ini");
		rename("desktop.ini", "fk-trash.dat");

		&trashlist;

                foreach $file (@flist) { &firststep("$file", "$message_code11"); }

                $file = "INFO";
                &firststep("$file"); 

		rename("fk-trash.dat", "desktop.ini");
		system("attrib", "+a +h desktop.ini");

		exit;		

} elsif($ARGV[0] eq "-floppy") {

        &smallheader("$version", "$year");
        &command_line_arguments("$message_code7", "$message_code12");

                print "\n";
                print "$message_code5";
                print "$message_code6";
                <STDIN>;
                print "\n";

        die("$message_code13") unless chdir("A:\\");

        &floppyfiles("$message_code4", "$message_code7");

        foreach $file (@floppyfiles)
        {
                open(KILLFILE, ">$file");
                print KILLFILE "";
                close(KILLFILE);
                print "$message_code9 $file\n";
                unlink("$file");
        }
        print "$message_code8";
        open(TEMP, ">>A:\\temp");
        $size = 0;
        while($size<2847) {
                $size++;
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
                print TEMP "0000000000000000000000000000000000000000000000000000000000000000";
        }
        close(TEMP);
        open(KILLFILE, ">$file");
        print KILLFILE "";
        close(KILLFILE);
        unlink("A:\\temp");
        print "$message_code10";

} else {

	$file = $ARGV[0];
	chomp($file);

	if (-r $file && -w $file) {

		&smallheader("$version", "$year");
                &command_line_arguments("$message_code7", "$message_code12");
                &firststep("$file", "$message_code11");
		exit;

	} else {

		&smallheader("$version", "$year");
                print "$message_code1";
                print "$message_code7";
		exit;
        }
}

##############################################################################
# Sub-Routines:

sub command_line_arguments {

        if ($ARGV[1] eq "-y") { } else { &confirmation_question("$message_code7", "$message_code12"); }
}

sub confirmation_question {
print "\n";
print "$message_code12";

$yesno = <STDIN>;
chomp($yesno);

if ($yesno eq "y") { } elsif ($yesno eq "n") 
	{
        print "$message_code7";
	exit;
	}
}

sub filelist {

        @flist = glob "*";
        if ($flist[0] eq "")
        {
                print "$message_code3";
                print "$message_code7";
                exit;
        }
	return @flist;
}

sub file_list_2 {

        @flist = glob "$ARGV[0]";
        if ($flist[0] eq "")
        {
                print "$message_code3";
                print "$message_code7";
                exit;
        }
	return @flist;
}

sub trashlist {

	@flist = glob "D*.*";
	return @flist;
}

sub floppyfiles {

        @floppyfiles = glob "*";
        if($floppyfiles[0] eq "")
        {
                print "$message_code4";
                print "$message_code7";
                exit;
        }
}

sub firststep {

	 $attribs = "-r -s -a -h";
	 system("attrib", "$attribs $file");

	 ### Starting Overwriting sequence:
  	 &overcode;
         &overwriting("$file", "$message_code11","\@randomcode"); 
}

sub overwriting {

print "$message_code11 $file ";

        foreach $pass (@randomcode)
        {
                &fisher_yates_shuffle( \@randomcode );
                open(KILLFILE, ">$file");
                print KILLFILE $pass;
                close(KILLFILE);

                &fisher_yates_shuffle( \@randomcode );
                open(KILLFILE, ">>$file");
                print KILLFILE @randomcode;
                close(KILLFILE);

                print "";
	}

        open(KILLFILE, ">$file");
        print KILLFILE "";
        close(KILLFILE);

	### Deleting.....
        unlink("$file");
	print "\n";
}

sub fisher_yates_shuffle {
	my $randomcode = shift;
	my $i;
	for ($i = @$randomcode; --$i; ) {
		  my $j = int rand ($i+1);
		  next if $i == $j;
		  @$randomcode[$i,$j] = @$randomcode[$j,$i];
	  }
}

sub overcode {

        $bf1 = rand(10);
        $bf2 = rand(10);
        $bf3 = rand(10);
        $bf4 = rand(10);
        $p1 = "01010101 01010101 01010101 "; 
        $p2 = "10101010 10101010 10101010 "; 
        $p3 = "10010010 01001001 00100100 ";
        $p4 = "01001001 00100100 10010010 ";
        $p5 = "00100100 10010010 01001001 ";
        $p6 = "00000000 00000000 00000000 "; 
        $p7 = "00010001 00010001 00010001 ";  
        $p8 = "00100010 00100010 00100010 "; 
        $p9 = "00110011 00110011 00110011 "; 
        $p10 = "01000100 01000100 01000100 "; 
        $p11 = "01010101 01010101 01010101 "; 
        $p12 = "01100110 01100110 01100110 "; 
        $p13 = "01110111 01110111 01110111 "; 
        $p14 = "10001000 10001000 10001000 "; 
        $p15 = "10011001 10011001 10011001 "; 
        $p16 = "10101010 10101010 10101010 "; 
        $p17 = "10111011 10111011 10111011 "; 
        $p18 = "11001100 11001100 11001100 "; 
        $p19 = "11011101 11011101 11011101 "; 
        $p20 = "11101110 11101110 11101110 "; 
        $p21 = "11111111 11111111 11111111 "; 
        $p22 = "10010010 01001001 00100100 ";
        $p23 = "01001001 00100100 10010010 ";
        $p24 = "00100100 10010010 01001001 ";
        $p25 = "01101101 10110110 11011011 ";
        $p26 = "10110110 11011011 01101101 ";
        $p27 = "11011011 01101101 10110110 ";
        $bf5 = rand(10);
        $bf6 = rand(10);
        $bf7 = rand(10);
        $bf8 = rand(10);

@randomcode =
(
        "$bf1\n","$bf2\n","$bf3\n","$bf4\n",
        "$p1","$p2","$p3","$p4","$p5","$p6","$p7","$p8","$p9","$p10",
        "$p11","$p12","$p13","$p14","$p15","$p16","$p17","$p18","$p19",
        "$p20","$p21","$p22","$p23","$p24","$p25","$p26","$p27",
        "$bf5\n","$bf6\n","$bf7\n","$bf8\n"
);

return @randomcode;
}

sub header {
        print "\n";
        print "                         \n";
        print "                              \n";                         
        print "                      $version\n";                         
        print "copyright (C) $year by Jens Luedicke <morpheus\@irs-net.com>\n";
        print "File-Killer comes with ABSOLUTELY NO WARRANTY; for details type 'kill -w'.\n";
	print "This is free software, and you are welcome to redistribute it\n";
        print "under certain conditions; type 'kill -c' for details.\n\n";
}

sub smallheader {
        print "\n";
        print "                         \n";
        print "                              \n";                         
        print "                      $version\n";                         
        print "copyright (C) $year by Jens Luedicke <morpheus\@irs-net.com>\n";
}

sub copyright {
	print "This program is free software; you can redistribute it and/or modify\n";
	print "it under the terms of the GNU General Public License as published by\n";
	print "the Free Software Foundation; either version 2 of the License, or\n";
        print "any later version. See 'copying' for further details!\n";
}

sub warranty {
	print "THE SOFTWARE IS PROVIDED \"AS IS\", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\n"; 
	print "IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\n"; 
	print "FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL\n"; 
	print "THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR\n"; 
	print "OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,\n"; 
	print "ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR\n"; 
	print "OTHER DEALINGS IN THE SOFTWARE.\n"; 
}
