/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.Concept;
import Sav.Processor.Connecter;
import Sav.Processor.Core;
import Sav.Processor.Domain;
import Sav.Processor.Long1;
import Sav.Processor.Node;
import Sav.Processor.NonRecognizableConnectException;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Processor.Trace;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;

public class Association
implements Cloneable,
Observer {
    Core core;
    Node fixNode;
    Node conNode;
    Node seeNode;
    Node curNode;
    Trace fixTrace = new Trace();
    Trace conTrace = new Trace();
    Trace seeTrace = new Trace();
    Trace curTrace;
    Trace fixTraceEnd = this.fixTrace;
    Trace conTraceEnd = this.conTrace;
    Stack conRoute = new Stack();
    Stack seeRoute = new Stack();
    long state = -1L;
    int category = 57;
    int sense = 62;
    boolean absolute = false;

    public Association() {
        this.core = new Core();
        ++this.core.observation;
    }

    public Association(Core core) {
        this.core = core;
        ++core.observation;
    }

    public Association(File file) throws IOException {
        this(file, true);
    }

    public Association(File file, boolean bl) throws IOException {
        this.core = new Core(file.getPath(), bl);
        ++this.core.observation;
    }

    public Association(String string) throws IOException {
        this(string, true);
    }

    public Association(String string, String string2) throws IOException {
        this.init(string, string2, true);
    }

    public Association(String string, String string2, boolean bl) throws IOException {
        this.init(string, string2, bl);
    }

    public Association(String string, boolean bl) throws IOException {
        String string2;
        String string3;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = null;
            string2 = string;
        }
        this.init(string3, string2, bl);
    }

    public boolean absolutizeClass() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        return new Domain(this).absolutizeClass(true);
    }

    public boolean absolutizeClass(Association association) throws IOException {
        return this.absolutizeClass(association, association.category, association.sense);
    }

    public boolean absolutizeClass(Association association, int n) throws IOException {
        return this.absolutizeClass(association, n, association.sense);
    }

    public boolean absolutizeClass(Association association, int n, int n2) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        return new Domain(this, association).absolutizeClass(true, n, n2);
    }

    void accessSet() throws IOException {
        this.accession();
        if (this.seeNode != null) {
            return;
        }
        if (this.fixNode == null) {
            this.fixNode = this.core.node.setTrace(this.fixTrace);
        }
        if (this.conNode == null) {
            this.conNode = this.fixNode.setTrace(this.conTrace);
        }
        if (this.seeTrace.next == null) {
            this.seeNode = this.conNode;
        }
    }

    boolean accession() throws IOException {
        if (this.seeNode != null) {
            return true;
        }
        if (this.state == this.core.state) {
            return false;
        }
        this.state = this.core.state;
        if (this.fixNode == null) {
            this.fixNode = this.core.node.getTrace(this.fixTrace);
            if (this.fixNode == null) {
                return false;
            }
            this.core.addObserver(this);
        }
        if (this.conNode == null) {
            this.conNode = this.fixNode.getTrace(this.conTrace);
            if (this.conNode == null || this.conNode.deploy() == 0) {
                return false;
            }
        }
        if (this.seeNode == null) {
            this.seeNode = this.conNode.getTrace(this.seeTrace);
            if (this.seeNode == null || this.seeNode.deploy() == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean appendClassMean(Concept concept) throws IOException {
        return this.appendClassMean(concept, false, false, null);
    }

    public boolean appendClassMean(Concept concept, boolean bl) throws IOException {
        return this.appendClassMean(concept, bl, false, null);
    }

    public boolean appendClassMean(Concept concept, boolean bl, boolean bl2) throws IOException {
        return this.appendClassMean(concept, bl, bl2, null);
    }

    public boolean appendClassMean(Concept concept, boolean bl, boolean bl2, Association association) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        boolean bl3 = false;
        Long1 long1 = PN.initMemory();
        Concept concept2 = this.getFirst(56);
        while (concept2 != null) {
            if (!bl2 || !concept2.equals(concept)) {
                this.con();
                if (association != null) {
                    association.con(concept2);
                }
                bl3 |= this.appendClassMean1(concept, bl, bl2, association);
                this.uncon();
                if (association != null) {
                    association.uncon();
                }
                PN.controlMemory(long1, this, association);
            }
            concept2 = this.getNext(56);
        }
        return bl3;
    }

    boolean appendClassMean1(Concept concept, boolean bl, boolean bl2, Association association) throws IOException {
        boolean bl3 = false;
        boolean bl4 = false;
        Long1 long1 = PN.initMemory();
        if (this.hasConnect(57)) {
            this.con(57);
            Concept concept2 = this.getFirst(56);
            while (concept2 != null) {
                if (bl2 && concept2.equals(concept)) {
                    if (association != null) {
                        association.setConcept();
                    }
                    bl3 = true;
                } else {
                    this.con();
                    if (association != null) {
                        association.con(57).con(concept2);
                    }
                    bl4 |= this.appendClassMean1(concept, bl, bl2, association);
                    this.uncon();
                    if (association != null) {
                        association.uncon().uncon();
                    }
                }
                PN.controlMemory(long1, this, association);
                concept2 = this.getNext(56);
            }
            this.uncon();
        }
        if (this.hasConcept()) {
            if (!bl3) {
                this.setConnect(57, concept);
                if (association != null) {
                    association.setConcept();
                }
                bl4 |= true;
            }
            if (bl) {
                this.clearConcept();
            }
        }
        return bl4;
    }

    public Association clear() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession()) {
            this.conNode.clearSign();
            this.noteClear();
        }
        return this;
    }

    public Association clear(int n) throws IOException {
        return this.clear(n, this.absolute);
    }

    public Association clear(int n, boolean bl) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Domain domain = new Domain(this);
        domain.clear(n, bl);
        return this;
    }

    public Association clear(Association association) throws IOException {
        return this.clear(association, association.category, association.sense, association.absolute);
    }

    public Association clear(Association association, int n) throws IOException {
        return this.clear(association, n, association.sense, association.absolute);
    }

    public Association clear(Association association, int n, int n2) throws IOException {
        return this.clear(association, n, n2, association.absolute);
    }

    public Association clear(Association association, int n, int n2, boolean bl) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Domain domain = new Domain(this, association);
        domain.clear(n, n2, bl);
        return this;
    }

    public Association clear(Concept concept) throws IOException {
        Node node;
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession() && (node = this.conNode.getTrace(concept.identifier, 57)) != null && node.clearConcept()) {
            if (node.count == 0) {
                this.conNode.clearTrace(concept.identifier);
            }
            this.noteClear();
        }
        return this;
    }

    public Association clear(String string) throws IOException {
        return this.clear(new Concept(string));
    }

    public boolean clearConcept() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession() && this.conNode.clearConcept()) {
            this.noteClear();
            return true;
        }
        return false;
    }

    public boolean clearConnect() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession() && this.conNode.clearConnectNode()) {
            this.noteClear();
            return true;
        }
        return false;
    }

    public boolean clearConnect(int n) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Association.testConnect(n);
        if (this.accession() && this.conNode.clearConnectNode(n)) {
            this.noteClear();
            return true;
        }
        return false;
    }

    public boolean clearConnect(int n, Association association) throws IOException {
        return this.clearConnect(n, association, association.category, association.sense, association.absolute);
    }

    public boolean clearConnect(int n, Association association, int n2) throws IOException {
        return this.clearConnect(n, association, n2, association.sense, association.absolute);
    }

    public boolean clearConnect(int n, Association association, int n2, int n3) throws IOException {
        return this.clearConnect(n, association, n2, n3, association.absolute);
    }

    public boolean clearConnect(int n, Association association, int n2, int n3, boolean bl) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Association.testConnect(n);
        if (!association.has()) {
            return false;
        }
        if (this.depends(association) >= 0) {
            association = association.get();
        }
        if (this.accession() && this.conNode.clearConnectNode(n, association.seeTrace, association.seeNode, n2, n3, bl)) {
            this.noteClear();
            return true;
        }
        return false;
    }

    public boolean clearConnect(int n, Concept concept) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Association.testConnect(n);
        if (this.accession() && this.conNode.clearConnectNode(n, concept.identifier, null, 0, 0, true)) {
            this.noteClear();
            return true;
        }
        return false;
    }

    public boolean clearConnect(int n, String string) throws IOException {
        return this.clearConnect(n, new Concept(string));
    }

    public void clearConnect(PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (!this.has()) {
            return;
        }
        this.testDependence(pList);
        Long1 long1 = PN.initMemory();
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                if (association == null) {
                    this.clearConnect(n);
                } else {
                    this.clearConnect(n, association);
                }
                PN.controlMemory(long1, this, association, pList);
                trace = trace.next;
            }
            association = (Association)pList.getNext();
        }
    }

    public boolean clearConnection(int n, PList pList) throws IOException {
        return this.clearConnection(n, this.absolute, pList);
    }

    public boolean clearConnection(int n, boolean bl, PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.testDependence(pList);
        return new Domain(this).clearConnection(n, bl, pList);
    }

    public boolean clearConnection(Association association, int n, int n2, PList pList) throws IOException {
        return this.clearConnection(association, n, n2, association.absolute, pList);
    }

    public boolean clearConnection(Association association, int n, int n2, boolean bl, PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.testDependence(association, pList);
        return new Domain(this, association).clearConnection(n, n2, bl, pList);
    }

    public boolean clearConnection(Association association, int n, PList pList) throws IOException {
        return this.clearConnection(association, n, association.sense, association.absolute, pList);
    }

    public boolean clearConnection(Association association, PList pList) throws IOException {
        return this.clearConnection(association, association.category, association.sense, association.absolute, pList);
    }

    public boolean clearConnection(PList pList) throws IOException {
        return this.clearConnection(this.category, this.absolute, pList);
    }

    public Object clone() {
        Association association = null;
        try {
            association = (Association)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        association.fixTrace = new Trace();
        association.fixTraceEnd = association.fixTrace.insert(this.fixTrace);
        association.conTrace = new Trace();
        association.conTraceEnd = association.conTrace.insert(this.conTrace);
        association.conRoute = (Stack)this.conRoute.clone();
        association.seeRoute = (Stack)this.seeRoute.clone();
        if (association.fixNode != null) {
            this.core.addObserver(association);
        }
        ++this.core.observation;
        return association;
    }

    public void close() throws IOException {
        this.core.close();
    }

    public Association con() {
        if (this.curTrace == null) {
            return this;
        }
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        this.conRoute.push(this.conTraceEnd);
        this.seeRoute.push(this.seeTrace);
        this.conTraceEnd = this.conTraceEnd.insert(this.curTrace);
        this.conNode = this.curNode;
        if (this.seeTrace.equals(this.curTrace, trace, trace2) && trace.next != null) {
            this.seeTrace = new Trace();
            this.seeTrace.next = trace.next;
            Concept.normal(this.seeTrace);
        } else {
            this.seeTrace = new Trace(0);
            this.seeNode = this.conNode;
        }
        this.curTrace = null;
        this.curNode = null;
        return this;
    }

    public Association con(int n) {
        Association.testConnect(n);
        Trace trace = new Trace();
        this.conRoute.push(this.conTraceEnd);
        this.seeRoute.push(this.seeTrace);
        this.conTraceEnd = this.conTraceEnd.next = new Trace(n);
        if (n <= 57 && this.seeTrace.next != null && this.seeTrace.next.sign == n) {
            trace.next = this.seeTrace.next.next;
            this.seeTrace = new Trace();
            this.seeTrace.next = trace.next;
            Concept.normal(this.seeTrace);
        } else {
            this.seeTrace = new Trace(0);
        }
        this.conNode = null;
        this.seeNode = null;
        this.state = -1L;
        this.curTrace = null;
        this.curNode = null;
        return this;
    }

    public Association con(Concept concept) {
        if (concept == null) {
            return this;
        }
        if (concept.identifier == this.curTrace) {
            return this.con();
        }
        this.con(concept.identifier);
        return this;
    }

    void con(Trace trace) {
        Trace trace2 = new Trace();
        Trace trace3 = new Trace();
        this.conRoute.push(this.conTraceEnd);
        this.seeRoute.push(this.seeTrace);
        this.conTraceEnd = this.conTraceEnd.insert(trace);
        this.curTrace = null;
        this.curNode = null;
        if (trace.next == null) {
            return;
        }
        if (this.seeTrace.equals(trace, trace2, trace3) && trace2.next != null) {
            this.seeTrace = new Trace();
            this.seeTrace.next = trace2.next;
            Concept.normal(this.seeTrace);
        } else {
            this.seeTrace = new Trace(0);
        }
        this.conNode = null;
        this.seeNode = null;
        this.state = -1L;
    }

    public Association con(String string) {
        return this.con(new Concept(string));
    }

    PList createAssList(PList pList) {
        PList pList2 = new PList();
        pList.getFirst();
        while (pList.hasCurrent()) {
            pList2.add(pList.getTypes(), (Object)new Association());
            pList.getNext();
        }
        return pList2;
    }

    public Concept createNewConcept() throws IOException {
        Node node;
        Trace trace;
        boolean bl = false;
        Trace trace2 = this.curTrace;
        Node node2 = this.curNode;
        Trace trace3 = this.seeTrace;
        Node node3 = this.seeNode;
        this.see(53);
        Concept concept = this.getLast(56);
        if (concept == null) {
            trace = new Trace();
            trace.next = new Trace(53);
            trace.next.next = new Trace(-1);
        } else {
            trace = concept.identifier;
        }
        bl = true;
        this.accessSet();
        do {
            trace = (Trace)trace.clone();
            trace.next.increase(31);
        } while ((node = this.conNode.getTrace(trace, 56)) != null);
        node = this.conNode.setTrace(trace);
        if (node.setConcept()) {
            this.noteSet();
        }
        this.curTrace = trace2;
        this.curNode = node2;
        this.seeTrace = trace3;
        this.seeNode = node3;
        Trace trace4 = new Trace(this.seeTrace.sign);
        Trace trace5 = trace4.insert(this.seeTrace);
        trace5.insert(trace);
        concept = new Concept(trace4);
        return concept;
    }

    public Concept defClass() throws IOException {
        Node node;
        Trace trace = null;
        if (this.accession() && (node = this.seeNode.seekClassDefnNode()) != null) {
            trace = node.defTrace(this.conNode);
        }
        if (trace == null) {
            return null;
        }
        return new Concept(trace);
    }

    public PList defCon() {
        Trace trace;
        PList pList = new PList();
        Trace trace2 = this.conTrace;
        Trace trace3 = trace = new Trace();
        while (trace2.next != null) {
            trace2 = trace2.next;
            if (trace2.sign > 57) {
                pList.add(new Concept(trace));
                pList.add(new Connecter(trace2.sign));
                trace3 = trace = new Trace();
                continue;
            }
            trace3 = trace3.next = new Trace(trace2.sign);
        }
        pList.add(new Concept(trace));
        return pList;
    }

    public Concept defSee() {
        return new Concept(this.seeTrace);
    }

    public Concept defineNewConcept() throws IOException {
        Trace trace;
        Trace trace2 = this.curTrace;
        Node node = this.curNode;
        Trace trace3 = this.seeTrace;
        Node node2 = this.seeNode;
        this.see(53);
        Concept concept = this.getLast(56);
        if (concept == null) {
            trace = new Trace();
            trace.next = new Trace(53);
            trace.next.next = new Trace(-1);
        } else {
            trace = concept.identifier;
        }
        if (this.accession()) {
            Node node3;
            do {
                trace = (Trace)trace.clone();
                trace.next.increase(31);
            } while ((node3 = this.conNode.getTrace(trace, 56)) != null);
        } else {
            trace = (Trace)trace.clone();
            trace.next.increase(31);
        }
        this.curTrace = trace2;
        this.curNode = node;
        this.seeTrace = trace3;
        this.seeNode = node2;
        Trace trace4 = new Trace(this.seeTrace.sign);
        Trace trace5 = trace4.insert(this.seeTrace);
        trace5.insert(trace);
        concept = new Concept(trace4);
        return concept;
    }

    public boolean delete() throws IOException {
        return this.core.delete();
    }

    int depends(Association association) {
        if (this.core != association.core) {
            String string = this.getAbsolutePath();
            String string2 = association.getAbsolutePath();
            if (string == null || string2 == null) {
                return -1;
            }
            if (!string.equals(string2)) {
                return -1;
            }
        }
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        trace.insert(this.fixTrace).insert(this.conTrace);
        trace2.insert(association.fixTrace).insert(association.conTrace);
        Concept.normal(trace);
        Concept.normal(trace2);
        Trace trace3 = new Trace();
        Trace trace4 = new Trace();
        if (!trace.equals(trace2, trace3, trace4)) {
            return -1;
        }
        if (trace3.next == trace4.next) {
            return 0;
        }
        if (trace4.next != null) {
            return 1;
        }
        return 2;
    }

    protected void finalize() throws IOException {
        if (--this.core.observation == 0) {
            if (this.core.path == null || this.core.path.charAt(0) == '$') {
                this.core.delete();
            } else {
                this.core.close();
            }
        }
    }

    public void fix() {
        if (this.conTraceEnd != this.conTrace) {
            this.fixTraceEnd.next = this.conTrace.next;
            this.fixTraceEnd = this.conTraceEnd;
            this.conTrace.next = null;
            this.conTraceEnd = this.conTrace;
            this.fixNode = this.conNode;
            this.conRoute = new Stack();
            this.seeRoute = new Stack();
        }
    }

    public Concept generalize(int n) throws IOException {
        Trace trace = null;
        boolean bl = false;
        if (this.accession()) {
            Node node = this.seeNode.seekKeyNode(n);
            trace = node.defTrace(this.conNode);
            if (n == 57 && !node.hasConcept(n)) {
                bl = true;
            }
        }
        if (trace == null) {
            return null;
        }
        Concept concept = new Concept(trace);
        if (bl) {
            concept = concept.getClassDefn();
        }
        return concept;
    }

    public Association get() throws IOException {
        Association association = new Association();
        association.set(this, this.category);
        return association;
    }

    public Association get(int n) throws IOException {
        Association association = new Association();
        association.set(this, n);
        return association;
    }

    public Association get(Association association) throws IOException {
        return this.get(association, association.category, this.sense, association.sense, association.absolute);
    }

    public Association get(Association association, int n) throws IOException {
        return this.get(association, n, this.sense, association.sense, association.absolute);
    }

    public Association get(Association association, int n, int n2) throws IOException {
        return this.get(association, n, this.sense, n2, association.absolute);
    }

    public Association get(Association association, int n, int n2, int n3) throws IOException {
        return this.get(association, n, n2, n3, association.absolute);
    }

    public Association get(Association association, int n, int n2, int n3, boolean bl) throws IOException {
        return new Domain(this, association).get(n, n2, n3, bl);
    }

    public Concept get(Concept concept) throws IOException {
        return this.get(concept, this.category);
    }

    public Concept get(Concept concept, int n) throws IOException {
        this.curTrace = concept.identifier;
        this.curNode = null;
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        if (!this.seeTrace.equals(concept.identifier, trace, trace2) || trace.next != null) {
            return null;
        }
        if (this.accession()) {
            this.curNode = this.conNode.getTrace(concept.identifier, n);
            if (this.curNode != null && !this.curNode.hasConcept(n)) {
                this.curNode = null;
            }
        }
        if (this.curNode == null) {
            return null;
        }
        return new Concept(this.curTrace);
    }

    public Concept get(String string) throws IOException {
        return this.get(new Concept(string));
    }

    String getAbsolutePath() {
        return this.core.aFile.getAbsolutePath();
    }

    public Association getAllName() throws IOException {
        Association association = new Association();
        this.getAllName(association);
        return association;
    }

    public void getAllName(Association association) throws IOException {
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            association.set(concept);
            this.con();
            if (this.hasConnect(57)) {
                this.con(57);
                this.getAllName(association);
                this.uncon();
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public Association getBy(int n, PList pList) throws IOException {
        return this.getBy(n, this.absolute, pList);
    }

    public Association getBy(int n, boolean bl, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this).getBy(n, bl, pList);
    }

    public Association getBy(Association association, int n, int n2, PList pList) throws IOException {
        return this.getBy(association, n, n2, association.absolute, pList);
    }

    public Association getBy(Association association, int n, int n2, boolean bl, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this, association).getBy(n, n2, bl, pList);
    }

    public Association getBy(Association association, int n, PList pList) throws IOException {
        return this.getBy(association, n, association.sense, association.absolute, pList);
    }

    public Association getBy(Association association, PList pList) throws IOException {
        return this.getBy(association, association.category, association.sense, association.absolute, pList);
    }

    public Association getBy(PList pList) throws IOException {
        return this.getBy(this.category, this.absolute, pList);
    }

    public int getCategory() {
        return this.category;
    }

    public Association getClassDefn() throws IOException {
        Association association = new Association();
        this.getClassDefn(false, false, association);
        return association;
    }

    public Association getClassDefn(int n) throws IOException {
        Association association = new Association();
        this.getClassDefn(n, false, association);
        return association;
    }

    public Association getClassDefn(int n, boolean bl) throws IOException {
        Association association = new Association();
        this.getClassDefn(n, bl, association);
        return association;
    }

    public void getClassDefn(int n, boolean bl, Association association) throws IOException {
        if (!association.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                this.con(57);
                association.con(concept);
                this.getClassDefn1(n - 1, association);
                this.uncon();
                association.uncon();
            } else if (bl && this.hasConcept()) {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public Association getClassDefn(boolean bl) throws IOException {
        Association association = new Association();
        this.getClassDefn(bl, false, association);
        return association;
    }

    public Association getClassDefn(boolean bl, boolean bl2) throws IOException {
        Association association = new Association();
        this.getClassDefn(bl, bl2, association);
        return association;
    }

    public void getClassDefn(boolean bl, boolean bl2, Association association) throws IOException {
        if (!association.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                this.con(57);
                association.con(concept);
                this.getClassDefn1(bl2, association);
                this.uncon();
                association.uncon();
            } else if (bl && this.hasConcept()) {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    void getClassDefn1(int n, Association association) throws IOException {
        if (n == 0) {
            association.setConcept();
            return;
        }
        boolean bl = false;
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                association.con(57).con(concept);
                this.con(57);
                this.getClassDefn1(n, association);
                this.uncon();
                association.uncon().uncon();
            } else if (this.hasConcept()) {
                bl = true;
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
        if (bl) {
            association.setConcept();
        }
    }

    void getClassDefn1(boolean bl, Association association) throws IOException {
        boolean bl2 = false;
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                association.con(57).con(concept);
                this.con(57);
                this.getClassDefn1(bl, association);
                this.uncon();
                association.uncon().uncon();
            } else if (this.hasConcept()) {
                bl2 = true;
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
        if (bl || bl2) {
            association.setConcept();
        }
    }

    public Association getClassDefnOf(Concept concept) throws IOException {
        Association association = new Association();
        Long1 long1 = PN.initMemory();
        Concept concept2 = this.getFirst(56);
        while (concept2 != null) {
            if (!concept2.equals(concept)) {
                this.con();
                if (this.hasConnect(57)) {
                    association.con(concept2);
                    this.getClassDefnOf1(concept, association);
                    association.uncon();
                }
                this.uncon();
                PN.controlMemory(long1, this, association);
            }
            concept2 = this.getNext(56);
        }
        return association;
    }

    void getClassDefnOf1(Concept concept, Association association) throws IOException {
        Long1 long1 = PN.initMemory();
        this.con(57);
        Concept concept2 = this.getFirst(56);
        while (concept2 != null) {
            if (concept2.equals(concept)) {
                association.setConcept();
            } else {
                this.con();
                if (this.hasConnect(57)) {
                    association.con(57).con(concept2);
                    this.getClassDefnOf1(concept, association);
                }
                this.uncon();
                PN.controlMemory(long1, this, association);
            }
            concept2 = this.getNext(56);
        }
        this.uncon();
    }

    public Association getClassMean() throws IOException {
        Association association = new Association();
        this.getClassMean(association);
        return association;
    }

    public void getClassMean(Association association) throws IOException {
        if (!association.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                this.con(57);
                this.getClassMean(association);
                this.uncon();
            } else {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public Association getClassName() throws IOException {
        Association association = new Association();
        this.getClassName(association);
        return association;
    }

    public void getClassName(Association association) throws IOException {
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57) || this.hasConcept()) {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public Association getClassValue() throws IOException {
        Association association = new Association();
        this.getClassValue(false, association);
        return association;
    }

    public Association getClassValue(int n) throws IOException {
        Association association = new Association();
        this.getClassValue(n, false, association);
        return association;
    }

    public Association getClassValue(int n, boolean bl) throws IOException {
        Association association = new Association();
        this.getClassValue(n, bl, association);
        return association;
    }

    public void getClassValue(int n, boolean bl, Association association) throws IOException {
        if (!association.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (n == 1) {
            this.getClassValue(bl, association);
            return;
        }
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                this.con(57);
                this.getClassValue(n - 1, bl, association);
                this.uncon();
            } else if (bl && this.hasConcept()) {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public Association getClassValue(boolean bl) throws IOException {
        Association association = new Association();
        this.getClassValue(bl, association);
        return association;
    }

    public void getClassValue(boolean bl, Association association) throws IOException {
        if (!association.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                this.con(57);
                this.getClassValue1(bl, association);
                this.uncon();
            } else if (bl && this.hasConcept()) {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public void getClassValue1(boolean bl, Association association) throws IOException {
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (this.hasConnect(57)) {
                this.con(57);
                association.con(concept).con(57);
                this.getClassValue1(bl, association);
                this.uncon();
                association.uncon().uncon();
            } else if (bl && this.hasConcept()) {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public Association getConnect(int n) throws IOException {
        Association.testConnect(n);
        this.con(n);
        Association association = this.get();
        this.uncon();
        return association;
    }

    public Association getConnect(int n, Association association) throws IOException {
        return this.getConnect(n, association, association.category, association.sense, association.absolute);
    }

    public Association getConnect(int n, Association association, int n2) throws IOException {
        return this.getConnect(n, association, n2, association.sense, association.absolute);
    }

    public Association getConnect(int n, Association association, int n2, int n3) throws IOException {
        return this.getConnect(n, association, n2, n3, association.absolute);
    }

    public Association getConnect(int n, Association association, int n2, int n3, boolean bl) throws IOException {
        Association.testConnect(n);
        this.con(n);
        Association association2 = this.get(association, n2, this.sense, n3, bl);
        this.uncon();
        return association2;
    }

    public Association getConnect(PList pList) throws IOException {
        Association association = null;
        if (!this.has()) {
            return new Association();
        }
        this.testConnect(pList);
        Long1 long1 = PN.initMemory();
        Association association2 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                if (this.hasConnect(n)) {
                    if (association == null) {
                        association = association2 == null ? this.getConnect(n) : this.getConnect(n, association2);
                    } else if (association2 == null) {
                        this.con(n);
                        association.set(this, 57);
                        this.uncon();
                    } else {
                        association.set(this.getConnect(n, association2));
                    }
                    PN.controlMemory(long1, this, pList);
                }
                trace = trace.next;
            }
            association2 = (Association)pList.getNext();
        }
        if (association == null) {
            association = new Association();
        }
        return association;
    }

    public PList getConnectList(PList pList) throws IOException {
        if (!this.has()) {
            return this.createAssList(pList);
        }
        this.testConnect(pList);
        PList pList2 = new PList();
        Long1 long1 = PN.initMemory();
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Association association2 = null;
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                if (this.hasConnect(n)) {
                    if (association2 == null) {
                        association2 = association == null ? this.getConnect(n) : this.getConnect(n, association);
                    } else if (association == null) {
                        this.con(n);
                        association2.set(this, 57);
                        this.uncon();
                    } else {
                        association2.set(this.getConnect(n, association));
                    }
                }
                trace = trace.next;
            }
            if (association2 == null) {
                association2 = new Association();
            }
            pList2.add(pList.getTypes(), (Object)association2);
            PN.controlMemory(long1, this, pList);
            association = (Association)pList.getNext();
        }
        return pList2;
    }

    public Association getConnection(int n, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this).getConnection(n, pList);
    }

    public Association getConnection(Association association, int n, int n2, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this, association).getConnection(n, n2, pList);
    }

    public Association getConnection(Association association, int n, PList pList) throws IOException {
        return this.getConnection(association, n, association.sense, pList);
    }

    public Association getConnection(Association association, PList pList) throws IOException {
        return this.getConnection(association, association.category, association.sense, pList);
    }

    public Association getConnection(PList pList) throws IOException {
        return this.getConnection(this.category, pList);
    }

    public PList getConnectionList(int n, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this).getConnectionList(n, pList);
    }

    public PList getConnectionList(Association association, int n, int n2, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this, association).getConnectionList(n, n2, pList);
    }

    public PList getConnectionList(Association association, int n, PList pList) throws IOException {
        return this.getConnectionList(association, n, association.sense, pList);
    }

    public PList getConnectionList(Association association, PList pList) throws IOException {
        return this.getConnectionList(association, association.category, association.sense, pList);
    }

    public PList getConnectionList(PList pList) throws IOException {
        return this.getConnectionList(this.category, pList);
    }

    public Core getCore() {
        return this.core;
    }

    public Concept getCurrent() {
        if (this.curTrace != null) {
            return new Concept(this.curTrace);
        }
        return null;
    }

    public Concept getFirst() throws IOException {
        return this.getFirst(this.category);
    }

    public Concept getFirst(int n) throws IOException {
        this.curTrace = null;
        this.curNode = null;
        if (this.accession()) {
            this.curNode = this.seeNode.hasConcept(n) ? this.seeNode : this.seeNode.nextNode(n, this.seeNode);
            if (this.curNode != null) {
                this.curTrace = this.curNode.defTrace(this.conNode);
            }
        }
        if (this.curNode == null) {
            return null;
        }
        return new Concept(this.curTrace);
    }

    public Concept getIfOne() throws IOException {
        return this.getIfOne(this.category);
    }

    public Concept getIfOne(int n) throws IOException {
        Node node;
        Trace trace = null;
        if (this.accession() && (node = this.seeNode.seekKeyNode(n)) != null && node.hasConcept(n) && !node.hasNotatNode(n)) {
            trace = node.defTrace(this.conNode);
        }
        if (trace == null) {
            return null;
        }
        return new Concept(trace);
    }

    public Association getInstance() throws IOException {
        return this.getInstance(this.absolute);
    }

    public Association getInstance(Association association) throws IOException {
        return this.getInstance(association, association.sense, association.absolute);
    }

    public Association getInstance(Association association, int n) throws IOException {
        return this.getInstance(association, n, association.absolute);
    }

    public Association getInstance(Association association, int n, boolean bl) throws IOException {
        Association association2 = new Association();
        this.getInstance(association, n, bl, association2);
        return association2;
    }

    public void getInstance(Association association, int n, boolean bl, Association association2) throws IOException {
        if (!association2.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        boolean bl2 = bl;
        if (n == 57) {
            bl = true;
        }
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(56);
        while (concept != null) {
            this.con(concept);
            if (!this.hasConcept(56)) {
                this.uncon();
            } else {
                association.con();
                if (!bl && association.hasConcept() && this.hasConcept()) {
                    association2.set(concept);
                }
                if (association.hasConnect(57)) {
                    this.con(57);
                    association.con(57);
                    this.getInstance(association, n, bl, association2);
                    this.uncon();
                    association.uncon();
                } else if (n == 57 && this.hasConnect(57)) {
                    this.con(57);
                    if (!bl2) {
                        association2.set(this);
                    } else {
                        this.getInstance(bl2, association2);
                    }
                    this.uncon();
                } else {
                    association2.set(concept);
                }
                this.uncon();
                association.uncon();
                PN.controlMemory(long1, this, association2);
            }
            concept = association.getNext(56);
        }
    }

    public Association getInstance(boolean bl) throws IOException {
        Association association = new Association();
        this.getInstance(bl, association);
        return association;
    }

    public void getInstance(boolean bl, Association association) throws IOException {
        if (!association.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = PN.initMemory();
        Concept concept = this.getFirst(56);
        while (concept != null) {
            this.con();
            if (!bl && this.hasConcept()) {
                association.set(concept);
            }
            if (this.hasConnect(57)) {
                this.con(57);
                this.getInstance(bl, association);
                this.uncon();
            } else if (bl) {
                association.set(concept);
            }
            this.uncon();
            PN.controlMemory(long1, this, association);
            concept = this.getNext(56);
        }
    }

    public Concept getLast() throws IOException {
        return this.getLast(this.category);
    }

    public Concept getLast(int n) throws IOException {
        this.curTrace = null;
        this.curNode = null;
        if (this.accession()) {
            this.curNode = this.seeNode.lastNode(n);
            if (this.curNode != null) {
                this.curTrace = this.curNode.defTrace(this.conNode);
            }
        }
        if (this.curNode == null) {
            return null;
        }
        return new Concept(this.curTrace);
    }

    public Concept getNext() throws IOException {
        return this.getNext(this.category);
    }

    public Concept getNext(int n) throws IOException {
        if (this.curTrace == null) {
            return null;
        }
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        if (!this.seeTrace.equals(this.curTrace, trace, trace2) || trace.next != null) {
            this.curTrace = null;
            this.curNode = null;
            return null;
        }
        if (this.accession()) {
            if (this.curNode == null) {
                this.curNode = this.conNode.getTrace(this.curTrace, n);
            }
            if (this.curNode == null) {
                if (trace2.next != null) {
                    this.curNode = this.seeNode.getNextNode(n, this.seeNode, trace2);
                }
            } else {
                this.curNode.deploy();
                this.curNode = this.curNode.nextNode(n, this.seeNode);
            }
            if (this.curNode != null) {
                this.curTrace = this.curNode.defTrace(this.conNode);
            }
        }
        if (this.curNode == null) {
            this.curTrace = null;
            return null;
        }
        return new Concept(this.curTrace);
    }

    public String getPath() {
        if (this.core.path == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            return this.core.path.replace('\\', '/');
        }
        return this.core.path;
    }

    public long getPower() throws IOException {
        return this.getPower(this.category, this.absolute);
    }

    public long getPower(int n) throws IOException {
        return this.getPower(n, this.absolute);
    }

    public long getPower(int n, boolean bl) throws IOException {
        return new Domain(this).getPower(n, bl);
    }

    public long getPower(Association association) throws IOException {
        return this.getPower(association, association.category, association.sense, association.absolute);
    }

    public long getPower(Association association, int n) throws IOException {
        return this.getPower(association, n, association.sense, association.absolute);
    }

    public long getPower(Association association, int n, int n2) throws IOException {
        return this.getPower(association, n, n2, association.absolute);
    }

    public long getPower(Association association, int n, int n2, boolean bl) throws IOException {
        return new Domain(this, association).getPower(n, n2, bl);
    }

    public int getSense() {
        return this.sense;
    }

    public boolean has() throws IOException {
        return this.accession();
    }

    public boolean has(int n) throws IOException {
        return (this.seeTrace.next == null || this.seeTrace.next.sign == n) && this.accession() && this.conNode.hasSign(n);
    }

    public boolean has(Association association) throws IOException {
        return this.has(association, association.category, this.sense, association.sense, association.absolute);
    }

    public boolean has(Association association, int n) throws IOException {
        return this.has(association, n, this.sense, association.sense, association.absolute);
    }

    public boolean has(Association association, int n, int n2, int n3) throws IOException {
        return new Domain(this, association).has(n, n2, n3, association.absolute);
    }

    public boolean has(Association association, int n, int n2, int n3, boolean bl) throws IOException {
        return new Domain(this, association).has(n, n2, n3, bl);
    }

    public boolean hasAbsolute() {
        return this.absolute;
    }

    public boolean hasConcept() throws IOException {
        return this.seeTrace.next == null && this.accession() && this.conNode.hasConcept();
    }

    public boolean hasConcept(int n) throws IOException {
        return this.seeTrace.next == null && this.accession() && this.conNode.hasConcept(n);
    }

    public boolean hasConnect() throws IOException {
        return this.seeTrace.next == null && this.accession() && this.conNode.hasConnectNode();
    }

    public boolean hasConnect(int n) throws IOException {
        Association.testConnect(n);
        return this.seeTrace.next == null && this.accession() && this.conNode.hasConnectNode(n);
    }

    public boolean hasConnect(int n, Association association) throws IOException {
        return this.hasConnect(n, association, association.category, association.sense, association.absolute);
    }

    public boolean hasConnect(int n, Association association, int n2) throws IOException {
        return this.hasConnect(n, association, n2, association.sense, association.absolute);
    }

    public boolean hasConnect(int n, Association association, int n2, int n3) throws IOException {
        return this.hasConnect(n, association, n2, n3, association.absolute);
    }

    public boolean hasConnect(int n, Association association, int n2, int n3, boolean bl) throws IOException {
        Association.testConnect(n);
        this.con(n);
        boolean bl2 = this.has(association, n2, this.sense, n3, bl);
        this.uncon();
        return bl2;
    }

    public boolean hasConnect(PList pList) throws IOException {
        if (!this.has()) {
            return false;
        }
        this.testConnect(pList);
        Long1 long1 = PN.initMemory();
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                if (this.hasConnect(n) && (association == null || this.hasConnect(n, association))) break;
                trace = trace.next;
            }
            if (trace == null) {
                return false;
            }
            PN.controlMemory(long1, this, association, pList);
            association = (Association)pList.getNext();
        }
        return true;
    }

    public boolean hasConnection(int n, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this).hasConnection(n, pList);
    }

    public boolean hasConnection(Association association, int n, int n2, PList pList) throws IOException {
        this.testConnect(pList);
        return new Domain(this, association).hasConnection(n, n2, pList);
    }

    public boolean hasConnection(Association association, int n, PList pList) throws IOException {
        return this.hasConnection(association, n, association.sense, pList);
    }

    public boolean hasConnection(Association association, PList pList) throws IOException {
        return this.hasConnection(association, association.category, association.sense, pList);
    }

    public boolean hasConnection(PList pList) throws IOException {
        return this.hasConnection(this.category, pList);
    }

    public boolean hasNotation() throws IOException {
        return (this.seeTrace.next == null || this.seeTrace.next.sign <= this.category) && this.accession() && this.conNode.hasNotatNode(this.category);
    }

    void init(String string, String string2, boolean bl) throws IOException {
        String string3;
        if (string2.indexOf(46) < 0) {
            string2 = String.valueOf(string2) + ".ass";
        }
        if (string == null) {
            string3 = string2;
        } else {
            if (File.separatorChar == '\\') {
                string = string.replace('/', '\\');
            }
            string3 = String.valueOf(string) + File.separator + string2;
        }
        this.core = new Core(string3, bl);
        ++this.core.observation;
    }

    public boolean normalizeClass() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        return new Domain(this).absolutizeClass(false);
    }

    public boolean normalizeClass(Association association) throws IOException {
        return this.normalizeClass(association, association.category, association.sense);
    }

    public boolean normalizeClass(Association association, int n) throws IOException {
        return this.normalizeClass(association, n, association.sense);
    }

    public boolean normalizeClass(Association association, int n, int n2) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        return new Domain(this, association).absolutizeClass(false, n, n2);
    }

    void noteClear() throws IOException {
        this.conNode.freeAncestors();
        this.curNode = null;
        if (this.conNode.count == 0) {
            this.conNode = null;
            this.seeNode = null;
            if (this.fixNode.count == 0) {
                this.fixNode = null;
            }
        } else if (this.seeTrace.next != null && this.seeNode.count == 0) {
            this.seeNode = null;
        }
        if (this.core.countObservers() > 1) {
            this.core.reset();
        }
    }

    void noteSet() {
        this.core.setUp();
        ++this.state;
    }

    public void print(PrintWriter printWriter) throws IOException {
        this.print(printWriter, this.category, 0, false, true);
        printWriter.flush();
    }

    public void print(PrintWriter printWriter, int n, int n2, boolean bl, boolean bl2) throws IOException {
        boolean bl3 = true;
        int n3 = n2;
        Concept concept = this.getIfOne(56);
        if (bl2 && concept == null) {
            printWriter.print("{ ");
            n2 += 2;
        }
        Long1 long1 = PN.initMemory();
        Concept concept2 = this.getFirst(56);
        while (concept2 != null) {
            this.con();
            if (bl3) {
                bl3 = false;
            } else {
                printWriter.print(",");
                this.printLineSpace(printWriter, n2, bl);
            }
            String string = concept2.toString();
            printWriter.print(string);
            if (n == 57 && this.hasConnect(57)) {
                this.con(57);
                printWriter.print(": ");
                this.print(printWriter, n, n2 + string.length() + 2, bl, true);
                this.uncon();
            }
            this.uncon();
            PN.controlMemory(long1, this);
            concept2 = this.getNext(56);
        }
        if (bl2 && concept == null) {
            this.printLineSpace(printWriter, n2 - 2, bl);
            printWriter.print("}");
        }
        if (bl && n3 == 0) {
            printWriter.println();
        }
    }

    void printLineSpace(PrintWriter printWriter, int n, boolean bl) throws IOException {
        if (!bl) {
            printWriter.print(' ');
            return;
        }
        printWriter.println();
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
    }

    public void println(PrintWriter printWriter) throws IOException {
        this.print(printWriter, this.category, 0, false, true);
        printWriter.println();
        printWriter.flush();
    }

    public void regain() {
        this.conRoute = new Stack();
        this.seeRoute = new Stack();
        this.state = -1L;
        this.conTrace.next = null;
        this.conTraceEnd = this.conTrace;
        this.conNode = null;
        this.seeTrace = new Trace();
        this.seeNode = null;
        this.curTrace = null;
        this.curNode = null;
    }

    public void restore() throws IOException {
        this.core.restore();
    }

    public void save() throws IOException {
        this.core.save();
    }

    public Association see() {
        this.seeTrace = new Trace();
        this.seeNode = this.conNode;
        this.state = -1L;
        this.curNode = null;
        return this;
    }

    public Association see(int n) {
        if (n > 56 || n < 31) {
            throw new IndexOutOfBoundsException("\nnotation = " + n + "\nNeed: PN.NATURAL, PN.CAPITAL, PN.ARITHMETICAL, PN.NUMBER, ... (see PN class)");
        }
        this.seeTrace = new Trace();
        this.seeTrace.next = new Trace(n);
        Concept.normal(this.seeTrace);
        this.seeNode = null;
        this.state = -1L;
        this.curNode = null;
        return this;
    }

    public Association see(Concept concept) {
        if (concept == null) {
            return this;
        }
        if (Concept.countClassLevel(this.seeTrace) > 0) {
            throw new IndexOutOfBoundsException("\nconcept = " + concept + "\nCannot: CLASS connect");
        }
        this.seeTrace = concept.identifier;
        this.seeNode = null;
        this.state = -1L;
        this.curNode = null;
        return this;
    }

    public Association see(String string) {
        return this.see(new Concept(string));
    }

    public Association set(Association association) throws IOException {
        return this.set(association, association.category, association.absolute);
    }

    public Association set(Association association, int n) throws IOException {
        return this.set(association, n, association.absolute);
    }

    public Association set(Association association, int n, boolean bl) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (!association.has()) {
            return this;
        }
        int n2 = this.depends(association);
        if (n2 == 0) {
            return this;
        }
        if (n2 > 0) {
            association = association.get();
        }
        this.accessSet();
        Node node = association.seeTrace.next == null ? this.conNode : this.conNode.setTrace(association.seeTrace);
        if (node.setNode(association.seeNode, n, bl)) {
            this.noteSet();
        }
        return this;
    }

    public Association set(Concept concept) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.accessSet();
        Node node = this.conNode.setTrace(concept.identifier);
        if (node.setConcept()) {
            this.noteSet();
        }
        return this;
    }

    public Association set(String string) throws IOException {
        return this.set(new Concept(string));
    }

    public void setAbsolute(boolean bl) {
        this.absolute = bl;
    }

    public void setCategory() {
        this.category = 57;
        if (this.category > this.sense) {
            throw new IndexOutOfBoundsException("\ncategory > sense");
        }
    }

    public void setCategory(int n) {
        this.category = n;
    }

    public boolean setConcept() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.accessSet();
        if (this.conNode.setConcept()) {
            this.noteSet();
            return true;
        }
        return false;
    }

    public boolean setConception(Association association, int n, int n2, PList pList) throws IOException {
        return this.setConception(association, n, n2, association.absolute, pList);
    }

    public boolean setConception(Association association, int n, int n2, boolean bl, PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.testDependence(association, pList);
        if (!association.has()) {
            return false;
        }
        int n3 = this.depends(association);
        if (n3 == 0) {
            return this.setConnection(association, n, n2, bl, pList);
        }
        if (n3 > 0) {
            association = association.get();
        }
        this.accessSet();
        Node node = association.seeTrace.next == null ? this.conNode : this.conNode.setTrace(association.seeTrace);
        if (!node.setNodeConception(association.seeNode, n, bl, pList)) {
            return false;
        }
        this.noteSet();
        return true;
    }

    public boolean setConception(Association association, int n, PList pList) throws IOException {
        return this.setConception(association, n, association.sense, association.absolute, pList);
    }

    public boolean setConception(Association association, PList pList) throws IOException {
        return this.setConception(association, association.category, association.sense, association.absolute, pList);
    }

    public boolean setConnect(int n, Association association) throws IOException {
        return this.setConnect(n, association, association.category, association.absolute);
    }

    public boolean setConnect(int n, Association association, int n2) throws IOException {
        return this.setConnect(n, association, n2, association.absolute);
    }

    public boolean setConnect(int n, Association association, int n2, boolean bl) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Association.testConnect(n);
        if (!association.has()) {
            return false;
        }
        if (this.depends(association) >= 0) {
            association = association.get();
        }
        this.accessSet();
        if (this.conNode.setConnectNode(n, association.seeTrace, association.seeNode, n2, bl)) {
            this.noteSet();
            return true;
        }
        return false;
    }

    public boolean setConnect(int n, Concept concept) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Association.testConnect(n);
        this.accessSet();
        if (this.conNode.setConnectNode(n, concept.identifier, null, 0, false)) {
            this.noteSet();
            return true;
        }
        return false;
    }

    public boolean setConnect(int n, String string) throws IOException {
        return this.setConnect(n, new Concept(string));
    }

    public void setConnect(PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.testDependence(pList);
        Long1 long1 = PN.initMemory();
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                this.setConnect(n, association);
                PN.controlMemory(long1, this, association, pList);
                trace = trace.next;
            }
            association = (Association)pList.getNext();
        }
    }

    public boolean setConnection(int n, PList pList) throws IOException {
        return this.setConnection(n, this.absolute, pList);
    }

    public boolean setConnection(int n, boolean bl, PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.testDependence(pList);
        return new Domain(this).setConnection(n, bl, pList);
    }

    public boolean setConnection(Association association, int n, int n2, PList pList) throws IOException {
        return this.setConnection(association, n, n2, association.absolute, pList);
    }

    public boolean setConnection(Association association, int n, int n2, boolean bl, PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.testDependence(association, pList);
        return new Domain(this, association).setConnection(n, n2, bl, pList);
    }

    public boolean setConnection(Association association, int n, PList pList) throws IOException {
        return this.setConnection(association, n, association.sense, association.absolute, pList);
    }

    public boolean setConnection(Association association, PList pList) throws IOException {
        return this.setConnection(association, association.category, association.sense, association.absolute, pList);
    }

    public boolean setConnection(PList pList) throws IOException {
        return this.setConnection(this.category, this.absolute, pList);
    }

    public void setSense() {
        this.sense = 62;
    }

    public void setSense(int n) {
        this.sense = n;
    }

    public void setSense(int n, int n2) {
        this.category = n;
        this.sense = n2;
    }

    public void store() throws IOException {
        this.core.store();
    }

    static void testConnect(int n) {
        if (n < 56) {
            throw new NonRecognizableConnectException("\nconnect < PN.LOWER_CONNECTION (See Sav.PN)");
        }
        if (n > 62) {
            throw new NonRecognizableConnectException("\nconnect > PN.UPPER_CONNECTION (See Sav.PN)");
        }
    }

    void testConnect(PList pList) throws IOException {
        pList.commonType = 62;
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                Association.testConnect(n);
                if (pList.commonType >= n) {
                    pList.commonType = n - 1;
                }
                trace = trace.next;
            }
            if (association != null) {
                association.has();
            }
            association = (Association)pList.getNext();
        }
    }

    void testDependence(Association association, PList pList) throws IOException {
        pList.commonType = 62;
        Association association2 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                Association.testConnect(n);
                if (pList.commonType >= n) {
                    pList.commonType = n - 1;
                }
                trace = trace.next;
            }
            if (association2 != null) {
                association2.has();
                if (this.depends(association2) >= 0 || association.depends(association2) >= 0) {
                    Association association3 = association2.get();
                    association3.setSense(association2.getSense());
                    pList.update(pList.getType(), (Object)association3);
                }
            }
            association2 = (Association)pList.getNext();
        }
    }

    void testDependence(PList pList) throws IOException {
        pList.commonType = 62;
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            Trace trace = pList.getTypes();
            while (trace != null) {
                int n = trace.sign;
                Association.testConnect(n);
                if (pList.commonType >= n) {
                    pList.commonType = n - 1;
                }
                trace = trace.next;
            }
            if (association != null) {
                association.has();
                if (this.depends(association) >= 0) {
                    Association association2 = association.get();
                    association2.setSense(association.getSense());
                    pList.update(pList.getType(), (Object)association2);
                }
            }
            association = (Association)pList.getNext();
        }
    }

    public String toString() {
        try {
            return this.toString(this.category);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    public String toString(int n) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.print(printWriter, n, 0, false, true);
        return stringWriter.getBuffer().toString();
    }

    public void unclone() {
        this.core.reset();
    }

    public Association uncon() {
        if (this.conRoute.empty()) {
            return this;
        }
        this.curTrace = new Trace();
        this.conTraceEnd = (Trace)this.conRoute.pop();
        if (this.conTraceEnd.sign > 57) {
            this.curTrace = null;
            this.curNode = null;
        } else {
            this.curTrace.next = this.conTraceEnd.next;
            this.curNode = this.conNode;
        }
        this.conTraceEnd.next = null;
        this.conNode = null;
        this.seeTrace = (Trace)this.seeRoute.pop();
        this.seeNode = null;
        this.state = -1L;
        return this;
    }

    public void update(Observable observable, Object object) {
        this.state = -1L;
        if (this.fixNode != null) {
            this.fixNode = null;
            this.conNode = null;
            this.seeNode = null;
            this.curNode = null;
        }
    }
}

