/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.IncompatibleDataException;
import Sav.Processor.Int1;
import Sav.Processor.OldVersionException;
import Sav.Processor.PN;
import Sav.Processor.Trace;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

class AssociationFile {
    File file;
    RandomAccessFile raf;
    boolean modifiable;
    int endAddress = 0;
    int spaceAddress = 0;
    byte[] spaceBlock;
    int spaceContinue;
    int spacePos;
    int spaceEnd;
    Trace newSpace = new Trace();
    Trace step;
    String path;
    int number;
    byte[] initBlock;

    AssociationFile() {
        this.modifiable = true;
    }

    AssociationFile(String string, boolean bl) throws IOException {
        this.path = string;
        this.file = new File(string);
        if (!this.file.exists()) {
            this.modifiable = bl;
            return;
        }
        if (bl && !this.file.canWrite()) {
            throw new SecurityException("\nNon-modifiable file " + string);
        }
        if (!bl && !this.file.canRead()) {
            throw new SecurityException("\nNon-readable file " + string);
        }
        this.modifiable = bl;
        this.open();
    }

    int alloc() throws IOException {
        Int1 int1 = new Int1(0);
        Int1 int12 = new Int1(0);
        if (this.file == null || !this.file.exists()) {
            return this.endAddress++;
        }
        if (this.raf == null) {
            this.open();
        }
        if (this.spaceAddress < 0) {
            this.spaceBlock = new byte[8192];
            this.spaceAddress = this.endAddress - 1;
            this.raf.seek(((long)this.spaceAddress << 13) + 32L);
            if (this.raf.read(this.spaceBlock) < 8192) {
                throw new EOFException("\nspaceAddress == " + this.spaceAddress);
            }
            PN.readSize(this.spaceBlock, 0, int1);
            this.spaceEnd = 2 + int1.value;
            if (this.spaceEnd < 8192 && (this.spaceBlock[this.spaceEnd] & 0xFF) >= 192) {
                this.spacePos = 2;
                PN.readAddress(this.spaceBlock, this.spaceEnd, int12);
                this.spaceContinue = int12.value;
            } else {
                this.spaceBlock = null;
                this.spaceAddress = 0;
            }
        }
        if (this.spaceAddress == 0) {
            return this.endAddress++;
        }
        if (this.spacePos < this.spaceEnd) {
            this.spacePos = PN.readAddress(this.spaceBlock, this.spacePos, int12);
            return int12.value;
        }
        if (this.spaceContinue == 0) {
            this.spaceAddress = 0;
            this.spaceBlock = null;
            return this.endAddress - 1;
        }
        this.step = this.step.next = new Trace(this.spaceContinue);
        this.raf.seek(((long)this.spaceContinue << 13) + 32L);
        this.raf.read(this.spaceBlock);
        PN.readSize(this.spaceBlock, 0, int1);
        this.spacePos = 2;
        this.spaceEnd = this.spacePos + int1.value;
        PN.readAddress(this.spaceBlock, this.spaceEnd, int12);
        this.spaceContinue = int12.value;
        this.spacePos = PN.readAddress(this.spaceBlock, this.spacePos, int12);
        return int12.value;
    }

    void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
            this.raf = null;
            this.spaceAddress = 0;
            this.endAddress = 0;
            this.spaceBlock = null;
            this.spaceContinue = 0;
            this.spacePos = 0;
            this.spaceEnd = 0;
            this.step = this.newSpace = new Trace();
            return;
        }
    }

    void closeSaving() throws IOException {
        int n;
        if (this.newSpace.next == null) {
            return;
        }
        Int1 int1 = new Int1(0);
        Int1 int12 = new Int1(0);
        int n2 = 8181;
        if (this.spaceAddress <= 0) {
            this.spaceBlock = new byte[8192];
        }
        if (this.spaceAddress < 0) {
            this.spaceAddress = this.endAddress - 1;
            this.raf.seek(((long)this.spaceAddress << 13) + 32L);
            if (this.raf.read(this.spaceBlock) < 8192) {
                throw new EOFException("\nspaceAddress == " + this.spaceAddress);
            }
            PN.readSize(this.spaceBlock, 0, int1);
            this.spaceEnd = 2 + int1.value;
            if (this.spaceEnd < 8192 && (this.spaceBlock[this.spaceEnd] & 0xFF) >= 192) {
                this.spacePos = 2;
                PN.readAddress(this.spaceBlock, this.spaceEnd, int12);
                this.spaceContinue = int12.value;
            } else {
                this.spaceAddress = 0;
            }
        }
        if (this.spaceAddress == 0) {
            this.spaceAddress = this.endAddress++;
            this.spaceContinue = 0;
            this.spacePos = 2;
            this.spaceEnd = 2;
        }
        this.step = this.newSpace;
        block0: while (this.step.next != null) {
            this.step = this.step.next;
            while (this.spaceEnd <= n2) {
                this.spaceEnd = PN.writeAddress(this.step.sign, this.spaceBlock, this.spaceEnd);
                if (this.step.next == null) break block0;
                this.step = this.step.next;
            }
            PN.writeAddress(this.spaceContinue, this.spaceBlock, this.spaceEnd);
            n = this.spaceEnd - 2;
            PN.writeSize(n, this.spaceBlock, 0);
            this.spaceContinue = this.step.sign;
            this.raf.seek(((long)this.spaceContinue << 13) + 32L);
            this.raf.write(this.spaceBlock);
            this.spaceEnd = 2;
        }
        this.newSpace.next = null;
        this.step = this.newSpace;
        int n3 = PN.writeAddress(this.spaceContinue, this.spaceBlock, this.spaceEnd);
        this.spaceBlock[n3++] = -47;
        this.spaceBlock[n3++] = -32;
        this.spaceBlock[n3] = -30;
        n = this.spaceEnd - 2;
        PN.writeSize(n, this.spaceBlock, 0);
        this.raf.seek(((long)this.spaceAddress << 13) + 32L);
        this.raf.write(this.spaceBlock);
    }

    boolean delete() throws IOException {
        if (this.file == null || !this.file.exists()) {
            return true;
        }
        this.close();
        if (!this.file.delete()) {
            return false;
        }
        if (this.path == null) {
            Trace trace = PN.freeTempAss;
            synchronized (trace) {
                if (this.number == PN.numTempAss) {
                    --PN.numTempAss;
                } else {
                    Trace trace2 = new Trace(this.number);
                    trace2.next = PN.freeTempAss.next;
                    PN.freeTempAss = trace2;
                }
                this.number = 0;
            }
        }
        return true;
    }

    void free(int n) {
        this.step = this.step.next = new Trace(n);
    }

    String getAbsolutePath() {
        if (this.file == null) {
            return null;
        }
        return this.file.getAbsolutePath();
    }

    void init() throws IOException {
        Object object;
        if (this.raf != null) {
            return;
        }
        if (this.file == null) {
            object = PN.freeTempAss;
            synchronized (object) {
                do {
                    if (PN.freeTempAss.next != null) {
                        Trace trace = PN.freeTempAss.next;
                        PN.freeTempAss.next = trace.next;
                        this.number = trace.sign;
                    } else {
                        this.number = ++PN.numTempAss;
                    }
                    this.path = "~Temp" + this.number + ".ass";
                    this.file = new File(this.path);
                } while (this.file.exists() && !this.file.delete());
            }
        }
        this.raf = new RandomAccessFile(this.file, "rw");
        object = "Sav Processor 3.0, ";
        this.raf.writeBytes((String)object);
        this.raf.seek(28L);
        this.raf.writeInt(521);
        this.step = this.newSpace = new Trace();
    }

    boolean open() throws IOException {
        if (this.file == null || !this.file.exists()) {
            return false;
        }
        if (this.raf != null) {
            return true;
        }
        this.endAddress = (int)(this.file.length() - 32L >> 13);
        if (!this.modifiable) {
            this.raf = new RandomAccessFile(this.file, "r");
        } else {
            if (this.endAddress > 1) {
                this.spaceAddress = -1;
            }
            this.step = this.newSpace;
            this.raf = new RandomAccessFile(this.file, "rw");
        }
        this.initBlock = new byte[32];
        this.raf.seek(0L);
        if (this.raf.read(this.initBlock) < 32) {
            throw new EOFException("");
        }
        int n = 13;
        if (!new String(this.initBlock, 0, n).equals("Sav Processor")) {
            this.raf.close();
            throw new IncompatibleDataException();
        }
        n = 14;
        String string = new String(this.initBlock, n, 3);
        if (string.compareTo("3.0") < 0) {
            this.raf.close();
            throw new OldVersionException(new String(this.initBlock, 0, n + 3));
        }
        return true;
    }

    void openSaving() throws IOException {
        if (!this.open()) {
            this.init();
        }
        if (this.spaceAddress <= 0) {
            return;
        }
        int n = this.spaceEnd - this.spacePos;
        byte[] byArray = this.spaceBlock;
        this.spaceBlock = new byte[8192];
        System.arraycopy(byArray, this.spacePos, this.spaceBlock, 2, n);
        this.spacePos = 2;
        this.spaceEnd = this.spacePos + n;
        PN.writeSize(n, this.spaceBlock, 0);
        PN.writeAddress(this.spaceContinue, this.spaceBlock, this.spaceEnd);
        this.raf.seek(((long)this.spaceAddress << 13) + 32L);
        this.raf.write(this.spaceBlock);
    }

    byte[] read(int n) throws IOException {
        if (this.file == null || !this.file.exists()) {
            return null;
        }
        if (this.raf == null && !this.open()) {
            return null;
        }
        byte[] byArray = new byte[8192];
        if (n == 0) {
            byte[] byArray2 = new byte[3];
            this.raf.seek(0L);
            if (this.raf.read(byArray2) < 3) {
                throw new EOFException("\naddress == " + n);
            }
            int n2 = 0;
            if (byArray2[n2++] != 83 || byArray2[n2++] != 97 || byArray2[n2] != 118) {
                throw new IOException();
            }
        }
        long l = ((long)n << 13) + 32L;
        this.raf.seek(l);
        if (this.raf.read(byArray) < 8192) {
            throw new EOFException("\naddress == " + n);
        }
        return byArray;
    }

    void write(byte[] byArray, int n) throws IOException {
        if (this.raf == null && !this.open()) {
            return;
        }
        this.raf.seek(((long)n << 13) + 32L);
        this.raf.write(byArray);
    }
}

