/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.AbsolutizeClassNode;
import Sav.Processor.ClearNode;
import Sav.Processor.ClearNodeConnection;
import Sav.Processor.Concept;
import Sav.Processor.Core;
import Sav.Processor.GetNode;
import Sav.Processor.GetNodeBy;
import Sav.Processor.GetNodeConnection;
import Sav.Processor.GetNodeConnectionList;
import Sav.Processor.GetNodePower;
import Sav.Processor.HasNode;
import Sav.Processor.HasNodeConnection;
import Sav.Processor.Int1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Processor.SetNode;
import Sav.Processor.SetNodeConception;
import Sav.Processor.SetNodeConnection;
import Sav.Processor.Trace;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

class Node
implements Cloneable {
    Node ancestor;
    int notation;
    int sign;
    int count = 0;
    int nextType;
    int first;
    int last;
    Node descendant;
    Node[] posterity;
    boolean changed;
    Core core;
    int onset;
    int size;
    byte[] block;
    int address = -1;
    long power;
    Node powerNode;

    Node() {
        this.sign = 50;
    }

    Node(int n) {
        this.sign = n;
        if (n > 31) {
            this.notation = n;
        }
    }

    Node(Core core) {
        this.core = core;
        this.notation = 50;
        this.sign = 50;
    }

    Node(Core core, int n) {
        this.core = core;
        this.sign = n;
        if (n > 31) {
            this.notation = n;
        }
    }

    Node(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            this.count = 0;
        } else {
            this.count = -1;
            this.size = n2;
            this.onset = n;
            this.block = byArray;
        }
    }

    boolean absolutizeClassNode(boolean bl) throws IOException {
        AbsolutizeClassNode absolutizeClassNode = new AbsolutizeClassNode(bl, this);
        return absolutizeClassNode.bResult;
    }

    boolean absolutizeClassNode(boolean bl, Node node, int n, int n2) throws IOException {
        AbsolutizeClassNode absolutizeClassNode = new AbsolutizeClassNode(bl, this, node, n, n2);
        return absolutizeClassNode.bResult;
    }

    boolean clearConcept() throws IOException {
        if (!this.hasConcept()) {
            return false;
        }
        Node node = this.getIndex(62);
        if (node.deploy() != 0) {
            node.clearSign();
            if (node.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            }
        }
        this.clearIndex(62);
        this.setChange();
        return true;
    }

    boolean clearConnectNode() throws IOException {
        int n;
        boolean bl = false;
        if (this.deploy() == 0 || this.last < 56) {
            return false;
        }
        if (this.count == 1) {
            Node node = this.getIndex(this.last);
            bl = node.clearSign();
            if (node.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            }
            if (this.last != 62) {
                return this.clearSign(this.last);
            }
            return bl;
        }
        if (this.first < 56) {
            n = 24;
        } else {
            this.first = 0;
            n = this.first & 0x1F;
        }
        int n2 = this.last & 0x1F;
        int n3 = 30;
        this.last = 0;
        int n4 = n;
        while (n4 <= n2) {
            Node node = this.posterity[n4];
            if (node != null) {
                bl |= node.clearSign();
                if (node.address >= 0) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                }
                if (n4 == n3) {
                    this.last = 62;
                } else {
                    --this.count;
                    this.posterity[n4] = null;
                    bl = true;
                }
            }
            ++n4;
        }
        if (this.count == 0) {
            this.posterity = null;
            return bl;
        }
        if (this.count == 1) {
            if (this.first == 0) {
                this.first = this.last;
            } else {
                this.last = this.first;
            }
            this.descendant = this.posterity[this.last & 0x1F];
            this.posterity = null;
            return bl;
        }
        if (this.last != 0) {
            return bl;
        }
        n4 = n - 1;
        while (this.posterity[n4] == null) {
            --n4;
        }
        this.last = 0x20 | n4;
        return bl;
    }

    boolean clearConnectNode(int n) throws IOException {
        Node node = this.getConnectNode(n);
        if (node == null) {
            return false;
        }
        node.clearSign();
        if (node.address >= 0) {
            this.core.aFile.free(node.address);
            node.address = -1;
        }
        if (n != 62) {
            return this.clearSign(n);
        }
        return true;
    }

    boolean clearConnectNode(int n, Trace trace, Node node, int n2, int n3, boolean bl) throws IOException {
        Node node2 = this.getConnectNode(n);
        if (node2 == null) {
            return false;
        }
        node2.clearNode(trace, node, n2, n3, bl);
        if (node2.count == 0 && n != 62) {
            this.clearSign(n);
        }
        return true;
    }

    boolean clearIndex(int n) throws IOException {
        if (this.count == 0) {
            return false;
        }
        if (this.count == 1) {
            if (this.first == n) {
                if (n > 57) {
                    this.lowerPower();
                }
                this.count = 0;
                this.descendant = null;
                return true;
            }
            return false;
        }
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        int n4 = n & 0x1F;
        if (this.posterity[n4] == null) {
            return false;
        }
        --this.count;
        if (this.count == 1) {
            if (n4 == n2) {
                this.first = this.last;
            } else {
                this.last = this.first;
            }
            this.descendant = this.posterity[this.first & 0x1F];
            this.posterity = null;
        } else {
            this.posterity[n4] = null;
            if (n4 == n2) {
                n4 = n2 + 1;
                while (this.posterity[n4] == null) {
                    ++n4;
                }
                this.first = this.nextType | n4;
            } else if (n4 == n3) {
                n4 = n3 - 1;
                while (this.posterity[n4] == null) {
                    --n4;
                }
                this.last = this.nextType | n4;
            }
        }
        if (n > 57 && this.last < 57) {
            this.lowerPower();
        }
        return true;
    }

    boolean clearNode(int n, boolean bl) throws IOException {
        ClearNode clearNode = new ClearNode(this, n, bl);
        return clearNode.bResult;
    }

    boolean clearNode(Node node, int n, int n2, boolean bl) throws IOException {
        ClearNode clearNode = new ClearNode(this, node, n, n2, bl);
        return clearNode.bResult;
    }

    boolean clearNode(Trace trace, Node node, int n, int n2, boolean bl) throws IOException {
        Node node2;
        if (!this.hasSign()) {
            return false;
        }
        if (trace == null || trace.next == null) {
            node2 = this;
        } else {
            node2 = this.getTrace(trace);
            if (node2 == null) {
                return false;
            }
        }
        boolean bl2 = node == null ? node2.clearNode(n, bl) : node2.clearNode(node, n, n2, bl);
        if (node2.count == 0) {
            this.clearTrace(trace);
        }
        if (this.count == 0 && this.address >= 0) {
            this.core.aFile.free(this.address);
            this.address = -1;
        }
        return bl2;
    }

    boolean clearNodeConnection(int n, boolean bl, PList pList) throws IOException {
        ClearNodeConnection clearNodeConnection = new ClearNodeConnection(this, n, bl, pList);
        return clearNodeConnection.bResult;
    }

    boolean clearNodeConnection(Node node, int n, int n2, boolean bl, PList pList) throws IOException {
        ClearNodeConnection clearNodeConnection = new ClearNodeConnection(this, node, n, n2, bl, pList);
        return clearNodeConnection.bResult;
    }

    boolean clearSign() throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        this.clearSignNode1();
        this.setChange();
        return true;
    }

    boolean clearSign(int n) throws IOException {
        Node node = this.getSign(n);
        if (node == null) {
            return false;
        }
        node.clearSign();
        if ((n & 0x20) == this.nextType) {
            this.clearIndex(n);
        } else if ((n & 0x20) < this.nextType) {
            Node node2 = this.getIndex(this.notation);
            if (node2.count == 0) {
                this.clearIndex(this.notation);
            }
        }
        this.setChange();
        return true;
    }

    void clearSignNode1() throws IOException {
        if (this.deploy() == 0) {
            return;
        }
        if (this.last > 57) {
            this.lowerPower();
        }
        if (this.count == 1) {
            Node node = this.descendant;
            node.clearSignNode1();
            if (node.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            }
            this.count = 0;
            this.descendant = null;
            return;
        }
        int n = this.first & 0x1F;
        int n2 = this.last & 0x1F;
        int n3 = n;
        while (n3 <= n2) {
            Node node = this.posterity[n3];
            if (node != null) {
                node.clearSignNode1();
                if (node.address >= 0) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                }
            }
            ++n3;
        }
        this.count = 0;
        this.posterity = null;
    }

    Node clearTrace(Trace trace) throws IOException {
        int n;
        int n2;
        int n3;
        Trace trace2 = trace.next;
        if (this.deploy() == 0) {
            return this;
        }
        if (trace2 == null) {
            return this;
        }
        int n4 = trace2.sign & 0x20;
        if (this.nextType < n4) {
            if (this.notation != trace2.sign) {
                return this;
            }
            return this.clearTrace(trace2);
        }
        if (this.nextType > n4) {
            n3 = this.notation;
            trace2 = trace;
        } else {
            n3 = trace2.sign;
        }
        Node node = this.getIndex(n3);
        if (node == null) {
            return this;
        }
        if (trace2.sign == 52 && ((n2 = node.getDegree()) < (n = this.getTraceDegree(trace2)) ? (trace2 = this.getTraceFooting(trace2, n - n2)) == null : n2 > n && (node = node.getFooting(n2 - n)) == null)) {
            return this;
        }
        Node node2 = node.clearTrace(trace2);
        if (node.count != 0) {
            return node2;
        }
        if (node.address >= 0) {
            this.core.aFile.free(node.address);
            node.address = -1;
        }
        this.clearSign(n3);
        return this;
    }

    public Object clone(Node node) {
        Node node2 = null;
        try {
            node2 = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        if (this.count == 1) {
            node2.descendant = (Node)this.descendant.clone(node2);
        } else if (this.count > 1) {
            int n = this.last & 0x1F;
            node2.posterity = new Node[32];
            int n2 = this.first & 0x1F;
            while (n2 <= n) {
                if (this.posterity[n2] != null) {
                    node2.posterity[n2] = (Node)this.posterity[n2].clone(node2);
                }
                ++n2;
            }
        }
        node2.ancestor = node;
        if (this.block != null) {
            node2.block = new byte[this.block.length];
            System.arraycopy(this.block, 0, node2.block, 0, this.block.length);
        }
        return node2;
    }

    boolean close() throws IOException {
        this.save();
        this.core.aFile.close();
        if (this.address < 0) {
            return false;
        }
        this.ploy();
        this.block = new byte[4];
        this.onset = 0;
        this.size = PN.writeAddress(this.address, this.block, 0);
        this.address = -1;
        return true;
    }

    boolean correlates(Node node) throws IOException {
        if (this.deploy() == 0 || node.deploy() == 0) {
            return true;
        }
        return this.nextType != 0 || node.nextType != 0 || this.notation == node.notation;
    }

    Trace defTrace() {
        return this.defTrace(null);
    }

    Trace defTrace(Node node) {
        Trace trace;
        Trace trace2 = new Trace();
        Node node2 = this;
        while (node2 != node) {
            trace2.sign = node2.sign;
            node2 = node2.ancestor;
            trace = trace2;
            trace2 = new Trace();
            trace2.next = trace;
        }
        if (trace2.next != null && trace2.next.sign <= 31) {
            trace2.sign = node2.notation;
            trace = trace2;
            trace2 = new Trace();
            trace2.next = trace;
        }
        return trace2;
    }

    void definePower() {
        Node node;
        int n;
        if (this.first > 57) {
            return;
        }
        if (this.last > 57) {
            this.power = 1L;
        }
        if (this.count == 1) {
            this.power = this.descendant.power;
            if (this.last < 57) {
                this.descendant.power = 0L;
            }
            return;
        }
        int n2 = this.first & 0x1F;
        if (this.last < 57) {
            n = this.last & 0x1F;
        } else {
            n = 25;
            if ((node = this.posterity[n--]) != null) {
                this.power = node.power;
            }
        }
        int n3 = n2;
        while (n3 <= n) {
            node = this.posterity[n3];
            if (node != null) {
                this.power += node.power;
                node.power = 0L;
            }
            ++n3;
        }
    }

    boolean delete() throws IOException {
        this.core.aFile.close();
        if (!this.core.aFile.delete()) {
            return false;
        }
        this.ploy();
        this.count = 0;
        this.block = null;
        this.onset = 0;
        this.size = 0;
        this.address = -1;
        this.changed = false;
        return true;
    }

    int depends(Node node) {
        if (this == node) {
            return 0;
        }
        if (this.core != node.core) {
            String string = this.core.aFile.getAbsolutePath();
            String string2 = node.core.aFile.getAbsolutePath();
            if (string == null || string2 == null) {
                return -1;
            }
            if (!string.equals(string2)) {
                return -1;
            }
        }
        Trace trace = this.defTrace();
        Trace trace2 = node.defTrace();
        Concept.normal(trace);
        Concept.normal(trace2);
        Trace trace3 = new Trace();
        Trace trace4 = new Trace();
        if (!trace.equals(trace2, trace3, trace4)) {
            return -1;
        }
        if (trace3.next == trace4.next) {
            return 0;
        }
        if (trace4.next != null) {
            return 1;
        }
        return 2;
    }

    synchronized int deploy() throws IOException {
        Node node;
        int n;
        int n2;
        if (this.count >= 0) {
            return this.count;
        }
        Int1 int1 = new Int1(0);
        int n3 = this.onset;
        if (this.block == null) {
            this.count = 0;
            return this.count;
        }
        if ((n2 = this.block[n3++] & 0xFF) >= 192) {
            PN.readAddress(this.block, this.onset, int1);
            this.address = int1.value;
            this.block = this.core.aFile.read(this.address);
            if (this.block == null) {
                this.count = 0;
                this.address = -1;
                return this.count;
            }
            n3 = PN.readSize(this.block, 0, int1);
            this.size = int1.value;
            this.onset = n3;
            n2 = this.block[n3++] & 0xFF;
        }
        this.nextType = n2 & 0x20;
        if (n2 >= 128) {
            int n4;
            int n5 = 0;
            this.first = 3;
            int n6 = 0;
            while (n6 < 4) {
                if ((n2 & 1 << n6) != 0) {
                    n5 |= (this.block[n3++] & 0xFF) << (n6 << 3);
                    if (this.first > n6) {
                        this.first = n6;
                    }
                    this.last = n6;
                }
                ++n6;
            }
            this.last = (this.last << 3) + 7;
            int n7 = 1 << this.last;
            while ((n5 & n7) == 0) {
                --this.last;
                n7 >>>= 1;
            }
            this.first <<= 3;
            n7 = 1 << this.first;
            while ((n5 & n7) == 0) {
                ++this.first;
                n7 <<= 1;
            }
            if (this.nextType > 0 && this.first == 0) {
                n3 = PN.readSize(this.block, n3, int1);
                n4 = int1.value;
                this.powerNode = new Node(this.block, n3, n4);
                n3 += n4;
                ++this.first;
                n7 <<= 1;
                while ((n5 & n7) == 0) {
                    ++this.first;
                    n7 <<= 1;
                }
                if (this.first == this.last) {
                    this.count = 1;
                    n3 = PN.readSize(this.block, n3, int1);
                    n4 = int1.value;
                    this.descendant = new Node(this.block, n3, n4);
                    this.propagate(this.nextType | this.first, this.descendant);
                    this.first |= this.nextType;
                    this.last |= this.nextType;
                    return this.count;
                }
            }
            this.count = 0;
            this.posterity = new Node[32];
            int n8 = this.first;
            while (n8 <= this.last) {
                if ((n5 & n7) != 0) {
                    ++this.count;
                    n3 = PN.readSize(this.block, n3, int1);
                    n4 = int1.value;
                    this.posterity[n8] = new Node(this.block, n3, n4);
                    n3 += n4;
                    this.propagate(this.nextType | n8, this.posterity[n8]);
                }
                ++n8;
                n7 <<= 1;
            }
            this.first |= this.nextType;
            this.last |= this.nextType;
            return this.count;
        }
        int n9 = 0;
        int n10 = n3;
        Node node2 = this;
        if (n2 >= 64) {
            int n11 = n2 & 0x1F;
            int n12 = this.block[n3++] & 0xFF;
            int n13 = 8;
            while (true) {
                n9 = n12 & 0x1F;
                n = this.nextType | n9;
                n12 >>= 5;
                n13 -= 5;
                if (n11-- == 0) break;
                node = new Node();
                node2.count = 1;
                node2.nextType = this.nextType;
                node2.first = n;
                node2.last = n;
                node2.descendant = node;
                node2.propagate(n, node);
                node2 = node;
                if (n13 >= 5) continue;
                n12 |= (this.block[n3++] & 0xFF) << n13;
                n13 += 8;
            }
            node = new Node(this.block, n3, this.size - 1 - (n3 - n10));
        } else {
            n9 = n2 & 0x1F;
            n = this.nextType | n9;
            node = new Node(this.block, n3, this.size - 1);
        }
        node2.count = 1;
        node2.nextType = this.nextType;
        node2.first = n;
        node2.last = n;
        node2.descendant = node;
        node2.propagate(n, node);
        return 1;
    }

    Node freeAncestors() throws IOException {
        Node node = this;
        while (node.count == 0 && node.ancestor != null) {
            if (node.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            }
            int n = node.sign;
            node = node.ancestor;
            node.clearSign(n);
        }
        return node;
    }

    Node getConnectNode(int n) throws IOException {
        if (!this.hasConnectNode(n)) {
            return null;
        }
        return this.getIndex(n);
    }

    Node getConnectNode(int n, Trace trace, Node node, int n2, int n3, int n4, boolean bl) throws IOException {
        Node node2 = this.getConnectNode(n);
        if (node2 == null) {
            return null;
        }
        return node2.getNode(trace, node, n2, n3, n4, bl);
    }

    int getDegree() throws IOException {
        int n = 0;
        if (this.sign != 52) {
            return -1;
        }
        Node node = this;
        while (node.deploy() > 0 && node.nextType == 0) {
            ++n;
            node = node.getIndex(node.first);
        }
        return n;
    }

    Node getFooting(int n) {
        Node node = this;
        int n2 = 0;
        while (n2 < n) {
            if ((node = node.getIndex(0)) == null) {
                return null;
            }
            ++n2;
        }
        return node;
    }

    Node getIndex(int n) {
        if (this.count == 0) {
            return null;
        }
        if (this.count == 1) {
            if (n == this.first) {
                return this.descendant;
            }
            return null;
        }
        return this.posterity[n & 0x1F];
    }

    Node getNextNode(int n, Node node, Trace trace) throws IOException {
        if (this.deploy() == 0) {
            throw new IndexOutOfBoundsException("\nUnexpected empty node\nSystem error, please direct to TechCenter");
        }
        if (trace.next == null) {
            return this.nextNode(n, node);
        }
        int n2 = trace.next.sign & 0x20;
        if (this.nextType < n2) {
            if (this.notation != trace.next.sign) {
                return this.nextNode(n, node);
            }
            return this.getNextNode(n, node, trace.next);
        }
        Node node2 = this.nextType > n2 ? this.getIndex(this.notation) : this.getIndex(trace.next.sign);
        if (node2 == null) {
            return this.nextNode(n, node);
        }
        return node2.getNextNode(n, node, trace.next);
    }

    Node getNode(int n, boolean bl) throws IOException {
        GetNode getNode = new GetNode(this, n, bl);
        return getNode.nResult;
    }

    Node getNode(Node node, int n, int n2, int n3, boolean bl) throws IOException {
        GetNode getNode = new GetNode(this, node, n, n2, n3, bl);
        return getNode.nResult;
    }

    Node getNode(Trace trace, Node node, int n, int n2, int n3, boolean bl) throws IOException {
        Node node2;
        if (!this.hasSign()) {
            return null;
        }
        if (trace == null || trace.next == null) {
            node2 = this;
        } else {
            node2 = this.getTrace(trace, n);
            if (node2 == null) {
                return null;
            }
        }
        if (node == null) {
            return node2.getNode(n, bl);
        }
        return node2.getNode(node, n, n2, n3, bl);
    }

    Node getNodeBy(int n, boolean bl, PList pList) throws IOException {
        GetNodeBy getNodeBy = new GetNodeBy(this, n, bl, pList);
        return getNodeBy.nResult;
    }

    Node getNodeBy(Node node, int n, int n2, boolean bl, PList pList) throws IOException {
        GetNodeBy getNodeBy = new GetNodeBy(this, node, n, n2, bl, pList);
        return getNodeBy.nResult;
    }

    Node getNodeConnection(int n, PList pList) throws IOException {
        GetNodeConnection getNodeConnection = new GetNodeConnection(this, n, pList);
        return getNodeConnection.nResult;
    }

    Node getNodeConnection(Node node, int n, int n2, PList pList) throws IOException {
        GetNodeConnection getNodeConnection = new GetNodeConnection(this, node, n, n2, pList);
        if (getNodeConnection.nResult.count == 0) {
            return null;
        }
        return getNodeConnection.nResult;
    }

    PList getNodeConnectionList(int n, PList pList) throws IOException {
        GetNodeConnectionList getNodeConnectionList = new GetNodeConnectionList(this, n, pList);
        return getNodeConnectionList.lResult;
    }

    PList getNodeConnectionList(Node node, int n, int n2, PList pList) throws IOException {
        GetNodeConnectionList getNodeConnectionList = new GetNodeConnectionList(this, node, n, n2, pList);
        return getNodeConnectionList.lResult;
    }

    long getNodePower(int n, boolean bl) throws IOException {
        GetNodePower getNodePower = new GetNodePower(this, n, bl);
        return getNodePower.lResult;
    }

    long getNodePower(Node node, int n, int n2, boolean bl) throws IOException {
        GetNodePower getNodePower = new GetNodePower(this, node, n, n2, bl);
        return getNodePower.lResult;
    }

    Node getSign(int n) throws IOException {
        if (this.deploy() == 0) {
            return null;
        }
        if (this.nextType < (n & 0x20)) {
            if (this.notation == n) {
                return this;
            }
            return null;
        }
        if (this.nextType > (n & 0x20)) {
            Node node = this.getIndex(this.notation);
            if (node == null) {
                return null;
            }
            return node.getSign(n);
        }
        return this.getIndex(n);
    }

    Node getTrace(Trace trace) throws IOException {
        return this.getTrace(trace, 62);
    }

    Node getTrace(Trace trace, int n) throws IOException {
        Node node = this;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            int n2;
            int n3;
            if (this.deploy() == 0) {
                return null;
            }
            if (trace2.sign > n) {
                return null;
            }
            if ((node = node.getSign(trace2.sign)) == null) {
                return null;
            }
            if (trace2.sign == 52 && trace2.next != null && ((n3 = node.getDegree()) < (n2 = this.getTraceDegree(trace2)) ? (trace2 = this.getTraceFooting(trace2, n2 - n3)) == null : n3 > n2 && (node = node.getFooting(n3 - n2)) == null)) {
                return null;
            }
            trace2 = trace2.next;
        }
        return node;
    }

    int getTraceDegree(Trace trace) {
        int n = 0;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            if (trace2.sign > 31) {
                return n;
            }
            ++n;
            trace2 = trace2.next;
        }
        return n;
    }

    Trace getTraceFooting(Trace trace, int n) {
        Trace trace2 = trace;
        int n2 = 0;
        while (n2 < n) {
            trace2 = trace2.next;
            if (trace2 == null || trace2.sign != 0) {
                return null;
            }
            ++n2;
        }
        return trace2;
    }

    boolean hasConcept() throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.last < 62) {
            return false;
        }
        return this.last == 62 || this.hasSign(62);
    }

    boolean hasConcept(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        return this.last > n || n == 62 && this.hasSign(62);
    }

    boolean hasConnect(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.last < n) {
            return false;
        }
        return this.hasIndex(n);
    }

    boolean hasConnectNode() throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.last < 56) {
            return false;
        }
        if (this.count > 1) {
            int n = 56;
            while (n <= 62) {
                Node node = this.posterity[n & 0x1F];
                if (node != null && node.deploy() != 0) {
                    return true;
                }
                ++n;
            }
        } else {
            return this.descendant.deploy() != 0;
        }
        return false;
    }

    boolean hasConnectNode(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        if (this.last < n) {
            return false;
        }
        Node node = this.getIndex(n);
        return node != null && node.deploy() != 0;
    }

    boolean hasConnectNode(int n, Trace trace, Node node, int n2, int n3, int n4, boolean bl) throws IOException {
        Node node2 = this.getConnectNode(n);
        if (node2 == null) {
            return false;
        }
        return node2.hasNode(trace, node, n2, n3, n4, bl);
    }

    boolean hasIndex(int n) throws IOException {
        return this.getIndex(n) != null;
    }

    boolean hasNode(Node node, int n, int n2, int n3, boolean bl) throws IOException {
        HasNode hasNode = new HasNode(this, node, n, n2, n3, bl);
        return hasNode.bResult;
    }

    boolean hasNode(Trace trace, Node node, int n, int n2, int n3, boolean bl) throws IOException {
        Node node2;
        if (!this.hasSign()) {
            return false;
        }
        if (trace == null || trace.next == null) {
            node2 = this;
        } else {
            node2 = this.getTrace(trace, n);
            if (node2 == null) {
                return false;
            }
        }
        if (node == null) {
            return true;
        }
        return node2.hasNode(node, n, n2, n3, bl);
    }

    boolean hasNodeConnection(int n, PList pList) throws IOException {
        HasNodeConnection hasNodeConnection = new HasNodeConnection(this, n, pList);
        return hasNodeConnection.bResult;
    }

    boolean hasNodeConnection(Node node, int n, int n2, PList pList) throws IOException {
        HasNodeConnection hasNodeConnection = new HasNodeConnection(this, node, n, n2, pList);
        return hasNodeConnection.bResult;
    }

    boolean hasNotatNode(int n) throws IOException {
        if (this.deploy() == 0) {
            return false;
        }
        return this.first <= n;
    }

    boolean hasSign() throws IOException {
        return this.deploy() != 0;
    }

    boolean hasSign(int n) throws IOException {
        return this.getSign(n) != null;
    }

    void infix(int n) {
        Node node = new Node();
        node.count = this.count;
        node.nextType = this.nextType;
        node.first = this.first;
        node.last = this.last;
        node.descendant = this.descendant;
        node.posterity = this.posterity;
        node.changed = this.changed;
        node.onset = this.onset;
        node.size = this.size;
        node.block = this.block;
        if (this.address == 0 && this.ancestor == null) {
            node.address = -1;
        } else {
            node.address = this.address;
            this.address = -1;
        }
        if (this.count == 1) {
            this.descendant.ancestor = node;
        } else {
            int n2 = this.first & 0x1F;
            int n3 = this.last & 0x1F;
            int n4 = n2;
            while (n4 <= n3) {
                Node node2 = this.posterity[n4];
                if (node2 != null) {
                    node2.ancestor = node;
                }
                ++n4;
            }
            this.posterity = null;
        }
        this.count = 0;
        this.setIndex(n, node);
    }

    void infixFooting(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = 0;
        while (n2 < n) {
            this.infix(0);
            ++n2;
        }
        Node node = this.getFooting(n - 1);
        node.setChange();
    }

    void jam(Node node) throws IOException {
        node.deploy();
        if (node.address >= 0) {
            if (this.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            } else {
                this.address = node.address;
            }
        }
        if (node.count == 1 && node.first == node.notation) {
            this.jam(node.descendant);
            return;
        }
        if (!node.changed) {
            this.size = node.size;
            this.onset = node.onset;
            this.block = node.block;
        }
        this.count = node.count;
        this.changed = node.changed;
        this.nextType = node.nextType;
        this.first = node.first;
        this.last = node.last;
        this.descendant = node.descendant;
        this.posterity = node.posterity;
        if (this.count == 1) {
            this.descendant.ancestor = this;
        } else {
            int n = this.first & 0x1F;
            int n2 = this.last & 0x1F;
            int n3 = n;
            while (n3 <= n2) {
                if (this.posterity[n3] != null) {
                    this.posterity[n3].ancestor = this;
                }
                ++n3;
            }
        }
    }

    Node lastNode(int n) throws IOException {
        Node node;
        if (this.first > n) {
            return this;
        }
        int n2 = this.first & 0x1F;
        if (this.last > n) {
            node = null;
            int n3 = n & 0x1F;
            while (n3 >= n2) {
                node = this.posterity[n3];
                if (node == null) {
                    --n3;
                    continue;
                }
                break;
            }
        } else {
            node = this.count == 1 ? this.descendant : this.posterity[this.last & 0x1F];
        }
        if (node.deploy() == 0) {
            return null;
        }
        return node.lastNode(n);
    }

    void lowerPower() {
        if (this.sign >= 57 || this.ancestor == null) {
            this.restorePower();
            this.powerNode = null;
            --this.power;
        }
        if (this.sign <= 57 && this.ancestor != null) {
            this.ancestor.lowerPower();
        }
    }

    Node nextNode(int n, Node node) throws IOException {
        Node node2;
        if (this.first <= n) {
            node2 = this.count == 1 ? this.descendant : this.posterity[this.first & 0x1F];
            if (node2.deploy() != 0) {
                if (node2.hasConcept(n)) {
                    return node2;
                }
                return node2.nextNode(n, node);
            }
        } else {
            node2 = this;
        }
        while (node2 != node) {
            int n2 = node2.sign & 0x1F;
            node2 = node2.ancestor;
            if (node2.count <= 1) continue;
            int n3 = node2.last > n ? n & 0x1F : node2.last & 0x1F;
            while (++n2 <= n3) {
                if (node2.posterity[n2] == null) continue;
                node2 = node2.posterity[n2];
                node2.deploy();
                if (node2.hasConcept(n)) {
                    return node2;
                }
                return node2.nextNode(n, node);
            }
        }
        return null;
    }

    void pack() throws IOException {
        int n;
        Node node = null;
        if (this.count <= 0) {
            return;
        }
        if (this.size > 0) {
            return;
        }
        if (this.power > 0L && this.powerNode == null) {
            this.packPower();
        }
        if (this.powerNode != null && this.nextType == 0) {
            this.infix(this.notation);
        }
        if (this.count == 1 && this.powerNode == null) {
            node = this.descendant;
            int n2 = 1;
            if (this.nextType == 0) {
                while (node.count == 1) {
                    if (node.first == node.notation) {
                        node.jam(node.descendant);
                    }
                    if (node.nextType != 0 || node.address >= 0 && node.size + n2 > 8190) break;
                    node = node.descendant;
                    if (++n2 <= 31) continue;
                }
                if (n2 == 2) {
                    node = this.descendant;
                    n2 = 1;
                }
            }
            if (n2 == 1) {
                this.size = 1;
                this.block = new byte[this.size];
                this.block[0] = (byte)node.sign;
            } else {
                this.size = (int)Math.ceil((double)n2 * 5.0 / 8.0) + 1;
                this.block = new byte[this.size];
                this.block[0] = (byte)(0x40 | this.nextType | n2 - 1);
                int n3 = 1;
                int n4 = 0;
                int n5 = 0;
                node = this.descendant;
                while (true) {
                    n5 |= (node.sign & 0x1F) << n4;
                    if ((n4 += 5) > 7) {
                        this.block[n3++] = (byte)n5;
                        n5 >>= 8;
                        n4 -= 8;
                    }
                    if (--n2 == 0) break;
                    if (node.address >= 0) {
                        this.core.aFile.free(node.address);
                        node.address = -1;
                    }
                    if (!node.changed) {
                        node.changed = true;
                        node.size = 0;
                        node.block = null;
                        node.onset = 0;
                    }
                    node = node.descendant;
                }
                if (n4 > 0) {
                    this.block[n3++] = (byte)n5;
                }
            }
            node.pack();
            if (node.address >= 0) {
                if (this.size + node.size <= 8190) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                    this.size += node.size;
                } else {
                    this.size = node.address > 0x1FFFFF ? (this.size += 4) : (this.size += 3);
                }
            } else if (this.size + node.size > 8190) {
                node.address = this.core.aFile.alloc();
                node.changed = true;
                this.size = node.address > 0x1FFFFF ? (this.size += 4) : (this.size += 3);
            } else {
                this.size += node.size;
            }
            return;
        }
        int n6 = 0;
        int n7 = -1;
        int n8 = 8190;
        int n9 = 0;
        int n10 = this.first & 0x1F;
        int n11 = this.last & 0x1F;
        if (this.powerNode != null) {
            n6 = 1;
            n = this.powerNode.size;
            this.size = n > 127 ? (this.size += n + 2) : (this.size += n + 1);
        }
        if (this.count == 1) {
            node = this.descendant;
            n6 |= 1 << (node.sign & 0x1F);
            node.pack();
            if (node.address >= 0) {
                if (node.size <= 4095) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                    n = node.size;
                } else {
                    n = node.address > 0x1FFFFF ? 4 : 3;
                }
            } else {
                n = node.size;
            }
            this.size = n > 127 ? (this.size += n + 2) : (this.size += n + 1);
        } else {
            n9 = n10;
            while (n9 <= n11) {
                node = this.posterity[n9];
                if (node != null) {
                    n6 |= 1 << n9;
                    node.pack();
                    if (node.address >= 0) {
                        if (node.size <= 4095 && node.size < n8) {
                            n7 = n9;
                            n8 = node.size;
                        }
                        n = node.address > 0x1FFFFF ? 4 : 3;
                    } else {
                        n = node.size;
                    }
                    this.size = n > 127 ? (this.size += n + 2) : (this.size += n + 1);
                }
                ++n9;
            }
        }
        int n12 = 1;
        int n13 = 0x80 | this.nextType;
        int n14 = 255;
        int n15 = 0;
        while (n15 < 4) {
            if ((n6 & n14) != 0) {
                ++n12;
                n13 |= 1 << n15;
            }
            n14 <<= 8;
            ++n15;
        }
        this.size += n12;
        this.block = new byte[n12];
        this.block[0] = (byte)n13;
        int n16 = 1;
        n15 = 0;
        while (n15 < 4) {
            n14 = n6 & 0xFF;
            if (n14 != 0) {
                this.block[n16++] = (byte)n14;
            }
            n6 >>>= 8;
            ++n15;
        }
        while (n7 >= 0) {
            if (this.size - 2 + n8 > 8190) break;
            node = this.posterity[n7];
            this.size = node.address > 0x1FFFFF ? (this.size -= 4) : (this.size -= 3);
            this.core.aFile.free(node.address);
            node.address = -1;
            this.size += n8;
            if (n8 > 127) {
                ++this.size;
            }
            n7 = -1;
            n8 = 8190;
            if (this.size > 4095) continue;
            n9 = n10;
            while (n9 <= n11) {
                node = this.posterity[n9];
                if (node != null && node.address >= 0 && node.size < 4095 && node.size < n8) {
                    n8 = node.size;
                    n7 = n9;
                }
                ++n9;
            }
        }
        while (this.size > 8190) {
            n = 0;
            if (this.count == 1) {
                node = this.descendant;
                n = node.size;
            } else {
                n9 = n10;
                while (n9 <= n11) {
                    node = this.posterity[n9];
                    if (node != null && node.count != 0 && node.address < 0 && node.size > n) {
                        n14 = n9;
                        n = node.size;
                    }
                    ++n9;
                }
                node = this.posterity[n14];
            }
            this.size -= n;
            if (n > 127) {
                --this.size;
            }
            node.address = this.core.aFile.alloc();
            node.changed = true;
            if (node.address > 0x1FFFFF) {
                this.size += 4;
                continue;
            }
            this.size += 3;
        }
    }

    void packPower() {
        this.powerNode = new Node(32);
        this.powerNode.core = this.core;
        Trace trace = new Trace(this.power, 31, 5);
        try {
            Node node = this.powerNode.setTrace(trace);
            this.powerNode.pack();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    void ploy() {
        this.count = -1;
        this.descendant = null;
        this.posterity = null;
    }

    void print() throws IOException {
        this.print(new PrintWriter(System.out));
    }

    void print(PrintWriter printWriter) throws IOException {
        printWriter.print("Node=");
        this.printAncestor(printWriter);
        printWriter.println();
        this.printDescendants(printWriter, 0);
        printWriter.println();
        printWriter.flush();
    }

    void printAncestor(PrintWriter printWriter) throws IOException {
        if (this.ancestor != null) {
            this.ancestor.printAncestor(printWriter);
            printWriter.print(':');
        }
        printWriter.print(this.sign);
    }

    void printDescendants(PrintWriter printWriter, int n) throws IOException {
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        String string = String.valueOf(this.sign);
        if (n != 0) {
            printWriter.print(string);
            n += string.length();
        }
        if (this.deploy() <= 0) {
            return;
        }
        printWriter.print(':');
        ++n;
        boolean bl = true;
        if (this.descendant != null) {
            this.descendant.printDescendants(printWriter, n);
        } else {
            int n4 = n2;
            while (n4 <= n3) {
                if (this.posterity[n4] != null) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.printLineSpace(printWriter, n);
                    }
                    this.posterity[n4].printDescendants(printWriter, n);
                }
                ++n4;
            }
        }
    }

    void printLineSpace(PrintWriter printWriter, int n) throws IOException {
        printWriter.println();
        int n2 = 0;
        while (n2 < n) {
            printWriter.print(' ');
            ++n2;
        }
    }

    void propagate(int n, Node node) {
        node.ancestor = this;
        node.core = this.core;
        node.sign = n;
        node.notation = n >= 56 ? 50 : (n > 31 ? n : this.notation);
    }

    boolean restore() throws IOException {
        if (!this.changed) {
            return false;
        }
        if (this.address < 0) {
            return false;
        }
        this.changed = false;
        this.ploy();
        this.block = new byte[4];
        this.onset = 0;
        this.size = PN.writeAddress(this.address, this.block, 0);
        this.address = -1;
        return true;
    }

    long restorePower() {
        if (this.power > 0L) {
            return this.power;
        }
        if (this.powerNode == null) {
            return 0L;
        }
        Node node = this.powerNode;
        try {
            while (node.deploy() != 0) {
                node = node.descendant;
                this.power = this.power << 5 | (long)node.sign;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1L;
        }
        return this.power;
    }

    void save() throws IOException {
        if (!this.changed) {
            return;
        }
        if (this.address < 0) {
            this.address = this.core.aFile.alloc();
        }
        this.pack();
        this.core.aFile.openSaving();
        byte[] byArray = new byte[8192];
        int n = PN.writeSize(this.size, byArray, 0);
        this.save1(byArray, n);
        if (this.address == 0) {
            Int1 int1 = new Int1(0);
            n = PN.readSize(byArray, 0, int1);
            if ((n += int1.value) + 3 < 8192) {
                PN.writeAddress(521, byArray, n);
            }
        }
        this.core.aFile.write(byArray, this.address);
        this.core.aFile.closeSaving();
    }

    void save1(byte[] byArray, int n) throws IOException {
        if (this.count == 0) {
            return;
        }
        if (this.onset > 0) {
            System.arraycopy(this.block, this.onset, byArray, n, this.size);
            this.block = byArray;
            this.onset = n;
            return;
        }
        System.arraycopy(this.block, 0, byArray, n, this.block.length);
        this.onset = n;
        n += this.block.length;
        this.block = byArray;
        if (this.count == 1 && this.powerNode == null) {
            Node node = this.descendant;
            while (node.count == 1 && node.size == 0) {
                node.changed = false;
                node = node.descendant;
            }
            if (node.address >= 0) {
                node.save3();
            } else {
                node.save1(byArray, n);
            }
            this.changed = false;
            return;
        }
        if (this.powerNode != null) {
            n = this.powerNode.save2(byArray, n);
        }
        if (this.count == 1) {
            Node node = this.descendant;
            node.save2(byArray, n);
            this.changed = false;
            return;
        }
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        int n4 = n2;
        while (n4 <= n3) {
            Node node = this.posterity[n4];
            if (node != null) {
                n = node.save2(byArray, n);
            }
            ++n4;
        }
        this.changed = false;
    }

    int save2(byte[] byArray, int n) throws IOException {
        if (this.address >= 0) {
            int n2 = this.address > 0x1FFFFF ? 4 : 3;
            n = PN.writeSize(n2, byArray, n);
            n = PN.writeAddress(this.address, byArray, n);
            this.save3();
        } else {
            n = PN.writeSize(this.size, byArray, n);
            this.save1(byArray, n);
            n += this.size;
        }
        return n;
    }

    void save3() throws IOException {
        if (!this.changed) {
            return;
        }
        byte[] byArray = new byte[8192];
        int n = PN.writeSize(this.size, byArray, 0);
        this.save1(byArray, n);
        this.core.aFile.write(byArray, this.address);
    }

    Node seekClassDefnNode() throws IOException {
        if (this.hasConcept(57)) {
            return this;
        }
        if (this.count == 1) {
            Node node = this.descendant.seekClassDefnNode();
            if (node == null && this.hasIndex(57)) {
                return this;
            }
            return node;
        }
        return null;
    }

    Node seekKeyNode(int n) throws IOException {
        if (this.hasConcept(n) || this.count > 1) {
            return this;
        }
        if (this.count == 0) {
            return null;
        }
        return this.descendant.seekKeyNode(n);
    }

    void setChange() {
        Node node = this;
        while (node != null) {
            if (node.changed && node.size == 0) {
                return;
            }
            node.changed = true;
            node.onset = 0;
            node.size = 0;
            node.block = null;
            node = node.ancestor;
        }
    }

    boolean setConcept() throws IOException {
        if (this.hasConcept()) {
            return false;
        }
        this.setSign(62, new Node());
        this.setChange();
        return true;
    }

    boolean setConnectNode(int n, Trace trace, Node node, int n2, boolean bl) throws IOException {
        Node node2 = this.getSign(n);
        if (node2 == null) {
            node2 = new Node();
            this.setSign(n, node2);
        }
        return node2.setNode(trace, node, n2, bl);
    }

    Node setCorrelating(Node node) throws IOException {
        if (this.correlates(node)) {
            return this;
        }
        Node node2 = new Node();
        this.setIndex(node.notation, node2);
        return node2;
    }

    Node setFooting(int n) {
        if (n == 0) {
            return this;
        }
        Node node = this.getIndex(0);
        if (node == null) {
            node = new Node();
            this.setIndex(0, node);
            return node.setFooting(n - 1);
        }
        return node.setFooting(n - 1);
    }

    void setIndex(int n, Node node) {
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        int n4 = n & 0x1F;
        if (this.count == 0) {
            if (n > 57) {
                this.upperPower();
            }
            this.count = 1;
            this.nextType = n & 0x20;
            this.first = n;
            this.last = n;
            this.descendant = node;
            this.propagate(n, node);
            return;
        }
        if (this.count == 1) {
            if (n2 == n4) {
                return;
            }
            this.posterity = new Node[32];
            this.posterity[n2] = this.descendant;
            this.descendant = null;
        }
        if (this.posterity[n4] != null) {
            return;
        }
        if (n > 57 && this.last <= 57) {
            this.upperPower();
        }
        ++this.count;
        if (n4 < n2) {
            this.first = this.nextType | n4;
        } else if (n4 > n3) {
            this.last = this.nextType | n4;
        }
        this.posterity[n4] = node;
        this.propagate(n, node);
    }

    boolean setNode(Node node, int n, boolean bl) throws IOException {
        SetNode setNode = new SetNode(this, node, n, bl);
        return setNode.bResult;
    }

    boolean setNode(Trace trace, Node node, int n, boolean bl) throws IOException {
        this.deploy();
        Node node2 = trace == null || trace.next == null ? this : this.setTrace(trace);
        if (node == null) {
            return node2.setConcept();
        }
        return node2.setNode(node, n, bl);
    }

    boolean setNodeConception(Node node, int n, boolean bl, PList pList) throws IOException {
        SetNodeConception setNodeConception = new SetNodeConception(this, node, n, bl, pList);
        return setNodeConception.bResult;
    }

    boolean setNodeConnection(int n, boolean bl, PList pList) throws IOException {
        SetNodeConnection setNodeConnection = new SetNodeConnection(this, n, bl, pList);
        return setNodeConnection.bResult;
    }

    boolean setNodeConnection(Node node, int n, int n2, boolean bl, PList pList) throws IOException {
        SetNodeConnection setNodeConnection = new SetNodeConnection(this, node, n, n2, bl, pList);
        return setNodeConnection.bResult;
    }

    boolean setSign(int n, Node node) throws IOException {
        Node node2 = this.getSign(n);
        if (node2 != null) {
            return false;
        }
        if (this.count == 0 || (n & 0x20) == this.nextType) {
            this.setIndex(n, node);
        } else if ((n & 0x20) < this.nextType) {
            node2 = new Node();
            this.setIndex(this.notation, node2);
            node2.setIndex(n, node);
        } else {
            this.infix(this.notation);
            this.setIndex(n, node);
        }
        return true;
    }

    Node setTrace(Trace trace) throws IOException {
        int n;
        Trace trace2 = trace.next;
        if (trace2 == null) {
            return this;
        }
        if (this.notation == trace2.sign) {
            return this.setTrace(trace2);
        }
        if (this.deploy() == 0) {
            Node node = new Node();
            this.setIndex(trace2.sign, node);
            return node.setTrace(trace2);
        }
        int n2 = trace2.sign & 0x20;
        if (this.nextType < n2) {
            this.infix(this.notation);
        }
        if (this.nextType > n2) {
            n = this.notation;
            trace2 = trace;
        } else {
            n = trace2.sign;
        }
        Node node = this.getIndex(n);
        if (node == null) {
            node = new Node();
            this.setIndex(n, node);
        }
        if (n == 52) {
            int n3;
            int n4 = node.getDegree();
            if (n4 < (n3 = this.getTraceDegree(trace2))) {
                node.infixFooting(n3 - n4);
            } else if (n4 > n3) {
                node = node.setFooting(n4 - n3);
            }
        }
        return node.setTrace(trace2);
    }

    boolean store() throws IOException {
        if (this.count < 0) {
            return false;
        }
        int n = this.first & 0x1F;
        int n2 = this.last & 0x1F;
        if (this != this.core.node) {
            return this.store(n, n2);
        }
        this.save();
        if (this.count == 1) {
            this.descendant.ploy();
            return true;
        }
        int n3 = n;
        while (n3 <= n2) {
            if (this.posterity[n3] != null) {
                this.posterity[n3].ploy();
            }
            ++n3;
        }
        return true;
    }

    boolean store(int n, int n2) throws IOException {
        if (this.count <= 0 || n > (this.last & 0x1F) || n2 < (this.first & 0x1F)) {
            return false;
        }
        if (this.core.node.address < 0) {
            this.core.node.address = this.core.aFile.alloc();
        }
        this.pack();
        this.core.aFile.openSaving();
        if (this.count == 1) {
            this.descendant.store1();
        } else {
            int n3 = n;
            while (n3 <= n2) {
                if (this.posterity[n3] != null) {
                    this.posterity[n3].store1();
                }
                ++n3;
            }
        }
        this.core.aFile.closeSaving();
        return true;
    }

    void store1() throws IOException {
        if (this.changed) {
            byte[] byArray = this.address >= 0 ? new byte[8192] : new byte[this.size + 2];
            int n = PN.writeSize(this.size, byArray, 0);
            this.save1(byArray, n);
            if (this.address >= 0) {
                this.core.aFile.write(byArray, this.address);
            }
        }
        this.ploy();
    }

    public String toString() {
        try {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            this.print(printWriter);
            return stringWriter.getBuffer().toString();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return "";
        }
    }

    void upperPower() {
        if (this.sign >= 57 || this.ancestor == null) {
            this.restorePower();
            this.powerNode = null;
            ++this.power;
        }
        if (this.sign <= 57 && this.ancestor != null) {
            this.ancestor.upperPower();
        }
    }
}

