/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

public class Trace
implements Cloneable {
    public int sign;
    public Trace next;

    public Trace() {
        this.sign = -1;
    }

    public Trace(int n) {
        this.sign = n;
    }

    Trace(int n, int n2, int n3) {
        this.sign = -1;
        if (n == 0) {
            this.next = new Trace(0);
            return;
        }
        Trace trace = null;
        while (n > 0) {
            Trace trace2 = new Trace(n & n2);
            trace2.next = trace;
            trace = trace2;
            n >>>= n3;
        }
        this.next = trace;
    }

    Trace(long l, int n, int n2) {
        this.sign = -1;
        if (l == 0L) {
            this.next = new Trace(0);
            return;
        }
        Trace trace = null;
        while (l > 0L) {
            Trace trace2 = new Trace((int)l & n);
            trace2.next = trace;
            trace = trace2;
            l >>>= n2;
        }
        this.next = trace;
    }

    public Object clone() {
        Trace trace = null;
        try {
            trace = (Trace)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        if (this.next != null) {
            trace.next = (Trace)this.next.clone();
        }
        return trace;
    }

    public boolean equals(Trace trace) {
        Trace trace2 = this;
        Trace trace3 = trace;
        while (trace3.next != null) {
            if (trace2.next == null) {
                return false;
            }
            if (trace3.next.sign != trace2.next.sign) {
                return false;
            }
            trace3 = trace3.next;
            trace2 = trace2.next;
        }
        return trace2.next == null;
    }

    public boolean equals(Trace trace, Trace trace2, Trace trace3) {
        Trace trace4 = this;
        Trace trace5 = trace;
        while (trace5.next != null) {
            if (trace4.next == null) break;
            if (trace5.next.sign != trace4.next.sign) {
                trace2.next = trace4.next;
                trace3.next = trace5.next;
                return false;
            }
            trace5 = trace5.next;
            trace4 = trace4.next;
        }
        trace2.next = trace4.next;
        trace3.next = trace5.next;
        return true;
    }

    public boolean equals(Trace trace, Trace trace2, Trace trace3, Trace trace4) {
        Trace trace5 = this;
        Trace trace6 = trace;
        Trace trace7 = trace4;
        while (trace6.next != null) {
            if (trace5.next == null) break;
            if (trace5.next.sign != trace6.next.sign) {
                trace2.next = trace5.next;
                trace3.next = trace6.next;
                return trace4.next != null;
            }
            trace7 = trace7.next = new Trace(trace5.next.sign);
            trace5 = trace5.next;
            trace6 = trace6.next;
        }
        trace2.next = trace5.next;
        trace3.next = trace6.next;
        return true;
    }

    Trace getFirstPart(int n) {
        Trace trace = new Trace();
        Trace trace2 = trace.next;
        Trace trace3 = this.next;
        while (trace3 != null && trace3.sign != n) {
            trace2 = new Trace(trace3.sign);
            trace2 = trace2.next;
            trace3 = trace3.next;
        }
        return trace;
    }

    public Trace getLast() {
        Trace trace = this;
        while (trace.next != null) {
            trace = trace.next;
        }
        return trace;
    }

    boolean increase(int n) {
        Trace trace = this.next;
        if (trace == null || trace.increase(n)) {
            if (this.sign > n) {
                Trace trace2 = trace.getLast();
                trace2.next = new Trace(1);
                return false;
            }
            if (this.sign == n) {
                this.sign = 0;
                return true;
            }
            ++this.sign;
            return false;
        }
        return false;
    }

    public Trace insert(Trace trace) {
        Trace trace2 = this;
        Trace trace3 = this.next;
        while (trace.next != null) {
            trace = trace.next;
            trace2 = trace2.next = new Trace(trace.sign);
        }
        trace2.next = trace3;
        return trace2;
    }

    public Trace substitute(Trace trace) {
        Trace trace2 = this;
        while (trace2.next != null) {
            if (trace.next == null) {
                trace2.next = null;
                return trace2;
            }
            trace2 = trace2.next;
            trace = trace.next;
            trace2.sign = trace.sign;
        }
        return trace2.insert(trace);
    }

    int toInteger(int n, int n2) {
        Trace trace = this;
        int n3 = 0;
        while (trace.next != null && trace.next.sign <= n) {
            trace = trace.next;
            n3 <<= n2;
            n3 |= trace.sign;
        }
        return n3;
    }

    long toLong(int n, int n2) {
        Trace trace = this;
        long l = 0L;
        while (trace.next != null && trace.next.sign <= n) {
            trace = trace.next;
            l <<= n2;
            l |= (long)trace.sign;
        }
        return l;
    }
}

