/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.Long1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Processor.PromptAssociation;
import Sav.Processor.Trace;
import Sav.Z.Commutator;
import Sav.Z.Expression;
import Sav.Z.Interface;
import Sav.Z.Statement;
import Sav.Z.Status;
import Sav.Z.StatusLine;
import Sav.Z.UndeletedFileException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class DBConnection
implements Interface {
    public static int defaultOutLimit = 1000000;
    public static String defaultDBPath = "Common";
    Association base;
    Association var;
    PromptAssociation spec;
    Statement savedStm;
    Statement curStm;
    PrintWriter pw;
    StringWriter sw;
    int outLimit;
    int outSum;
    Commutator comm = new Commutator();
    StatusLine stLine;
    Status stProcess;
    Status stResult;
    Status stDataBase;
    PList warnings = new PList();

    public DBConnection() throws IOException {
        this.base = new Association(defaultDBPath, true);
        this.construct();
    }

    public DBConnection(File file) throws IOException {
        this.base = new Association(file);
        this.construct();
    }

    public DBConnection(File file, boolean bl) throws IOException {
        this.base = new Association(file, bl);
        this.construct();
    }

    public DBConnection(String string) throws IOException {
        this.base = new Association(string);
        this.construct();
    }

    public DBConnection(String string, String string2) throws IOException {
        this.base = new Association(string, string2);
        this.construct();
    }

    public DBConnection(String string, String string2, boolean bl) throws IOException {
        this.base = new Association(string, string2, bl);
        this.construct();
    }

    public DBConnection(String string, boolean bl) throws IOException {
        this.base = new Association(string, bl);
        this.construct();
    }

    public DBConnection(boolean bl) throws IOException {
        this.base = new Association(defaultDBPath, bl);
        this.construct();
    }

    public void addOutSum(int n) {
        this.outSum += n;
    }

    void changeBase(File file) throws IOException {
        this.savedStm = this.curStm;
        this.base.close();
        this.var.store();
        this.spec.store();
        this.base = new Association(file);
    }

    void changeBase1(File file) throws IOException {
        this.savedStm = this.curStm;
        this.base.close();
        this.var.store();
        this.spec.store();
        if (!file.delete() && file.exists()) {
            throw new UndeletedFileException();
        }
        this.base = new Association(file);
    }

    public void clearControlDataBase() {
        this.stDataBase = null;
    }

    public void clearControlLine() {
        this.stLine = null;
    }

    public void clearControlProcess() {
        this.stProcess = null;
    }

    public void clearControlResult() {
        this.stResult = null;
    }

    public void clearOutLimit() {
        this.outLimit = 0;
    }

    public void clearOutSum() {
        this.outSum = 0;
    }

    public void clearPrintWriter() {
        this.sw = null;
        this.pw = null;
    }

    void clearStatusDataBase() {
        if (this.stDataBase != null) {
            this.stDataBase.clear();
        }
    }

    public void clearStatusLine() {
        if (this.stLine != null) {
            this.stLine.clear();
        }
    }

    public void clearStatusProcess() {
        if (this.stProcess != null) {
            this.stProcess.clear();
        }
    }

    public void clearStatusResult() {
        if (this.stResult != null) {
            this.stResult.clear();
        }
    }

    public void clearStringWriter() {
        if (this.sw == null) {
            return;
        }
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void clearWarnings() {
        this.warnings = new PList();
    }

    public void close() throws IOException {
        this.base.close();
        this.var.delete();
        this.spec.delete();
    }

    void construct() {
        Concept concept = new Concept(4);
        try {
            File file = new File("$Variables");
            file.delete();
            this.var = new Association("$Variables");
            this.spec = new PromptAssociation();
            this.spec.con(61);
            this.spec.con("print");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("p");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printLine");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pl");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printName");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pn");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printClass");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pc");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printRelation");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pr");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("printTable");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("pt");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("readTable");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("rt");
            this.spec.setConnect(61, concept);
            this.spec.uncon();
            this.spec.con("");
            this.spec.setConnect(61, new Concept(2));
            this.spec.regain();
            this.spec.con(57);
            this.spec.con(concept).con(57);
            this.spec.set("print");
            this.spec.set("p");
            this.spec.set("printLine");
            this.spec.set("pl");
            this.spec.set("printName");
            this.spec.set("pn");
            this.spec.set("printClass");
            this.spec.set("pc");
            this.spec.set("printRelation");
            this.spec.set("pr");
            this.spec.set("printTable");
            this.spec.set("pt");
            this.spec.set("readTable");
            this.spec.set("rt");
            this.spec.uncon().uncon();
            this.spec.con(new Concept(2)).con(57);
            this.spec.set("");
            this.spec.regain();
            this.spec.store();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(0);
        }
    }

    void copyClassRelation(Association association, Association association2) throws IOException {
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(56);
        while (concept != null) {
            this.base.con(concept);
            if (!this.base.has()) {
                this.base.uncon();
            } else {
                association2.con(concept);
                this.base.con(58);
                association2.con(58);
                association2.set(this.base);
                this.base.uncon();
                association2.uncon();
                this.base.con(59);
                association2.con(59);
                association2.set(this.base);
                this.base.uncon();
                association2.uncon();
                this.base.con(62);
                association2.con(62);
                association2.set(this.base);
                this.base.uncon();
                association2.uncon();
                association.con();
                if (association.hasConnect(57)) {
                    association.con(57);
                    this.base.con(57);
                    association2.con(57);
                    this.copyClassRelation(association, association2);
                    association.uncon();
                    this.base.uncon();
                    association2.uncon();
                }
                association.uncon();
                this.base.uncon();
                association2.uncon();
                PN.controlMemory(long1, this.base, association, association2);
            }
            concept = association.getNext(56);
        }
    }

    public Statement createStatement(String string) {
        return this.createStatement(string, 0);
    }

    public Statement createStatement(String string, int n) {
        return new Statement(this, string, n);
    }

    public Statement createStatement(String string, int n, File file, int n2) {
        return new Statement(this, string, n, file, n2);
    }

    void cutClassRelation(Association association) throws IOException {
        Association association2 = null;
        Association association3 = null;
        Association association4 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(56);
        while (concept != null) {
            association.con();
            if (association.hasConnect(57)) {
                association.con(57);
                this.cutClassRelation(association);
            }
            if (association.hasConnect(58)) {
                association2 = association.getConnect(58);
            }
            if (association.hasConnect(59)) {
                association3 = association.getConnect(59);
            }
            if (association.hasConnect(62)) {
                association4 = association.getConnect(62);
            }
            if (association2 != null || association3 != null || association4 != null) {
                Concept concept2 = (Concept)association.defCon().getLast();
                this.deleteRel(concept2, association2, association3, association4);
            }
            association2 = null;
            association3 = null;
            association4 = null;
            PN.controlMemory(long1, this.base, association);
            concept = association.getNext(56);
        }
    }

    void deleteClass(Association association, Association association2) throws IOException {
        Association association3 = this.selectClass(association, association2);
        this.deleteConception(association3);
    }

    void deleteConception(Association association) throws IOException {
        this.deleteRelation(association);
        this.base.clear(association);
    }

    void deleteIdentity(Association association, Association association2) throws IOException {
        Association association3;
        PList pList;
        PList pList2 = new PList();
        pList2.add(58, null);
        pList2.add(59, null);
        pList2.add(62, null);
        Long1 long1 = PN.initMemory();
        if (association2.getSense() == 57 && association.getSense() != 57) {
            pList2.add(57, null);
            pList = this.base.getConnectionList(association2, 57, 62, pList2);
            association3 = (Association)pList.getLast();
            pList.remove();
            this.deleteClass(association, association3);
        } else {
            pList = this.base.getConnectionList(association2, 57, 62, pList2);
        }
        this.deleteRelation(association, pList);
        pList = null;
        PN.controlMemory(long1, this.base, association, association2);
        if (association.getSense() != 57 || association2.getSense() != 57) {
            return;
        }
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            if (!this.base.hasConnect(57)) {
                this.base.uncon();
            } else {
                association3 = this.base.getConnect(57);
                this.base.uncon();
                Association association4 = new Association();
                association4.con(concept).con(57);
                Concept concept2 = association2.getFirst(57);
                while (concept2 != null) {
                    this.base.con(concept2);
                    if (!this.base.hasConnect(57)) {
                        this.base.uncon();
                    } else {
                        this.base.con(57);
                        this.copyClassRelation(association3, association4);
                        this.base.uncon();
                        this.base.uncon();
                        PN.controlMemory(long1, this.base, association, association2, association4);
                    }
                    concept2 = association2.getNext(57);
                }
                if (association4.has()) {
                    this.cutClassRelation(association4);
                }
                association4 = null;
                PN.controlMemory(long1, this.base, association, association2);
            }
            concept = association.getNext(57);
        }
    }

    void deleteRel(Association association, Association association2, Association association3, Association association4) throws IOException {
        PList pList = new PList();
        pList.add(58, (Object)association2);
        pList.add(59, (Object)association3);
        pList.add(62, (Object)association4);
        this.deleteRelation(association, pList);
    }

    void deleteRel(Concept concept, Association association, Association association2, Association association3) throws IOException {
        Association association4 = new Association();
        association4.set(concept);
        this.deleteRel(association4, association, association2, association3);
    }

    void deleteRelation(Association association) throws IOException {
        PList pList = new PList();
        pList.add(58, null);
        pList.add(59, null);
        pList.add(62, null);
        Long1 long1 = PN.initMemory();
        PList pList2 = this.base.getConnectionList(association, pList);
        this.base.clearConnection(association, pList);
        Association association2 = (Association)pList2.getFirst();
        while (pList2.hasCurrent()) {
            if (association2 != null && association2.has()) {
                int n = pList2.getType();
                if (n == 62) {
                    n = 58;
                } else if (n == 58) {
                    n = 62;
                }
                PList pList3 = new PList();
                pList3.add(n, (Object)association);
                this.base.clearConnection(association2, pList3);
                PN.controlMemory(long1, association, this.base, pList2);
            }
            association2 = (Association)pList2.getNext();
        }
    }

    void deleteRelation(Association association, PList pList) throws IOException {
        Long1 long1 = PN.initMemory();
        this.base.clearConnection(association, pList);
        Association association2 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association2 != null) {
                Trace trace;
                PList pList2 = new PList();
                Trace trace2 = trace = (Trace)pList.getTypes().clone();
                while (trace2 != null) {
                    if (trace2.sign == 62) {
                        trace2.sign = 58;
                    } else if (trace2.sign == 58) {
                        trace2.sign = 62;
                    }
                    trace2 = trace2.next;
                }
                pList2.add(trace, (Object)association);
                this.base.clearConnection(association2, pList2);
                PN.controlMemory(long1, association, this.base, pList);
            }
            association2 = (Association)pList.getNext();
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    public Association getBase() {
        return this.base;
    }

    public Commutator getCommutator() {
        return this.comm;
    }

    public Status getControlLine() {
        return this.stLine;
    }

    public int getOutLimit() {
        return this.outLimit;
    }

    public int getOutSum() {
        return this.outSum;
    }

    public PrintWriter getPrintWriter() {
        return this.pw;
    }

    public String getStatusLine() {
        if (this.stLine != null) {
            return this.stLine.get();
        }
        return null;
    }

    public int getStatusLineCount() {
        if (this.stLine != null) {
            return this.stLine.getCount();
        }
        return 0;
    }

    public int getStatusLineInterval() {
        if (this.stLine != null) {
            return this.stLine.getInterval();
        }
        return 0;
    }

    public String getStatusProcess() {
        if (this.stProcess != null) {
            return this.stProcess.get();
        }
        return null;
    }

    public String getStatusResult() {
        if (this.stResult != null) {
            return this.stResult.get();
        }
        return null;
    }

    public StringWriter getStringWriter() {
        return this.sw;
    }

    public PList getWarnings() {
        return this.warnings;
    }

    public boolean hasWarnings() {
        return this.warnings.isEmpty() ^ true;
    }

    Association insertClass(Association association, Association association2) throws IOException {
        Association association3 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association2.getFirst(56);
        while (concept != null) {
            Association association4 = this.insertClass1(association, concept);
            association2.con(concept);
            if (association2.hasConnect(57)) {
                association2.con(57);
                association4 = this.insertClass(association4, association2);
                association2.uncon();
            }
            association2.uncon();
            if (association3 == null) {
                association3 = association4;
            } else {
                association3.set(association4);
            }
            association4 = null;
            PN.controlMemory(long1, this.base, association, association2, association3);
            concept = association2.getNext(56);
        }
        if (association3 == null) {
            return new Association();
        }
        return association3;
    }

    Association insertClass1(Association association, Concept concept) throws IOException {
        if (association == null || association == PN.aNull) {
            Association association2 = this.selectClass1(association, concept);
            if (association2.has()) {
                return association2;
            }
            this.base.set(concept);
            return new Association().set(concept);
        }
        Association association3 = new Association();
        association3.set(association);
        int n = concept.getNotation();
        if (n == 52 || n == 51) {
            association3.appendClassMean(concept, true, false);
            this.base.set(association3);
            return association3;
        }
        Association association4 = new Association();
        if (association3.appendClassMean(concept, true, true, association4)) {
            this.base.con(concept);
            if (this.base.setConnect(61, association4)) {
                this.base.regain();
                this.base.set(association3);
            } else {
                this.base.regain();
            }
        }
        return association3;
    }

    Association insertConception(Association association) throws IOException {
        this.base.set(association);
        return association;
    }

    void insertContents(Association association) throws IOException {
        this.base.con("$Contents").setConcept();
        this.base.setConnect(58, association);
        this.base.uncon();
        PList pList = new PList();
        pList.add(62, (Object)new Association().set("$Contents"));
        this.base.setConception(association, pList);
    }

    void insertContents(Association association, Association association2) throws IOException {
        this.base.con("$Contents").setConcept();
        if (!this.base.hasConnect(58, association2, 56, 62)) {
            this.base.uncon();
            return;
        }
        this.base.setConnect(58, association, 56);
        this.base.uncon();
        Association association3 = new Association();
        association3.set("$Contents");
        PList pList = new PList();
        pList.add(62, (Object)association3);
        this.base.setConception(association, 56, pList);
    }

    void insertIdentity(Association association, Association association2) throws IOException {
        Association association3;
        PList pList;
        PList pList2 = new PList();
        pList2.add(58, null);
        pList2.add(59, null);
        pList2.add(62, null);
        Long1 long1 = PN.initMemory();
        if (association.getSense() != 57 && association2.getSense() == 57) {
            pList2.add(57, null);
            pList = this.base.getConnectionList(association2, 57, 62, pList2);
            association3 = (Association)pList.getLast();
            pList.remove();
            this.insertClass(association, association3);
        } else {
            pList = this.base.getConnectionList(association2, 57, 62, pList2);
        }
        this.insertRelation(association, pList);
        pList = null;
        PN.controlMemory(long1, this.base, association, association2);
        if (association.getSense() != 57 || association2.getSense() != 57) {
            return;
        }
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            if (!this.base.hasConnect(57)) {
                this.base.uncon();
            } else {
                association3 = this.base.getConnect(57);
                this.base.uncon();
                Association association4 = new Association();
                association4.con(concept).con(57);
                Concept concept2 = association2.getFirst(57);
                while (concept2 != null) {
                    this.base.con(concept2);
                    if (!this.base.hasConnect(57)) {
                        this.base.uncon();
                    } else {
                        this.base.con(57);
                        this.copyClassRelation(association3, association4);
                        this.base.uncon();
                        this.base.uncon();
                        PN.controlMemory(long1, this.base, association, association2, association4);
                    }
                    concept2 = association2.getNext(57);
                }
                if (association4.has()) {
                    this.pasteClassRelation(association4);
                }
                association4 = null;
                PN.controlMemory(long1, this.base, association, association2);
            }
            concept = association.getNext(57);
        }
    }

    Association insertName(Association association, PList pList, boolean bl) throws IOException {
        Association association2 = new Association();
        Expression expression = (Expression)pList.getFirst();
        boolean bl2 = pList.hasNext();
        if (!bl && expression.cnc != null && !bl2) {
            return association2.set(expression.cnc);
        }
        if (association == null || association == PN.aNull) {
            if (!this.selectName1(expression.cnc, bl2, association2)) {
                this.insertName1(expression.cnc, association2);
            }
            return association2;
        }
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            if (expression.cnc != null && expression.cnc.getNotation() == 52 && !this.base.hasConcept()) {
                boolean bl3 = false;
            }
            this.base.con(57);
            association2.con(concept).con(57);
            if (!this.selectName1(expression.cnc, bl2, association2)) {
                this.insertName1(expression.cnc, association2);
            }
            this.base.regain();
            association2.regain();
            PN.controlMemory(long1, this.base, association, association2);
            concept = association.getNext(57);
        }
        return association2;
    }

    void insertName1(Concept concept, Association association) throws IOException {
        Concept concept2;
        if (concept == null) {
            this.base.see(52);
            concept2 = this.base.getLast(56);
            int n = concept2 == null ? 1 : concept2.toNumber() + 1;
            concept2 = new Concept(n);
        } else {
            concept2 = concept;
        }
        this.base.set(concept2);
        association.set(concept2);
    }

    boolean insertNewObject(Association association, Association association2) throws IOException {
        if (association == null) {
            Concept concept = this.base.createNewConcept();
            association2.set(concept);
            return true;
        }
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept).con(57);
            Concept concept2 = this.base.createNewConcept();
            this.base.uncon().uncon();
            association2.setConnect(57, concept2);
            PN.controlMemory(long1, this.base, association2, association);
            concept = association.getNext(57);
        }
        return true;
    }

    Association insertObject(Association association, PList pList, boolean bl) throws IOException {
        Concept concept = null;
        Association association2 = new Association();
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            if (expression.index == 1) {
                association2.con(concept);
                this.base.con(concept);
                association2.set(this.base, 56);
                association2.uncon();
                this.base.uncon();
                return this.insertClass(association, association2);
            }
            Concept concept2 = expression.cnc;
            if (concept2 == null) {
                association2.con(concept);
                this.base.con(concept);
                this.base.see(52);
                if (this.base.has() && pList.hasNext()) {
                    association2.set(this.base, 56);
                } else {
                    int n = 1;
                    concept2 = this.base.getLast(56);
                    if (concept2 != null) {
                        n = concept2.toNumber() + 1;
                    }
                    concept2 = new Concept(n);
                    association2.set(concept2);
                }
                association2.uncon();
                this.base.uncon();
                return this.insertClass(association, association2);
            }
            concept = concept == null ? concept2 : new Concept(concept, 56, concept2);
            expression = (Expression)pList.getNext();
        }
        association2.set(concept);
        if (!bl) {
            return association2;
        }
        return this.insertClass(association, association2);
    }

    void insertRel(Association association, Association association2, Association association3, Association association4) throws IOException {
        PList pList = new PList();
        if (association2 != null) {
            pList.add(58, (Object)association2);
        }
        if (association3 != null) {
            pList.add(59, (Object)association3);
        }
        if (association4 != null) {
            pList.add(62, (Object)association4);
        }
        this.insertRelation(association, pList);
    }

    void insertRel(Concept concept, Association association, Association association2, Association association3) throws IOException {
        Association association4 = new Association();
        association4.set(concept);
        this.insertRel(association4, association, association2, association3);
    }

    void insertRelation(Association association, PList pList) throws IOException {
        PList pList2 = new PList();
        this.base.setConception(association, pList);
        Long1 long1 = PN.initMemory();
        Association association2 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association2 != null) {
                int n = pList.getType();
                int n2 = n == 62 ? 58 : (n == 59 ? 59 : 62);
                pList2.add(n2, (Object)association);
                this.base.setConception(association2, pList2);
                PN.controlMemory(long1, association, this.base, pList);
            }
            association2 = (Association)pList.getNext();
        }
    }

    PList insertSchema(Association association, Association association2) throws IOException {
        PList pList = new PList();
        Association association3 = new Association();
        association3.setCategory(56);
        pList.add(58, (Object)association3);
        pList.add(59, (Object)association3);
        pList.add(62, (Object)association3);
        pList = this.base.getConnectionList(association2, 56, 62, pList);
        Association association4 = null;
        Association association5 = null;
        Association association6 = null;
        association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (!association3.has()) {
                pList.remove();
            } else {
                int n = pList.getType();
                if (n == 58) {
                    association5 = association3;
                    association6 = association3;
                } else if (n == 59) {
                    association4 = association3;
                    if (association6 == null) {
                        association6 = association3;
                    } else {
                        association6.set(association3);
                    }
                } else {
                    if (association4 == null) {
                        association4 = association3;
                    } else {
                        association4.set(association3);
                    }
                    if (association5 == null) {
                        association5 = association3;
                    } else {
                        association5.set(association3);
                    }
                }
            }
            association3 = (Association)pList.getNext();
        }
        if (pList.isEmpty()) {
            return null;
        }
        PList pList2 = new PList();
        if (association4 != null) {
            pList2.add(58, association4);
        }
        if (association5 != null) {
            pList2.add(59, (Object)association5);
        }
        if (association6 != null) {
            pList2.add(62, (Object)association6);
        }
        pList2 = this.base.getConnectionList(association, 56, 62, pList2);
        Association association7 = (Association)pList2.getFirst();
        while (pList2.hasCurrent()) {
            if (!association7.has()) {
                pList2.remove();
            }
            association7 = (Association)pList2.getNext();
        }
        if (pList2.isEmpty()) {
            return pList;
        }
        return null;
    }

    PList insertSchema(Association association, PList pList) throws IOException {
        return this.insertSchema(association, pList, null);
    }

    PList insertSchema(Association association, PList pList, PList pList2) throws IOException {
        Association association2 = association.get(56);
        PList pList3 = new PList();
        if (pList2 != null) {
            pList2.init();
        }
        Long1 long1 = PN.initMemory();
        Association association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            block26: {
                block30: {
                    int n;
                    block32: {
                        Association association4;
                        block31: {
                            PList pList4;
                            block27: {
                                int n2;
                                Trace trace;
                                block29: {
                                    block28: {
                                        block25: {
                                            if (pList2 != null) {
                                                pList2.getNext();
                                            }
                                            if (association3 != null) break block25;
                                            if (pList2 != null) {
                                                pList2.remove();
                                            }
                                            pList3.add(pList.getType(), null);
                                            break block26;
                                        }
                                        n = pList.getType();
                                        pList4 = new PList();
                                        if (n != 0) break block27;
                                        pList4.add(62, (Object)association2);
                                        pList4.add(59, (Object)association2);
                                        pList4.add(58, (Object)association2);
                                        PList pList5 = this.base.getConnectionList(association3, 56, 62, pList4);
                                        trace = null;
                                        Trace trace2 = null;
                                        n2 = 0;
                                        association4 = (Association)pList5.getFirst();
                                        while (pList5.hasCurrent()) {
                                            if (association4 != null && association4.has()) {
                                                n2 = pList5.getType();
                                                if (n2 == 62) {
                                                    n2 = 58;
                                                } else if (n2 == 58) {
                                                    n2 = 62;
                                                }
                                                trace2 = trace == null ? (trace = new Trace(n2)) : (trace2.next = new Trace(n2));
                                            }
                                            association4 = (Association)pList5.getNext();
                                        }
                                        if (pList2 != null) break block28;
                                        if (trace != null && trace.next != null) {
                                            return null;
                                        }
                                        break block29;
                                    }
                                    if (trace != null && trace.next != null) break block26;
                                    pList2.remove();
                                }
                                if (trace == null) {
                                    n = 59;
                                } else {
                                    n = n2;
                                    if (n == 62) {
                                        n = 58;
                                    } else if (n == 58) {
                                        n = 62;
                                    }
                                }
                                pList3.add(n, (Object)association3);
                                break block30;
                            }
                            if (n == 62) {
                                pList4.add(62, (Object)association2);
                                pList4.add(59, (Object)association2);
                            } else if (n == 59) {
                                pList4.add(62, (Object)association2);
                                pList4.add(58, (Object)association2);
                            } else {
                                pList4.add(58, (Object)association2);
                                pList4.add(59, (Object)association2);
                            }
                            association4 = this.base.getConnection(association3, 56, 62, pList4);
                            if (pList2 != null) break block31;
                            if (association4.has()) {
                                return null;
                            }
                            break block32;
                        }
                        if (association4.has()) break block26;
                        pList2.remove();
                    }
                    pList3.add(n, (Object)association3);
                }
                PN.controlMemory(long1, this.base, pList);
            }
            association3 = (Association)pList.getNext();
        }
        if (pList3.isEmpty()) {
            return null;
        }
        return pList3;
    }

    void instancing(PList pList) {
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            association.setSense(57);
            association = (Association)pList.getNext();
        }
    }

    public boolean isInterrupted() {
        return this.comm.isOff();
    }

    PList orderRels(PList pList) throws IOException {
        Cloneable cloneable;
        int n;
        int n2;
        if (pList.isEmpty()) {
            return pList;
        }
        int[] nArray = new int[4];
        Trace[][] traceArray = new Trace[4][];
        Association[][] associationArray = new Association[4][];
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association != null) {
                n2 = (int)association.getPower();
                if (association.getSense() == 57 && n2 > 1) {
                    nArray[3] = nArray[3] + 1;
                } else if (association.getSense() == 57) {
                    nArray[2] = nArray[2] + 1;
                } else if (n2 > 1) {
                    nArray[1] = nArray[1] + 1;
                } else {
                    nArray[0] = nArray[0] + 1;
                }
            }
            association = (Association)pList.getNext();
        }
        if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 0 && nArray[3] == 0) {
            return new PList();
        }
        if (nArray[0] > 0) {
            traceArray[0] = new Trace[nArray[0]];
            associationArray[0] = new Association[nArray[0]];
        }
        if (nArray[1] > 0) {
            traceArray[1] = new Trace[nArray[1]];
            associationArray[1] = new Association[nArray[1]];
        }
        if (nArray[2] > 0) {
            traceArray[2] = new Trace[nArray[2]];
            associationArray[2] = new Association[nArray[2]];
        }
        if (nArray[3] > 0) {
            traceArray[3] = new Trace[nArray[3]];
            associationArray[3] = new Association[nArray[3]];
        }
        Association association2 = new Association();
        Concept[] conceptArray = new Concept[]{new Concept(0), new Concept(1), new Concept(2), new Concept(3)};
        nArray = new int[4];
        association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (association != null) {
                Trace trace = pList.getTypes();
                n2 = (int)association.getPower();
                if (association.getSense() == 57 && n2 > 1) {
                    n = 3;
                } else if (association.getSense() == 57) {
                    n = 2;
                    n2 = (int)this.base.getPower(association, 57, 57);
                } else if (n2 > 1) {
                    n = 1;
                } else {
                    n = 0;
                    Concept concept = association.getIfOne(57);
                    this.base.con(concept);
                    n2 = 0;
                    cloneable = trace;
                    while (cloneable != null) {
                        if (((Trace)cloneable).sign == 62) {
                            this.base.con(58);
                        } else if (((Trace)cloneable).sign == 59) {
                            this.base.con(59);
                        } else {
                            this.base.con(62);
                        }
                        n2 += (int)this.base.getPower();
                        this.base.uncon();
                        cloneable = ((Trace)cloneable).next;
                    }
                    this.base.uncon();
                }
                association2.con(conceptArray[n]).con(59).con(new Concept(n2));
                association2.setConnect(59, new Concept(nArray[n]));
                association2.regain();
                traceArray[n][nArray[n]] = trace;
                associationArray[n][nArray[n]] = association;
                int n3 = n;
                nArray[n3] = nArray[n3] + 1;
            }
            association = (Association)pList.getNext();
        }
        PList pList2 = new PList();
        n = 0;
        while (n < 4) {
            if (nArray[n] != 0) {
                association2.con(conceptArray[n]).con(59);
                cloneable = association2.getFirst(56);
                while (cloneable != null) {
                    association2.con();
                    Association association3 = association2.getConnect(59);
                    Concept concept = association3.getFirst(56);
                    while (concept != null) {
                        pList2.add(traceArray[n][concept.toNumber()], (Object)associationArray[n][concept.toNumber()]);
                        concept = association3.getNext(56);
                    }
                    association2.uncon();
                    cloneable = association2.getNext(56);
                }
                association2.regain();
            }
            ++n;
        }
        return pList2;
    }

    void pasteClassRelation(Association association) throws IOException {
        Association association2 = null;
        Association association3 = null;
        Association association4 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(56);
        while (concept != null) {
            association.con();
            if (association.hasConnect(57)) {
                association.con(57);
                this.pasteClassRelation(association);
            }
            if (association.hasConnect(58)) {
                association2 = association.getConnect(58);
            }
            if (association.hasConnect(59)) {
                association3 = association.getConnect(59);
            }
            if (association.hasConnect(62)) {
                association4 = association.getConnect(62);
            }
            if (association2 != null || association3 != null || association4 != null) {
                Concept concept2 = (Concept)association.defCon().getLast();
                this.insertRel(concept2, association2, association3, association4);
            }
            association2 = null;
            association3 = null;
            association4 = null;
            PN.controlMemory(long1, this.base, association);
            concept = association.getNext(56);
        }
    }

    public void restore() throws IOException {
        this.base.restore();
        this.var.restore();
        this.spec.restore();
    }

    public void restoreSpecification() {
        this.spec.restore();
    }

    public void save(Statement statement) throws IOException {
        this.savedStm = statement;
        this.base.save();
        this.var.save();
        this.spec.store();
    }

    Association selectClass(Association association) throws IOException {
        return this.base.get(association, 57, 62, 57);
    }

    Association selectClass(Association association, Association association2) throws IOException {
        Association association3 = null;
        Long1 long1 = PN.initMemory();
        Concept concept = association2.getFirst(56);
        while (concept != null) {
            Association association4 = this.selectClass1(association, concept);
            if (association4.has()) {
                association2.con(concept);
                if (association2.hasConnect(57)) {
                    association2.con(57);
                    association4 = this.selectClass(association4, association2);
                    association2.uncon();
                }
                association2.uncon();
                if (association3 == null) {
                    association3 = association4;
                } else {
                    association3.set(association4);
                }
                association4 = null;
                PN.controlMemory(long1, this.base, association, association2, association3);
            }
            concept = association2.getNext(56);
        }
        if (association3 == null) {
            return new Association();
        }
        return association3;
    }

    Association selectClass1(Association association, Concept concept) throws IOException {
        Association association2 = new Association();
        int n = concept.getNotation();
        if (n == 52 || n == 51) {
            if (association != null) {
                association2.set(association);
            }
            association2.appendClassMean(concept, true, false);
            return this.base.get(association2);
        }
        this.base.con(concept);
        if (association == null) {
            if (this.base.hasConcept()) {
                association2.set(concept);
            }
            this.base.uncon();
            return association2;
        }
        if (this.base.hasConnect(61)) {
            this.base.con(61);
            association2.set(this.base);
            this.base.uncon();
            association2.appendClassMean(concept, true, false);
        }
        if (this.base.hasConcept()) {
            association2.set(concept);
        }
        this.base.uncon();
        if (association == PN.aNull) {
            return association2;
        }
        return association2.get(association, 57, 57, 57);
    }

    Association selectInstance(Association association) throws IOException {
        return this.base.getInstance(association);
    }

    Association selectInterval(Association association, Association association2, Association association3) throws IOException {
        Association association4 = new Association();
        if (association2 == null && association3 == null) {
            association4 = this.base.get(association, 57, 62, 57);
            return association4;
        }
        Long1 long1 = PN.initMemory();
        if (association2 != null && association3 != null) {
            association4.set(association2).set(association3);
            Concept concept = association2.getLast(57);
            Concept concept2 = association3.getFirst(57);
            concept = this.base.get(concept);
            concept = this.base.getNext(57);
            while (!concept.equals(concept2)) {
                association4.set(concept);
                PN.controlMemory(long1, this.base, association4, association2, association3);
                concept = this.base.getNext(57);
            }
            return association4;
        }
        if (association2 != null) {
            association4.set(association2);
            if (association == null || association == PN.aNull) {
                Concept concept = association2.getLast(57);
                this.selectInterval0(concept, association4);
                return association4;
            }
            Concept concept = association.getFirst(57);
            while (concept != null) {
                this.base.con(concept);
                if (this.base.hasConnect(57)) {
                    this.base.con(57);
                    association2.con(concept).con(57);
                    Concept concept3 = association2.getLast(57);
                    if (concept3 != null) {
                        association4.con(concept).con(57);
                        this.selectInterval0(concept3, association4);
                    }
                }
                this.base.regain();
                association2.regain();
                association4.regain();
                PN.controlMemory(long1, this.base, association4, association2);
                concept = association.getNext(57);
            }
            return association4;
        }
        association4.set(association3);
        if (association == null || association == PN.aNull) {
            Concept concept = association3.getFirst(57);
            this.selectInterval1(concept, association4);
            return association4;
        }
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept);
            if (this.base.hasConnect(57)) {
                this.base.con(57);
                association3.con(concept).con(57);
                Concept concept4 = association3.getFirst(57);
                association4.con(concept).con(57);
                this.selectInterval1(concept4, association4);
            }
            this.base.regain();
            association3.regain();
            association4.regain();
            PN.controlMemory(long1, this.base, association4, association3);
            concept = association.getNext(57);
        }
        return association4;
    }

    void selectInterval0(Concept concept, Association association) throws IOException {
        concept = this.base.get(concept, 57);
        Long1 long1 = PN.initMemory();
        concept = this.base.getNext(57);
        while (concept != null) {
            association.set(concept);
            PN.controlMemory(long1, this.base, association);
            concept = this.base.getNext(57);
        }
    }

    void selectInterval1(Concept concept, Association association) throws IOException {
        Concept concept2 = this.base.get(concept, 57);
        Long1 long1 = PN.initMemory();
        concept2 = this.base.getFirst(57);
        while (concept2 != null) {
            if (concept2.equals(concept)) {
                return;
            }
            association.set(concept2);
            PN.controlMemory(long1, this.base, association);
            concept2 = this.base.getNext(57);
        }
    }

    Association selectName(Association association, PList pList, boolean bl) throws IOException {
        Association association2 = new Association();
        Expression expression = (Expression)pList.getFirst();
        boolean bl2 = pList.hasNext();
        if (!bl && expression.cnc != null && !bl2) {
            return association2.set(expression.cnc);
        }
        if (association == null || association == PN.aNull) {
            this.selectName1(expression.cnc, bl2, association2);
            return association2;
        }
        Long1 long1 = PN.initMemory();
        Concept concept = association.getFirst(57);
        while (concept != null) {
            this.base.con(concept).con(57);
            association2.con(concept).con(57);
            this.selectName1(expression.cnc, bl2, association2);
            PN.controlMemory(long1, this.base, association, association2);
            this.base.regain();
            association2.regain();
            concept = association.getNext(57);
        }
        return association2;
    }

    boolean selectName1(Concept concept, boolean bl, Association association) throws IOException {
        Concept concept2;
        if (bl) {
            if (concept == null) {
                this.base.see(52);
            } else {
                this.base.see(concept);
            }
            association.set(this.base, 56);
            return this.base.has();
        }
        if (concept == null) {
            this.base.see(52);
            concept2 = this.base.getLast(56);
        } else {
            concept2 = this.base.get(concept);
        }
        if (concept2 != null) {
            association.set(concept2);
        }
        return concept2 != null;
    }

    Association selectObject(Association association, PList pList, boolean bl) throws IOException {
        Concept concept = null;
        Association association2 = new Association();
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            if (expression.index == 1) {
                association2.con(concept);
                this.base.con(concept);
                association2.set(this.base, 56);
                association2.uncon();
                this.base.uncon();
                return this.selectClass(association, association2);
            }
            Concept concept2 = expression.cnc;
            if (concept2 == null) {
                association2.con(concept);
                this.base.con(concept);
                this.base.see(52);
                if (pList.hasNext()) {
                    association2.set(this.base, 56);
                } else {
                    concept2 = this.base.getLast(56);
                    association2.set(concept2);
                }
                association2.uncon();
                this.base.uncon();
                return this.selectClass(association, association2);
            }
            concept = concept == null ? concept2 : new Concept(concept, 56, concept2);
            expression = (Expression)pList.getNext();
        }
        association2.set(concept);
        if (!bl) {
            return association2;
        }
        return this.selectClass(association, association2);
    }

    Association selectObjects(Association association) throws IOException {
        PList pList = new PList();
        if (association == null) {
            pList.add(62, null);
            Association association2 = this.base.getBy(56, pList);
            return association2;
        }
        if (association == PN.aNull) {
            return this.base.get(56);
        }
        Association association3 = new Association();
        association3.setCategory(56);
        pList.add(57, (Object)association3);
        return this.base.getConnection(association, 57, 62, pList);
    }

    Association selectRel(Association association, Trace trace, Association association2) throws IOException {
        Trace trace2;
        Trace trace3 = trace2 = (Trace)trace.clone();
        while (trace3 != null) {
            if (trace3.sign == 62) {
                trace3.sign = 58;
            } else if (trace3.sign == 58) {
                trace3.sign = 62;
            }
            trace3 = trace3.next;
        }
        PList pList = new PList();
        pList.add(trace2, (Object)association);
        Association association3 = this.base.getConnection(association2, pList);
        return association3;
    }

    Association selectRelation(Association association, PList pList) throws IOException {
        Association association2;
        Trace trace;
        Association association3;
        long l = 0L;
        pList = this.orderRels(pList);
        Long1 long1 = PN.initMemory();
        if (association == null) {
            association3 = (Association)pList.getFirst();
            trace = pList.getTypes();
            association2 = this.selectRel(null, trace, association3);
            if (!association2.has() || !pList.hasNext()) {
                return association2;
            }
            PN.controlMemory(long1, association2, this.base, pList);
        } else {
            association2 = association;
            pList.init();
        }
        l = association2.getPower();
        if (association2.getSense() == 57) {
            l = l < 100L ? this.base.getPower(association2, 57, 57) : (l *= 10L);
        }
        if (l < 1000L) {
            association2 = this.base.getBy(association2, pList.cloneNext());
            PN.controlMemory(long1, association2, this.base, pList);
            return association2;
        }
        association3 = (Association)pList.getNext();
        while (pList.hasCurrent()) {
            if (association3 != null) {
                trace = pList.getTypes();
                long l2 = association3.getPower();
                if (association3.getSense() == 57) {
                    l2 = l2 < 100L ? this.base.getPower(association3, 57, 57) : (l2 *= 10L);
                }
                if (l2 > l) {
                    if (pList.hasNext()) {
                        association2 = this.base.getBy(association2, pList.cloneNext());
                    }
                    PN.controlMemory(long1, association2, this.base, pList);
                    return association2;
                }
                if (!(association2 = this.selectRel(association2, trace, association3)).has()) {
                    return association2;
                }
                PN.controlMemory(long1, association2, this.base, pList);
            }
            association3 = (Association)pList.getNext();
        }
        return association2;
    }

    PList selectSchema(Association association, Association association2) throws IOException {
        PList pList = new PList();
        Association association3 = new Association();
        association3.setCategory(56);
        pList.add(58, (Object)association3);
        pList.add(59, (Object)association3);
        pList.add(62, (Object)association3);
        pList = this.base.getConnectionList(association2, 56, 62, pList);
        association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            if (!association3.has()) {
                pList.remove();
            }
            association3 = (Association)pList.getNext();
        }
        if (pList.isEmpty()) {
            return null;
        }
        PList pList2 = this.base.getConnectionList(association, 56, 62, pList);
        Association association4 = (Association)pList2.getFirst();
        while (association4 != null) {
            if (!association4.has()) {
                pList2.remove();
            }
            association4 = (Association)pList2.getNext();
        }
        if (pList2.isEmpty()) {
            return null;
        }
        return pList2;
    }

    PList selectSchema(Association association, PList pList) throws IOException {
        return this.selectSchema(association, pList, null);
    }

    PList selectSchema(Association association, PList pList, PList pList2) throws IOException {
        Association association2;
        if (association == null) {
            association2 = new Association();
            association2.setCategory(56);
        } else {
            association2 = association.get(56);
        }
        PList pList3 = new PList();
        if (pList2 != null) {
            pList2.init();
        }
        Long1 long1 = PN.initMemory();
        Association association3 = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            block25: {
                block29: {
                    int n;
                    block31: {
                        block30: {
                            PList pList4;
                            block26: {
                                Trace trace;
                                block28: {
                                    block27: {
                                        block24: {
                                            if (pList2 != null) {
                                                pList2.getNext();
                                            }
                                            if (association3 != null) break block24;
                                            if (pList2 != null) {
                                                pList2.remove();
                                            }
                                            pList3.add(pList.getType(), null);
                                            break block25;
                                        }
                                        n = pList.getType();
                                        pList4 = new PList();
                                        if (n != 0) break block26;
                                        pList4.add(62, (Object)association2);
                                        pList4.add(59, (Object)association2);
                                        pList4.add(58, (Object)association2);
                                        PList pList5 = this.base.getConnectionList(association3, 56, 62, pList4);
                                        association2 = null;
                                        trace = null;
                                        Trace trace2 = null;
                                        Association association4 = (Association)pList5.getFirst();
                                        while (pList5.hasCurrent()) {
                                            if (association4 != null && association4.has()) {
                                                int n2 = pList5.getType();
                                                if (n2 == 62) {
                                                    n2 = 58;
                                                } else if (n2 == 58) {
                                                    n2 = 62;
                                                }
                                                if (trace == null) {
                                                    association2 = association4;
                                                    trace2 = trace = new Trace(n2);
                                                } else {
                                                    association2.set(association4);
                                                    trace2 = trace2.next = new Trace(n2);
                                                }
                                            }
                                            association4 = (Association)pList5.getNext();
                                        }
                                        if (pList2 != null) break block27;
                                        if (trace == null) {
                                            return null;
                                        }
                                        break block28;
                                    }
                                    if (trace == null) break block25;
                                    pList2.remove();
                                }
                                pList3.add(trace, (Object)association3);
                                break block29;
                            }
                            if (n == 62) {
                                pList4.add(58, (Object)association2);
                            } else if (n == 59) {
                                pList4.add(59, (Object)association2);
                            } else {
                                pList4.add(62, (Object)association2);
                            }
                            association2 = this.base.getConnection(association3, 56, 62, pList4);
                            if (pList2 != null) break block30;
                            if (!association2.has()) {
                                return null;
                            }
                            break block31;
                        }
                        if (!association2.has()) break block25;
                        pList2.remove();
                    }
                    pList3.add(n, (Object)association3);
                }
                PN.controlMemory(long1, this.base, pList);
            }
            association3 = (Association)pList.getNext();
        }
        if (pList3.isEmpty()) {
            return null;
        }
        return pList3;
    }

    public void setCommutator(Commutator commutator) {
        this.comm = commutator;
    }

    public void setControlDataBase(Status status) {
        this.stDataBase = status;
    }

    public void setControlLine(StatusLine statusLine) {
        this.stLine = statusLine;
    }

    public void setControlProcess(Status status) {
        this.stProcess = status;
    }

    public void setControlResult(Status status) {
        this.stResult = status;
    }

    public void setCurrentStm(Statement statement) {
        this.curStm = statement;
    }

    public void setOutLimit() {
        this.outLimit = defaultOutLimit;
    }

    public void setOutLimit(int n) {
        this.outLimit = n;
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.sw = null;
        this.pw = printWriter;
    }

    void setStatusDataBase(String string) {
        if (this.stDataBase == null) {
            return;
        }
        if (string.length() > 40) {
            int n = string.length() - 40 + 3;
            this.stDataBase.set("..." + string.substring(n));
        } else {
            this.stDataBase.set(string);
        }
    }

    public void setStatusLine(String string) {
        if (this.stLine != null) {
            this.stLine.set(string);
        }
    }

    public void setStatusLineCount(int n) {
        if (this.stLine != null) {
            this.stLine.setCount(n);
        }
    }

    public void setStatusLineInterval(int n) {
        if (this.stLine != null) {
            this.stLine.setInterval(n);
        }
    }

    public void setStatusProcess(String string) {
        if (this.stProcess != null) {
            this.stProcess.set(string);
        }
    }

    public void setStatusResult(String string) {
        if (this.stResult != null) {
            this.stResult.set(string);
        }
    }

    public void setStringWriter() {
        this.sw = new StringWriter();
        this.pw = new PrintWriter(this.sw);
    }

    public void setStringWriter(StringWriter stringWriter) {
        this.sw = stringWriter;
        this.pw = new PrintWriter(stringWriter);
    }

    public void store(Statement statement) throws IOException {
        this.savedStm = statement;
        this.base.store();
        this.var.store();
        this.spec.store();
    }
}

