/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.Long1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Z.Copula;
import Sav.Z.Interface;
import Sav.Z.Procedure;
import Sav.Z.Statement;
import Sav.Z.Warning;
import Sav.Z.ZException;
import java.io.File;
import java.io.IOException;

class Expression
implements Interface {
    int index;
    String text;
    int begin;
    int end;
    Copula copula;
    PList list = new PList();
    boolean no;
    String type;
    Statement stm;
    File file;
    Procedure proc;
    Expression eContext;
    int feature;
    int down;
    int up;
    int slashPos;
    String sentence;
    Association ass;
    Concept cnc;

    Expression() {
    }

    Expression(Statement statement) throws ZException {
        this.stm = statement;
        this.text = this.stm.text;
        this.begin = this.stm.pos;
        try {
            this.equip();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    Expression(Statement statement, int n, int n2) {
        this.stm = statement;
        this.text = this.stm.text;
        this.begin = n;
        this.end = n;
        this.index = n2;
    }

    Expression(Statement statement, Expression expression, Copula copula) {
        this.stm = statement;
        this.text = this.stm.text;
        this.add(expression, copula);
    }

    Expression(Statement statement, Expression expression, Copula copula, Expression expression2) {
        this.stm = statement;
        this.text = this.stm.text;
        this.add(expression, copula, expression2);
    }

    void add(Expression expression, Copula copula) {
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(expression);
    }

    void add(Expression expression, Copula copula, Expression expression2) {
        this.begin = expression.begin;
        this.end = expression2.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(expression);
        this.list.add(expression2);
    }

    void affect(Expression expression) {
        this.index = expression.index;
        this.text = expression.text;
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = expression.copula;
        this.list = expression.list;
        this.no = expression.no;
        this.type = expression.type;
        this.stm = expression.stm;
        this.file = expression.file;
        this.proc = expression.proc;
        this.eContext = expression.eContext;
        this.feature = expression.feature;
        this.down = expression.down;
        this.up = expression.up;
        this.slashPos = expression.slashPos;
        this.cnc = expression.cnc;
        this.ass = expression.ass;
    }

    void assignementOfClass(Expression expression) throws IOException {
        Long1 long1 = PN.initMemory();
        if (!this.ass.has()) {
            return;
        }
        Expression expression2 = (Expression)expression.list.getFirst();
        expression.list.remove();
        if (expression.execute(null, true)) {
            if (expression.no) {
                expression.deriveClass();
                this.stm.dbc.deleteClass(this.ass, expression.ass);
            } else {
                this.stm.dbc.insertClass(this.ass, expression.ass);
            }
        }
        expression.ass = null;
        expression.list.getFirst();
        expression.list.insert(expression2);
    }

    void assignementOfConceptionToConception(Association association, Expression expression) throws IOException {
        if (!expression.execute(association, true)) {
            return;
        }
        if (expression.no) {
            PList pList = this.stm.dbc.selectSchema(this.ass, expression.ass);
            if (pList == null) {
                this.warnFail(14, expression, "Unknown schema");
            } else {
                this.stm.dbc.deleteIdentity(this.ass, expression.ass);
            }
        } else {
            PList pList = this.stm.dbc.insertSchema(this.ass, expression.ass);
            if (pList == null) {
                this.warnFail(14, expression, "Conflicting schema");
            } else {
                this.stm.dbc.insertContents(this.ass, expression.ass);
                this.stm.dbc.insertIdentity(this.ass, expression.ass);
            }
        }
    }

    void assignementOfConceptionToVariable(Expression expression) throws IOException {
        if (!expression.execute(null, false)) {
            return;
        }
        if (expression.no) {
            this.deriveClass();
            this.ass.clear(expression.ass);
        } else {
            if (this.ass.getSense() != expression.ass.getSense()) {
                this.deriveClass();
                expression.deriveClass();
            }
            this.ass.set(expression.ass);
        }
    }

    void assignementOfRelation(Expression expression) throws IOException {
        if (!this.ass.has()) {
            return;
        }
        this.list.getFirst();
        PList pList = new PList();
        PList pList2 = new PList();
        Long1 long1 = PN.initMemory();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            while (expression3 != null) {
                if (expression3.execute(null, true)) {
                    if (expression2.down != 0 && expression2.up != 0) {
                        pList.add(59, (Object)expression3.ass);
                    } else if (expression2.down != 0) {
                        pList.add(62, (Object)expression3.ass);
                    } else if (expression2.up != 0) {
                        pList.add(58, (Object)expression3.ass);
                    } else {
                        pList.add(0, (Object)expression3.ass);
                    }
                    expression3.ass = null;
                    pList2.add(expression3);
                    PN.controlMemory(long1, this.ass, pList);
                }
                expression3 = (Expression)expression2.list.getNext();
            }
            expression2 = (Expression)this.list.getNext();
        }
        if (expression.no) {
            pList = this.stm.dbc.selectSchema(this.ass, pList, pList2);
            if (!pList2.isEmpty()) {
                this.warnFail(" ~ ", pList2, "Unknown schema");
            }
            if (pList != null) {
                this.stm.dbc.deleteRelation(this.ass, pList);
            }
        } else {
            pList = this.stm.dbc.insertSchema(this.ass, pList, pList2);
            if (!pList2.isEmpty()) {
                this.warnFail(" = ", pList2, "Conflicting schema");
            }
            if (pList != null) {
                this.stm.dbc.insertRelation(this.ass, pList);
            }
        }
    }

    boolean assignementToConception(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association, true)) {
            return false;
        }
        this.ass = expression.ass;
        Long1 long1 = PN.initMemory();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3.index == -10) {
                if (expression2.index == 11) {
                    expression.assignementOfRelation(expression2);
                } else {
                    expression.assignementOfClass(expression2);
                }
            } else {
                expression.assignementOfConceptionToConception(association, expression2);
            }
            expression2.ass = null;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        expression.ass = null;
        return true;
    }

    boolean assignementToVariable(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        Long1 long1 = PN.initMemory();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3.index != -10) {
                expression.assignementOfConceptionToVariable(expression2);
            } else if (expression2.index == 11) {
                expression.assignementOfRelation(expression2);
            } else {
                expression.assignementOfClass(expression2);
            }
            expression2.ass = null;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        this.ass = expression.ass;
        expression.ass = null;
        if (association != null) {
            return this.executeVariable(association, true);
        }
        return this.ass.has();
    }

    void construe(Expression expression, int n) throws ZException {
        try {
            this.construe1(expression, n);
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    void construe1(Expression expression, int n) throws IOException {
        switch (this.index) {
            case -10: {
                this.eContext = expression;
                this.feature = n;
                break;
            }
            case 0: {
                this.construeSpecific(expression, n);
                break;
            }
            case 5: {
                this.construeSpace(expression, n);
                break;
            }
            case 6: {
                this.construeBrace(expression, n);
                break;
            }
            case 7: {
                this.construeBracket(expression, n);
                break;
            }
            case 8: {
                this.construeParenthesis(expression, n);
                break;
            }
            case 11: {
                this.construeParenthesisTerm(expression, n);
                break;
            }
            case 12: {
                this.construeDash(expression, n);
                break;
            }
            case 13: {
                this.construeColon(expression, n);
                break;
            }
            case 14: 
            case 15: {
                this.construeEquality(expression, n);
                break;
            }
            case 16: {
                this.construeSlash(expression, n);
                break;
            }
            case 17: {
                this.construeBackSlash(expression, n);
                break;
            }
            case 18: {
                this.construeComma(expression, n);
                break;
            }
            case 19: {
                this.construeAssignement(expression, n);
                break;
            }
        }
        if (this.list.hasOne() && this.index >= 11) {
            Expression expression2 = (Expression)this.list.getFirst();
            if (expression2.index == -10) {
                this.index = -10;
            } else {
                this.affect(expression2);
            }
        } else if (this.list.isEmpty()) {
            if (this.index == -4) {
                this.warnErr1("Missing procedure's parentheses");
                this.list.add(this.stm.createExpression(this.end, -10));
                this.proc = new Procedure(this);
                this.proc.construe();
            } else if (this.index > 0) {
                this.index = -10;
            }
        }
    }

    void construeAssignement(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        n = n & 0xE0 | 4;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(expression, n);
            if (expression2.index == -10) {
                if (expression2.copula != null) {
                    this.list.remove();
                } else {
                    expression2.warnErr0("Unexpected indefinitude");
                    this.list.remove();
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeBackSlash(Expression expression, int n) throws IOException {
        if ((n & 0x1F) != 16) {
            this.warnErr0("Unexpected slash expression");
            this.index = -10;
            return;
        }
        int n2 = this.construeSlash1(expression, n);
        Expression expression2 = (Expression)this.list.getFirst();
        this.list.remove();
        expression2 = (Expression)this.list.getLast();
        expression2.down = n2;
    }

    void construeBrace(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        n = n & 0xE0 | 0x10;
        Expression expression2 = (Expression)this.list.getLast();
        this.end = expression2.end + 1;
        this.list = expression2.list;
        Expression expression3 = (Expression)this.list.getFirst();
        while (expression3 != null) {
            expression3.construe(expression, n);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            } else if (expression3.down != 0 && expression3.up != 0 && (expression3.down > 1 || expression3.up > 1)) {
                expression3.warnErr("Unexpected slash level", expression3.slashPos);
                expression3.down = -1;
                expression3.up = -1;
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeBracket(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        n = n & 0xE0 | 0x10;
        Expression expression2 = (Expression)this.list.getLast();
        this.end = expression2.end + 1;
        this.list = expression2.list;
        Expression expression3 = (Expression)this.list.getFirst();
        while (expression3 != null) {
            expression3.construe(expression, n);
            if (expression3.index == -10) {
                if (expression3.copula == null) {
                    expression3.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            } else {
                if (expression3.up != 0) {
                    expression3.warnErr("Unexpected slash", expression3.slashPos);
                    expression3.up = 0;
                }
                if (expression3.down > 0) {
                    expression3.warnErr("Unexpected slash level", expression3.slashPos);
                    expression3.down = -1;
                }
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeColon(Expression expression, int n) throws IOException {
        Expression expression2 = null;
        this.eContext = expression;
        this.feature = n;
        n = n & 0xE0 | 1;
        expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n);
        expression2.eContext = expression;
        expression = expression2;
        n |= 0x40;
        Expression expression3 = (Expression)this.list.getNext();
        while (expression3 != null) {
            expression3.construe(expression, n);
            if (expression3.index != -10) {
                expression3.eContext = expression;
                expression = expression3;
            } else if (expression3.copula != null) {
                this.list.remove();
            } else if (this.list.hasNext() || expression2.index == -10) {
                expression3.warnErr0("Unexpected indefinitude");
                this.list.remove();
            }
            expression3 = (Expression)this.list.getNext();
        }
    }

    void construeComma(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(expression, n);
            if (expression2.index == -10) {
                if (expression2.copula == null) {
                    expression2.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeDash(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        n = n & 0xE0 | 1;
        Expression expression2 = (Expression)this.list.getLast();
        expression2.construe(expression, n);
        Expression expression3 = (Expression)this.list.getFirst();
        expression3.construe(expression, n);
        Expression expression4 = expression3;
        Expression expression5 = (Expression)this.list.getNext();
        while (expression5 != expression2) {
            expression4.warnErr1("Surplus - dash");
            expression4 = expression5;
            this.list.remove();
            expression5 = (Expression)this.list.getNext();
        }
        if (expression3.index == -10 && expression2.index == -10 && (n & 0x40) == 0) {
            this.warnErr0("Unexpected - dash");
            this.list.remove();
        }
    }

    void construeEquality(Expression expression, int n) throws IOException {
        Expression expression2 = null;
        this.eContext = expression;
        this.feature = n;
        n = n & 0xE0 | 2;
        Expression expression3 = (Expression)this.list.getLast();
        expression2 = (Expression)this.list.getFirst();
        if (expression2.index == -10) {
            n &= 0xFFFFFF7F;
        } else if (expression3.index == -10) {
            n |= 0x80;
        }
        boolean bl = true;
        expression3 = (Expression)this.list.getFirst();
        while (expression3 != null) {
            if (bl) {
                bl = false;
                expression3.construe(expression, n);
                n &= 0xFFFFFF7F;
            } else {
                expression3.construe(expression, n);
                if (expression3.index == -10) {
                    if (expression3.copula != null) {
                        this.list.remove();
                    } else if (this.list.hasNext() || expression2.index == -10) {
                        expression3.warnErr0("Unexpected indefinitude");
                        this.list.remove();
                    }
                }
            }
            expression3 = (Expression)this.list.getNext();
        }
        expression2 = (Expression)this.list.getFirst();
        expression3 = (Expression)this.list.getNext();
        if (expression3 == null) {
            return;
        }
        if (expression2.index == -10) {
            if (expression3.no && this.feature != 128) {
                expression2.warnErr1("Unexpected inequality");
                this.index = -10;
                return;
            }
            return;
        }
        if (expression2.index == -4 || expression2.index == -2) {
            if (this.index == 14) {
                this.warnErr("Irregular equality", this.copula.position);
            } else {
                this.warnErr("Irregular inequality", this.copula.position);
            }
            while (expression3 != null) {
                this.list.remove();
                expression3 = (Expression)this.list.getNext();
            }
            return;
        }
        if (expression2.index == -1 && (expression3.index != -10 || this.list.hasNext())) {
            this.list.getFirst();
            if (this.index == 14) {
                this.warnErr("Irregular equality", this.copula.position);
            } else {
                this.warnErr("Irregular inequality", this.copula.position);
            }
            while (expression3 != null) {
                this.list.remove();
                expression3 = (Expression)this.list.getNext();
            }
            return;
        }
    }

    void construeNumber() {
        int n = this.end - this.begin - 1;
        if (n == 0) {
            return;
        }
        long l = Long.parseLong(this.text.substring(this.begin + 1, this.end));
        if (l > Integer.MAX_VALUE) {
            this.warnErr0("Number > PN.MAX_NUMBER(2147483647)");
            this.index = -10;
            return;
        }
        this.cnc = new Concept((int)l);
    }

    void construeParenthesis(Expression expression, int n) throws IOException {
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index != -10) {
            this.construeProcedure(expression, n);
            return;
        }
        this.eContext = expression;
        this.feature = n;
        n = n & 0x80 | 0x10;
        Expression expression3 = (Expression)this.list.getLast();
        this.end = expression3.end + 1;
        this.list = expression3.list;
        expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(null, n);
            if (expression2.index == -10) {
                if (expression2.copula == null) {
                    expression2.warnErr0("Unexpected indefinitude");
                }
                this.list.remove();
            } else if (expression2.down > 0 || expression2.up > 0) {
                expression2.warnErr("Unexpected slash level", expression2.slashPos);
                if (expression2.down > 0) {
                    expression2.down = -1;
                }
                if (expression2.up > 0) {
                    expression2.up = -1;
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeParenthesisTerm(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.construe(expression, n);
        if (expression2.index == -10 && (n & 0x80) != 0) {
            expression2.warnErr0("Description of relation without identifier");
            expression2.index = 52;
        }
        expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            expression2.construe(expression, n);
            if (expression2.index == -10) {
                this.list.remove();
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeProcedure(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getFirst();
        expression2.index = -4;
        expression2.construeSpecific(expression, n);
        if (expression2.index == -10) {
            this.index = -10;
            return;
        }
        if (expression2.index != -4) {
            expression2.warnErr("Unrecognized procedure name", expression2.begin + 1);
            this.index = -10;
            return;
        }
        this.begin = expression2.begin;
        this.index = -4;
        this.cnc = expression2.cnc;
        Expression expression3 = (Expression)this.list.getNext();
        this.end = expression3.end + 1;
        this.list = expression3.list;
        this.proc = new Procedure(this);
        this.proc.construe();
    }

    void construeSlash(Expression expression, int n) throws IOException {
        if ((n & 0x1F) != 16) {
            this.warnErr0("Unexpected slash expression");
            this.index = -10;
            return;
        }
        int n2 = this.construeSlash1(expression, n);
        Expression expression2 = (Expression)this.list.getFirst();
        this.list.remove();
        expression2 = (Expression)this.list.getLast();
        expression2.up = n2;
    }

    int construeSlash1(Expression expression, int n) throws IOException {
        int n2 = 0;
        Expression expression2 = (Expression)this.list.getFirst();
        Expression expression3 = (Expression)this.list.getNext();
        if (this.list.hasNext()) {
            expression3.warnErr1("Redundant slash");
            this.list.getNext();
            while (this.list.hasCurrent()) {
                this.list.remove();
                this.list.getNext();
            }
        }
        if (expression3.index == -10) {
            expression3.warnErr0("Unrecognized slash object");
            this.list.getLast();
            this.list.remove();
            expression2.construe(expression, n);
            return 0;
        }
        expression3.construe(expression, n);
        if (expression3.index == -10) {
            this.index = -10;
            return 0;
        }
        if (expression2.index != -10) {
            if (expression2.focus(2)) {
                if (expression2.cnc == null) {
                    expression2.warnErr0("Unrecognized slash level");
                    expression2.index = -10;
                    n2 = -1;
                } else {
                    n2 = this.cnc.toNumber();
                }
            } else {
                expression2.warnErr0("Unrecognized slash level");
                expression2.index = -10;
                n2 = -1;
            }
        }
        if (n2 != 0 && (expression3.down != 0 || expression3.up != 0)) {
            if (n2 > 0) {
                expression2.warnErr0("Unexpected slash level");
            }
            if (expression3.down > 0 || expression3.up > 0) {
                this.warnErr("Unexpected slash level", expression3.slashPos);
            }
            n2 = -1;
        }
        expression3.slashPos = this.begin;
        return n2;
    }

    void construeSpace(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.feature = n;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.eContext = expression;
            expression2.feature = n;
            switch (expression2.index) {
                case 4: {
                    expression2.construeWord();
                    break;
                }
                case 2: {
                    expression2.construeNumber();
                    break;
                }
                case 3: {
                    expression2.construeString();
                    break;
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeSpecific(Expression expression, int n) throws IOException {
        Concept concept;
        Concept concept2;
        boolean bl;
        int n2;
        int n3;
        int n4;
        this.eContext = expression;
        this.feature = n;
        if (this.text.charAt(this.begin) == '$') {
            String string;
            int n5 = this.begin + 1;
            if (this.text.charAt(n5) != '\"' && this.text.charAt(n5) != '\'') {
                n4 = n5;
                while (n4 < this.end) {
                    if (this.text.charAt(n4) == '\"' || this.text.charAt(n4) == '\'' || this.text.charAt(n4) == ' ' || this.text.charAt(n4) == '*') break;
                    ++n4;
                }
                string = this.text.substring(n5, n4);
            } else {
                string = "";
                n4 = n5;
            }
            Integer n6 = (Integer)Statement.hTypeObjects.get(string);
            if (n6 != null) {
                this.index = n6;
                while (n4 < this.end) {
                    if (this.text.charAt(n4) != ' ') break;
                    ++n4;
                }
                n3 = n4;
            } else {
                n3 = n5;
            }
        } else {
            n3 = this.begin;
        }
        if (this.text.charAt(this.end - 1) == '*') {
            n2 = this.end - 1;
            bl = true;
        } else {
            n2 = this.end;
            bl = false;
        }
        if (this.text.charAt(n2 - 1) == '\"' || this.text.charAt(n2 - 1) == '\'') {
            --n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n4 = n3;
        while (n4 < n2) {
            char c = this.text.charAt(n4);
            if (c != '\"' && c != '\'' && c != ' ') {
                stringBuffer.append(c);
            } else {
                if (c == ' ') {
                    ++n4;
                    while (n4 < n2) {
                        c = this.text.charAt(n4);
                        if (c != ' ') break;
                        ++n4;
                    }
                    if (n4 == n2) break;
                }
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(' ');
                }
                if (c == '\"' || c == '\'') {
                    ++n4;
                    while (n4 < n2) {
                        stringBuffer.append(this.text.charAt(n4));
                        ++n4;
                    }
                    break;
                }
                stringBuffer.append(this.text.charAt(n4));
            }
            ++n4;
        }
        String string = stringBuffer.toString();
        if (this.index < 0) {
            concept2 = new Concept(-this.index);
            this.type = Statement.types[-this.index];
        } else {
            concept2 = null;
        }
        if (this.index == -1 && string.equals("")) {
            string = this.stm.dbc.base.getPath();
        }
        this.cnc = concept = new Concept(string);
        Concept concept3 = null;
        Concept concept4 = null;
        if (bl) {
            if (concept2 == null) {
                this.stm.dbc.spec.con(61);
                this.stm.dbc.spec.see(concept);
                concept3 = this.stm.dbc.spec.getFirst(56);
                if (concept3 != null) {
                    if (this.stm.dbc.spec.getNext(56) != null) {
                        this.warnErr("Ambiguous specific name " + string + "*", n3);
                        this.cnc = concept3;
                    }
                    this.stm.dbc.spec.con(concept3).con(61);
                    concept4 = this.stm.dbc.spec.getFirst(56);
                    if (this.stm.dbc.spec.getNext(56) != null) {
                        this.warnErr("Ambiguous specific type", this.begin + 1);
                        this.type = Statement.types[concept4.toNumber()];
                    }
                }
            } else {
                this.stm.dbc.spec.con(57).con(concept2);
                if (this.stm.dbc.spec.hasConnect(57)) {
                    concept4 = concept2;
                    this.stm.dbc.spec.con(57);
                    this.stm.dbc.spec.see(concept);
                    concept3 = this.stm.dbc.spec.getFirst(56);
                    if (concept3 != null && this.stm.dbc.spec.getNext(56) != null) {
                        this.warnErr("Ambiguous specific name " + string + "*", n3);
                        this.cnc = concept3;
                    }
                }
            }
            this.stm.dbc.spec.regain();
        } else {
            if (concept2 == null) {
                this.stm.dbc.spec.con(61).con(concept);
                if (this.stm.dbc.spec.hasConnect(61)) {
                    concept3 = concept;
                    this.stm.dbc.spec.con(61);
                    concept4 = this.stm.dbc.spec.getFirst(56);
                    if (this.stm.dbc.spec.getNext(56) != null) {
                        this.warnErr("Ambiguous specific type", this.begin + 1);
                        this.type = Statement.types[concept4.toNumber()];
                    }
                }
            } else {
                this.stm.dbc.spec.con(57).con(concept2);
                if (this.stm.dbc.spec.hasConnect(57)) {
                    concept4 = concept2;
                    this.stm.dbc.spec.con(57);
                    concept3 = this.stm.dbc.spec.get(concept);
                }
            }
            this.stm.dbc.spec.regain();
        }
        if (concept3 == null) {
            if (bl) {
                this.warnErr("Unrecognized specific name " + string + "*", n3);
                this.index = -10;
                return;
            }
        } else if (bl) {
            this.cnc = concept3;
            concept = concept3;
            string = concept3.toString();
        }
        if (concept4 == null) {
            if (concept2 == null) {
                this.index = -3;
                concept2 = new Concept(-this.index);
                this.type = "var";
            }
        } else if (concept2 == null) {
            this.index = -concept4.toNumber();
            concept2 = concept4;
        }
        if (this.index == -4) {
            if (n != 128) {
                this.warnErr0("Unexpected procedure");
                this.index = -10;
            } else if (concept3 == null) {
                this.warnErr("Unrecognized procedure name", n3);
                this.index = -10;
            }
            return;
        }
        if (this.index == -3) {
            if (this.ass == null) {
                this.ass = (Association)this.stm.dbc.var.clone();
                this.ass.con(concept).con(57);
                this.ass.fix();
            }
        } else if (this.index == -2) {
            if ((n & 0xFFFFFF7F) != 8) {
                this.warnErr0("Unexpected file variable");
                this.index = -10;
                return;
            }
            if (!string.equals("")) {
                String string2;
                File file;
                if (File.separatorChar == '\\') {
                    string = string.replace('/', '\\');
                }
                int n7 = string.lastIndexOf(58);
                int n8 = string.lastIndexOf(File.separatorChar);
                int n9 = n8 >= 0 ? n8 : (n7 >= 0 ? n7 : -1);
                if (n9 >= 0 && !(file = new File(string2 = string.substring(0, n9))).isDirectory()) {
                    this.warnErr0("File name is not correct");
                    this.index = -10;
                    return;
                }
                this.file = new File(string);
                if ((n & 0x80) != 0) {
                    if (this.file.exists() && !this.file.canWrite()) {
                        this.warnErr0("Non-modifiable file");
                        this.index = -10;
                        return;
                    }
                } else if (this.file.exists() && !this.file.canRead()) {
                    this.warnErr0("Non-readable file");
                    this.index = -10;
                    return;
                }
            }
        } else if (this.index == -1) {
            String string3;
            File file;
            if ((n & 0xFFFFFFFD) != 128) {
                this.warnErr0("Unexpected base variable");
                this.index = -10;
                return;
            }
            if (File.separatorChar == '\\') {
                string = string.replace('/', '\\');
            }
            int n10 = string.lastIndexOf(58);
            int n11 = string.lastIndexOf(File.separatorChar);
            int n12 = n11 >= 0 ? n11 : (n10 >= 0 ? n10 : -1);
            if (n12 >= 0 && !(file = new File(string3 = string.substring(0, n12))).isDirectory()) {
                this.warnErr0("Base name is not correct");
                this.index = -10;
                return;
            }
            if (string.indexOf(46) < 0) {
                string = String.valueOf(string) + ".ass";
            }
            this.stm.fNewBase = new File(string);
        }
        if (concept4 == null || concept3 == null) {
            this.stm.dbc.spec.con(61).con(concept);
            this.stm.dbc.spec.setConnect(61, concept2);
            this.stm.dbc.spec.regain();
            this.stm.dbc.spec.con(57).con(concept2);
            this.stm.dbc.spec.setConnect(57, concept);
            this.stm.dbc.spec.regain();
        }
    }

    void construeString() {
        this.cnc = new Concept(this.text.substring(this.begin, this.end));
    }

    void construeWord() {
        this.cnc = new Concept(this.text.substring(this.begin, this.end));
    }

    void contextToStringBuffer(StringBuffer stringBuffer) {
        PList pList = new PList();
        while (this.eContext != null) {
            pList.insert(this.eContext);
            this.eContext = this.eContext.eContext;
        }
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            expression.toStringBuffer(stringBuffer);
            stringBuffer.append(": ");
            expression = (Expression)pList.getNext();
        }
    }

    void controlMemory(Long1 long1) throws IOException {
        PN.controlMemory(long1, this.stm.dbc.base, this.ass);
    }

    void controlMemory(Long1 long1, Association association) throws IOException {
        PN.controlMemory(long1, this.stm.dbc.base, this.ass, association);
    }

    void controlMemory(Long1 long1, Association association, Association association2, PList pList) throws IOException {
        if (!PN.filledMemory(long1)) {
            return;
        }
        this.stm.dbc.base.store();
        if (this.ass != null) {
            this.ass.store();
        }
        if (association != null) {
            association.store();
        }
        if (association2 != null) {
            association2.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        PN.optimizeMemory(long1);
    }

    void controlMemory(Long1 long1, Association association, PList pList) throws IOException {
        if (!PN.filledMemory(long1)) {
            return;
        }
        this.stm.dbc.base.store();
        if (this.ass != null) {
            this.ass.store();
        }
        if (association != null) {
            association.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        PN.optimizeMemory(long1);
    }

    void controlMemory(Long1 long1, PList pList) throws IOException {
        if (!PN.filledMemory(long1)) {
            return;
        }
        this.stm.dbc.base.store();
        if (this.ass != null) {
            this.ass.store();
        }
        PList pList2 = (PList)pList.clone();
        Expression expression = (Expression)pList2.getFirst();
        while (expression != null) {
            if (expression.ass != null) {
                expression.ass.store();
            }
            expression = (Expression)pList2.getNext();
        }
        PN.optimizeMemory(long1);
    }

    void deriveClass() throws IOException {
        if (this.ass.getSense() == 57) {
            this.ass = this.stm.dbc.base.get(this.ass);
        }
    }

    void equip() {
        int n;
        char c;
        char c2 = '\u0000';
        int n2 = this.stm.end;
        this.begin = this.stm.pos;
        while (this.begin < n2) {
            this.begin = Statement.passCommentary(this.stm.text, this.begin);
            this.begin = Statement.passAngleBracket(this.stm.text, this.begin);
            if (this.begin == this.stm.pos) break;
            this.stm.pos = this.begin;
        }
        if (this.begin >= n2) {
            this.end = this.begin = n2;
            this.index = -10;
            return;
        }
        this.end = this.begin;
        c2 = this.text.charAt(this.begin);
        if (c2 == ';' || c2 == '<' || c2 == '>') {
            this.index = -10;
            return;
        }
        int n3 = c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' ? -1 : "$*#\"' {[(}])^:=~/\\,".indexOf(c2);
        if (n3 == 0 && this.end + 1 < n2 && this.text.charAt(this.end + 1) != ' ') {
            c = this.text.charAt(this.end + 1);
            n = "$*#\"' {[(}])^:=~/\\,".indexOf(c);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || n >= 0 && c != '\"' && c != '\'')) {
                ++this.end;
                while (this.end < n2) {
                    c = this.text.charAt(this.end);
                    n = "$*#\"' {[(}])^:=~/\\,".indexOf(c);
                    if (n >= 0 && c != ' ' && c != '\\') {
                        if (c == '/') {
                            if (this.end + 1 < n2 && (this.text.charAt(this.end + 1) == '/' || this.text.charAt(this.end + 1) == '*')) {
                                break;
                            }
                        } else {
                            if (c == ';' || c == '<') break;
                            if (c == '*') {
                                ++this.end;
                                break;
                            }
                            if (c != '\"' && c != '\'') break;
                            char c3 = c;
                            int n4 = this.end + 1;
                            while (n4 < n2) {
                                if (this.text.charAt(n4) == c3) break;
                                ++n4;
                            }
                            if (n4 >= n2) break;
                            this.end = n4 + 1;
                            if (this.end >= n2 || this.text.charAt(this.end) != '*') break;
                            ++this.end;
                            break;
                        }
                    }
                    ++this.end;
                }
                this.index = 0;
                this.copula = this.stm.createCopula(this.begin, this.index, '$');
                this.stm.pos = this.end;
                return;
            }
        }
        if (n3 <= 0) {
            while (++this.end < n2) {
                c = this.text.charAt(this.end);
                if (c <= ' ' || c == ';' || c == '<' || !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || (n = "$*#\"' {[(}])^:=~/\\,".indexOf(c)) < 0 || c == '\\') && (c != '/' || this.end + 1 < n2 && (this.text.charAt(this.end + 1) == '/' || this.text.charAt(this.end + 1) == '*'))) break;
            }
            this.index = 4;
            this.copula = this.stm.createCopula(this.begin, this.index, '\u0000');
            this.stm.pos = this.end;
            return;
        }
        if (n3 == 1) {
            this.index = 1;
            this.copula = this.stm.createCopula(this.begin, this.index, '*');
            this.stm.pos = ++this.end;
            return;
        }
        if (n3 == 2) {
            while (++this.end < n2) {
                char c4 = this.text.charAt(this.end);
                if (c4 < '0' || c4 > '9') break;
            }
            this.index = 2;
            this.copula = this.stm.createCopula(this.begin, this.index, '#');
            this.stm.pos = this.end;
            return;
        }
        if (n3 == 3 || n3 == 4) {
            char c5 = c2;
            while (++this.end < n2) {
                if (this.text.charAt(this.end) == c5) break;
            }
            if (this.end == n2) {
                this.warnErr0("Unclosed " + c5 + " left quote");
                this.stm.pos = ++this.begin;
                this.equip();
                return;
            }
            this.index = n3;
            this.copula = this.stm.createCopula(this.begin, this.index, c2);
            this.stm.pos = ++this.end;
            return;
        }
        if (this.stm.copula != null && this.stm.copula.index == n3 && n3 > 11 && n3 < 18) {
            this.warnErr1("Redundant or duplicate " + c2 + " symbol");
            this.stm.pos = ++this.end;
            this.equip();
            return;
        }
        this.index = -10;
        this.stm.pos = this.end;
        this.end = this.begin;
    }

    boolean execute() {
        return this.execute(null, false);
    }

    boolean execute(Association association) {
        return this.execute(association, false);
    }

    boolean execute(Association association, boolean bl) throws ZException {
        try {
            return this.execute1(association, bl);
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    boolean execute1(Association association, boolean bl) throws ZException, IOException {
        switch (this.index) {
            case -1: {
                this.stm.dbc.changeBase(this.stm.fNewBase);
                return false;
            }
            case -4: {
                return this.proc.execute();
            }
            case -3: {
                return this.executeVariable(association, bl);
            }
            case 5: {
                return this.executeSpace(association, bl);
            }
            case 6: {
                return this.executeBrace(association, bl);
            }
            case 7: {
                return this.executeBracket(association, bl);
            }
            case 11: {
                return this.executeParenthesisTerm(association);
            }
            case 12: {
                return this.executeDash(association);
            }
            case 13: {
                return this.executeColon(association);
            }
            case 14: {
                return this.executeEquality(association);
            }
            case 15: {
                return this.executeInEquality(association);
            }
            case 18: {
                return this.executeComma(association, bl);
            }
            case 19: {
                return this.executeAssignement(association);
            }
        }
        return false;
    }

    boolean executeAssignement(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        switch (expression.index) {
            case -3: {
                return this.assignementToVariable(association);
            }
        }
        return this.assignementToConception(association);
    }

    boolean executeBrace(Association association, boolean bl) throws IOException {
        Long1 long1 = PN.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.execute(association, false)) {
                if (expression.down != 0 && expression.up == 0) {
                    expression.ass.setAbsolute(true);
                }
                if (this.ass == null) {
                    if (expression.index == -3) {
                        this.ass = expression.ass.get();
                        this.ass.setSense(expression.ass.getSense());
                        this.ass.setAbsolute(expression.ass.hasAbsolute());
                    } else {
                        this.ass = expression.ass;
                    }
                } else {
                    if (this.ass.getSense() != expression.ass.getSense()) {
                        this.deriveClass();
                        expression.deriveClass();
                    }
                    if (!this.ass.hasAbsolute() || expression.ass.hasAbsolute()) {
                        this.ass.set(expression.ass);
                    } else {
                        expression.ass.set(this.ass);
                        this.ass = expression.ass;
                    }
                }
                expression.ass = null;
                this.controlMemory(long1, association);
            }
            expression = (Expression)this.list.getNext();
        }
        if (this.ass == null || !this.ass.has()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.dbc.selectClass(association, this.ass) : this.stm.dbc.insertClass(association, this.ass);
        return this.yields1();
    }

    boolean executeBracket(Association association, boolean bl) throws IOException {
        Long1 long1 = PN.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.execute(null, false)) {
                if (expression.down != 0 && expression.up == 0) {
                    expression.ass.setAbsolute(true);
                }
                expression.ass = expression.ass.getSense() == 57 ? this.stm.dbc.selectInstance(expression.ass) : expression.ass.getInstance();
                if (this.ass == null) {
                    this.ass = expression.ass;
                } else {
                    this.ass.set(expression.ass);
                }
                expression.ass = null;
                PN.controlMemory(long1, this.ass);
            }
            expression = (Expression)this.list.getNext();
        }
        if (this.ass == null || !this.ass.has()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.dbc.selectClass(association, this.ass) : this.stm.dbc.insertClass(association, this.ass);
        return this.yields1();
    }

    /*
     * Unable to fully structure code
     */
    boolean executeColon(Association var1_1) throws IOException {
        var3_2 = PN.initMemory();
        var2_3 = (Expression)this.list.getFirst();
        while (var2_3 != null) {
            if (this.ass != null) ** GOTO lbl9
            if (var2_3.index == -10) {
                this.ass = var1_1 == null ? PN.aNull : var1_1;
            } else {
                this.ass = var1_1;
lbl9:
                // 2 sources

                if (this.ass != null) {
                    this.ass.setSense(57);
                }
                if (var2_3.index == -10) {
                    return true;
                }
                if (!var2_3.execute(this.ass, true)) {
                    this.ass = null;
                    return false;
                }
                this.ass = var2_3.ass;
                var2_3.ass = null;
                this.controlMemory(var3_2);
            }
            var2_3 = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean executeComma(Association association, boolean bl) throws IOException {
        return this.executeBrace(association, bl);
    }

    boolean executeDash(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        if (expression.index != -10 && !expression.execute(association, true) && expression2.index != -10 && !expression2.execute(association, true)) {
            return false;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.dbc.selectInterval(association, expression.ass, expression2.ass) : this.stm.dbc.selectInterval(association, expression.ass, expression2.ass);
        expression.ass = null;
        expression2.ass = null;
        return this.yields1();
    }

    boolean executeEquality(Association association) throws IOException {
        Expression expression;
        Expression expression2;
        Expression expression3 = (Expression)this.list.getFirst();
        if (expression3.index == -1) {
            Expression expression4 = (Expression)this.list.getNext();
            this.stm.dbc.changeBase(this.stm.fNewBase);
            return false;
        }
        if (expression3.index == -10) {
            expression2 = (Expression)this.list.getNext();
            expression = null;
        } else {
            expression3 = null;
            expression = (Expression)this.list.getLast();
            if (expression.index != -10) {
                expression = null;
            }
            expression2 = (Expression)this.list.getFirst();
        }
        if (!expression2.execute(association, false)) {
            return false;
        }
        if (expression2.index == -3) {
            this.ass = expression2.ass.get();
            this.ass.setSense(expression2.ass.getSense());
            this.ass.setAbsolute(expression2.ass.hasAbsolute());
        } else {
            this.ass = expression2.ass;
        }
        expression2.ass = null;
        Long1 long1 = PN.initMemory();
        expression2 = (Expression)this.list.getNext();
        while (expression2 != expression) {
            if (!expression2.execute(association, false)) {
                this.ass = null;
                return false;
            }
            Association association2 = expression2.ass.get(this.ass);
            if (this.ass.getSense() == expression2.ass.getSense()) {
                association2.setSense(this.ass.getSense());
            }
            expression2.ass = null;
            if (!this.yields1()) {
                return false;
            }
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        if (expression != null) {
            this.ass = this.stm.dbc.insertClass(association, this.ass);
            return true;
        }
        if (expression3 != null || association != null) {
            this.ass = this.stm.dbc.selectClass(association, this.ass);
        }
        return this.yields1();
    }

    boolean executeInEquality(Association association) throws IOException {
        Expression expression;
        Expression expression2;
        Expression expression3 = (Expression)this.list.getFirst();
        if (expression3.index == -1) {
            Expression expression4 = (Expression)this.list.getNext();
            this.stm.dbc.changeBase1(this.stm.fNewBase);
            return false;
        }
        if (expression3.index == -10) {
            expression2 = (Expression)this.list.getNext();
            expression = null;
        } else {
            expression3 = null;
            expression = (Expression)this.list.getLast();
            if (expression.index != -10) {
                expression = null;
            }
            expression2 = (Expression)this.list.getFirst();
        }
        if (!expression2.execute(association, false)) {
            return false;
        }
        if (expression2.index == -3) {
            this.ass = expression2.ass.get();
            this.ass.setSense(expression2.ass.getSense());
            this.ass.setAbsolute(expression2.ass.hasAbsolute());
        } else {
            this.ass = expression2.ass;
        }
        expression2.ass = null;
        Long1 long1 = PN.initMemory();
        expression2 = (Expression)this.list.getNext();
        while (expression2 != expression) {
            if (expression2.execute(association, false)) {
                this.deriveClass();
                this.ass.clear(expression2.ass);
                expression2.ass = null;
                if (!this.yields1()) {
                    return false;
                }
                this.controlMemory(long1);
            }
            expression2 = (Expression)this.list.getNext();
        }
        if (!this.yields1()) {
            return false;
        }
        if (expression != null) {
            this.stm.dbc.deleteRelation(this.ass);
            return true;
        }
        if (expression3 != null) {
            this.deriveClass();
            this.stm.dbc.deleteConception(this.ass);
            this.ass = null;
            return false;
        }
        return this.yields1();
    }

    boolean executeParenthesisTerm(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (expression.index == -10) {
            if (association != null && association != PN.aNull) {
                expression.ass = association;
            }
        } else if (!expression.execute(association, true)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        PList pList = new PList();
        Long1 long1 = PN.initMemory();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            PList pList2 = expression2.list;
            expression2 = (Expression)pList2.getFirst();
            while (expression2 != null) {
                if (!expression2.execute(null, true) && (this.feature & 0x80) == 0) {
                    return false;
                }
                if (expression2.down != 0 && expression2.up != 0) {
                    pList.add(59, (Object)expression2.ass);
                } else if (expression2.down != 0) {
                    pList.add(62, (Object)expression2.ass);
                } else if (expression2.up != 0) {
                    pList.add(58, (Object)expression2.ass);
                } else {
                    pList.add(0, (Object)expression2.ass);
                }
                expression2.ass = null;
                PN.controlMemory(long1, this.ass, pList);
                expression2 = (Expression)pList2.getNext();
            }
            expression2 = (Expression)this.list.getNext();
        }
        if ((this.feature & 0x80) == 0) {
            if ((pList = this.stm.dbc.selectSchema(this.ass, pList)) == null) {
                this.warnFail(this.eContext, "Unknown schema");
                return false;
            }
            this.ass = this.stm.dbc.selectRelation(this.ass, pList);
        } else {
            if ((pList = this.stm.dbc.insertSchema(this.ass, pList)) == null) {
                this.warnFail(this.eContext, "Conflicting schema");
                return false;
            }
            this.stm.dbc.insertContents(this.ass.get(56));
            this.stm.dbc.insertRelation(this.ass, pList);
        }
        return this.yields1();
    }

    boolean executeSpace(Association association, boolean bl) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        switch (expression.index) {
            case 1: {
                this.ass = this.stm.dbc.selectObjects(association);
                return this.yields1();
            }
            case 2: 
            case 3: {
                this.ass = (this.feature & 0x80) == 0 ? this.stm.dbc.selectName(association, this.list, bl) : this.stm.dbc.insertName(association, this.list, bl);
                return this.yields1();
            }
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.dbc.selectObject(association, this.list, bl) : this.stm.dbc.insertObject(association, this.list, bl);
        return this.yields1();
    }

    void executeStatement() {
        this.executeStatement(null, false);
    }

    void executeStatement(Association association, boolean bl) {
        if (this.index < 18) {
            this.executeStatement1(association, bl);
            return;
        }
        Long1 long1 = PN.initMemory();
        try {
            Expression expression = (Expression)this.list.getFirst();
            while (expression != null) {
                if (expression.executeStatement1(association, bl)) {
                    if (this.ass == null) {
                        this.ass = expression.ass;
                    } else {
                        this.ass.set(expression.ass);
                    }
                    expression.ass = null;
                }
                this.controlMemory(long1, this.list);
                expression = (Expression)this.list.getNext();
            }
        }
        catch (ZException zException) {
            throw zException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.stm, this.begin);
            throw new ZException(exception.toString());
        }
    }

    boolean executeStatement1(Association association, boolean bl) {
        Expression expression = (Expression)this.list.getFirst();
        if (this.feature == 128 && expression != null && expression.index == -10 && this.index == 14) {
            Expression expression2 = (Expression)this.list.getNext();
            if (!expression2.no) {
                Procedure procedure = new Procedure(this, new PList().add(expression2));
                procedure.execute();
                return false;
            }
        }
        return this.execute(association, bl);
    }

    boolean executeVariable(Association association, boolean bl) throws IOException {
        if (!this.yields()) {
            return false;
        }
        if (!bl) {
            return true;
        }
        this.ass = (this.feature & 0x80) == 0 ? this.stm.dbc.selectClass(association, this.ass) : this.stm.dbc.insertClass(association, this.ass);
        return this.yields1();
    }

    boolean focus(int n) {
        if (this.index == 5 && this.list.hasOne()) {
            Expression expression = (Expression)this.list.getFirst();
            if (expression.index == n) {
                this.affect(expression);
                return true;
            }
        }
        return false;
    }

    void freeInnerExpression() {
        Expression.freeInnerExpression(this.list);
    }

    static void freeInnerExpression(PList pList) {
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            expression.ass = null;
            expression = (Expression)pList.getNext();
        }
    }

    void insert(Expression expression) {
        this.begin = expression.begin;
        this.list.getFirst();
        this.list.insert(expression);
    }

    void toStringBuffer(StringBuffer stringBuffer) {
        this.toStringBuffer(stringBuffer, true);
    }

    void toStringBuffer(StringBuffer stringBuffer, boolean bl) {
        String string;
        if (bl) {
            bl = false;
        } else {
            if (this.down != 0) {
                if (this.down > 0) {
                    stringBuffer.append(this.down);
                }
                stringBuffer.append('\\');
            }
            if (this.up != 0) {
                if (this.up > 0) {
                    stringBuffer.append(this.up);
                }
                stringBuffer.append('/');
            }
        }
        if (this.index == -10) {
            return;
        }
        if (this.list.isEmpty()) {
            if (this.index <= 0) {
                stringBuffer.append('$');
                if (this.type != null) {
                    stringBuffer.append(this.type).append(" ");
                }
                if (this.text.charAt(this.end - 1) == '\"' || this.text.charAt(this.end - 1) == '\'') {
                    stringBuffer.append('\'');
                    stringBuffer.append(this.cnc.toString());
                    stringBuffer.append('\'');
                } else {
                    stringBuffer.append(this.cnc.toString());
                }
                return;
            }
            stringBuffer.append(this.text.substring(this.begin, this.end));
            return;
        }
        if (this.index == -4) {
            stringBuffer.append('$');
            if (this.type != null) {
                stringBuffer.append(this.type).append(" ");
            }
            stringBuffer.append(this.cnc.toString());
            stringBuffer.append(this.copula.mark);
            string = ", ";
        } else if (this.index == 6 || this.index == 7 || this.index == 8) {
            if (this.copula.mark == '{') {
                stringBuffer.append("{ ");
            } else {
                stringBuffer.append(this.copula.mark);
            }
            string = ", ";
        } else {
            string = this.index == 11 ? " " : (this.index == 14 || this.index == 15 ? String.valueOf(this.copula.mark) : String.valueOf(this.copula.mark) + " ");
        }
        Expression expression = (Expression)this.list.getFirst();
        if (expression != null) {
            expression.toStringBuffer(stringBuffer, bl);
        }
        while (this.list.hasNext()) {
            expression = (Expression)this.list.getNext();
            if (this.index == 19) {
                if (expression.no) {
                    stringBuffer.append(" ~");
                } else {
                    stringBuffer.append(" =");
                }
                Expression expression2 = (Expression)expression.list.getFirst();
                if (expression2 == null || expression2.index != -10) {
                    stringBuffer.append("= ");
                }
            } else if (this.index == 5) {
                if (expression.index != 1) {
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(string);
            }
            expression.toStringBuffer(stringBuffer, bl);
        }
        if (this.copula.mark == '{') {
            stringBuffer.append(" }");
        } else if (this.copula.mark == '[') {
            stringBuffer.append(']');
        } else if (this.copula.mark == '<') {
            stringBuffer.append('>');
        } else if (this.copula.mark == '(') {
            stringBuffer.append(')');
        }
    }

    void warnErr(String string, int n) {
        new Warning("Error", this.stm, n, string);
    }

    void warnErr0(String string) {
        new Warning("Error", this.stm, this.begin, string);
    }

    void warnErr1(String string) {
        new Warning("Error", this.stm, this.end, string);
    }

    void warnFail(int n, Expression expression, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        if (expression.no) {
            stringBuffer.append(" ~ ");
        } else {
            stringBuffer.append(" = ");
        }
        expression.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Warning("Failure", this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(Expression expression, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Warning("Failure", this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toStringBuffer(stringBuffer);
        if (string.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string);
        }
        new Warning("Failure", this.stm, this.begin, stringBuffer.toString());
    }

    void warnFail(String string, PList pList, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        this.contextToStringBuffer(stringBuffer);
        this.toStringBuffer(stringBuffer);
        stringBuffer.append(string);
        stringBuffer.append("(");
        Expression expression = (Expression)pList.getFirst();
        while (expression != null) {
            expression.toStringBuffer(stringBuffer, false);
            if (pList.hasNext()) {
                stringBuffer.append(", ");
            }
            expression = (Expression)pList.getNext();
        }
        stringBuffer.append(") ");
        if (string2.length() > 0) {
            stringBuffer.append(" - ");
            stringBuffer.append(string2);
        }
        new Warning("Failure", this.stm, this.begin, stringBuffer.toString());
    }

    boolean yields() throws IOException {
        if (this.ass != null && this.ass.has()) {
            return true;
        }
        this.ass = null;
        if (!this.stm.noWarnFailure) {
            this.warnFail("");
        }
        return false;
    }

    boolean yields1() throws IOException {
        if (this.ass != null && this.ass.has()) {
            return true;
        }
        this.ass = null;
        if (!this.stm.noWarnFailure) {
            this.warnFail(this.eContext, "");
        }
        return false;
    }
}

