/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Long1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Z.DBConnection;
import Sav.Z.Interface;
import Sav.Z.Statement;
import Sav.Z.Status;
import Sav.Z.Warning;
import Sav.Z.ZException;
import java.io.IOException;

public class Script
implements Interface {
    DBConnection dbc;
    String dbPath;
    String text;
    PList stmList;
    Status stScriptLine;
    Status stProcess;
    Status stDataBase;
    int iLine;
    int executedPosition;
    int analysedPosition;

    public Script(DBConnection dBConnection, String string) throws IOException {
        this.dbc = dBConnection;
        this.setStatusDataBase(dBConnection.getBase().getPath());
    }

    public boolean analyse() {
        Throwable throwable = null;
        ZException zException = null;
        int n = this.dbc.getWarnings().count();
        this.stmList = new PList();
        this.analysedPosition = 0;
        this.setStatusProcess("Analysing ...");
        this.iLine = 1;
        this.setStatusScriptLine(Integer.toString(this.iLine));
        try {
            this.analyse1();
        }
        catch (ZException zException2) {
            zException = zException2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.dbc, this.iLine, this.analysedPosition);
            throwable = exception;
        }
        this.clearStatusScriptLine();
        this.clearStatusProcess();
        if (throwable != null) {
            throw new ZException(throwable.toString());
        }
        if (zException != null) {
            throw zException;
        }
        if (n == this.dbc.getWarnings().count()) {
            this.setStatusResult("Analysis successful!");
            return true;
        }
        return false;
    }

    void analyse1() {
        int n = this.text.length();
        while (this.analysedPosition < n) {
            Statement statement = this.dbc.createStatement(this.text, this.analysedPosition);
            statement.setLineNumber(this.iLine);
            statement.analyse();
            if (statement.toEnd() != statement.toBegin()) {
                this.stmList.add(statement);
            }
            ++this.analysedPosition;
            while (this.analysedPosition < statement.getEnd()) {
                if (statement.getText().charAt(this.analysedPosition) == '\n') {
                    ++this.iLine;
                    this.setStatusScriptLine(Integer.toString(this.iLine));
                }
                ++this.analysedPosition;
            }
        }
    }

    void clearStatusDataBase() {
        this.dbc.clearStatusDataBase();
    }

    void clearStatusProcess() {
        this.dbc.clearStatusProcess();
    }

    void clearStatusResult() {
        this.dbc.clearStatusResult();
    }

    void clearStatusScriptLine() {
        this.dbc.clearStatusLine();
    }

    public void execute() {
        Throwable throwable = null;
        ZException zException = null;
        int n = this.dbc.getWarnings().count();
        this.executedPosition = 0;
        this.setStatusProcess("Executing ...");
        this.iLine = 1;
        this.setStatusScriptLine(Integer.toString(this.iLine));
        try {
            this.execute1();
        }
        catch (ZException zException2) {
            zException = zException2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.dbc, this.iLine, this.executedPosition);
            throwable = exception;
        }
        this.clearStatusScriptLine();
        this.clearStatusProcess();
        if (throwable != null) {
            throw new ZException(throwable.toString());
        }
        if (zException != null) {
            throw zException;
        }
        if (n == this.dbc.getWarnings().count()) {
            this.setStatusResult("Execution successful!");
        }
    }

    void execute1() throws IOException {
        this.stmList = new PList();
        int n = this.text.length();
        this.dbc.restoreSpecification();
        Statement statement = null;
        Long1 long1 = PN.initMemory();
        while (this.executedPosition < n) {
            if (this.dbc.isInterrupted()) break;
            statement = this.dbc.createStatement(this.text, this.executedPosition);
            statement.setLineNumber(this.iLine);
            if (!statement.analyse()) break;
            if (statement.getIndex() != -10) {
                this.executeStm(statement);
            }
            PN.controlMemory(long1, this.dbc.base, this.dbc.var);
            ++this.executedPosition;
            while (this.executedPosition < statement.getEnd()) {
                if (statement.getText().charAt(this.executedPosition) == '\n') {
                    ++this.iLine;
                    this.setStatusScriptLine(Integer.toString(this.iLine));
                }
                ++this.executedPosition;
            }
        }
        this.dbc.store(statement);
    }

    public void executeStatements() {
        Throwable throwable = null;
        ZException zException = null;
        if (this.dbc.hasWarnings()) {
            return;
        }
        this.executedPosition = 0;
        this.setStatusProcess("Executing ...");
        this.iLine = 1;
        this.setStatusScriptLine(Integer.toString(this.iLine));
        try {
            this.executeStatements1();
        }
        catch (ZException zException2) {
            zException = zException2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new Warning(exception, this.dbc, this.iLine, this.analysedPosition);
            throwable = exception;
        }
        this.clearStatusScriptLine();
        this.clearStatusProcess();
        if (throwable != null) {
            throw new ZException(throwable.toString());
        }
        if (zException != null) {
            throw zException;
        }
        if (this.dbc.hasWarnings()) {
            this.setStatusResult("Execution successful!");
        }
    }

    void executeStatements1() throws IOException {
        if (this.stmList.isEmpty()) {
            return;
        }
        this.iLine = 1;
        int n = this.text.length();
        this.dbc.restoreSpecification();
        Long1 long1 = PN.initMemory();
        Statement statement = (Statement)this.stmList.getFirst();
        while (statement != null) {
            if (this.dbc.isInterrupted()) break;
            this.executeStm(statement);
            PN.controlMemory(long1, this.dbc.base, this.dbc.var);
            this.iLine = statement.getLineNumber();
            this.setStatusScriptLine(Integer.toString(this.iLine));
            this.executedPosition = statement.getEnd();
            statement = (Statement)this.stmList.getNext();
        }
        this.dbc.store(statement);
        this.clearStatusScriptLine();
    }

    void executeStm(Statement statement) throws IOException {
        statement.execute();
        if (!this.dbc.getBase().getPath().equals(this.dbPath)) {
            this.setStatusDataBase(this.dbc.getBase().getPath());
        }
    }

    void setStatusDataBase(String string) {
        this.dbc.setStatusDataBase(string);
    }

    void setStatusProcess(String string) {
        this.dbc.setStatusProcess(string);
    }

    void setStatusResult(String string) {
        this.dbc.setStatusResult(string);
    }

    void setStatusScriptLine(String string) {
        this.dbc.setStatusLine(string);
    }
}

