'
' AUTO.BAS
'
' Edit EMAIL.INC before compiling.
' Compile + link: PBCC AUTO.BAS
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"

Sub MyPrint(S As Asciiz)
Dim I As Integer
Dim C As String
Dim X As String
X = ""
For I = 1 To 128
  C = MID$(S,I,1)
  IF ASC(C) >= ASC(" ") THEN
    X = X + C
  ELSE
    PRINT X
    Exit Sub
  END If
Next I
End Sub

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
Call MyPrint(Buffer)
End Sub

FUNCTION PbMain() AS LONG
$INCLUDE "EMAIL.INC"
Dim I As Integer
Dim N As Integer
Dim P1 As Integer
Dim P2 As Integer
Dim Code As Long
Dim NbrMsg As Long
Dim Version As Integer
Dim DiagFile As Asciiz * 64
Dim Temp As Asciiz * 255
Dim Buffer As Asciiz * 5000
Dim ToAddr As Asciiz * 64
Dim Message As Asciiz * 64
Dim Subject As Asciiz * 64
Dim NullString As Asciiz * 1

PRINT "AUTO 01/20/2000"

NullString = Chr$(0)
Message = "Your email has been received."
Subject = "Automated Response"

' attach SEE
Code = seeAttach(2, %SEE_KEY_CODE)
If Code < 0 Then
  PRINT "Cannot attach SEE. Check SEE_KEY_CODE"
  Exit Function
End If
' define diagnostics log file for channel 0
DiagFile = "AUTO-0.LOG"
Code = seeStringParam(0,%SEE_LOG_FILE, DiagFile)
' connect to POP3 server
PRINT "Connecting to POP3 server ";POP3_HOST_NAME
Code = seePop3Connect(0,POP3_HOST_NAME,POP3_USER_NAME,POP3_PASSWORD)
IF Code < 0 THEN
  Call ShowError(Code)
  EXIT Function
END IF
' define diagnostics log file for channel 1
DiagFile = "AUTO-1.LOG"
Code = seeStringParam(1,%SEE_LOG_FILE, DiagFile)
' connect to SMTP server
PRINT "Connecting to SMTP server ";SMTP_HOST_NAME
Code = seeSmtpConnect(1,SMTP_HOST_NAME,YOUR_EMAIL_ADDR,YOUR_EMAIL_ADDR)
IF Code < 0 THEN
  Call ShowError(Code)
  ' close open connection to POP3 server
  Code = seeClose(0)
  EXIT Function
END IF
' get # messages waiting
PRINT "Getting message status..."
NbrMsg = seeGetEmailCount(0)
IF NbrMsg < 0 THEN
  Call ShowError(NbrMsg)
  Exit Function
ELSE
  PRINT NbrMsg;" messages waiting."
END IF

' read message headers
For I = 1 To NbrMsg
  ' read message I
  PRINT "---[ Message " + Str$(I) + " ]---"
  Buffer = Space$(1024)
  Code = seeGetEmailLines(0, I, 0, Buffer, 5000)
  If Code < 0 Then
     Call ShowError(Code)
     Exit For
  End If
  If Code > 0 Then
    ' search for "Reply-To: " line
    Temp = Space$(255)
    N = seeExtractText(Buffer, "Reply-To: ", Temp, 255)
    If N = 0 Then
      ' search for "From: " line
      N = seeExtractText(Buffer, "From: ", Temp, 255)
    End If
    If N = 0 Then
      PRINT "Can't find 'Reply-To:' or 'From:'"
    Else
      MyPrint(Temp)
      ' extract return address
      P1 = InStr(Temp, ":")
      P2 = InStr(P1, Temp, Chr$(13))
      If P2 = 0 Then
        P2 = Len(Temp) - P1
      End If
      '''MsgBox "P1=" + Str$(P1) + ", P2=" + Str$(P2)
      ToAddr = Mid$(Temp, P1 + 2, P2 - P1 - 2)
      '''MsgBox "[" + ToAddr + "]"
      ToAddr = ToAddr + Chr$(0)
      Code = seeVerifyFormat(ToAddr)
      If Code < 0 Then
       'error in format
        PRINT "Error in " + ToAddr
        Call ShowError(NbrMsg)
      Else
        ' email response
        Code = seeSendEmail(1, ToAddr, NullString, NullString, Subject, Message, NullString)
        If Code < 0 Then
          'error attempting to send email
          Call ShowError(NbrMsg)
          Exit For
        Else
          PRINT "Response sent to " + ToAddr
          PRINT
        End If
      End If
    End If
  End If
Next I
' close all connections + release SEE
Code = seeClose(0)
Code = seeClose(1)
Code = seeRelease()
END FUNCTION
