'
' BCAST.BAS (Broadcast)
'
' Edit EMAIL.INC, and the strings
' EmailList, EmailSubj, and EmailFile
' (line 58 below) before compiling.
'
' Compile & link: PBCC STAT.BAS
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
PRINT Buffer
End Sub

Sub MyPrint(S As Asciiz)
Dim I As Integer
Dim C As String
Dim X As String
X = ""
For I = 1 To 128
  C = MID$(S,I,1)
  IF ASC(C) >= ASC(" ") THEN
    X = X + C
  ELSE
    PRINT X
    Exit Sub
  END If
Next I
End Sub

FUNCTION PbMain() AS LONG
$INCLUDE "EMAIL.INC"
Dim I As Long
Dim Code As Long
Dim Version As Long
Dim NbrMsg As Long
Dim NullString As Asciiz * 2
Dim X As Asciiz * 64
Dim Buffer As Asciiz * 1024
Dim Temp As Asciiz * 128
Dim DiagFile As Asciiz * 64
Dim A As String
Dim B As String
Dim C As String

Dim EmailList As Asciiz * 16
Dim EmailSubj As Asciiz * 16
Dim EmailFile As Asciiz * 16

PRINT "BCAST 04/02/99"
On Error Goto ErrorHandler

EmailList = "BCAST.EML"
EmailSubj = "BCAST Test"
EmailFile = "@BCAST.MAI"

NullString = ""
' attach SEE
Code = seeAttach(1,%SEE_KEY_CODE)
If Code < 0 Then
  PRINT "Cannot attach SEE. Check SEE_KEY_CODE"
  Exit Function
End If
' display SEE version
Version = seeStatistics(0,%SEE_GET_VERSION)
C = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
B = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
A = LTRIM$(Str$(&H0F AND Version))
PRINT "SEE Version " + A + "." + B + "." + C

PRINT
PRINT "SMTP  Host: "; SMTP_HOST_NAME
PRINT "Email From: "; YOUR_EMAIL_ADDR
PRINT "Email List: "; EmailList
PRINT "Email Subj: "; EmailSubj
PRINT "Email File: "; EmailFile

' OK to continue ?
PRINT
PRINT "Type ESC to quit, any other key to continue..."
DO
  A = InKey$
  If Len(A) > 0 Then Exit Do
LOOP
' quit ?
IF A = Chr$(27) Then
  Exit Function
end if

' check email return address
Code = seeVerifyFormat(YOUR_EMAIL_ADDR)
If Code < 0 Then
  PRINT "Error: ";YOUR_EMAIL_ADDR;": ";
  Call ShowError(Code)
  Exit Function
End If

' check format of email addresses

PRINT "Opening " + EmailList
PRINT "Checking email address format"
Open EmailList For Input As 1
Do Until EOF(1)
  Line Input #1, X
  If Len(X) > 2 Then
    If (InStr(X, "<") = 0) And (InStr(X, ">") = 0) Then
      ' sorround with brackets
      X = "<" + X + ">"
    End If
    Code = seeVerifyFormat(X)
    If Code < 0 Then
      PRINT X
      Call ShowError(Code)
      Exit Function
    End If
  End If
Loop
Close 1
PRINT "All email addresses check OK."

' define diagnostics log file
DiagFile = "BCAST.LOG"
Code = seeStringParam(0,%SEE_LOG_FILE, DiagFile)

' connect to the SMTP server
PRINT
PRINT "Connecting to ";SMTP_HOST_NAME
Code = seeSmtpConnect(0,SMTP_HOST_NAME, YOUR_EMAIL_ADDR, NullString)
IF Code < 0 THEN
  Call ShowError(Code)
  EXIT Function
END IF
Code = seeDebug(0,%SEE_GET_SERVER_IP, Buffer, 30)
PRINT "Connected to " + Buffer

' send email message
PRINT "Opening " + EmailList
' wait up to 60 seconds for server response
Code = seeIntegerParam(0,%SEE_MAX_RESPONSE_WAIT, 60000&)

Open EmailList For Input As 1
PRINT "Sending email..."
Do Until EOF(1)
  Line Input #1, X
  If Len(X) > 2 Then
    If (InStr(X, "<") = 0) And (InStr(X, ">") = 0) Then
      ' sorround with brackets
      X = "<" + X + ">"
    End If
    PRINT X
    ' send email
    Code = seeSendEmail(0,X, NullString, NullString, EmailSubj, EmailFile, NullString)
    If Code < 0 Then
      ' error sending email
      Call ShowError(Code)
      ' try to reconnect
      PRINT "Re-connecting to ";SMTP_HOST_NAME
      Code = seeSmtpConnect(0,SMTP_HOST_NAME, YOUR_EMAIL_ADDR, NullString)
      IF Code < 0 THEN
        Call ShowError(Code)
        Code = seeClose(0)
        Code = seeRelease()
        EXIT Function
      End If
    End If
  End If
Loop
Close 1
PRINT "All email sent."
Code = seeClose(0)
Code = seeRelease()
Exit Function

ErrorHandler:

Select Case Err
  Case 53: Print "ERROR 53: File " & EmailList & " doesn't exist."
  Case 76: Print "ERROR 76: Path " & EmailList & " doesn't exist."
  Case Else: Print "ERROR " & Str$(Err) & " occurred."
End Select
Exit Function
END FUNCTION

