'
' DELETE.BAS
'
' Edit EMAIL.INC before compiling.
' Compile & link: PBCC DELETE.BAS
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"

GLOBAL ArgVal() As String
$INCLUDE "GETARGS.PBI"

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
PRINT Buffer
End Sub

FUNCTION PbMain() AS LONG
$INCLUDE "EMAIL.INC"
Dim N As Integer
Dim NbrMsg As Long
Dim MsgNbr As Long
Dim FirstMsg As Long
Dim LastMsg As Long
Dim Code As Long
Dim ArgVal(10) As String
Dim Buffer As Asciiz * 30
Dim NullString As Asciiz * 2
Dim Version As Integer
Dim DiagFile As Asciiz * 64
Dim A As String
Dim B As String
Dim C As String

Dim Quote As String

PRINT "DELETE 04/02/99"

NullString = Chr$(0)
Quote = Chr$(&H22)

' get args
N = GetArgs()

IF (N <> 1) AND (N <> 2) THEN
  PRINT "Usage: DELETE first_msg_nbr {last_msg_nbr}"
  PRINT "   eg: DELETE 1 3"
  Exit Function
END IF

' gets ASCIIZ version of argument strings
FirstMsg = VAL(ArgVal(1))
IF N = 2 THEN
  LastMsg = VAL(ArgVal(2))
ELSE
  LastMsg = FirstMsg
END IF

' check message number range
IF FirstMsg < 1 THEN
  PRINT "ERROR: First msg # must be 1 or higher"
  Exit Function
END IF
IF LastMsg < FirstMsg THEN
  PRINT "ERROR: First msg # must be <= last msg #"
  Exit Function
END IF

' attach SEE
Code = seeAttach(1,%SEE_KEY_CODE)
If Code < 0 Then
  PRINT "Cannot attach SEE. Check SEE_KEY_CODE"
  Exit Function
End If
' display SEE version
Version = seeStatistics(0,%SEE_GET_VERSION)
C = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
B = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
A = LTRIM$(Str$(&H0F AND Version))
PRINT "SEE Version " + A + "." + B + "." + C

' define diagnostics log file
DiagFile = "DELETE.LOG"
Code = seeStringParam(0,%SEE_LOG_FILE, DiagFile)

' connect to the POP3 server
PRINT "Connecting to ";POP3_HOST_NAME
Code = seePop3Connect(0,POP3_HOST_NAME, POP3_USER_NAME, POP3_PASSWORD)
IF Code < 0 THEN
  Call ShowError(Code)
  Code = seeClose(0)
  Code = seeRelease()
  EXIT Function
END IF
Code = seeDebug(0,%SEE_GET_SERVER_IP, Buffer, 30)
PRINT "Connected to " + Buffer

' get # messages waiting
PRINT "Getting message status."
NbrMsg = seeGetEmailCount(0)
IF NbrMsg < 0 THEN
  Call ShowError(NbrMsg)
  Code = seeClose(0)
  Code = seeRelease()
  EXIT Function
END IF
PRINT NbrMsg;" messages waiting."

' any email on the server ?
If NbrMsg = 0 Then
  PRINT "You no email waiting on the server."
  Code = seeClose(0)
  Code = seeRelease()
  Exit Function
End If

' verify message number range
IF LastMsg > NbrMsg THEN
  PRINT "ERROR: Message number ";Str$(LastMsg);" does not exist"
  Code = seeClose(0)
  Code = seeRelease()
  Exit Function
END IF

' delete the email in reverse order
For MsgNbr = LastMsg To FirstMsg Step -1
  PRINT "deleting message # ";MsgNbr
  Code = seeDeleteEmail(0,MsgNbr)
Next MsgNbr

Code = seeClose(0)
Code = seeRelease()
END FUNCTION
