'
' GETARGS.BPI
'
' Returns an array of substrings from the command line
' in array ArgVal(), which should be dimensioned in
' the calling program.
'
' Including program (PbMain) must have statement
' "GLOBAL ArgVal() As String"
'

%READY_FOR_STRING = 1
%QUOTED_STRING_BEGUN = 2
%NON_QUOTED_STRING_BEGUN = 3

Function GetArgs() As Integer
Dim ArgVal(10) As String
Dim I As Integer
Dim N As Integer
Dim Cnt As Integer
Dim R As String
Dim L As String
Dim QuoteChar As String
Dim State As Integer
QuoteChar = Chr$(&H22)
State = %READY_FOR_STRING
R = RTRIM$(COMMAND$)
Cnt = 0
While R <> ""
  L = LEFT$(R,1)
  R = RIGHT$(R, LEN(R) - 1)
  '''print "[";L;"|";R;"]"
  Select Case State
    Case %READY_FOR_STRING
      ' ready to start a new string
      Select Case L
        Case " "
          ' nothing to do
        Case QuoteChar
          ' start quoted string
          State = %QUOTED_STRING_BEGUN
          Cnt = Cnt + 1
          ArgVal(Cnt) = ""
        Case Else
          ' start non-quoted string
          Cnt = Cnt + 1
          ArgVal(Cnt) = L
          State = %NON_QUOTED_STRING_BEGUN
      End Select
    Case %QUOTED_STRING_BEGUN
      ' quoted string is under construction
      Select Case L
        Case " "
          ' append the blank
          ArgVal(Cnt) = ArgVal(Cnt) + L
        Case QuoteChar
          ' terminate the quoted string
          State = %READY_FOR_STRING
        Case Else
          ' append character
          ArgVal(Cnt) = ArgVal(Cnt) + L
      End Select
    Case %NON_QUOTED_STRING_BEGUN
      ' non-quoted string is under construction
      Select Case L
        Case " "
          ' terminate the non-quoted string
          State = %READY_FOR_STRING
        Case QuoteChar
          ' terimate quoted string & start new quoted string
          Cnt = Cnt + 1
          ArgVal(Cnt) = ""
          State = %QUOTED_STRING_BEGUN
        Case Else
          ' append character
          ArgVal(Cnt) = ArgVal(Cnt) + L
      End Select
    Case Else
  End Select
Wend
GetArgs = Cnt
End Function
