'
' GETRAW.BAS
'
' Compile & link: PBCC GETRAW.BAS
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"

GLOBAL ArgVal() As String
$INCLUDE "GETARGS.PBI"

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
PRINT Buffer
End Sub

%BUFFER_SIZE = 65500

FUNCTION PbMain() AS LONG
$INCLUDE "EMAIL.INC"
Dim Code As Long
Dim N As Integer
Dim MsgSize As Long
Dim BytesRead As Long
Dim MsgNumber As Long
Dim Buffer As Asciiz * %BUFFER_SIZE
Dim Pop3Server As Asciiz * 64
Dim Pop3User As Asciiz * 64
Dim Pop3Pass As Asciiz * 64
Dim FileName As String

PRINT "GETRAW 1/20/2000"

FileName = "FILE.RAW"
' get command line arguments
N = GetArgs()
If N <> 4 Then
  PRINT "USAGE: GETRAW Server User Password MsgNbr "
  Exit Function
End If
' gets ASCIIZ version of argument strings
Pop3Server = ArgVal(1)
Pop3User = ArgVal(2)
Pop3Pass = ArgVal(3)
MsgNumber = VAL(ArgVal(4))
PRINT "Server : " & Pop3Server
PRINT "  User : " & Pop3User
PRINT "  Pass : " & Pop3Pass
PRINT "MsgNbr : " & Str$(MsgNumber)
PRINT "  File : " & FileName
PRINT
' attach SEE
Code = seeAttach(1, %SEE_KEY_CODE)
If Code < 0 Then
  PRINT "Cannot attach SEE. Check SEE_KEY_CODE"
  Exit Function
End If
' connect to POP3 Pop3Server
Print "Connecting to " & Pop3Server
Code = seePop3Connect(0, Pop3Server, Pop3User, Pop3Pass)
If Code < 0 Then
  'error attempting to connect
  Call ShowError(Code)
  Code = seeClose(0)
  Exit Function
End If
' read raw message
MsgSize = seeGetEmailSize(0, MsgNumber)
Print "Message " & Str$(MsgNumber) & " size is " & Str$(MsgSize)
If MsgSize <= 0 Then
   Print "No such message"
Else
   If MsgSize >= %BUFFER_SIZE Then
     Print "Message is too big"
   Else
     ' room for BUFFER_SIZE bytes
     Print "Wait while file is being downloaded..."
     BytesRead = seeGetEmailLines(0, MsgNumber, 2000, Buffer, %BUFFER_SIZE)
     Print "OK"
     Print Str$(BytesRead) & " bytes read."
     ' write to disk
     Open "FILE.RAW" For Output As 1
     Print #1, Left$(Buffer, BytesRead)
     Close 1
   End If
End If
' all done
Code = seeClose(0)
Code = seeRelease()
END FUNCTION

