'
' READER.BAS
'
' Edit EMAIL.INC before compiling.
' Compile & link: PBCC READER.BAS
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"

GLOBAL ArgVal() As String
$INCLUDE "GETARGS.PBI"

Sub MyPrint(S As Asciiz)
Dim I As Integer
Dim C As String
Dim X As String
X = ""
For I = 1 To 128
  C = MID$(S,I,1)
  IF ASC(C) >= ASC(" ") THEN
    X = X + C
  ELSE
    PRINT X
    Exit Sub
  END If
Next I
End Sub

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
MyPrint(Buffer)
End Sub

FUNCTION PbMain() AS LONG
$INCLUDE "EMAIL.INC"
Dim I As Integer
Dim N As Integer
Dim NbrMsg As Long
Dim MsgNbr As Long
Dim BytesRead As Long
Dim LastRead As Long
Dim Code As Long
Dim ArgVal(10) As String
Dim Buffer As Asciiz * 1024
Dim NullString As Asciiz * 2
Dim Version As Integer
Dim DiagFile As Asciiz * 64
Dim A As String
Dim B As String
Dim C As String
Dim FileName As Asciiz * 64
Dim EmailDir As Asciiz * 64
Dim AttachDir As Asciiz * 64

PRINT "READER 1/20/2000"

NullString = Chr$(0)

' get command line arguments
N = GetArgs()

IF N <> 2 THEN
  PRINT "Usage: READER message_number message_filename"
  PRINT "   eg: READER 1 message.txt";
  Exit Function
END IF

' gets ASCIIZ version of argument strings
MsgNbr = VAL(ArgVal(1))
Filename = ArgVal(2)
EmailDir = "."
AttachDir = "."

' attach SEE
Code = seeAttach(1, %SEE_KEY_CODE)
If Code < 0 Then
  PRINT "Cannot attach SEE. Check SEE_KEY_CODE"
  Exit Function
End If
' display SEE version
Version = seeStatistics(0,%SEE_GET_VERSION)
C = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
B = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
A = LTRIM$(Str$(&H0F AND Version))
PRINT "SEE Version " + A + "." + B + "." + C
' define diagnostics log file
DiagFile = "READER.LOG"
Code = seeStringParam(0,%SEE_LOG_FILE, DiagFile)

' connect to the POP3 server
PRINT "Connecting to ";POP3_HOST_NAME
Code = seePop3Connect(0,POP3_HOST_NAME, POP3_USER_NAME, POP3_PASSWORD)
IF Code < 0 THEN
  Call ShowError(Code)
  Code = seeClose(0)
  Code = seeRelease()
  EXIT Function
END IF
Code = seeDebug(0,%SEE_GET_SERVER_IP, Buffer, 30)
PRINT "Connected to " + Buffer

' get # messages waiting
PRINT "Getting message status."
NbrMsg = seeGetEmailCount(0)
IF NbrMsg < 0 THEN
  Call ShowError(NbrMsg)
  Code = seeClose(0)
  Code = seeRelease()
  EXIT Function
END IF
PRINT NbrMsg;" messages waiting."
' any email on the server ?
If NbrMsg = 0 Then
  PRINT "You no email waiting on the server."
  Code = seeClose(0)
  Code = seeRelease()
  Exit Function
End If
' does the server have this message # ?
If (MsgNbr=0) OR (MsgNbr>NbrMsg) Then
  PRINT "There is no message # ";MsgNbr
  Code = seeClose(0)
  Code = seeRelease()
  Exit Function
End If

' disable AUTO CALL [see Users Manual SEE4VB_U.TXT]
Code = seeIntegerParam(0,%SEE_AUTO_CALL_DRIVER, 0&)
' prefix "1-", "2-", etc. to attachment filenames
Code = seeIntegerParam(0,%SEE_FILE_PREFIX, 1)

' setup to read message MsgNbr
Code = seeGetEmailFile(0,MsgNbr, FileName, EmailDir, AttachDir)
PRINT "Reading message # ";MsgNbr;" to file ";FileName
' read email using seeDriver
LastRead = 0
Do
  ' execute next state
  Code = seeDriver(0)
  If Code = 0 Then
    ' driver is done
    Exit Do
  End If
  If Code < 0 Then
    'driver returned error
    Call ShowError(Code)
    Exit Do
  End If
  ' driver not yet done, so report progress.
  BytesRead = seeStatistics(0,%SEE_GET_TOTAL_BYTES_READ)
  Locate CursorY, 1
  If BytesRead <> LastRead Then
    PRINT Str$(BytesRead) + " bytes read.";
    LastRead = BytesRead
  End if
Loop
PRINT
' re-enable AUTO CALL
Code = seeIntegerParam(0,%SEE_AUTO_CALL_DRIVER, 1&)
' tell user we are done
PRINT "Email has been read with ";
PRINT Str$(seeStatistics(0,%SEE_GET_ATTACH_COUNT));" attachment(s)."
' get list of attachment file names
Code = seeDebug(0, %SEE_GET_ATTACH_NAMES, Buffer, 1024)
If Code > 0 Then
  PRINT "Attachment names are:"
  MyPrint(Buffer)
End If
Code = seeClose(0)
Code = seeRelease()
END FUNCTION
