'
' STATUS.BAS
'
' Edit EMAIL.INC before compiling.
' Compile & link: PBCC STAT.BAS
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"

Sub MyPrint(S As Asciiz)
Dim I As Integer
Dim C As String
Dim X As String
X = ""
For I = 1 To 128
  C = MID$(S,I,1)
  IF ASC(C) >= ASC(" ") THEN
    X = X + C
  ELSE
    PRINT X
    Exit Sub
  END If
Next I
End Sub

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
MyPrint(Buffer)
End Sub

FUNCTION PbMain() AS LONG
$INCLUDE "EMAIL.INC"
Dim I As Long
Dim N As Integer
Dim Code As Long
Dim NbrMsg As Long
Dim Buffer As Asciiz * 1024
Dim Temp As Asciiz * 128
Dim Version As Integer
Dim DiagFile As Asciiz * 64
Dim A As String
Dim B As String
Dim C As String

PRINT "STATUS 01/20/2000"

' attach SEE
Code = seeAttach(1, %SEE_KEY_CODE)
If Code < 0 Then
  PRINT "Cannot attach SEE. Check SEE_KEY_CODE"
  Exit Function
End If
' display SEE version
Version = seeStatistics(0,%SEE_GET_VERSION)
C = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
B = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
A = LTRIM$(Str$(&H0F AND Version))
PRINT "SEE Version " + A + "." + B + "." + C

' define diagnostics log file
DiagFile = "status.log"
Code = seeStringParam(0,%SEE_LOG_FILE, DiagFile)
' connect to POP3 server [see EMAIL.INC]
PRINT "Connecting to ";POP3_HOST_NAME
Code = seePop3Connect(0,POP3_HOST_NAME,POP3_USER_NAME,POP3_PASSWORD)
IF Code < 0 THEN
  Call ShowError(Code)
  Code = seeClose(0)
  Code = seeRelease()
  EXIT Function
END IF
Code = seeDebug(0,%SEE_GET_SERVER_IP, Buffer, 30)
PRINT "Connected to " + Buffer
' get # messages waiting
PRINT "Getting message count..."
NbrMsg = seeGetEmailCount(0)
If NbrMsg < 0 Then
  Call ShowError(NbrMsg)
  Code = seeClose(0)
  Code = seeRelease()
  Exit Function
End If
If NbrMsg = 0 Then
  PRINT "You have no email on the server."
Else
  PRINT Str$(NbrMsg) & " messages waiting."
  ' read message headers
  For I = 1 To NbrMsg
    ' read message I
    PRINT "---[ Message " + Str$(I) + " ]------------------------------------"
    Code = seeGetEmailLines(0,I, 0&, Buffer, 1024&)
    If Code > 0 Then
      ' display "DATE: " line
      N = seeExtractText(Buffer, "Date: ", Temp, 255)
      If N > 0 Then
        MyPrint(Temp)
      End If
      ' display "FROM: " line
      N = seeExtractText(Buffer, "From: ", Temp, 255)
      If N > 0 Then
        MyPrint(Temp)
      End If
      ' display "SUBJECT: " line
      N = seeExtractText(Buffer, "Subject: ", Temp, 255)
      If N > 0 Then
        MyPrint(Temp)
      End If
      ' display "STATUS: " line
      N = seeExtractText(Buffer, "Status: ", Temp, 255)
      If N > 0 Then
        MyPrint(Temp)
      End If
    End If
  Next I
End If
PRINT "------------------------------------------------"
PRINT "Done."

Code = seeClose(0)
Code = seeRelease()
END FUNCTION

