'
' TSTAT.BAS
'
' Compile & link: PBCC TSTAT.BAS -ID:\PBCC10\WINAPI
'   where the include specification reference is where WINAPI.INC
'   is located on your system.
'
' No printing is done in the thread function since otherwise the
' the output among all threads is intermixed.
'
' Test accounts are hard-coded at line 77.
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"
$INCLUDE "WIN32API.INC"

%NBR_THREADS = 2
Global ThreadID() As Long
Global HostName() As Asciiz * 32
Global UserName() As Asciiz * 32
Global UserPass() As Asciiz * 32
Global Messages() As Long

FUNCTION MyThread(ByVal Index As Long) As Long
Dim Code As Long
Dim Chan As Long
Dim DiagFile As Asciiz * 64
Dim ThreadID(2) As Long
Dim HostName(2) As Asciiz * 32
Dim UserName(2) As Asciiz * 32
Dim UserPass(2) As Asciiz * 32
Dim Messages(2) As Long
' channels are numbered from 0 (REMEMBER THIS!)
Chan = Index - 1
Messages(Index) = 0
' connect to POP3 server
Code = seePop3Connect(Chan,HostName(Index),UserName(Index),UserPass(Index))
IF Code < 0 THEN
  Call ShowError(Code)
  EXIT Function
END IF
Code = SleepEx(0, 0)
' get # messages waiting
Code = seeGetEmailCount(Chan)
IF Code < 0 THEN
  Call ShowError(Code)
ELSE
  ' save message count
  Messages(Index) = Code
END IF
Code = seeClose(Chan)
END FUNCTION

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
PRINT Buffer
End Sub

FUNCTION PbMain() AS LONG
Dim I As Integer
Dim Code As Long
Dim Result As Long
Dim Running As Long
Dim ThreadID(2) As Long
Dim HostName(2) As Asciiz * 32
Dim UserName(2) As Asciiz * 32
Dim UserPass(2) As Asciiz * 32
Dim Messages(2) As Long

PRINT "TSTAT 04/02/99"

' attach SEE
Code = seeAttach(%NBR_THREADS, %SEE_KEY_CODE)

'hard code test accounts to check
HostName(1) = "10.0.0.1"
UserName(1) = "mike"
UserPass(1) = "mike"
HostName(2) = "10.0.0.1"
UserName(2) = "pam"
UserPass(2) = "pam"

' start all threads
FOR I = 1 TO %NBR_THREADS
  THREAD CREATE MyThread(I) to ThreadID(I)
NEXT I

PRINT "All threads started"
Code = SleepEx(100, 0)
' run till all threads are done
DO
  Running = 0
  FOR I = 1 TO %NBR_THREADS
    THREAD STATUS ThreadID(I) TO Result
    ' is this thread running ?
    IF Result <> 0 THEN
      Incr Running
    END IF
  NEXT I
  ' all threads terminated ?
  IF Running = 0 THEN
    PRINT "All threads are terminated."
    EXIT LOOP
  END IF
  Code = SleepEx(0, 0)
LOOP
' report results
FOR I = 1 TO %NBR_THREADS
  PRINT Messages(I);" messages waiting for ";UserName(I)
NEXT I
' all done
Code = seeRelease()
END FUNCTION
