'
' VERUSR.BAS
'
' Edit EMAIL.INC before compiling.
' Compile & link: PBCC VERUSR.BAS
'

$INCLUDE "SEE32.PBI"
$INCLUDE "KEYCODE.PBI"

GLOBAL ArgVal() As String
$INCLUDE "GETARGS.PBI"

Sub ShowError(Code As Long)
Dim N As Long
Dim Buffer As Asciiz * 128
N = seeErrorText(0,Code,Buffer,128)
PRINT Buffer
End Sub

FUNCTION PbMain() AS LONG
$INCLUDE "EMAIL.INC"
Dim I As Integer
Dim N As Integer
Dim Code As Long
Dim ArgVal(10) As String
Dim NullString As Asciiz * 2
Dim Buffer As Asciiz * 128
Dim Version As Integer
Dim DiagFile As Asciiz * 64
Dim A As String
Dim B As String
Dim C As String
Dim User As Asciiz * 64
Dim Domain As Asciiz * 64

Dim Quote As String

PRINT "VERUSR 04/02/99"

NullString = Chr$(0)
Quote = Chr$(&H22)

' get command line arguments
N = GetArgs()

IF N <> 1 THEN
  PRINT "Usage: VERUSR user@domain"
  PRINT "   eg: VERUSE msc@traveller.com"
  Exit Function
END IF

' get ASCIIZ version of argument strings
A = ArgVal(1)

' remove brackets, if any
I = InStr(A,"<")
IF I > 0 THEN
  A = RIGHT$(A,LEN(A)-I)
END IF
I = InStr(A,">")
IF I > 0 THEN
  A = LEFT$(A,I-1)
END IF

' look for @
I = InStr(A,"@")
IF I > 0 THEN
  User = LEFT$(A,I-1)
  Domain = RIGHT$(A,LEN(A)-I)
ELSE
  PRINT "Missing @ in ";A
  EXIT Function
END IF

' attach SEE
Code = seeAttach(1, %SEE_KEY_CODE)
If Code < 0 Then
  PRINT "Cannot attach SEE. Check SEE_KEY_CODE"
  Exit Function
End If
' display SEE version
Version = seeStatistics(0,%SEE_GET_VERSION)
C = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
B = LTRIM$(Str$(&H0F AND Version))
SHIFT RIGHT Version, 4
A = LTRIM$(Str$(&H0F AND Version))
PRINT "SEE Version " + A + "." + B + "." + C

' define diagnostics log file
DiagFile = "verusr.log"
Code = seeStringParam(0,%SEE_LOG_FILE, DiagFile)

' connect to the remote SMTP server
PRINT "Connecting to ";Domain
Code = seeSmtpConnect(0,Domain, YOUR_EMAIL_ADDR, NullString)
IF Code < 0 THEN
  Call ShowError(Code)
  Code = seeClose(0)
  Code = seeRelease()
  EXIT Function
END IF
Code = seeDebug(0,%SEE_GET_SERVER_IP, Buffer, 30)
PRINT "Connected to " + Buffer

' verify user
PRINT User;"@";Domain;" is ";
IF seeVerifyUser(0,User) = 0 THEN
  Code = seeDebug(0,%SEE_GET_LAST_RESPONSE, Buffer, 128)
  PRINT "NOT verified (";LEFT$(Buffer,Code);")"
ELSE
  PRINT "verified."
END IF
Code = seeClose(0)
Code = seeRelease()
END FUNCTION
