// MCell ModulusMT8 DLL by Alastair Couper
//

library ModulusMT8; // This rule sets the new state of each cell to the
                    // modulus sum, base 9 of its immediate 8 neighbors
                    // plus itself. The possible states are thus 0-8.

uses
  SysUtils,
  Classes;

//
// Calculate the new state of the 'Me' cell.
function CARule(Generation,col,row,
                NW,N, NE,
                W, Me,E,
                SW,S, SE: Integer): Integer; stdcall;

begin
  CARule := (NW + N + NE + W + Me + E + SW + S + SE) mod 9; // totalistic rule
end;
//
// Setup the rule.
// The function is called immediately after this rule is selected in MCell.
procedure CASetup(var RuleType, CountOfColors: Integer; ColorPalette, Misc: PChar); stdcall;
begin
  RuleType := 2;       // 1 - 1D, 2 - 2D
  CountOfColors := 9;  // count of states, 0..n-1
  StrCopy(ColorPalette, 'Low Color');  // optional color palette specification
  StrCopy(Misc, '');   // optional extra parameters; none supported yet
end;

exports
  CARule  index 1,
  CASetup index 2;

begin
  // optional internal initialization.
end.

