// "Triad" Cellular Automaton rule by Lionel Bonnetier, Summer 1996
// Adapted to MCell by Mirek Wojtowicz, June 1999
//
// The rule logic
// ==============
// There exist 5 alive states:
//   Primary (1) and Secondary (2) Red,
//   Primary (3) and Secondary (4) Blue,
//   and a yellow (5) Clash.
//
// Primary evolves to opposite primary if exactly one neighbor is Clash.
// Else primary evolves to secondary.
// Every secondary dies.
// Every clash dies.
// Two primaries of one kind give birth to a primary of their kind
//   provided there is no more than one primary of the opposite kind.
// Opposite primaries in the same quantities give birth to a Clash.
//

library Triad;

uses
  SysUtils, Classes;

//
// Calculate the new state of the 'Me' cell.
function CARule(Generation,col,row,
                NW,N, NE,
                W, Me,E,
                SW,S, SE: Integer): Integer; stdcall;
var
  sttAry: array [0..5] of Integer; // totals of neighbours in 0..5 states
  bNewVal: Integer;
  i: Integer;
begin
  bNewVal := 0; // default value

  for i := 0 to 5 do
    sttAry[i] := 0;

  // calculate totals of neighbours in each state
  Inc(sttAry[NW mod 6]);
  Inc(sttAry[N  mod 6]);
  Inc(sttAry[NE mod 6]);
  Inc(sttAry[W  mod 6]);
  Inc(sttAry[E  mod 6]);
  Inc(sttAry[SW mod 6]);
  Inc(sttAry[S  mod 6]);
  Inc(sttAry[SE mod 6]);

  case Me of // test the current state
    0:
       begin
         if (sttAry[1] > 0) and (sttAry[1] = sttAry[3]) then
           bNewVal := 5 // Clash!
         else
         begin
           if (sttAry[1] = 2) and (sttAry[3] < 2) then
             bNewVal := 1; // new Red
           if (sttAry[3] = 2) and (sttAry[1] < 2) then
             bNewVal := 3; // new Blue
         end;
       end;
    1:
       begin
         if (sttAry[5] = 1) then // one Clash - change to the opposite color
           bNewVal := 3  // turn Blue
         else
           bNewVal := 2; // get older
       end;
    3:
       begin
         if (sttAry[5] = 1) then // one Clash - change to the opposite color
           bNewVal := 1  // turn Red
         else
           bNewVal := 4; // get older
       end;
    2, 4, 5:
       bNewVal := 0; // Sorry.
  end;
  CARule := bNewVal;
end;
//
// Setup the rule.
// The function is called immediatelly after this rule is selected.
procedure CASetup(var RuleType, CountOfColors: Integer; ColorPalette, Misc: PChar); stdcall;
begin
  RuleType := 2;      // 1 - 1D, 2 - 2D
  CountOfColors := 6; // 6 states, 0..5
  StrCopy(ColorPalette, '2_2_1');  // load this color palette
  StrCopy(Misc, '');  // no extra parameters
end;

exports
  CARule  index 1,
  CASetup index 2;

begin
  // No internal initialization.
end.
