// Rudy Rucker's Venus rule
//

library Venus;  // Your DLL name, change by "Save Project as..." option of the File menu

uses
  SysUtils, Classes;

//
// Calculate the new state of the 'Me' cell.
function CARule(Generation,col,row,
                NW,N, NE,
                W, Me,E,
                SW,S, SE: Integer): Integer; stdcall;
var
  oldState: Integer;
  newState: Integer;
begin
  newState := 0;

  // only bit 1 is significant
  NW := NW and 1;
  N  := N  and 1;
  NE := NE and 1;
  W  := W  and 1;
  E  := E  and 1;
  SW := SW and 1;
  S  := S  and 1;
  SE := SE and 1;

  oldState := Me and 3;
  case oldState of
    0: newState := 2*(NW xor SW) + W;
    1: newState := 2*(NW xor NE) + N;
    2: newState := 2*(NE xor SE) + E;
    3: newState := 2*(SE xor SW) + S;
  end;
  CARule := newState;
end;
//
// Setup the rule.
// The function is called immediatelly after this rule is selected in MCell.
procedure CASetup(var RuleType, CountOfColors: Integer; ColorPalette, Misc: PChar); stdcall;
begin
  RuleType := 2;       // 1 - 1D, 2 - 2D
  CountOfColors := 4;  // count of states, 0..3
  StrCopy(ColorPalette, '3 colors');  // optional color palette specification
  StrCopy(Misc, '');   // no extra parameters
end;

exports
  CARule  index 1,
  CASetup index 2;

begin
  // optional internal initialization.
end.
