#define APPNAME "Minimized Windows Viewer"
#include <windows.h>

#define CM_TOGGLEVIS   0x7FF0
#define CM_CLOSE       0x7FFF
#define VS_VISIBLE     0
#define VS_HIDDEN      1
#define VS_ALL         2

#define CLASSNAME      "MINWINS_AEXP0!@#$%^&*("
#define APPICON        "APPICON"

static int  windowsCount = 0;
static HWND windows[ 10240];
static viewState = VS_VISIBLE;
static char misc[ 256];


BOOL CALLBACK ewp( HWND hwnd, HMENU m)
{
   char buf[ 256];
   BOOL visible = IsWindowVisible( hwnd);
   switch ( viewState) {
   case VS_VISIBLE:
      if ( !visible) return TRUE;
      break;
   case VS_HIDDEN:
      if ( visible) return TRUE;
      break;
   }
   if ( !GetWindowText( hwnd, buf, 255))
      return TRUE;
   windows[ windowsCount] = hwnd;
   AppendMenu( m, MF_STRING | (( visible && ( viewState == VS_ALL)) ? MF_CHECKED : 0), windowsCount, buf);
   return windowsCount++ < 10240;
}

static void
menus( HWND hWnd, BOOL doEnum)
{
   HMENU m;
   POINT lp;
   m = CreatePopupMenu();

   if ( doEnum) {
       windowsCount = 0;
       EnumWindows( ewp, ( LPARAM) m);
       AppendMenu( m, MF_SEPARATOR, 0, NULL);
   }
   AppendMenu( m, MF_STRING | ( viewState == VS_VISIBLE ? MF_CHECKED : 0), CM_TOGGLEVIS + VS_VISIBLE, "View &visible");
   AppendMenu( m, MF_STRING | ( viewState == VS_HIDDEN  ? MF_CHECKED : 0), CM_TOGGLEVIS + VS_HIDDEN , "View &hidden");
   AppendMenu( m, MF_STRING | ( viewState == VS_ALL     ? MF_CHECKED : 0), CM_TOGGLEVIS + VS_ALL    , "View &all");
   AppendMenu( m, MF_STRING, CM_CLOSE,     "&Close");
   GetCursorPos( &lp);
   SetForegroundWindow( hWnd);
   TrackPopupMenu( m, TPM_LEFTBUTTON|TPM_LEFTALIGN|TPM_RIGHTBUTTON, lp.x, lp.y, 0, hWnd, NULL);
   PostMessage( hWnd, WM_USER, 0, 0);
}


#define WM_NOTIFYICON (WM_USER+100)

static HWND      frame;


LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
   LRESULT     ret = 0;
   switch ( message) {
   case WM_DESTROY:
      PostQuitMessage(0);
      break;
   case WM_COMMAND:
      switch( wParam) {
      case CM_CLOSE:
         PostQuitMessage(0);
         break;
      case CM_TOGGLEVIS + VS_VISIBLE:
      case CM_TOGGLEVIS + VS_HIDDEN:
      case CM_TOGGLEVIS + VS_ALL:
         viewState = wParam - CM_TOGGLEVIS;
         break;
      default:
         if (( wParam >= 0) && ((int) wParam < windowsCount) && IsWindow( windows[ wParam]))
            SetWindowPos( windows[ wParam], 0, 0, 0, 0, 0,
                SWP_NOSIZE|SWP_NOMOVE|SWP_NOZORDER|
                ( IsWindowVisible(windows[ wParam]) ? ( SWP_HIDEWINDOW|SWP_NOACTIVATE) : SWP_SHOWWINDOW)
            );
      }
      return 0;
   case WM_NOTIFYICON:
      switch( lParam) {
      case WM_LBUTTONDOWN:
         menus( hWnd, 1);
         break;
      case WM_RBUTTONDOWN:
         menus( hWnd, 0);
         break;
      }
      return 0;
   }
   ret = DefWindowProc(hWnd, message, wParam, lParam);
   return ret;
}



int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
   if ( FindWindow( CLASSNAME, NULL))return TRUE;

   {
       WNDCLASS  wc;

       memset( &wc, 0, sizeof( wc));
       wc.style         = CS_HREDRAW | CS_VREDRAW | CS_DBLCLKS;
       wc.lpfnWndProc   = (WNDPROC)WndProc;
       wc.cbClsExtra    = 0;
       wc.cbWndExtra    = 0;
       wc.hInstance     = hInstance;
       wc.hIcon         = LoadIcon( hInstance, APPICON);
       wc.hCursor       = LoadCursor(NULL, IDC_ARROW);
       wc.hbrBackground = (HBRUSH)(COLOR_WINDOW+1);
       wc.lpszClassName = CLASSNAME;
       wc.lpszMenuName  = NULL;
       RegisterClass( &wc);

       frame = CreateWindow( CLASSNAME, "Hidden Window Manager by Dmitry Karasik, dk@plab.ku.dk",
            WS_SYSMENU | WS_THICKFRAME| WS_MINIMIZEBOX | WS_MAXIMIZEBOX,
            100, 100, 0, 0, NULL, NULL, hInstance, NULL);
   }

   {
      NOTIFYICONDATA pnid = {
         sizeof( NOTIFYICONDATA),
         frame,
         0,
         NIF_ICON|NIF_MESSAGE|NIF_TIP,
         WM_NOTIFYICON,
         LoadIcon( hInstance, APPICON),
         "Hidden Window Manager"
      };
      Shell_NotifyIcon( NIM_ADD, &pnid);
      if ( pnid. hIcon) DestroyIcon( pnid. hIcon);
   }

   {
      MSG msg;
      while ( GetMessage(&msg, NULL, 0, 0)) {
         TranslateMessage(&msg);
         DispatchMessage(&msg);
      }
   }

   {
      NOTIFYICONDATA pnid = {
         sizeof( NOTIFYICONDATA),
         frame,
         0
      };
      Shell_NotifyIcon( NIM_DELETE, &pnid);
   }

   DestroyWindow( frame);
   frame = NULL;
   return TRUE;
}


