Attribute VB_Name = "Module1"
Option Explicit

Public Declare Function GetVersion Lib "kernel32" () As Long

Public Declare Function FindWindow Lib "user32" Alias "FindWindowA" (ByVal lpClassName As String, ByVal lpWindowName As String) As Long

Global Const MAXLines = 1   '   the evaluation version of the SVServer application is limited to one line
Global Const MAXEntryErrorCount = 2
Global Const MAXSuccessiveErrors = 5
Global Const KEY_ESCAPE = &H1B

'   Application DDE Status
Global Const READY = 0
Global Const COMMAND = 1
Global Const NOTIFIED = 2
Global Const STATUS_RETURNED = 3
Global Const NOP = 4

'   SVServer Function Status
Global Const STATUS_FUNCTION_NONE = 0
Global Const STATUS_FUNCTION_READY = 1
Global Const STATUS_FUNCTION_RUNNING = 2
Global Const STATUS_FUNCTION_NOTIFIED = 3
Global Const STATUS_FUNCTION_COMPLETE = 4

'   Command Process
Global Const CMD_Open = 0
Global Const CMD_Start = 10
Global Const CMD_Main_Entry = 20
Global Const CMD_User_Records = 30
Global Const CMD_User_Plays = 40
Global Const CMD_User_Dials = 50
Global Const CMD_Error_Message = 80
Global Const CMD_Exit_Message = 99
Global Const CMD_Hang_Up = 100
Global Const CMD_Close = 1000
Global Const CMD_Abort = -1

Global Const DV_TPT_TYPE = 1
Global Const DX_IOTT_TYPE = 2
Global Const DX_CAP_TYPE = 3
Global Const TN_GEN_TYPE = 4

'   Application user save area
Type UserDataType
    SavePhoneNo As String * 32
    SaveFileName As String * 32
    SaveResponse As Integer
    CallAnalysis As Integer
End Type

Type DDELinkType
    LineNo As Integer
    Function As Integer
    Status As Integer
    Error As Integer
    Return As Long
    Result As String * 128
End Type

Type LineDataType
    Process As Integer
    NextStep As Integer
    JumpStep As Integer
    RetryCount As Integer
    TimeOutCount As Integer
    EntryErrorCount As Long
    LineVolumeAdjust As Integer
    LineSpeedAdjust As Integer
    DeviceHandle As Integer
    LineString As String * 16
    SuccessiveErrors As Integer
    AbortProcess As Integer
    ExitProcess As Integer
End Type

Type CFGFileDataType
    CFGAutoStartSampleApp As Integer
    CFGDialogicFilePath As String * 128
    CFGSVServerFilePath As String * 128
    CFGSystemMessages As String * 128
    CFGNumberMessages As String * 128
    CFGMessagesDirectory As String * 128
    CFGDatabaseFilePath As String * 128
    CFGCaptureTextToFile As Integer
    CFGVolumeAdjust As Integer
    CFGSpeedAdjust As Integer
End Type

Global Const ChAddresses = "dxxxB1C1,dxxxB1C2,dxxxB1C3,dxxxB1C4,dxxxB2C1,dxxxB2C2,dxxxB2C3,dxxxB2C4"

Global WS1 As Workspace
Global DB1 As Database
Global RS1 As Recordset

Global StartUpDirPath As String * 128
Global TimeCount2 As Long

Global UserData(MAXLines) As UserDataType

Global LineData(MAXLines) As LineDataType
Global LinkResult(MAXLines) As DDELinkType

Global PassFilePath As String * 128
Global PassFilePattern As String * 16
    
Global CFGFileNo As Integer
Global CFGFileName As String
Global CFGFilePath As String

Global CFGFileData As CFGFileDataType
Global CFGTempData As CFGFileDataType

Global TXTFileNo As Integer
Global TXTFileName As String
Global TXTFilePath As String

Global Const MB_OK = 0                 ' OK button only
Global Const MB_OKCANCEL = 1           ' OK and Cancel buttons
Global Const MB_ABORTRETRYIGNORE = 2   ' Abort, Retry, and Ignore buttons
Global Const MB_YESNOCANCEL = 3        ' Yes, No, and Cancel buttons
Global Const MB_YESNO = 4              ' Yes and No buttons
Global Const MB_RETRYCANCEL = 5        ' Retry and Cancel buttons

Global Const IDYES = 6
Global Const IDNO = 7

Global Const SR_POLLMODE = 0            ' Run SRL in polling mode
Global Const SR_MODEID = &H2            ' Set SRL running in signalling or DOS mode
Global Const SRL_DEVICE = 0             ' The SRL device

'Values for setting hook state
 
Global Const DL_ONHOOK = 0
Global Const DL_OFFHOOK = 1
'Global Const DX_ONHOOK = 0
'Global Const DX_OFFHOOK = 1

'       Define Event Types

Global Const TDX_PLAY = &H81           ' Play Completed
Global Const TDX_RECORD = &H82         ' Record Completed
Global Const TDX_GETDIG = &H83         ' Get Digits Completed
Global Const TDX_DIAL = &H84           ' Dial Completed
Global Const TDX_CALLP = &H85          ' Call Progress Completed
Global Const TDX_CST = &H86            ' CST Event Received
Global Const TDX_SETHOOK = &H87        ' SetHook Completed
Global Const TDX_WINK = &H88           ' Wink Completed
Global Const TDX_PLAYTONE = &H8A       ' Play Tone Completed
Global Const TDX_GETR2MF = &H8B        ' Get R2MF completed

Global Const TDX_ERROR = &H89          ' Error Event
Global Const DX_ATOMIC_ERR = &HEE      ' Error event for Atomic Funcs

'D/4X Events and masks
 
Global Const DE_RINGS = 1        ' Rings received
Global Const DE_SILON = 2        ' Silence on
Global Const DE_SILOF = 3        ' Silenec off
Global Const DE_LCON = 4         ' Loop current on
Global Const DE_LCOF = 5         ' Loop current off
Global Const DE_WINK = 6         ' Wink received
Global Const DE_RNGOFF = 7       ' Ring off event
Global Const DE_DIGITS = 8       ' Digit Received
Global Const DE_DIGOFF = 9       ' Digit tone off event
Global Const DE_LCREV = 13       ' Loop current reversal
Global Const DE_TONEON = 17      ' Tone ON  Event Received
Global Const DE_TONEOFF = 18     ' Tone OFF Event Received
Global Const DE_STOPRINGS = 19   ' Stop ring detect state

Global Const DM_RINGS = 1      ' ( 1 << (DE_RINGS - 1) )
Global Const DM_SILON = 2      ' ( 1 << (DE_SILON - 1) )
Global Const DM_SILOFF = 4     ' ( 1 << (DE_SILOF - 1) )
Global Const DM_LCON = 8       ' ( 1 << (DE_LCON - 1) )
Global Const DM_LCOFF = 16     ' ( 1 << (DE_LCOF - 1) )
Global Const DM_LCREV = 4096   ' ( 1 << (DE_LCREV - 1) )
Global Const DM_WINK = 32      ' ( 1 << (DE_WINK - 1) )
Global Const DM_RNGOFF = 64    ' ( 1 << (DE_RNGOFF - 1) )
Global Const DM_DIGITS = 128   ' ( 1 << (DE_DIGITS - 1) )
Global Const DM_DIGOFF = 256   ' ( 1 << (DE_DIGOFF - 1) )

'CHANNEL PARAMETERS

Global Const PM_BD = &H800000           ' Board Level Parameter
Global Const PM_CH = &H0                ' Channel Level Parameter

Global Const PM_DXXX = &H0              ' D/xxx Parameter
Global Const PM_D12X = &H1000000        ' D/12x Parameter
Global Const PM_MF40 = &H2000000        ' MF/40 Parameter
Global Const PM_D12XDEV = &H4000000

Global Const PM_FW = &H0                ' Firmware Parameter
Global Const PM_DRV = &H8000000         ' Driver Parameter
Global Const PM_LIB = &H10000000        ' Library Parameter

Global Const PRM_DEST = &H18000000
Global Const PRM_DEVTYP = &H7000000
Global Const PRM_DATTYP = &HE0000000
Global Const PRM_NUM = &HFFFF
Global Const PRM_TERM = &H7F0000

Global Const PM_BYTE = &H0              ' Byte
Global Const PM_SHORT = &H20000000      ' Short
Global Const PM_INT = &H40000000        ' Int
Global Const PM_LONG = &H60000000       ' Long
Global Const PM_VLSTR = &H80000000      ' Variable Length String
Global Const PM_FLSTR = &HA0000000      ' Fixed Length String

Global Const PM_VLSTR_MAXLEN = 128 ' Max Length for Variable Length Parms
 
' DTMF anti-talkoff during playback
'Global Const DXCH_DTMFTLK    ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0101L)

' DTMF debounce time
'Global Const DXCH_DTMFDEB    ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0201L)

' DTMF initiation bitmap
'Global Const DXCH_DTINITSET  ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0203L)

' Delay after ring recvd before winking
'Global Const DXCH_WINKDLY    ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0204L)

' Duration of wink (off-hook state)
'Global Const DXCH_WINKLEN    ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0205L)

' Min LC on to be recognized as wink
'Global Const DXCH_MINRWINK   ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0206L)

' Max LC on to be recognized as wink
'Global Const DXCH_MAXRWINK   ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0207L)

' Length of DTMF digit for dialing
'Global Const DXCH_TTDATA     ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0208L)

' Length of TT inter digit delay
'Global Const DXCH_T_IDD      ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0209L)

' MF detection mask
'Global Const DXCH_MFMODE     ((PM_SHORT|PM_FW|PM_MF40|PM_CH) | &H0201L)

' Diagnostic mask
'Global Const DXCH_MFDIAG     ((PM_SHORT|PM_FW|PM_MF40|PM_CH) | &H0202L)

' Per channel dig rate: play (D/xxx only)
'Global Const DXCH_PLAYDRATE  ((PM_SHORT|PM_FW|PM_D12X|PM_CH) | &H0E01L)

' Per channel dig rate: rec (D/xxx only)
'Global Const DXCH_RECRDRATE  ((PM_SHORT|PM_FW|PM_D12X|PM_CH) | &H0E02L)

' DTMF detection edge select
'Global Const DXCH_DFLAGS     ((PM_SHORT|PM_FW|PM_DXXX|PM_CH) | &H0801L)

' Per channel ring count
Global Const DXCH_RINGCNT = ((PM_SHORT Or PM_DRV Or PM_DXXX Or PM_CH) Or &H1)

Function LoadFileData() As Integer

    On Error Resume Next

    '   Load Confiuration File

    Err = 0
    LoadFileData = True
    Open CFGFilePath For Random Access Read Write As CFGFileNo Len = Len(CFGFileData)
    If Err = 0 Then
        If LOF(CFGFileNo) > 0 Then
            Get #CFGFileNo, 1, CFGFileData
            CFGTempData = CFGFileData
        Else
            CFGTempData.CFGAutoStartSampleApp = False
            If GetVersion > 0 Then
                If FileExists("c:\program files\dialogic\bin\ncm.exe") Then
                    CFGTempData.CFGDialogicFilePath = "c:\program files\dialogic\bin\ncm.exe"
                Else
                    CFGTempData.CFGDialogicFilePath = "..\dialogic\bin\ncm.exe"
                End If
            Else
                If FileExists("c:\users\dialogic\bin\startcfg.exe") Then
                    CFGTempData.CFGDialogicFilePath = "c:\users\dialogic\bin\startcfg.exe"
                Else
                    CFGTempData.CFGDialogicFilePath = "..\users\dialogic\bin\startcfg.exe"
                End If
            End If
            CFGTempData.CFGSVServerFilePath = LCase$(Trim$(StartUpDirPath) & "\svserver.exe")
            CFGTempData.CFGSystemMessages = LCase$(Trim$(StartUpDirPath) & "\svsample\systemsg")
            CFGTempData.CFGNumberMessages = LCase$(Trim$(StartUpDirPath) & "\svsample\numbers")
            CFGTempData.CFGMessagesDirectory = LCase$(Trim$(StartUpDirPath) & "\svsample\messages")
            CFGTempData.CFGDatabaseFilePath = LCase$(Trim$(StartUpDirPath) & "\svsample\svserver.mdb")
            CFGTempData.CFGCaptureTextToFile = True
            CFGTempData.CFGVolumeAdjust = 2
            CFGTempData.CFGSpeedAdjust = 2
        End If
        Close CFGFileNo
    Else
        MsgBox "OPEN ERROR " & Str$(Err) & " , CONFIGURATION FILE PATH = " & CFGFilePath
        LoadFileData = False
    End If
End Function


Sub CenterForm(TheForm As Form)

    On Error Resume Next

    TheForm.Left = (Screen.Width - TheForm.Width) / 2
    TheForm.Top = (Screen.Height - TheForm.Height) / 2
    
    DoEvents
    
End Sub

Public Sub SaveFileData()

    On Error Resume Next

    Open CFGFilePath For Random Access Write As CFGFileNo Len = Len(CFGFileData)
    CFGFileData = CFGTempData
    Put #CFGFileNo, 1, CFGFileData
    Close CFGFileNo
End Sub

Public Function ShellDialogic(AppFilePath As String) As Integer
    Dim Result
    
    On Error Resume Next
    
    '   Launch maximized with focus
    
    Err = 0
    Result = Shell(AppFilePath, 1)
    ShellDialogic = Err
    
End Function

Public Function ShellSVServer(AppFilePath As String) As Integer
    Dim Result
    
    On Error Resume Next
    
    Err.Clear

    '   For Asynchronous operations:
    '   Result = Shell(Trim$(AppFilePath) & " MaxLines " & Trim$(Str(MAXLines)), 1)
    '   For asynchronous operations with a seperate event thread use
    '   Result = Shell(Trim$(AppFilePath) & " EventThread, MaxLines " & Trim$(Str(MAXLines)), 1)
    
    '   For synchronous operations:
    '   To run as one thread per channel use the term MultiThread
    '   To limit the number of lines use MaxLines nn in the Declaration section
    Result = Shell(Trim$(AppFilePath) & " MultiThread, MaxLines " & Trim$(Str(MAXLines)), 1)
    
    '   For troubleshooting the SVServer application add the following code:
    '   & " Debug=" & Trim$(StartUpDirPath), 1) as below
    '   Result = Shell(Trim$(AppFilePath) & " MultiThread, MaxLines " & Trim$(Str(MAXLines)) & " Debug=" & Trim$(StartUpDirPath), 1)
    
    ShellSVServer = Err.Number
    
End Function

Public Function CopyText() As Integer
    Dim Result As Integer
    Dim EditString As String

    On Error Resume Next

    Result = False

    If TypeOf Screen.ActiveControl Is TextBox Then Result = True
    If TypeOf Screen.ActiveControl Is ComboBox Then
        If Screen.ActiveControl.Style <> 2 Then Result = True
    End If
    If Result = True Then
        EditString = Trim$(Mid$(Screen.ActiveControl.Text, Screen.ActiveControl.SelStart + 1, Screen.ActiveControl.SelLength))
        Clipboard.SetText EditString
    End If
    CopyText = Result

End Function

Public Function CutText() As Integer
    Dim Result As Integer
    Dim EditString As String, String1 As String, String2 As String
    Dim LenEditString As Integer, LenString1 As Integer, LenString2 As Integer

    On Error Resume Next

    Result = CopyText()
    If Result = True Then
        LenEditString = Len(Trim$(Screen.ActiveControl.Text))
        EditString = Trim$(Screen.ActiveControl.Text)

        LenString1 = Screen.ActiveControl.SelStart
        String1 = Trim$(Left$(Screen.ActiveControl.Text, LenString1))
        
        LenString2 = LenEditString - (LenString1 + Screen.ActiveControl.SelLength)
        String2 = Trim$(Right$(EditString, LenString2))

        Screen.ActiveControl.Text = Trim$(String1) & Trim$(String2)
    Else
        Result = False
    End If
    CutText = Result

End Function


Public Sub EditMenuDisable()

    On Error Resume Next

    Screen.ActiveForm.CutItem.Enabled = False
    Screen.ActiveForm.CopyItem.Enabled = False
    
End Sub

Public Sub EditMenuEnable()

    On Error Resume Next

    Screen.ActiveForm.CutItem.Enabled = True
    Screen.ActiveForm.CopyItem.Enabled = True
    Screen.ActiveForm.PasteItem.Enabled = True

End Sub

Public Function PasteText()
    Dim Result As Integer
    Dim EditString As String, String1 As String, String2 As String, String3 As String
    Dim LenEditString As Integer, LenString1 As Integer, LenString2 As Integer, LenString3 As Integer

    On Error Resume Next

    Result = False

    If TypeOf Screen.ActiveControl Is TextBox Then Result = True
    If TypeOf Screen.ActiveControl Is ComboBox Then
        If Screen.ActiveControl.Style <> 2 Then Result = True
    End If
    If Result = True Then
        LenEditString = Len(Trim$(Screen.ActiveControl.Text))
        EditString = Trim$(Screen.ActiveControl.Text)

        LenString1 = Screen.ActiveControl.SelStart
        String1 = Trim$(Left$(Screen.ActiveControl.Text, LenString1))
        
        String2 = Trim$(Clipboard.GetText(1))
        LenString2 = Len(String2)

        LenString3 = LenEditString - (LenString1 + Screen.ActiveControl.SelLength)
        String3 = Trim$(Right$(EditString, LenString3))

        Screen.ActiveControl.Text = Trim$(String1) & Trim$(String2) & Trim$(String3)
    Else
        Result = False
    End If
    PasteText = Result
    
End Function






Public Sub ShellTextFile(TheFilePath As String)
    Dim Result As Variant
    Dim FilePath As String * 128

    On Error Resume Next

    FilePath = Trim$("notepad.exe " & Trim$(TheFilePath))
    Result = Shell(Trim$(FilePath), 1)
    SendKeys "%(EW)", True
    DoEvents
    
End Sub

Public Function ClearLinkStatus(TheLine As Integer)

    On Error Resume Next
    
    LinkResult(TheLine).Function = 0
    LinkResult(TheLine).Status = 0
    LinkResult(TheLine).Error = 0
    LinkResult(TheLine).Return = 0
    LinkResult(TheLine).Result = ""
    LinkResult(TheLine).LineNo = TheLine
        
End Function

Public Function StripNumber(InString As String, OutString As String) As Integer
    Dim Ndx As Integer, Max As Integer, Cnt As Integer

    Cnt = 0:
    Max = Len(Trim$(InString))
    For Ndx = 1 To Max Step 1
        If (StrComp(Mid$(InString, Ndx, 1), "0", 1) >= 0 And StrComp(Mid$(InString, Ndx, 1), "9", 1) <= 0) Then
            Cnt = Cnt + 1
            Mid$(OutString, Cnt, 1) = Mid$(InString, Ndx, 1)
        End If
    Next Ndx
    StripNumber = Cnt

End Function


Public Function FileExists(FilePath As String) As Integer

    If Dir$(FilePath) = "" Then
        FileExists = False
    Else
        FileExists = True
    End If

End Function
Public Sub ShellFunctionSet()
    Dim Result As Variant
    Dim FilePath As String * 128

    On Error Resume Next
    
    FilePath = "write.exe " & Trim$(StartUpDirPath) & "\functset.doc"
    Result = Shell(FilePath, 3)
    DoEvents
    
End Sub

Public Sub ShellOrderForm()
    Dim Result As Variant
    Dim FilePath As String * 128

    On Error Resume Next
    
    FilePath = "write.exe " & Trim$(StartUpDirPath) & "\svsorder.wri"
    Result = Shell(FilePath, 3)
    DoEvents
    
End Sub
