Attribute VB_Name = "Module4"

'FILE: dxdevdef.bas

'Miscellaneous defines
 
Global Const PGRPHSHIFT = 4                     ' Shift for paragraphs-to-bytes
Global Const MFBDCH = 1                         ' Ch # for board MF/40 commands
Global Const ADPCM_SIL = &H80                   ' ADPCM silence value
Global Const DX_NOPORT = &HFFFF                 ' IO port not used

Global Const SR_STOPREQUEST = &H2
Global Const DL_LASTBUFFULL = &H80              ' May need to put elsewhere

'Defines for D4XE support.
 
Global Const D4XE_LOCATOR = &HE0                ' D4XE locator offset in sram
Global Const D4XE_MAXLOC = &HFF                 ' D4xE locator max. value
Global Const D4XE_DATA = &HED                   ' interrupt rearm write data

'Device features
 
Global Const FTR_VFS = &H1                      ' Voice store/forward capability
Global Const FTR_CALLP = &H2                    ' Call progress
Global Const FTR_MF = &H4                       ' MF digit detection
Global Const FTR_VR = &H8                       ' Voice recognition
Global Const FTR_FAX = &H10                     ' Fax capabilitis
Global Const FTR_PBXSL = &H20                   ' Cnct to Northern Telecom SL1 PABX
Global Const FTR_PBXSX = &H40                   ' Cnct to Mitel PBX
Global Const FTR_ROUTE = &H80                   ' Board can route timeslots

'Base technology type
 
Global Const TYP_SPRINGBOARD = &H1              ' Springboard device
Global Const TYP_DX = &H2                       ' D/4x or D/2x based device

'Types of devices
 
Global Const TYP_BOARD = &H1                    ' Board device
Global Const TYP_CHANNEL = &H2                  ' Channel device
Global Const TYP_XAXIS = &H4                    ' AMX x-axis device
Global Const TYP_TIMESLOT = &H8                 ' Timeslot device

'Board type (BD_HWTYPE)
 
Global Const TYP_D40 = 0                        ' D/40 functions alone
Global Const TYP_D41 = 1                        ' D/40 functions and call analysis

'Hardware configuration (BD_SYSCFG)
 
Global Const CFG_LOOP = 0                       ' Loop start interface in use
Global Const CFG_DTI = 1                        ' DTI/1xx installed

' Bitmask defines for daughterboard id's
Global Const DB_MF40ID = &H1                    ' MF40 Daughterboard
Global Const DB_FAXID = &H2                     ' FAX Daughterboard
Global Const DB_SLID = &H4                      ' SL Daughterboard
Global Const DB_SXID = &H8                      ' SX Daughterboard
Global Const DB_NSID = &H10                     ' NS Daughterboard
Global Const DB_VRID = &H20                     ' VR Daughterboard

'Device identifier defines
 
Global Const DT_MEM = (&H100000)                ' Shared RAM device class
Global Const DT_SBA = (&H200000)                ' SBA device class

Global Const DT_IO = (&H400000)                 ' I/O interface device class

Global Const DT_SPAN = (&H800000)               ' Span Card device class

Global Const DT_DXXX = (&H1000)                 ' D/XXX device class
Global Const DT_DTI = (&H2000)                  ' DTI device class DT_DTI replaces __DT_DTI__
Global Const DT_AMX = (&H4000)                  ' AMX device class
Global Const DT_VRXXX = (&H8000)                ' VR/XXX device class

Global Const DT_CH = (&H100)                    ' channel device class
Global Const DT_TS = (&H200)                    ' timeslot device class

Global Const DT_DXBD = (DT_MEM Or DT_DXXX)              ' DXX board device class
Global Const DT_DXCH = (DT_MEM Or DT_DXXX Or DT_CH)     ' DXX channel device class

Global Const DT_NDTBD = (DT_MEM Or DT_DTI)              ' DTI board device class
Global Const DT_NDTTS = (DT_MEM Or DT_DTI Or DT_TS)     ' DTI channel device class

Global Const DI_D20 = (DT_MEM Or DT_DXXX Or 20)         ' Dev = D/20
Global Const DI_D20BD = DI_D20                          ' Dev = D/20 bd
Global Const DI_D20CH = (DT_MEM Or DT_DXXX Or DT_CH Or 20)      ' Dev = D/20 ch

Global Const DI_D21 = (DT_MEM Or DT_DXXX Or 21)         ' Dev = D/21
Global Const DI_D21BD = DI_D21                          ' Dev = D/21 bd
Global Const DI_D21CH = (DT_MEM Or DT_DXXX Or DT_CH Or 21)      ' Dev = D/21 ch

Global Const DI_D40 = (DT_MEM Or DT_DXXX Or 40)         ' Dev = D/40
Global Const DI_D40BD = DI_D40                          ' Dev = D/40 bd
Global Const DI_D40CH = (DT_MEM Or DT_DXXX Or DT_CH Or 40)      ' Dev = D/40 ch

Global Const DI_D41 = (DT_MEM Or DT_DXXX Or 41)         ' Dev = D/41
Global Const DI_D41BD = DI_D41                          ' Dev = D/41 bd
Global Const DI_D41CH = (DT_MEM Or DT_DXXX Or DT_CH Or 41)      ' Dev = D/41 ch

Global Const DI_D120 = (DT_SBA Or DT_MEM Or DT_DXXX Or 120)     ' Dev = D/120
Global Const DI_D120CH = (DT_SBA Or DT_MEM Or DT_DXXX Or DT_CH Or 120)  ' Dev = D/120 ch

Global Const DI_D121 = (DT_SBA Or DT_MEM Or DT_DXXX Or 121)             ' Dev = D/121
Global Const DI_D121CH = (DT_SBA Or DT_MEM Or DT_DXXX Or DT_CH Or 121)  ' Dev = D/121 ch

Global Const DI_VR40 = (DT_MEM Or DT_VRXXX Or 40)               ' Dev = VR/40
Global Const DI_VR40CH = (DT_MEM Or DT_VRXXX Or DT_CH Or 40)    ' Dev = VR/40 ch

Global Const DI_VR121 = (DT_SBA Or DT_MEM Or DT_VRXXX Or 121)   ' Dev = VR/120
Global Const DI_VR121CH = (DT_SBA Or DT_MEM Or DT_VRXXX Or DT_CH Or 121)    ' Dev = VR/120 ch

Global Const DI_VR160 = (DT_SBA Or DT_MEM Or DT_VRXXX Or 160)   ' Dev = VR/160
Global Const DI_VR160CH = (DT_SBA Or DT_MEM Or DT_VRXXX Or DT_CH Or 160)    ' Dev = VR/160 ch

Global Const DI_VR160C = (DT_SBA Or DT_MEM Or DT_VRXXX Or 161)  ' Dev = VR/160C
Global Const DI_VR160CCH = (DT_SBA Or DT_MEM Or DT_VRXXX Or DT_CH Or 161)   ' Dev = VR/160C ch

Global Const DI_DTI100 = (DT_IO Or DT_DTI Or 100)               ' Dev = DTI/100
Global Const DI_DTI100CH = (DT_IO Or DT_DTI Or DT_CH Or 100)    ' Dev = DTI/100 ch

Global Const DI_DTI101 = (DT_IO Or DT_DTI Or 101)               ' Dev = DTI/101
Global Const DI_DTI101CH = (DT_IO Or DT_DTI Or DT_CH Or 101)    ' Dev = DTI/101 ch

Global Const DI_DTI124 = (DT_IO Or DT_DTI Or 124)               ' Dev = DTI/124
Global Const DI_DTI124CH = (DT_IO Or DT_DTI Or DT_CH Or 124)    ' Dev = DTI/124 ch

Global Const DI_DTI200 = (DT_IO Or DT_DTI Or 200)               ' Dev = DTI/200

Global Const DI_AMX80 = (DT_AMX Or 80)                          ' Dev = AMX/80
Global Const DI_AMX80CH = (DT_AMX Or DT_CH Or 80)               ' Dev = AMX/80 ch

Global Const DI_AMX81 = (DT_AMX Or 81)                          ' Dev = AMX/81
Global Const DI_AMX81CH = (DT_AMX Or DT_CH Or 81)               ' Dev = AMX/81 ch

Global Const DI_SPAN = (DT_SPAN Or DT_DXXX)                     ' Span card virtual D/4x board
Global Const DI_T1SPAN = (DT_SPAN Or DT_DTI Or 24)              ' Span card T1 board
Global Const DI_E1SPAN = (DT_SPAN Or DT_DTI Or 30)              ' Span card E1 board
