unit MinModal;

{
:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
  MinModal: minimizer for modal windows. Why we can't minimeze an
            application when a modal window is active? Drop this
            component to the form, open form by method 'ShowModal'
            and try minimize this form at run time.
            All your application will be minimized!

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  Author: Zimin Sergey. Russia, august 1999.
  E-mail: szimin@mypad.com
  Web-site: http://szimin.spedia.net

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  Status: Freeware with full source.

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

  Tested under Windows 9x, Windows NT.
  Component realized for Delphi 3, Delphi 4, C++ Buider 4.
  (Also must work in C++ Buider 3, but not tested)

:::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::

Additional tool for programmers:

Also I can offer additional tool - MaxSpace, special program for
programmers, who use Delphi or C++ Builder (version insensitive).
It turns your Object Inspector and IDE toolbar into "Auto-Hide"
windows. This mean that now you can write code on a full screen.
The normal state of Object Inspector and IDE toolbar will be out
of the screen. But as you will be needed their you move the pointer
of mouse to the left side of screen for appearance Object Inspector
or move to the top for appearance IDE toolbar. And after you used
the Object Inspector or IDE toolbar they automatic move out of the
screen and you again can use a FULL SCREEN. It's perfect for Delphi 4
and C++ Builder 4, where is added the Code Explorer - very useful
addition, but it take the working space and minimum space is leaved
for Code Editor.

Also I can offer the special components, that allow you asynchronously
execute several queries and stored procedures at the same time.
The asynchronous executing is possibility to execute several queries
and stored procedures at the same time (parallel). When queries and
stored procedures are executing asynchronously your application can
respond to the user's and system's requirements and can execute any
action that you will define. Thus the users can refuse executing
queries (stored procedures) at any time. Opening several big dataset
take place in 3-5 time quicker, than if open their synchronously. The
bigger dataset the quicker asynchronous queries is opened (relatively
synchronous). Tested under Microsoft SQL Server 6.5.

Also I can offer the NEW ELEGANT MDI interface (component for Delphi4).
It is an elegant realization of the old squalid MDI interface.

Also I can offer a freeware component 'WavePanel' - component with running
colors, like panel at the bottom of the screen when Windows 9x loading.

If you want to get a trial version MaxSpace or asynchronous SQl
components or elegant MDI then send me message at my
e-mail: szimin@mypad.com
or visit my web-site
http://szimin.spedia.net

                                                           Good luck!
                                                              Sergey.
                                                     szimin@mypad.com
                                             http://szimin.spedia.net
                                                  Russia, august 1999
}

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  TMinModal = class(TComponent)
  private
    Form: TForm;
    OldModalWndProc: Pointer;
    InstanceModalWndProc: Pointer;
    FAbout: String;
    FOnMinimize: TNotifyEvent;
    procedure SetAbout(const Value: String);
  protected
    procedure ModalWndProc(var Message: TMessage); virtual;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
  published
    property About: String read FAbout write SetAbout stored False;
    property OnMinimize: TNotifyEvent read FOnMinimize write FOnMinimize;
  end;

procedure Register;

implementation

uses AboutMinModal, DsgnIntf;

const
  EMail = 'szimin@mypad.com';

type
  TAboutProperty = class(TStringProperty)
  protected
    function GetAttributes: TPropertyAttributes; override;
    procedure Edit; override;
  end;

procedure Register;
begin
  RegisterComponents('Additional', [TMinModal]);

  RegisterPropertyEditor(TypeInfo(String), TMinModal, 'About',
      TAboutProperty);
end;

procedure RememberMe(Sender: TObject);
begin
  with TFormAbout.Create(Application) do begin
    WavePanel5.Caption := Email;
    Caption := 'http://szimin.spedia.net';
    Left := (Screen.Width-Width) div 2;
    Top  := (Screen.Height-Height) div 2;
    ShowModal;
    Free;
  end;
end;

{ TMinModal }

constructor TMinModal.Create(AOwner: TComponent);
var
  Component: TComponent;
begin
  inherited Create(AOwner);
  FAbout := 'Minimizer For Modal Windows ('+EMail+')';

  if not(csDesigning in ComponentState) then begin
    Component:=Owner;
    while Assigned(Component) and not (Component is TForm) do
      Component:= Component.Owner;
    if not Assigned(Component) then
      Exit;
    Form := Component as TForm;

    if (not (csDesigning in ComponentState)) then begin
      InstanceModalWndProc := MakeObjectInstance(ModalWndProc);
      OldModalWndProc := Pointer(GetWindowLong(Form.Handle, GWL_WNDPROC));
      SetWindowLong(Form.Handle, GWL_WNDPROC, Longint(InstanceModalWndProc));
    end;
  end;
end;

destructor TMinModal.Destroy;
begin
  if Assigned(InstanceModalWndProc) then begin
    SetWindowLong(Form.Handle, GWL_WNDPROC, Longint(OldModalWndProc));
    FreeObjectInstance(InstanceModalWndProc);
    InstanceModalWndProc := nil;
  end;
  inherited Destroy;
end;

procedure TMinModal.ModalWndProc(var Message: TMessage);
begin
  case Message.Msg of
    WM_SYSCOMMAND:
      begin
        if Message.WParam=SC_MINIMIZE then begin
          if Assigned(FOnMinimize) then FOnMinimize(Self);
          Application.MainForm.Perform(Message.Msg, Message.WParam, Message.LParam);
          Exit;
        end;
      end;
    WM_DESTROY:
      begin
        if Assigned(InstanceModalWndProc) then begin
          SetWindowLong(Form.Handle, GWL_WNDPROC, Longint(OldModalWndProc));
          FreeObjectInstance(InstanceModalWndProc);
          InstanceModalWndProc := nil;
        end;
      end;
  end;
  Message.Result:= CallWindowProc(OldModalWndProc, Form.Handle, Message.Msg, Message.WParam, Message.LParam);
end;

procedure TMinModal.SetAbout(const Value: String);
begin
  if FAbout<>Value then RememberMe(Self);
end;

{ TAboutProperty }

procedure TAboutProperty.Edit;
begin
  RememberMe(Self);
end;

function TAboutProperty.GetAttributes: TPropertyAttributes;
begin
  Result := inherited GetAttributes + [paReadOnly, paDialog];
end;

end.
