// Borland C++ Builder
// Copyright (c) 1995, 1998 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RichView.pas' rev: 3.00

#ifndef RichViewHPP
#define RichViewHPP
#include <Menus.hpp>
#include <Clipbrd.hpp>
#include <Commctrl.hpp>
#include <RVScroll.hpp>
#include <RVStyle.hpp>
#include <DLines.hpp>
#include <Forms.hpp>
#include <Controls.hpp>
#include <Graphics.hpp>
#include <Classes.hpp>
#include <SysUtils.hpp>
#include <Messages.hpp>
#include <Windows.hpp>
#include <SysInit.hpp>
#include <System.hpp>

//-- user supplied -----------------------------------------------------------

namespace Richview
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS ERichViewError;
class PASCALIMPLEMENTATION ERichViewError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	/* Exception.Create */ __fastcall ERichViewError(const System::AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	/* Exception.CreateFmt */ __fastcall ERichViewError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	/* Exception.CreateRes */ __fastcall ERichViewError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	/* Exception.CreateResFmt */ __fastcall ERichViewError(int Ident, const System::TVarRec * Args, const 
		int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	/* Exception.CreateHelp */ __fastcall ERichViewError(const System::AnsiString Msg, int AHelpContext
		) : Sysutils::Exception(Msg, AHelpContext) { }
	/* Exception.CreateFmtHelp */ __fastcall ERichViewError(const System::AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	/* Exception.CreateResHelp */ __fastcall ERichViewError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	/* Exception.CreateResFmtHelp */ __fastcall ERichViewError(int Ident, const System::TVarRec * Args, 
		const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext)
		 { }
	
public:
	/* TObject.Destroy */ __fastcall virtual ~ERichViewError(void) { }
	
};

enum TRVSaveFormat { rvsfText, rvsfHTML, rvsfRTF, rvsfRVF };

enum TRVSaveOption { rvsoOverrideImages };

typedef Set<TRVSaveOption, rvsoOverrideImages, rvsoOverrideImages>  TRVSaveOptions;

enum TRVBreakStyle { rvbsLine, rvbsRectangle, rvbs3d };

class DELPHICLASS TRVCPInfo;
class DELPHICLASS TRVItemInfo;
class PASCALIMPLEMENTATION TRVItemInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	short StyleNo;
	short ParaNo;
	Byte SameAsPrev;
	int imgNo;
	Classes::TPersistent* gr;
	int Tag;
	TRVCPInfo* Checkpoint;
public:
	/* TObject.Create */ __fastcall TRVItemInfo(void) : System::TObject() { }
	/* TObject.Destroy */ __fastcall virtual ~TRVItemInfo(void) { }
	
};

class PASCALIMPLEMENTATION TRVCPInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	System::AnsiString Name;
	int DrawLineNo;
	TRVCPInfo* Next;
	TRVCPInfo* Prev;
	Byte RaiseEvent;
	TRVItemInfo* ItemInfo;
	int Tag;
public:
	/* TObject.Create */ __fastcall TRVCPInfo(void) : System::TObject() { }
	/* TObject.Destroy */ __fastcall virtual ~TRVCPInfo(void) { }
	
};

typedef void *TCheckpointData;

class DELPHICLASS TRVJumpInfo;
class PASCALIMPLEMENTATION TRVJumpInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int l;
	int t;
	int w;
	int h;
	int id;
	int DrawLineNo;
	Controls::TCursor Cursor;
public:
	/* TObject.Create */ __fastcall TRVJumpInfo(void) : System::TObject() { }
	/* TObject.Destroy */ __fastcall virtual ~TRVJumpInfo(void) { }
	
};

typedef void __fastcall (__closure *TJumpEvent)(System::TObject* Sender, int id);

typedef void __fastcall (__closure *TRVMouseMoveEvent)(System::TObject* Sender, int id);

class DELPHICLASS TRichView;
typedef void __fastcall (__closure *TRVSaveComponentToFileEvent)(TRichView* Sender, System::AnsiString 
	Path, Classes::TPersistent* SaveMe, TRVSaveFormat SaveFormat, System::AnsiString &OutStr);

typedef void __fastcall (__closure *TRVURLNeededEvent)(TRichView* Sender, int id, System::AnsiString 
	&url);

typedef void __fastcall (__closure *TRVDblClickEvent)(TRichView* Sender, System::AnsiString ClickedWord
	, int Style);

typedef void __fastcall (__closure *TRVRightClickEvent)(TRichView* Sender, System::AnsiString ClickedWord
	, int Style, int X, int Y);

typedef void __fastcall (__closure *TRVMouseEvent)(TRichView* Sender, Controls::TMouseButton Button, 
	Classes::TShiftState Shift, int ItemNo, int X, int Y);

typedef void __fastcall (__closure *TRVFPictureNeededEvent)(TRichView* Sender, System::AnsiString Name
	, int Tag, Graphics::TGraphic* &gr);

typedef void __fastcall (__closure *TRVFControlNeededEvent)(TRichView* Sender, System::AnsiString Name
	, int Tag, Controls::TControl* &ctrl);

typedef void __fastcall (__closure *TRVFImageListNeededEvent)(TRichView* Sender, int ImageListTag, Controls::TImageList* 
	&il);

typedef void __fastcall (__closure *TRVCheckpointVisibleEvent)(TRichView* Sender, TCheckpointData CheckpointData
	);

enum TRVVAlign { rvvaBaseline, rvvaMiddle };

enum TBackgroundStyle { bsNoBitmap, bsStretched, bsTiled, bsTiledAndScrolled, bsCentered };

enum TRVDisplayOption { rvdoImages, rvdoComponents, rvdoBullets };

typedef Set<TRVDisplayOption, rvdoImages, rvdoBullets>  TRVDisplayOptions;

struct TScreenAndDevice
{
	int ppixScreen;
	int ppiyScreen;
	int ppixDevice;
	int ppiyDevice;
	int LeftMargin;
	int RightMargin;
} ;

class DELPHICLASS TRVInteger2;
class PASCALIMPLEMENTATION TRVInteger2 : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int val;
public:
	/* TObject.Create */ __fastcall TRVInteger2(void) : System::TObject() { }
	/* TObject.Destroy */ __fastcall virtual ~TRVInteger2(void) { }
	
};

enum TRVState { rvstClickedBeyondLine, rvstMakingSelection, rvstDrawHover, rvstSkipFormatting, rvstFormatParas 
	};

typedef Set<TRVState, rvstClickedBeyondLine, rvstFormatParas>  TRVStates;

enum TRVFlag { rvflUseJumps, rvflTrim, rvflShareContents, rvflUseExternalLeading };

typedef Set<TRVFlag, rvflUseJumps, rvflUseExternalLeading>  TRVFlags;

enum TRVOption { rvoAllowSelection, rvoSingleClick, rvoScrollToEnd, rvoClientTextWidth, rvoShowCheckpoints, 
	rvoTagsArePChars, rvoAutoCopyText, rvoAutoCopyRVF, rvoAutoCopyImage, rvoFormatInvalidate };

typedef Set<TRVOption, rvoAllowSelection, rvoFormatInvalidate>  TRVOptions;

enum TCPEventKind { cpeNone, cpeAsSectionStart, cpeWhenVisible };

enum TRVFOption { rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoIgnoreUnknownPicFmt, rvfoIgnoreUnknownCtrls, 
	rvfoConvUnknownStylesToZero, rvfoConvLargeImageIdxToZero, rvfoSaveBinary };

typedef Set<TRVFOption, rvfoSavePicturesBody, rvfoSaveBinary>  TRVFOptions;

enum TRVFWarning { rvfwUnknownPicFmt, rvfwUnknownCtrls, rvfwConvUnknownStyles, rvfwConvLargeImageIdx 
	};

typedef Set<TRVFWarning, rvfwUnknownPicFmt, rvfwConvLargeImageIdx>  TRVFWarnings;

enum TRVSearchOption { rvsroMatchCase };

typedef Set<TRVSearchOption, rvsroMatchCase, rvsroMatchCase>  TRVSearchOptions;

class PASCALIMPLEMENTATION TRichView : public Rvscroll::TRVScroller 
{
	typedef Rvscroll::TRVScroller inherited;
	
private:
	Controls::TCursor FCursor;
	TRVOptions FOptions;
	int VScrollDelta;
	int HScrollDelta;
	bool ScrollTimerActive;
	System::AnsiString FDelimiters;
	TJumpEvent FOnJump;
	TRVMouseMoveEvent FOnRVMouseMove;
	TRVSaveComponentToFileEvent FOnSaveComponentToFile;
	TRVURLNeededEvent FOnURLNeeded;
	TRVDblClickEvent FOnRVDblClick;
	TRVRightClickEvent FOnRVRightClick;
	TRVMouseEvent FOnRVMouseUp;
	TRVMouseEvent FOnRVMouseDown;
	TCPEventKind FCPEventKind;
	TRVFPictureNeededEvent FOnRVFPictureNeeded;
	TRVFControlNeededEvent FOnRVFControlNeeded;
	TRVFImageListNeededEvent FOnRVFImageListNeeded;
	TRVCheckpointVisibleEvent FOnCheckpointVisible;
	int FFirstJumpNo;
	int FMaxTextWidth;
	int FMinTextWidth;
	int FLeftMargin;
	int FRightMargin;
	Graphics::TBitmap* FBackBitmap;
	TBackgroundStyle FBackgroundStyle;
	TRVFOptions FRVFOptions;
	TRVFWarnings FRVFWarnings;
	TRVCPInfo* LastRaisedCP;
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &Message);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Message);
	MESSAGE void __fastcall WMCopy(Messages::TWMNoParams &Message);
	MESSAGE void __fastcall WMTimer(Messages::TWMTimer &Message);
	HIDESBASE MESSAGE void __fastcall WMDestroy(Messages::TWMNoParams &Message);
	void __fastcall InvalidateJumpRect(int no);
	int __fastcall FindDrawItemAtPos(int X, int Y);
	int __fastcall GetLineCount(void);
	bool __fastcall GetAllowSelection(void);
	bool __fastcall GetSingleClick(void);
	void __fastcall SetAllowSelection(const bool Value);
	void __fastcall SetSingleClick(const bool Value);
	void __fastcall CopyText_(void);
	void __fastcall CopyRVF_(void);
	void __fastcall CopyImage_(void);
	void __fastcall DoOnBackBitmapChange(System::TObject* Sender);
	void __fastcall DoOnDebFormPaint(System::TObject* Sender);
	void __fastcall DoOnDebFormCloseQuery(System::TObject* Sender, bool &CanClose);
	
protected:
	Classes::TStringList* Lines;
	Dlines::TRVDrawLines* DrawLines;
	TRVDisplayOptions DisplayOptions;
	Classes::TNotifyEvent FOnSelect;
	TRVFlags Flags;
	TRVStates State;
	int FSelStartNo;
	int FSelEndNo;
	int FSelStartOffs;
	int FSelEndOffs;
	TRVCPInfo* FirstCP;
	TRVCPInfo* LastCP;
	TRVCPInfo* NotAddedCP;
	int CPCount;
	Classes::TStringList* jumps;
	Rvstyle::TRVStyle* FStyle;
	int nJmps;
	TRVItemInfo* FActiveImage;
	int TextWidth;
	int TextHeight;
	int LastJumpMovedAbove;
	int LastDLMovedAbove;
	int LastLineFormatted;
	int LastJumpDowned;
	System::AnsiString imgSavePrefix;
	int imgSaveNo;
	TRVSaveOptions SaveOptions;
	Forms::TForm* __fastcall RVDebugForm(void);
	virtual void __fastcall Paint(void);
	int __fastcall FindDrawLineByLine(int ItemNo);
	virtual void __fastcall InsertFirstRVFItem(int &Index, const System::AnsiString s, TRVItemInfo* li, 
		bool EditFlag);
	bool __fastcall InsertRVFFromStream_(Classes::TStream* Stream, int Index, int AParaNo, bool AppendMode
		, bool EditFlag);
	System::AnsiString __fastcall ReplaceTabs(const System::AnsiString s);
	int __fastcall GetBeforeLineOffs(int ItemNo);
	int __fastcall GetAfterLineOffs(int ItemNo);
	int __fastcall GetBeforeDrawLineOffs(int DrawLineNo);
	int __fastcall GetAfterDrawLineOffs(int DrawLineNo);
	Graphics::TColor __fastcall GetColor(void);
	Graphics::TColor __fastcall GetHoverColor(Graphics::TColor Color);
	bool __fastcall IsCopyShortcut(Classes::TShiftState Shift, Word Key);
	bool __fastcall IsCutShortcut(Classes::TShiftState Shift, Word Key);
	bool __fastcall IsPasteShortcut(Classes::TShiftState Shift, Word Key);
	int __fastcall ItemLength(int No);
	void __fastcall FreeCheckpoint(TRVCPInfo* &cp, bool AdjustLinks, bool DecCPCount);
	void __fastcall FreeLineObject(TRVItemInfo* li);
	void __fastcall SetCP(TRVItemInfo* li, TRVCPInfo* &PrevCP, TRVCPInfo* &CP);
	void __fastcall GetSelBounds(int &StartNo, int &EndNo, int &StartOffs, int &EndOffs, bool Normalize
		);
	void __fastcall StoreSelBounds(int &StartNo, int &EndNo, int &StartOffs, int &EndOffs, bool Normalize
		);
	void __fastcall RestoreSelBounds(int StartNo, int EndNo, int StartOffs, int EndOffs);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall Click(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	void __fastcall FinishScreenLine(const TScreenAndDevice &sad, int LineWidth, int LastDrawLine, Byte 
		parafinished, Byte &dontdoit);
	void __fastcall NewFormatLine(const System::AnsiString LinesNo, int StartOffs, int no, int &x, int 
		&baseline, int &prevdesc, int &prevabove, Graphics::TCanvas* Canvas, TScreenAndDevice &sad, bool &
		IsParaStart, int &LineWidth, int &FirstIndent, int &LastDrawLine, int &VerticalOffs, Byte &DontFSL
		, int &LastTextStyle);
	void __fastcall FormatWords(System::AnsiString LinesNo, int no, int &x, int &baseline, int &prevdesc
		, int &prevabove, Graphics::TCanvas* Canvas, TScreenAndDevice &sad, bool &IsParaStart, int &LineWidth
		, int &FirstIndent, int &LastDrawLine, int &VerticalOffs, Byte &DontFSL, int &LastTextStyle);
	void __fastcall AdjustJumpsCoords(void);
	void __fastcall AdjustChildrenCoords(void);
	virtual void __fastcall ClearTemporal(void);
	int __fastcall GetFirstVisible(int TopLine);
	int __fastcall GetFirstItemVisible(void);
	int __fastcall GetLastItemVisible(void);
	int __fastcall GetDrawLineNo(int BoundLine, int Option);
	virtual void __fastcall Format_(bool OnlyResized, int depth, Graphics::TCanvas* Canvas, bool OnlyTail
		);
	void __fastcall SetBackBitmap(Graphics::TBitmap* Value);
	void __fastcall DrawBack(HDC DC, const Windows::TRect &Rect, int Width, int Height);
	void __fastcall SetBackgroundStyle(TBackgroundStyle Value);
	void __fastcall SetVSmallStep(int Value);
	virtual System::AnsiString __fastcall GetNextFileName(const System::AnsiString Path, const System::AnsiString 
		Ext, bool OverrideFiles);
	void __fastcall ShareLinesFrom(TRichView* Source);
	bool __fastcall FindClickedWord(System::AnsiString &clickedword, int X, int Y, int &StyleNo, int &ItemNo
		);
	void __fastcall GetDrawLineBounds(int No, int &First, int &Last);
	void __fastcall FindDrawItemForSel(int X, int Y, int &No, int &Offs, bool isstart);
	virtual void __fastcall DoOnSelection(void);
	void __fastcall DrawLine2Line(int DrawLineNo, int DrawLineOffs, int &ItemNo, int &LineOffs);
	void __fastcall Line2DrawLine(int ItemNo, int LineOffs, int &DrawLineNo, int &DrawLineOffs);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	int __fastcall GetNextLineNo(int no);
	int __fastcall GetPrevLineNo(int no);
	virtual void __fastcall Loaded(void);
	void __fastcall CopyTag(int SourceTag, int &Tag);
	bool __fastcall CompareTags(int Tag1, int Tag2);
	void __fastcall SetStyle(Rvstyle::TRVStyle* Value);
	int __fastcall CountItemWidth(TRVItemInfo* li);
	int __fastcall GetMaxTotalIndent(void);
	virtual void __fastcall GetSelStart(int &DLNo, int &DLOffs);
	virtual void __fastcall AfterVScroll(void);
	virtual void __fastcall AfterHScroll(void);
	void __fastcall InsertCheckpoint(int Index, int Tag, const System::AnsiString Name, bool RaiseEvent
		);
	int __fastcall GetMaxPictureWidth(void);
	
public:
	__fastcall virtual TRichView(Classes::TComponent* AOwner);
	__fastcall virtual ~TRichView(void);
	void __fastcall AddNL(const System::AnsiString s, int StyleNo, int ParaNo);
	void __fastcall AddFmt(const System::AnsiString FormatStr, const System::TVarRec * Args, const int 
		Args_Size, int StyleNo, int ParaNo);
	void __fastcall Add(const System::AnsiString s, int StyleNo);
	void __fastcall AddTextNL(System::AnsiString s, int StyleNo, int FirstParaNo, int OtherParaNo);
	void __fastcall AddBreak(void);
	int __fastcall AddCheckpoint(void);
	int __fastcall AddNamedCheckpoint(System::AnsiString CpName);
	int __fastcall AddNamedCheckpointEx(const System::AnsiString CpName, bool RaiseEvent);
	void __fastcall AddPictureEx(const System::AnsiString Name, Graphics::TGraphic* gr, int ParaNo, TRVVAlign 
		VAlign);
	void __fastcall AddHotspotEx(const System::AnsiString Name, int ImageIndex, int HotImageIndex, Controls::TImageList* 
		ImageList, int ParaNo);
	void __fastcall AddBulletEx(const System::AnsiString Name, int ImageIndex, Controls::TImageList* ImageList
		, int ParaNo);
	void __fastcall AddControlEx(const System::AnsiString Name, Controls::TControl* ctrl, int ParaNo, TRVVAlign 
		VAlign);
	void __fastcall AddBreakEx(Byte Width, TRVBreakStyle Style, Graphics::TColor Color);
	void __fastcall AddNLTag(System::AnsiString s, int StyleNo, int ParaNo, int Tag);
	void __fastcall AddTag(const System::AnsiString s, int StyleNo, int Tag);
	void __fastcall AddBreakTag(int Tag);
	int __fastcall AddCheckpointTag(int Tag);
	int __fastcall AddNamedCheckpointExTag(const System::AnsiString CpName, bool RaiseEvent, int Tag);
	void __fastcall AddPictureExTag(const System::AnsiString Name, Graphics::TGraphic* gr, int ParaNo, 
		TRVVAlign VAlign, int Tag);
	void __fastcall AddHotspotExTag(const System::AnsiString Name, int ImageIndex, int HotImageIndex, Controls::TImageList* 
		ImageList, int ParaNo, int Tag);
	void __fastcall AddBulletExTag(const System::AnsiString Name, int ImageIndex, Controls::TImageList* 
		ImageList, int ParaNo, int Tag);
	void __fastcall AddControlExTag(const System::AnsiString Name, Controls::TControl* ctrl, int ParaNo
		, TRVVAlign VAlign, int Tag);
	void __fastcall AddBreakExTag(Byte Width, TRVBreakStyle Style, Graphics::TColor Color, int Tag);
	void __fastcall AddFromNewLine(const System::AnsiString s, int StyleNo);
	void __fastcall AddCenterLine(const System::AnsiString s, int StyleNo);
	void __fastcall AddText(const System::AnsiString s, int StyleNo);
	void __fastcall AddTextFromNewLine(const System::AnsiString s, int StyleNo);
	void __fastcall AddPicture(Graphics::TGraphic* gr);
	void __fastcall AddHotspot(int ImageIndex, Controls::TImageList* ImageList, bool fromnewline);
	void __fastcall AddBullet(int ImageIndex, Controls::TImageList* ImageList, bool fromnewline);
	void __fastcall AddControl(Controls::TControl* ctrl, bool center);
	int __fastcall GetCheckpointY(int no);
	TCheckpointData __fastcall GetFirstCheckpoint(void);
	TCheckpointData __fastcall GetNextCheckpoint(TCheckpointData CheckpointData);
	TCheckpointData __fastcall GetItemCheckpoint(int ItemNo);
	TCheckpointData __fastcall FindCheckpointByName(const System::AnsiString Name);
	TCheckpointData __fastcall FindCheckpointByTag(int Tag);
	TCheckpointData __fastcall GetCheckpointByNo(int No);
	void __fastcall GetCheckpointInfo(TCheckpointData CheckpointData, int &Tag, System::AnsiString &Name
		, bool &RaiseEvent);
	void __fastcall GetCheckpointXY(TCheckpointData CheckpointData, int &X, int &Y);
	int __fastcall GetCheckpointYEx(TCheckpointData CheckpointData);
	int __fastcall GetCheckpointItemNo(TCheckpointData CheckpointData);
	int __fastcall GetCheckpointNo(TCheckpointData CheckpointData);
	int __fastcall GetJumpPointY(int id);
	int __fastcall GetJumpPointItemNo(int id);
	virtual void __fastcall Clear(void);
	void __fastcall Format(void);
	void __fastcall FormatTail(void);
	void __fastcall AppendFrom(TRichView* Source);
	__property int VSmallStep = {read=SmallStep, write=SetVSmallStep, nodefault};
	bool __fastcall SaveHTMLEx(const System::AnsiString FileName, const System::AnsiString Title, const 
		System::AnsiString ImagesPrefix, const System::AnsiString ExtraStyles, const System::AnsiString ExternalCSS
		, System::AnsiString CPPrefix, TRVSaveOptions Options);
	bool __fastcall SaveHTML(const System::AnsiString FileName, const System::AnsiString Title, const System::AnsiString 
		ImagesPrefix, TRVSaveOptions Options);
	bool __fastcall SaveText(const System::AnsiString FileName, int LineWidth);
	bool __fastcall LoadText(const System::AnsiString FileName, int StyleNo, int ParaNo);
	bool __fastcall LoadRVFFromStream(Classes::TStream* Stream);
	bool __fastcall InsertRVFFromStream(Classes::TStream* Stream, int Index);
	bool __fastcall AppendRVFFromStream(Classes::TStream* Stream, int ParaNo);
	bool __fastcall LoadRVF(const System::AnsiString FileName);
	bool __fastcall SaveRVFToStream(Classes::TStream* Stream, bool SelectionOnly);
	bool __fastcall SaveRVF(const System::AnsiString FileName, bool SelectionOnly);
	void __fastcall CopyRVF(void);
	void __fastcall DeleteSection(const System::AnsiString CpName);
	void __fastcall DeleteLines(int FirstItemNo, int Count);
	virtual System::AnsiString __fastcall SavePicture(TRVSaveFormat DocumentSaveFormat, const System::AnsiString 
		Path, Graphics::TGraphic* gr);
	void __fastcall CopyText(void);
	void __fastcall CopyImage(void);
	void __fastcall Copy(void);
	bool __fastcall CopyDef(void);
	Graphics::TGraphic* __fastcall GetSelectedImage(void);
	System::AnsiString __fastcall GetSelText(void);
	bool __fastcall SelectionExists(void);
	void __fastcall Deselect(void);
	void __fastcall SelectAll(void);
	bool __fastcall SearchText(System::AnsiString s, TRVSearchOptions SrchOptions);
	int __fastcall GetItemStyle(int ItemNo);
	void __fastcall GetBreakInfo(int ItemNo, Byte &AWidth, TRVBreakStyle &AStyle, Graphics::TColor &AColor
		, int &ATag);
	void __fastcall GetBulletInfo(int ItemNo, System::AnsiString &AName, int &AImageIndex, Controls::TImageList* 
		&AImageList, int &ATag);
	void __fastcall GetHotspotInfo(int ItemNo, System::AnsiString &AName, int &AImageIndex, int &AHotImageIndex
		, Controls::TImageList* &AImageList, int &ATag);
	void __fastcall GetPictureInfo(int ItemNo, System::AnsiString &AName, Graphics::TGraphic* &Agr, TRVVAlign 
		&AVAlign, int &ATag);
	void __fastcall GetControlInfo(int ItemNo, System::AnsiString &AName, Controls::TControl* &Actrl, TRVVAlign 
		&AVAlign, int &ATag);
	void __fastcall GetTextInfo(int ItemNo, System::AnsiString &AText, int &ATag);
	int __fastcall GetItemTag(int ItemNo);
	bool __fastcall IsParaStart(int ItemNo);
	void __fastcall SetBreakInfo(int ItemNo, Byte AWidth, TRVBreakStyle AStyle, Graphics::TColor AColor
		, int ATag);
	void __fastcall SetBulletInfo(int ItemNo, const System::AnsiString AName, int AImageIndex, Controls::TImageList* 
		AImageList, int ATag);
	void __fastcall SetHotspotInfo(int ItemNo, const System::AnsiString AName, int AImageIndex, int AHotImageIndex
		, Controls::TImageList* AImageList, int ATag);
	bool __fastcall SetPictureInfo(int ItemNo, const System::AnsiString AName, Graphics::TGraphic* Agr, 
		TRVVAlign AVAlign, int ATag);
	bool __fastcall SetControlInfo(int ItemNo, const System::AnsiString AName, TRVVAlign AVAlign, int ATag
		);
	void __fastcall SetItemTag(int ItemNo, int ATag);
	void __fastcall SetCheckpointInfo(int ItemNo, int ATag, const System::AnsiString AName, bool ARaiseEvent
		);
	bool __fastcall RemoveCheckpoint(int ItemNo);
	int __fastcall FindControlItemNo(Controls::TControl* actrl);
	void __fastcall GetSelectionBounds(int &StartItemNo, int &StartItemOffs, int &EndItemNo, int &EndItemOffs
		, bool Normalize);
	void __fastcall SetSelectionBounds(int StartItemNo, int StartItemOffs, int EndItemNo, int EndItemOffs
		);
	void __fastcall GetWordAt(int X, int Y, int &ItemNo, System::AnsiString &Word);
	__property int LineCount = {read=GetLineCount, nodefault};
	__property int ItemCount = {read=GetLineCount, nodefault};
	__property int FirstItemVisible = {read=GetFirstItemVisible, nodefault};
	__property int LastItemVisible = {read=GetLastItemVisible, nodefault};
	__property TRVFWarnings RVFWarnings = {read=FRVFWarnings, nodefault};
	__property int DocumentHeight = {read=TextHeight, nodefault};
	
__published:
	__property Tracking ;
	__property VScrollVisible ;
	__property OnVScrolled ;
	__property Controls::TCursor Cursor = {read=FCursor, write=FCursor, nodefault};
	__property TRVOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property Color ;
	__property PopupMenu ;
	__property OnClick ;
	__property OnKeyDown ;
	__property OnKeyUp ;
	__property OnKeyPress ;
	__property int FirstJumpNo = {read=FFirstJumpNo, write=FFirstJumpNo, nodefault};
	__property TJumpEvent OnJump = {read=FOnJump, write=FOnJump};
	__property TRVMouseMoveEvent OnRVMouseMove = {read=FOnRVMouseMove, write=FOnRVMouseMove};
	__property TRVSaveComponentToFileEvent OnSaveComponentToFile = {read=FOnSaveComponentToFile, write=
		FOnSaveComponentToFile};
	__property TRVURLNeededEvent OnURLNeeded = {read=FOnURLNeeded, write=FOnURLNeeded};
	__property TRVDblClickEvent OnRVDblClick = {read=FOnRVDblClick, write=FOnRVDblClick};
	__property TRVRightClickEvent OnRVRightClick = {read=FOnRVRightClick, write=FOnRVRightClick};
	__property TRVMouseEvent OnRVMouseUp = {read=FOnRVMouseUp, write=FOnRVMouseUp};
	__property TRVMouseEvent OnRVMouseDown = {read=FOnRVMouseDown, write=FOnRVMouseDown};
	__property TRVCheckpointVisibleEvent OnCheckpointVisible = {read=FOnCheckpointVisible, write=FOnCheckpointVisible
		};
	__property Classes::TNotifyEvent OnSelect = {read=FOnSelect, write=FOnSelect};
	__property TRVFPictureNeededEvent OnRVFPictureNeeded = {read=FOnRVFPictureNeeded, write=FOnRVFPictureNeeded
		};
	__property TRVFControlNeededEvent OnRVFControlNeeded = {read=FOnRVFControlNeeded, write=FOnRVFControlNeeded
		};
	__property TRVFImageListNeededEvent OnRVFImageListNeeded = {read=FOnRVFImageListNeeded, write=FOnRVFImageListNeeded
		};
	__property Rvstyle::TRVStyle* Style = {read=FStyle, write=SetStyle};
	__property int MaxTextWidth = {read=FMaxTextWidth, write=FMaxTextWidth, nodefault};
	__property int MinTextWidth = {read=FMinTextWidth, write=FMinTextWidth, nodefault};
	__property int LeftMargin = {read=FLeftMargin, write=FLeftMargin, nodefault};
	__property int RightMargin = {read=FRightMargin, write=FRightMargin, nodefault};
	__property Graphics::TBitmap* BackgroundBitmap = {read=FBackBitmap, write=SetBackBitmap};
	__property TBackgroundStyle BackgroundStyle = {read=FBackgroundStyle, write=SetBackgroundStyle, nodefault
		};
	__property System::AnsiString Delimiters = {read=FDelimiters, write=FDelimiters};
	__property TRVFOptions RVFOptions = {read=FRVFOptions, write=FRVFOptions, nodefault};
	__property bool AllowSelection = {read=GetAllowSelection, write=SetAllowSelection, stored=false, nodefault
		};
	__property bool SingleClick = {read=GetSingleClick, write=SetSingleClick, stored=false, nodefault};
		
	__property TCPEventKind CPEventKind = {read=FCPEventKind, write=FCPEventKind, nodefault};
public:
	/* TWinControl.CreateParented */ __fastcall TRichView(HWND ParentWindow) : Rvscroll::TRVScroller(ParentWindow
		) { }
	
};

//-- var, const, procedure ---------------------------------------------------
#define rvsBreak (Shortint)(-1)
#define rvsCheckpoint (Shortint)(-2)
#define rvsPicture (Shortint)(-3)
#define rvsHotspot (Shortint)(-4)
#define rvsComponent (Shortint)(-5)
#define rvsBullet (Shortint)(-6)
#define rvsBack (Shortint)(-7)
#define rvdoALL (System::Set<TRVDisplayOption, rvdoImages, rvdoBullets> () << rvdoImages << rvdoComponents \
	<< rvdoBullets )
#define TagEmptyStr (char)(48)
#define RVFormatName "RichView Format"
#define gdlnFirstVisible (Byte)(1)
#define gdlnLastCompleteVisible (Byte)(2)
#define gdlnLastVisible (Byte)(3)
#define errRVTypesMismatch "Can't get or set this kind of information for this item"
extern PACKAGE void __fastcall InfoAboutSaD(TScreenAndDevice &sad, Graphics::TCanvas* Canvas);
extern PACKAGE void __fastcall Register(void);

}	/* namespace Richview */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Richview;
#endif
//-- end unit ----------------------------------------------------------------
#endif	// RichView
