// Borland C++ Builder
// Copyright (c) 1995, 1999 by Borland International
// All rights reserved

// (DO NOT EDIT: machine generated header) 'RichView.pas' rev: 4.00

#ifndef RichViewHPP
#define RichViewHPP

#pragma delphiheader begin
#pragma option push -w-
#include <Menus.hpp>	// Pascal unit
#include <Clipbrd.hpp>	// Pascal unit
#include <ImgList.hpp>	// Pascal unit
#include <jpeg.hpp>	// Pascal unit
#include <Commctrl.hpp>	// Pascal unit
#include <RVScroll.hpp>	// Pascal unit
#include <RVStyle.hpp>	// Pascal unit
#include <DLines.hpp>	// Pascal unit
#include <Forms.hpp>	// Pascal unit
#include <Controls.hpp>	// Pascal unit
#include <Graphics.hpp>	// Pascal unit
#include <Classes.hpp>	// Pascal unit
#include <SysUtils.hpp>	// Pascal unit
#include <Messages.hpp>	// Pascal unit
#include <Windows.hpp>	// Pascal unit
#include <SysInit.hpp>	// Pascal unit
#include <System.hpp>	// Pascal unit

//-- user supplied -----------------------------------------------------------

namespace Richview
{
//-- type declarations -------------------------------------------------------
class DELPHICLASS ERichViewError;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION ERichViewError : public Sysutils::Exception 
{
	typedef Sysutils::Exception inherited;
	
public:
	#pragma option push -w-inl
	/* Exception.Create */ inline __fastcall ERichViewError(const AnsiString Msg) : Sysutils::Exception(
		Msg) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmt */ inline __fastcall ERichViewError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size) : Sysutils::Exception(Msg, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateRes */ inline __fastcall ERichViewError(int Ident, Extended Dummy) : Sysutils::Exception(
		Ident, Dummy) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmt */ inline __fastcall ERichViewError(int Ident, const System::TVarRec * Args
		, const int Args_Size) : Sysutils::Exception(Ident, Args, Args_Size) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateHelp */ inline __fastcall ERichViewError(const AnsiString Msg, int AHelpContext)
		 : Sysutils::Exception(Msg, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateFmtHelp */ inline __fastcall ERichViewError(const AnsiString Msg, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Msg, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResHelp */ inline __fastcall ERichViewError(int Ident, int AHelpContext) : Sysutils::Exception(
		Ident, AHelpContext) { }
	#pragma option pop
	#pragma option push -w-inl
	/* Exception.CreateResFmtHelp */ inline __fastcall ERichViewError(int Ident, const System::TVarRec 
		* Args, const int Args_Size, int AHelpContext) : Sysutils::Exception(Ident, Args, Args_Size, AHelpContext
		) { }
	#pragma option pop
	
public:
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~ERichViewError(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TRVSaveFormat { rvsfText, rvsfHTML, rvsfRTF, rvsfRVF };
#pragma option pop

#pragma option push -b-
enum TRVSaveOption { rvsoOverrideImages };
#pragma option pop

typedef Set<TRVSaveOption, rvsoOverrideImages, rvsoOverrideImages>  TRVSaveOptions;

#pragma option push -b-
enum TRVBreakStyle { rvbsLine, rvbsRectangle, rvbs3d };
#pragma option pop

class DELPHICLASS TRVCPInfo;
class DELPHICLASS TRVItemInfo;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVItemInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	short StyleNo;
	short ParaNo;
	Byte SameAsPrev;
	int imgNo;
	Classes::TPersistent* gr;
	int Tag;
	TRVCPInfo* Checkpoint;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVItemInfo(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVItemInfo(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVCPInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	AnsiString Name;
	int DrawLineNo;
	TRVCPInfo* Next;
	TRVCPInfo* Prev;
	Byte RaiseEvent;
	TRVItemInfo* ItemInfo;
	int Tag;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVCPInfo(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVCPInfo(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

typedef void *TCheckpointData;

class DELPHICLASS TRVJumpInfo;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVJumpInfo : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int l;
	int t;
	int w;
	int h;
	int id;
	int DrawLineNo;
	Controls::TCursor Cursor;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVJumpInfo(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVJumpInfo(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

typedef void __fastcall (__closure *TJumpEvent)(System::TObject* Sender, int id);

typedef void __fastcall (__closure *TRVMouseMoveEvent)(System::TObject* Sender, int id);

class DELPHICLASS TRichView;
typedef void __fastcall (__closure *TRVSaveComponentToFileEvent)(TRichView* Sender, AnsiString Path, 
	Classes::TPersistent* SaveMe, TRVSaveFormat SaveFormat, AnsiString &OutStr);

typedef void __fastcall (__closure *TRVURLNeededEvent)(TRichView* Sender, int id, AnsiString &url);

typedef void __fastcall (__closure *TRVDblClickEvent)(TRichView* Sender, AnsiString ClickedWord, int 
	Style);

typedef void __fastcall (__closure *TRVRightClickEvent)(TRichView* Sender, AnsiString ClickedWord, int 
	Style, int X, int Y);

typedef void __fastcall (__closure *TRVMouseEvent)(TRichView* Sender, Controls::TMouseButton Button, 
	Classes::TShiftState Shift, int ItemNo, int X, int Y);

typedef void __fastcall (__closure *TRVFPictureNeededEvent)(TRichView* Sender, AnsiString Name, int 
	Tag, Graphics::TGraphic* &gr);

typedef void __fastcall (__closure *TRVFControlNeededEvent)(TRichView* Sender, AnsiString Name, int 
	Tag, Controls::TControl* &ctrl);

typedef void __fastcall (__closure *TRVFImageListNeededEvent)(TRichView* Sender, int ImageListTag, Controls::TImageList* 
	&il);

typedef void __fastcall (__closure *TRVCheckpointVisibleEvent)(TRichView* Sender, TCheckpointData CheckpointData
	);

#pragma option push -b-
enum TRVVAlign { rvvaBaseline, rvvaMiddle };
#pragma option pop

#pragma option push -b-
enum TBackgroundStyle { bsNoBitmap, bsStretched, bsTiled, bsTiledAndScrolled, bsCentered };
#pragma option pop

#pragma option push -b-
enum TRVDisplayOption { rvdoImages, rvdoComponents, rvdoBullets };
#pragma option pop

typedef Set<TRVDisplayOption, rvdoImages, rvdoBullets>  TRVDisplayOptions;

#pragma pack(push, 4)
struct TScreenAndDevice
{
	int ppixScreen;
	int ppiyScreen;
	int ppixDevice;
	int ppiyDevice;
	int LeftMargin;
	int RightMargin;
} ;
#pragma pack(pop)

class DELPHICLASS TRVInteger2;
#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRVInteger2 : public System::TObject 
{
	typedef System::TObject inherited;
	
public:
	int val;
public:
	#pragma option push -w-inl
	/* TObject.Create */ inline __fastcall TRVInteger2(void) : System::TObject() { }
	#pragma option pop
	#pragma option push -w-inl
	/* TObject.Destroy */ inline __fastcall virtual ~TRVInteger2(void) { }
	#pragma option pop
	
};

#pragma pack(pop)

#pragma option push -b-
enum TRVState { rvstClickedBeyondLine, rvstMakingSelection, rvstDrawHover, rvstSkipFormatting, rvstFormatParas 
	};
#pragma option pop

typedef Set<TRVState, rvstClickedBeyondLine, rvstFormatParas>  TRVStates;

#pragma option push -b-
enum TRVFlag { rvflUseJumps, rvflTrim, rvflShareContents, rvflUseExternalLeading };
#pragma option pop

typedef Set<TRVFlag, rvflUseJumps, rvflUseExternalLeading>  TRVFlags;

#pragma option push -b-
enum TRVOption { rvoAllowSelection, rvoSingleClick, rvoScrollToEnd, rvoClientTextWidth, rvoShowCheckpoints, 
	rvoTagsArePChars, rvoAutoCopyText, rvoAutoCopyRVF, rvoAutoCopyImage, rvoFormatInvalidate };
#pragma option pop

typedef Set<TRVOption, rvoAllowSelection, rvoFormatInvalidate>  TRVOptions;

#pragma option push -b-
enum TCPEventKind { cpeNone, cpeAsSectionStart, cpeWhenVisible };
#pragma option pop

#pragma option push -b-
enum TRVFOption { rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoIgnoreUnknownPicFmt, rvfoIgnoreUnknownCtrls, 
	rvfoConvUnknownStylesToZero, rvfoConvLargeImageIdxToZero, rvfoSaveBinary };
#pragma option pop

typedef Set<TRVFOption, rvfoSavePicturesBody, rvfoSaveBinary>  TRVFOptions;

#pragma option push -b-
enum TRVFWarning { rvfwUnknownPicFmt, rvfwUnknownCtrls, rvfwConvUnknownStyles, rvfwConvLargeImageIdx 
	};
#pragma option pop

typedef Set<TRVFWarning, rvfwUnknownPicFmt, rvfwConvLargeImageIdx>  TRVFWarnings;

#pragma option push -b-
enum TRVSearchOption { rvsroMatchCase };
#pragma option pop

typedef Set<TRVSearchOption, rvsroMatchCase, rvsroMatchCase>  TRVSearchOptions;

#pragma pack(push, 4)
class PASCALIMPLEMENTATION TRichView : public Rvscroll::TRVScroller 
{
	typedef Rvscroll::TRVScroller inherited;
	
private:
	Controls::TCursor FCursor;
	TRVOptions FOptions;
	int VScrollDelta;
	int HScrollDelta;
	bool ScrollTimerActive;
	AnsiString FDelimiters;
	TJumpEvent FOnJump;
	TRVMouseMoveEvent FOnRVMouseMove;
	TRVSaveComponentToFileEvent FOnSaveComponentToFile;
	TRVURLNeededEvent FOnURLNeeded;
	TRVDblClickEvent FOnRVDblClick;
	TRVRightClickEvent FOnRVRightClick;
	TRVMouseEvent FOnRVMouseUp;
	TRVMouseEvent FOnRVMouseDown;
	TCPEventKind FCPEventKind;
	TRVFPictureNeededEvent FOnRVFPictureNeeded;
	TRVFControlNeededEvent FOnRVFControlNeeded;
	TRVFImageListNeededEvent FOnRVFImageListNeeded;
	TRVCheckpointVisibleEvent FOnCheckpointVisible;
	int FFirstJumpNo;
	int FMaxTextWidth;
	int FMinTextWidth;
	int FLeftMargin;
	int FRightMargin;
	Graphics::TBitmap* FBackBitmap;
	TBackgroundStyle FBackgroundStyle;
	TRVFOptions FRVFOptions;
	TRVFWarnings FRVFWarnings;
	TRVCPInfo* LastRaisedCP;
	HIDESBASE MESSAGE void __fastcall WMSize(Messages::TWMSize &Message);
	HIDESBASE MESSAGE void __fastcall WMEraseBkgnd(Messages::TWMEraseBkgnd &Message);
	HIDESBASE MESSAGE void __fastcall CMMouseLeave(Messages::TMessage &Message);
	MESSAGE void __fastcall WMCopy(Messages::TWMNoParams &Message);
	MESSAGE void __fastcall WMTimer(Messages::TWMTimer &Message);
	HIDESBASE MESSAGE void __fastcall WMDestroy(Messages::TWMNoParams &Message);
	void __fastcall InvalidateJumpRect(int no);
	int __fastcall FindDrawItemAtPos(int X, int Y);
	int __fastcall GetLineCount(void);
	bool __fastcall GetAllowSelection(void);
	bool __fastcall GetSingleClick(void);
	void __fastcall SetAllowSelection(const bool Value);
	void __fastcall SetSingleClick(const bool Value);
	void __fastcall CopyText_(void);
	void __fastcall CopyRVF_(void);
	void __fastcall CopyImage_(void);
	void __fastcall DoOnBackBitmapChange(System::TObject* Sender);
	void __fastcall DoOnDebFormPaint(System::TObject* Sender);
	void __fastcall DoOnDebFormCloseQuery(System::TObject* Sender, bool &CanClose);
	
protected:
	Classes::TStringList* Lines;
	Dlines::TRVDrawLines* DrawLines;
	TRVDisplayOptions DisplayOptions;
	Classes::TNotifyEvent FOnSelect;
	TRVFlags Flags;
	TRVStates State;
	int FSelStartNo;
	int FSelEndNo;
	int FSelStartOffs;
	int FSelEndOffs;
	TRVCPInfo* FirstCP;
	TRVCPInfo* LastCP;
	TRVCPInfo* NotAddedCP;
	int CPCount;
	Classes::TStringList* jumps;
	Rvstyle::TRVStyle* FStyle;
	int nJmps;
	TRVItemInfo* FActiveImage;
	int TextWidth;
	int TextHeight;
	int LastJumpMovedAbove;
	int LastDLMovedAbove;
	int LastLineFormatted;
	int LastJumpDowned;
	AnsiString imgSavePrefix;
	int imgSaveNo;
	TRVSaveOptions SaveOptions;
	Forms::TForm* __fastcall RVDebugForm(void);
	virtual void __fastcall Paint(void);
	int __fastcall FindDrawLineByLine(int ItemNo);
	virtual void __fastcall InsertFirstRVFItem(int &Index, const AnsiString s, TRVItemInfo* li, bool EditFlag
		);
	bool __fastcall InsertRVFFromStream_(Classes::TStream* Stream, int Index, int AParaNo, bool AppendMode
		, bool EditFlag);
	AnsiString __fastcall ReplaceTabs(const AnsiString s);
	int __fastcall GetBeforeLineOffs(int ItemNo);
	int __fastcall GetAfterLineOffs(int ItemNo);
	int __fastcall GetBeforeDrawLineOffs(int DrawLineNo);
	int __fastcall GetAfterDrawLineOffs(int DrawLineNo);
	Graphics::TColor __fastcall GetColor(void);
	Graphics::TColor __fastcall GetHoverColor(Graphics::TColor Color);
	bool __fastcall IsCopyShortcut(Classes::TShiftState Shift, Word Key);
	bool __fastcall IsCutShortcut(Classes::TShiftState Shift, Word Key);
	bool __fastcall IsPasteShortcut(Classes::TShiftState Shift, Word Key);
	int __fastcall ItemLength(int No);
	void __fastcall FreeCheckpoint(TRVCPInfo* &cp, bool AdjustLinks, bool DecCPCount);
	void __fastcall FreeLineObject(TRVItemInfo* li);
	void __fastcall SetCP(TRVItemInfo* li, TRVCPInfo* &PrevCP, TRVCPInfo* &CP);
	void __fastcall GetSelBounds(int &StartNo, int &EndNo, int &StartOffs, int &EndOffs, bool Normalize
		);
	void __fastcall StoreSelBounds(int &StartNo, int &EndNo, int &StartOffs, int &EndOffs, bool Normalize
		);
	void __fastcall RestoreSelBounds(int StartNo, int EndNo, int StartOffs, int EndOffs);
	DYNAMIC void __fastcall MouseMove(Classes::TShiftState Shift, int X, int Y);
	DYNAMIC void __fastcall MouseUp(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, int 
		Y);
	DYNAMIC void __fastcall MouseDown(Controls::TMouseButton Button, Classes::TShiftState Shift, int X, 
		int Y);
	DYNAMIC void __fastcall DblClick(void);
	DYNAMIC void __fastcall Click(void);
	DYNAMIC void __fastcall KeyDown(Word &Key, Classes::TShiftState Shift);
	void __fastcall FinishScreenLine(const TScreenAndDevice &sad, int LineWidth, int LastDrawLine, Byte 
		parafinished, Byte &dontdoit);
	void __fastcall NewFormatLine(const AnsiString LinesNo, int StartOffs, int no, int &x, int &baseline
		, int &prevdesc, int &prevabove, Graphics::TCanvas* Canvas, TScreenAndDevice &sad, bool &IsParaStart
		, int &LineWidth, int &FirstIndent, int &LastDrawLine, int &VerticalOffs, Byte &DontFSL, int &LastTextStyle
		);
	void __fastcall FormatWords(AnsiString LinesNo, int no, int &x, int &baseline, int &prevdesc, int &
		prevabove, Graphics::TCanvas* Canvas, TScreenAndDevice &sad, bool &IsParaStart, int &LineWidth, int 
		&FirstIndent, int &LastDrawLine, int &VerticalOffs, Byte &DontFSL, int &LastTextStyle);
	void __fastcall AdjustJumpsCoords(void);
	void __fastcall AdjustChildrenCoords(void);
	virtual void __fastcall ClearTemporal(void);
	int __fastcall GetFirstVisible(int TopLine);
	int __fastcall GetFirstItemVisible(void);
	int __fastcall GetLastItemVisible(void);
	int __fastcall GetDrawLineNo(int BoundLine, int Option);
	virtual void __fastcall Format_(bool OnlyResized, int depth, Graphics::TCanvas* Canvas, bool OnlyTail
		);
	void __fastcall SetBackBitmap(Graphics::TBitmap* Value);
	void __fastcall DrawBack(HDC DC, const Windows::TRect &Rect, int Width, int Height);
	void __fastcall SetBackgroundStyle(TBackgroundStyle Value);
	void __fastcall SetVSmallStep(int Value);
	virtual AnsiString __fastcall GetNextFileName(const AnsiString Path, const AnsiString Ext, bool OverrideFiles
		);
	void __fastcall ShareLinesFrom(TRichView* Source);
	bool __fastcall FindClickedWord(AnsiString &clickedword, int X, int Y, int &StyleNo, int &ItemNo);
	void __fastcall GetDrawLineBounds(int No, int &First, int &Last);
	void __fastcall FindDrawItemForSel(int X, int Y, int &No, int &Offs, bool isstart);
	virtual void __fastcall DoOnSelection(void);
	void __fastcall DrawLine2Line(int DrawLineNo, int DrawLineOffs, int &ItemNo, int &LineOffs);
	void __fastcall Line2DrawLine(int ItemNo, int LineOffs, int &DrawLineNo, int &DrawLineOffs);
	virtual void __fastcall Notification(Classes::TComponent* AComponent, Classes::TOperation Operation
		);
	int __fastcall GetNextLineNo(int no);
	int __fastcall GetPrevLineNo(int no);
	virtual void __fastcall Loaded(void);
	void __fastcall CopyTag(int SourceTag, int &Tag);
	bool __fastcall CompareTags(int Tag1, int Tag2);
	void __fastcall SetStyle(Rvstyle::TRVStyle* Value);
	int __fastcall CountItemWidth(TRVItemInfo* li);
	int __fastcall GetMaxTotalIndent(void);
	virtual void __fastcall GetSelStart(int &DLNo, int &DLOffs);
	virtual void __fastcall AfterVScroll(void);
	virtual void __fastcall AfterHScroll(void);
	void __fastcall InsertCheckpoint(int Index, int Tag, const AnsiString Name, bool RaiseEvent);
	int __fastcall GetMaxPictureWidth(void);
	
public:
	__fastcall virtual TRichView(Classes::TComponent* AOwner);
	__fastcall virtual ~TRichView(void);
	void __fastcall AddNL(const AnsiString s, int StyleNo, int ParaNo);
	void __fastcall AddFmt(const AnsiString FormatStr, const System::TVarRec * Args, const int Args_Size
		, int StyleNo, int ParaNo);
	void __fastcall Add(const AnsiString s, int StyleNo);
	void __fastcall AddTextNL(AnsiString s, int StyleNo, int FirstParaNo, int OtherParaNo);
	void __fastcall AddBreak(void);
	int __fastcall AddCheckpoint(void);
	int __fastcall AddNamedCheckpoint(AnsiString CpName);
	int __fastcall AddNamedCheckpointEx(const AnsiString CpName, bool RaiseEvent);
	void __fastcall AddPictureEx(const AnsiString Name, Graphics::TGraphic* gr, int ParaNo, TRVVAlign VAlign
		);
	void __fastcall AddHotspotEx(const AnsiString Name, int ImageIndex, int HotImageIndex, Controls::TImageList* 
		ImageList, int ParaNo);
	void __fastcall AddBulletEx(const AnsiString Name, int ImageIndex, Controls::TImageList* ImageList, 
		int ParaNo);
	void __fastcall AddControlEx(const AnsiString Name, Controls::TControl* ctrl, int ParaNo, TRVVAlign 
		VAlign);
	void __fastcall AddBreakEx(Byte Width, TRVBreakStyle Style, Graphics::TColor Color);
	void __fastcall AddNLTag(AnsiString s, int StyleNo, int ParaNo, int Tag);
	void __fastcall AddTag(const AnsiString s, int StyleNo, int Tag);
	void __fastcall AddBreakTag(int Tag);
	int __fastcall AddCheckpointTag(int Tag);
	int __fastcall AddNamedCheckpointExTag(const AnsiString CpName, bool RaiseEvent, int Tag);
	void __fastcall AddPictureExTag(const AnsiString Name, Graphics::TGraphic* gr, int ParaNo, TRVVAlign 
		VAlign, int Tag);
	void __fastcall AddHotspotExTag(const AnsiString Name, int ImageIndex, int HotImageIndex, Controls::TImageList* 
		ImageList, int ParaNo, int Tag);
	void __fastcall AddBulletExTag(const AnsiString Name, int ImageIndex, Controls::TImageList* ImageList
		, int ParaNo, int Tag);
	void __fastcall AddControlExTag(const AnsiString Name, Controls::TControl* ctrl, int ParaNo, TRVVAlign 
		VAlign, int Tag);
	void __fastcall AddBreakExTag(Byte Width, TRVBreakStyle Style, Graphics::TColor Color, int Tag);
	void __fastcall AddFromNewLine(const AnsiString s, int StyleNo);
	void __fastcall AddCenterLine(const AnsiString s, int StyleNo);
	void __fastcall AddText(const AnsiString s, int StyleNo);
	void __fastcall AddTextFromNewLine(const AnsiString s, int StyleNo);
	void __fastcall AddPicture(Graphics::TGraphic* gr);
	void __fastcall AddHotspot(int ImageIndex, Controls::TImageList* ImageList, bool fromnewline);
	void __fastcall AddBullet(int ImageIndex, Controls::TImageList* ImageList, bool fromnewline);
	void __fastcall AddControl(Controls::TControl* ctrl, bool center);
	int __fastcall GetCheckpointY(int no);
	TCheckpointData __fastcall GetFirstCheckpoint(void);
	TCheckpointData __fastcall GetNextCheckpoint(TCheckpointData CheckpointData);
	TCheckpointData __fastcall GetItemCheckpoint(int ItemNo);
	TCheckpointData __fastcall FindCheckpointByName(const AnsiString Name);
	TCheckpointData __fastcall FindCheckpointByTag(int Tag);
	TCheckpointData __fastcall GetCheckpointByNo(int No);
	void __fastcall GetCheckpointInfo(TCheckpointData CheckpointData, int &Tag, AnsiString &Name, bool 
		&RaiseEvent);
	void __fastcall GetCheckpointXY(TCheckpointData CheckpointData, int &X, int &Y);
	int __fastcall GetCheckpointYEx(TCheckpointData CheckpointData);
	int __fastcall GetCheckpointItemNo(TCheckpointData CheckpointData);
	int __fastcall GetCheckpointNo(TCheckpointData CheckpointData);
	int __fastcall GetJumpPointY(int id);
	int __fastcall GetJumpPointItemNo(int id);
	virtual void __fastcall Clear(void);
	void __fastcall Format(void);
	void __fastcall FormatTail(void);
	void __fastcall AppendFrom(TRichView* Source);
	__property int VSmallStep = {read=SmallStep, write=SetVSmallStep, nodefault};
	bool __fastcall SaveHTMLEx(const AnsiString FileName, const AnsiString Title, const AnsiString ImagesPrefix
		, const AnsiString ExtraStyles, const AnsiString ExternalCSS, AnsiString CPPrefix, TRVSaveOptions 
		Options);
	bool __fastcall SaveHTML(const AnsiString FileName, const AnsiString Title, const AnsiString ImagesPrefix
		, TRVSaveOptions Options);
	bool __fastcall SaveText(const AnsiString FileName, int LineWidth);
	bool __fastcall LoadText(const AnsiString FileName, int StyleNo, int ParaNo);
	bool __fastcall LoadRVFFromStream(Classes::TStream* Stream);
	bool __fastcall InsertRVFFromStream(Classes::TStream* Stream, int Index);
	bool __fastcall AppendRVFFromStream(Classes::TStream* Stream, int ParaNo);
	bool __fastcall LoadRVF(const AnsiString FileName);
	bool __fastcall SaveRVFToStream(Classes::TStream* Stream, bool SelectionOnly);
	bool __fastcall SaveRVF(const AnsiString FileName, bool SelectionOnly);
	void __fastcall CopyRVF(void);
	void __fastcall DeleteSection(const AnsiString CpName);
	void __fastcall DeleteLines(int FirstItemNo, int Count);
	virtual AnsiString __fastcall SavePicture(TRVSaveFormat DocumentSaveFormat, const AnsiString Path, 
		Graphics::TGraphic* gr);
	void __fastcall CopyText(void);
	void __fastcall CopyImage(void);
	void __fastcall Copy(void);
	bool __fastcall CopyDef(void);
	Graphics::TGraphic* __fastcall GetSelectedImage(void);
	AnsiString __fastcall GetSelText(void);
	bool __fastcall SelectionExists(void);
	void __fastcall Deselect(void);
	void __fastcall SelectAll(void);
	bool __fastcall SearchText(AnsiString s, TRVSearchOptions SrchOptions);
	int __fastcall GetItemStyle(int ItemNo);
	void __fastcall GetBreakInfo(int ItemNo, Byte &AWidth, TRVBreakStyle &AStyle, Graphics::TColor &AColor
		, int &ATag);
	void __fastcall GetBulletInfo(int ItemNo, AnsiString &AName, int &AImageIndex, Controls::TImageList* 
		&AImageList, int &ATag);
	void __fastcall GetHotspotInfo(int ItemNo, AnsiString &AName, int &AImageIndex, int &AHotImageIndex
		, Controls::TImageList* &AImageList, int &ATag);
	void __fastcall GetPictureInfo(int ItemNo, AnsiString &AName, Graphics::TGraphic* &Agr, TRVVAlign &
		AVAlign, int &ATag);
	void __fastcall GetControlInfo(int ItemNo, AnsiString &AName, Controls::TControl* &Actrl, TRVVAlign 
		&AVAlign, int &ATag);
	void __fastcall GetTextInfo(int ItemNo, AnsiString &AText, int &ATag);
	int __fastcall GetItemTag(int ItemNo);
	bool __fastcall IsParaStart(int ItemNo);
	void __fastcall SetBreakInfo(int ItemNo, Byte AWidth, TRVBreakStyle AStyle, Graphics::TColor AColor
		, int ATag);
	void __fastcall SetBulletInfo(int ItemNo, const AnsiString AName, int AImageIndex, Controls::TImageList* 
		AImageList, int ATag);
	void __fastcall SetHotspotInfo(int ItemNo, const AnsiString AName, int AImageIndex, int AHotImageIndex
		, Controls::TImageList* AImageList, int ATag);
	bool __fastcall SetPictureInfo(int ItemNo, const AnsiString AName, Graphics::TGraphic* Agr, TRVVAlign 
		AVAlign, int ATag);
	bool __fastcall SetControlInfo(int ItemNo, const AnsiString AName, TRVVAlign AVAlign, int ATag);
	void __fastcall SetItemTag(int ItemNo, int ATag);
	void __fastcall SetCheckpointInfo(int ItemNo, int ATag, const AnsiString AName, bool ARaiseEvent);
	bool __fastcall RemoveCheckpoint(int ItemNo);
	int __fastcall FindControlItemNo(Controls::TControl* actrl);
	void __fastcall GetSelectionBounds(int &StartItemNo, int &StartItemOffs, int &EndItemNo, int &EndItemOffs
		, bool Normalize);
	void __fastcall SetSelectionBounds(int StartItemNo, int StartItemOffs, int EndItemNo, int EndItemOffs
		);
	void __fastcall GetWordAt(int X, int Y, int &ItemNo, AnsiString &Word);
	__property int LineCount = {read=GetLineCount, nodefault};
	__property int ItemCount = {read=GetLineCount, nodefault};
	__property int FirstItemVisible = {read=GetFirstItemVisible, nodefault};
	__property int LastItemVisible = {read=GetLastItemVisible, nodefault};
	__property TRVFWarnings RVFWarnings = {read=FRVFWarnings, nodefault};
	__property int DocumentHeight = {read=TextHeight, nodefault};
	
__published:
	__property Tracking ;
	__property VScrollVisible ;
	__property OnVScrolled ;
	__property Controls::TCursor Cursor = {read=FCursor, write=FCursor, nodefault};
	__property TRVOptions Options = {read=FOptions, write=FOptions, nodefault};
	__property Anchors ;
	__property Constraints ;
	__property Color ;
	__property PopupMenu ;
	__property OnClick ;
	__property OnKeyDown ;
	__property OnKeyUp ;
	__property OnKeyPress ;
	__property int FirstJumpNo = {read=FFirstJumpNo, write=FFirstJumpNo, nodefault};
	__property TJumpEvent OnJump = {read=FOnJump, write=FOnJump};
	__property TRVMouseMoveEvent OnRVMouseMove = {read=FOnRVMouseMove, write=FOnRVMouseMove};
	__property TRVSaveComponentToFileEvent OnSaveComponentToFile = {read=FOnSaveComponentToFile, write=
		FOnSaveComponentToFile};
	__property TRVURLNeededEvent OnURLNeeded = {read=FOnURLNeeded, write=FOnURLNeeded};
	__property TRVDblClickEvent OnRVDblClick = {read=FOnRVDblClick, write=FOnRVDblClick};
	__property TRVRightClickEvent OnRVRightClick = {read=FOnRVRightClick, write=FOnRVRightClick};
	__property TRVMouseEvent OnRVMouseUp = {read=FOnRVMouseUp, write=FOnRVMouseUp};
	__property TRVMouseEvent OnRVMouseDown = {read=FOnRVMouseDown, write=FOnRVMouseDown};
	__property TRVCheckpointVisibleEvent OnCheckpointVisible = {read=FOnCheckpointVisible, write=FOnCheckpointVisible
		};
	__property Classes::TNotifyEvent OnSelect = {read=FOnSelect, write=FOnSelect};
	__property TRVFPictureNeededEvent OnRVFPictureNeeded = {read=FOnRVFPictureNeeded, write=FOnRVFPictureNeeded
		};
	__property TRVFControlNeededEvent OnRVFControlNeeded = {read=FOnRVFControlNeeded, write=FOnRVFControlNeeded
		};
	__property TRVFImageListNeededEvent OnRVFImageListNeeded = {read=FOnRVFImageListNeeded, write=FOnRVFImageListNeeded
		};
	__property Rvstyle::TRVStyle* Style = {read=FStyle, write=SetStyle};
	__property int MaxTextWidth = {read=FMaxTextWidth, write=FMaxTextWidth, nodefault};
	__property int MinTextWidth = {read=FMinTextWidth, write=FMinTextWidth, nodefault};
	__property int LeftMargin = {read=FLeftMargin, write=FLeftMargin, nodefault};
	__property int RightMargin = {read=FRightMargin, write=FRightMargin, nodefault};
	__property Graphics::TBitmap* BackgroundBitmap = {read=FBackBitmap, write=SetBackBitmap};
	__property TBackgroundStyle BackgroundStyle = {read=FBackgroundStyle, write=SetBackgroundStyle, nodefault
		};
	__property AnsiString Delimiters = {read=FDelimiters, write=FDelimiters};
	__property TRVFOptions RVFOptions = {read=FRVFOptions, write=FRVFOptions, nodefault};
	__property bool AllowSelection = {read=GetAllowSelection, write=SetAllowSelection, stored=false, nodefault
		};
	__property bool SingleClick = {read=GetSingleClick, write=SetSingleClick, stored=false, nodefault};
		
	__property TCPEventKind CPEventKind = {read=FCPEventKind, write=FCPEventKind, nodefault};
public:
	#pragma option push -w-inl
	/* TWinControl.CreateParented */ inline __fastcall TRichView(HWND ParentWindow) : Rvscroll::TRVScroller(
		ParentWindow) { }
	#pragma option pop
	
};

#pragma pack(pop)

//-- var, const, procedure ---------------------------------------------------
static const Shortint rvsBreak = 0xffffffff;
static const Shortint rvsCheckpoint = 0xfffffffe;
static const Shortint rvsPicture = 0xfffffffd;
static const Shortint rvsHotspot = 0xfffffffc;
static const Shortint rvsComponent = 0xfffffffb;
static const Shortint rvsBullet = 0xfffffffa;
static const Shortint rvsBack = 0xfffffff9;
#define rvdoALL (System::Set<TRVDisplayOption, rvdoImages, rvdoBullets> () << rvdoImages << rvdoComponents \
	<< rvdoBullets )
static const char TagEmptyStr = '\x30';
#define RVFormatName "RichView Format"
static const Shortint gdlnFirstVisible = 0x1;
static const Shortint gdlnLastCompleteVisible = 0x2;
static const Shortint gdlnLastVisible = 0x3;
#define errRVTypesMismatch "Can't get or set this kind of information for this item"
extern PACKAGE void __fastcall InfoAboutSaD(TScreenAndDevice &sad, Graphics::TCanvas* Canvas);
extern PACKAGE void __fastcall Register(void);

}	/* namespace Richview */
#if !defined(NO_IMPLICIT_NAMESPACE_USE)
using namespace Richview;
#endif
#pragma option pop	// -w-

#pragma delphiheader end.
//-- end unit ----------------------------------------------------------------
#endif	// RichView
