unit CtrlImg;

interface
uses Windows, Classes, Controls, StdCtrls, Graphics, Forms, SysUtils;

function DrawButton(ctrl: TButton): TBitmap;
function DrawEdit(ctrl: TEdit): TBitmap;
function DrawMemo(ctrl: TMemo): TBitmap;

implementation
{------------------------------------------------------------------}
function AllocBmp(ctrl: TControl): TBitmap;
begin
  Result        := TBitmap.Create;
  Result.Width  := ctrl.Width;
  Result.Height := ctrl.Height;
end;
{------------------------------------------------------------------}
function DrawButton(ctrl: TButton): TBitmap;
var r: TRect;
begin
  Result := AllocBmp(ctrl);
  r := Rect(0,0,ctrl.Width,ctrl.Height);
  with Result.Canvas do begin
    DrawFrameControl(Handle, r, DFC_BUTTON, DFCS_BUTTONPUSH);
    Font := ctrl.Font;
    Brush.Style := bsClear;
    DrawText(Handle, PChar(ctrl.Caption),-1,
             r, DT_CENTER or DT_VCENTER or DT_SINGLELINE);
  end;
end;
{------------------------------------------------------------------}
procedure DrawEditBack(Canvas: TCanvas; var r: TRect; Color: TColor;
                       Ctl3D, Border: Boolean);
begin
  with Canvas do begin
    Brush.Color := Color;
    FillRect(r);
    if Border then
      if Ctl3D then
        DrawEdge(Handle, r, EDGE_SUNKEN, BF_RECT or BF_ADJUST)
      else
        begin
          with r do Rectangle(Left,Top,Right,Bottom);
          InflateRect(r,-1,-1);
        end;
    InflateRect(r,-1,-1);
  end;
end;
{------------------------------------------------------------------}
function DrawEdit(ctrl: TEdit): TBitmap;
var r: TRect;
begin
  Result := AllocBmp(ctrl);
  r := Rect(0,0,ctrl.Width,ctrl.Height);
  with Result.Canvas do begin
    DrawEditBack(Result.Canvas, r, ctrl.Color, ctrl.Ctl3D,
                 ctrl.BorderStyle = bsSingle);
    Font := ctrl.Font;
    DrawText(Handle, PChar(ctrl.Text),-1,
             r, DT_LEFT or DT_SINGLELINE or DT_EDITCONTROL);
  end;
end;
{------------------------------------------------------------------}
function DrawMemo(ctrl: TMemo): TBitmap;
var r: TRect;
begin
  Result := AllocBmp(ctrl);
  r := Rect(0,0,ctrl.Width,ctrl.Height);
  with Result.Canvas do begin
    DrawEditBack(Result.Canvas, r, ctrl.Color, ctrl.Ctl3D,
                 ctrl.BorderStyle = bsSingle);
    Font := ctrl.Font;
    DrawText(Handle, PChar(ctrl.Text),-1,
             r, DT_LEFT or DT_EDITCONTROL);
  end;
end;

end.
