/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagFOREACHARG: takes a specified Tag (ARG1) and resizes the taglist
 *                    so the former ARGs can be used by the specified Tag
 *
 * History: - Creation 12/02/98 nh
 *
 * Date:              12/02/98
 * @author nh
 * @version 1.0
 */
package com.delec.prep;
import java.util.*;
import java.io.*;

public class PRePTagFOREACHARG extends PRePTagCode
{

	/**
	 * Constructor
	 */
	public PRePTagFOREACHARG()
	{
		super("FOREACHARG");
	}

	/**
	 * @param PrintWriter writer to compile the tag to
	 * @param TagList where the tags are stored
	 */
	public void compile(Session session) 
	{
		PRePTag prepTag = session.getTagList().find("ARG1");
		if ( prepTag != null )
		{
			PRePTagCount prepTagCount = (PRePTagCount)session.getTagList().find("ARG0");
			if ( prepTagCount != null )
			{
				int iNumberOfArgs = prepTagCount.getIntValue();
				int iTagListSize = session.getTagList().size();

				session.getTagList().setSize(iTagListSize-(iNumberOfArgs+1)); //+1
				iTagListSize = session.getTagList().size();
				prepTagCount = (PRePTagCount)session.getTagList().find("ARG0");
				if ( prepTagCount != null )
				{
					iNumberOfArgs = prepTagCount.getIntValue();
					session.getTagList().setSize(iTagListSize);	// -1

					for ( int i = 1; i <= prepTagCount.getIntValue(); i++ )
					{
						PRePTag prepTagArg = session.getTagList().find("ARG"+i);
						PRePTagText prepTagText = new PRePTagText("dummy");
						prepTagText.setValue("{"+prepTag.getValue()+"::"+prepTagArg.getValue()+"}");
						prepTagText.compile(session);
					}
				}
				else
				{
					session.getExceptionList().addElement(new PRePException(this, "'no arguments defined!'")); 
				}
			}
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "'tag element is null'")); 
		}
	}
}



