/*
 *    The term 'program' used in the copyright and the license below means
 *    PReP Version 1.0 
 *
 *    Copyright (C) 1998, 1999 DELECis
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *    This copyright notice must appear in all copies and modifications.
 *
 *    Contact: prep@delec.com
 *
 *    Read the manual: http://www.delec.com/is/products/prep/manual/jprep/
 */

/**
 * PReP Version 1.0
 *
 * PRePTagObject: a tag which get a format order as argument and
 *                formats the value in this way
 *
 * @author nh
 * @version 1.0
 * @see PRePMain, TagList, PRePTag, PRePTagCode
 */
 
package com.delec.prep;
//import java.util.*;
import java.io.*;
import java.sql.*;
import java.text.*;

public class PRePTagObject extends PRePTag implements ExceptionHandler
{
	/**
	 * the value of the tag
	 */
	Object value;

	/**
	 * Session for the Exception Handler
	 */
	Session sessExp;

	/**
	 * @param String tag name
	 */
	public PRePTagObject(String sTagName)
	{
		super(sTagName);
	}

	/**
	 * gets the value of the tag
	 * @return the value of the tag as a String
	 */
	public String getValue()
	{
		if ( this.value == null )
		{
			return "null";
		}
		return this.value.toString();
	}

	public String getAllValue()
	{
		return getValue();
	}

	/**
	 * gets the value of the tag (object)
	 * @return the value of the tag as an object
	 */
	public Object getObjectValue()
	{
		if ( this.value == null )
		{
			return "null";
		}
		return this.value;
	}

	/**
	 * sets the value of the tag
	 * @param int value to set
	 */
	public void setValue(int value)
	{
		this.value = new Integer(value);
	}

	/**
	 * sets the value of the tag
	 * @param double value to set
	 */
	public void setValue(double value)
	{
		this.value = new Double(value);
	}

	/**
	 * sets the value of the tag
	 * @param Object value to set
	 */
	public void setValue(Object value)
	{
		if ( value == null )
		{
			value = "null";
		}
		this.value = value;
	}

	public void setValue(float value)
	{
		this.value = new Float(value);
	}

	public void setValue(char value)
	{
		this.value = new Character(value);
	}

	/**
	 * formats the output as specified
	 * @param PrintWriter 
	 * @param String defines the format
	 */
	public void format(PrintWriter pwriter, String strFormat, ExceptionHandler exceptionHandler)
	{
		if ( value instanceof Integer )
		{
 
			Integer iValue = (Integer)value;
			if ( strFormat == null )
			{
				strFormat = "%i";
			}
			Format.print(pwriter, strFormat, iValue.intValue(), exceptionHandler);
		}
		else if ( value instanceof Double )
		{

			Double dValue = (Double)value;
			if ( strFormat == null )
			{
				strFormat = "%d";
			}
			Format.print(pwriter, strFormat, dValue.doubleValue(), exceptionHandler);
		}

		else if ( value instanceof Timestamp )
		{
			SimpleDateFormat simpleDateFormat;

			if ( strFormat != null )
			{
				strFormat = strFormat.substring(1);	//drop the % sign
				simpleDateFormat = new SimpleDateFormat(strFormat);
			}
			else
			{
				simpleDateFormat = new SimpleDateFormat();
			}

			String strFormattedDate = simpleDateFormat.format(value);
			pwriter.print(strFormattedDate);
		}

		else if ( value instanceof String )
		{

			String strValue = (String)value;
			if ( strValue.equals("null") )
			{
				strFormat = "%s";
			}

			else if ( strValue.equals("unknown") )
			{
				strFormat = "%s";
			}

			if ( strFormat == null )
			{
				strFormat = "%s";
			}
			Format.print(pwriter, strFormat, strValue.toString(), exceptionHandler);
		}
		else if ( value instanceof Character )
		{

			Character chValue = (Character)value;
			if ( strFormat == null )
			{
				strFormat = "%s";
			}
			Format.print(pwriter, strFormat, chValue.charValue(), exceptionHandler);
		}
		else if ( value instanceof Float )
		{

			Float flValue = (Float)value;
			if ( strFormat == null )
			{
				strFormat = "%f";
			}
			Format.print(pwriter, strFormat, flValue.floatValue(), exceptionHandler);
		}
		else
		{

			if ( value != null )
			{
				pwriter.print(value.toString());
			}
			else
			{
				pwriter.print("null");
			}
		}
	}

	/**
	  * @param Session contains TagList and PrintWriter 
	 **/
	public void compile(Session session)
	{

		sessExp = session;
		ExceptionHandler exceptionHandler = this;
		PRePTag tagNewValue = session.getTagList().find("ARG1"); 
		String strNewValue = "";
		PrintWriter pWriter = session.getPrintWriter();
		if ( tagNewValue != null )
		{
			strNewValue = tagNewValue.getValue();

			if ( strNewValue.equals("compile") )
			{
				PRePTagText ptt = new PRePTagText("dummy");
				ptt.setValue(value.toString());
				ptt.compile(session);
			}
			else if ( !strNewValue.startsWith("%") )
			{
				strNewValue = null;
				format(pWriter, strNewValue, exceptionHandler);
			}
			else
			{
				format(pWriter, strNewValue, exceptionHandler);
			}
		}
		else
		{
			session.getExceptionList().addElement(new PRePException(this, "argument not valid", 2));
		}
	}

	public void handleException(Exception exception)
	{
		if ( !(sessExp.getExceptionList().contains(new PRePException(this, getName()+" "+exception))) )
		{
			sessExp.getExceptionList().addElement(new PRePException(this, getName()+" "+exception));
		}
	}
}
