/*
 * Decompiled with CFR 0.152.
 */
package Sav.Interpreter;

import Sav.Interpreter.About;
import Sav.Interpreter.Correction;
import Sav.Interpreter.HAdvices;
import Sav.Interpreter.HPrepare;
import Sav.Interpreter.History;
import Sav.Interpreter.Message;
import Sav.Interpreter.Report;
import Sav.Navigator.VClass;
import Sav.Processor.Concept;
import Sav.Processor.PList;
import Sav.Z.DBConnection;
import Sav.Z.Fielder;
import Sav.Z.Interface;
import Sav.Z.Statement;
import Sav.Z.Warning;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import java.util.StringTokenizer;
import symantec.itools.awt.StatusBar;

public class Entry
extends Frame
implements Interface {
    DBConnection dbc;
    String dbPath;
    String entryText;
    PList statements;
    int errCount;
    int failCount;
    int excCount;
    int[] wPosition;
    Message message;
    Correction correction;
    Report report;
    History history;
    String fileSeparator;
    String dirName;
    String fileName = "Entry.z";
    int executedPosition;
    int analysedPosition;
    StatusBar sbEntryLine;
    int iEntryLine;
    HAdvices adv;
    HPrepare prep;
    Dimension dim;
    FileDialog saveFileDialog = new FileDialog(this);
    FileDialog openFileDialog = new FileDialog(this);
    TextArea textArea = new TextArea();
    Panel panel1 = new Panel();
    StatusBar sbProcess = new StatusBar();
    StatusBar sbDataBase = new StatusBar();
    MenuBar mainMenuBar = new MenuBar();
    Menu mFile = new Menu();
    MenuItem miNew = new MenuItem();
    MenuItem miOpen = new MenuItem();
    MenuItem miSave = new MenuItem();
    MenuItem miSaveAs = new MenuItem();
    MenuItem miSaveHistoryAs = new MenuItem();
    MenuItem miExit = new MenuItem();
    Menu mScript = new Menu();
    MenuItem miAnalyze = new MenuItem();
    MenuItem miExecute = new MenuItem();
    MenuItem miInsert = new MenuItem();
    Menu mTools = new Menu();
    MenuItem miNavigate = new MenuItem();
    Menu mHelp = new Menu();
    MenuItem miHAdvice = new MenuItem();
    MenuItem miHPrepare = new MenuItem();
    MenuItem miAbout = new MenuItem();

    public Entry() throws IOException {
        this("Common.ass");
    }

    public Entry(String string) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Properties properties = new Properties(System.getProperties());
        this.fileSeparator = properties.getProperty("file.separator");
        this.adv = new HAdvices((Frame)this, false);
        this.prep = new HPrepare((Frame)this, false);
        this.setLayout(new BorderLayout(0, 0));
        ((Component)this).setBackground(Color.white);
        this.setFont(new Font("Courier", 0, 12));
        ((Component)this).setSize(380, 190);
        ((Component)this).setVisible(false);
        this.saveFileDialog.setMode(1);
        ((Dialog)this.saveFileDialog).setTitle("Entry Save");
        this.openFileDialog.setMode(0);
        ((Dialog)this.openFileDialog).setTitle("Entry Open");
        this.add("Center", this.textArea);
        this.textArea.setFont(new Font("Courier", 0, 12));
        this.textArea.setBounds(0, 0, 380, 170);
        this.panel1.setLayout(null);
        this.add("South", this.panel1);
        this.panel1.setBackground(Color.lightGray);
        this.panel1.setFont(new Font("Dialog", 0, 11));
        this.panel1.setBounds(0, 170, 380, 20);
        try {
            this.sbProcess.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbProcess.setIPadBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbProcess.setBorderColor(Color.lightGray);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbProcess.setPaddingRight(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbProcess.setPaddingBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbProcess.setPaddingTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbProcess.setIPadTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbProcess.setPaddingLeft(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.panel1.add(this.sbProcess);
        this.sbProcess.setBounds(0, 0, 140, 20);
        try {
            this.sbDataBase.setBevelStyle(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbDataBase.setIPadBottom(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbDataBase.setBorderColor(Color.lightGray);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbDataBase.setPaddingRight(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbDataBase.setPaddingBottom(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbDataBase.setPaddingTop(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbDataBase.setIPadTop(0);
        }
        catch (PropertyVetoException propertyVetoException) {}
        try {
            this.sbDataBase.setPaddingLeft(1);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.panel1.add(this.sbDataBase);
        this.sbDataBase.setFont(new Font("Dialog", 0, 11));
        this.sbDataBase.setBounds(140, 0, 232, 20);
        this.setTitle("Sav Z Interpreter - " + this.fileName);
        this.mFile.setLabel("File");
        this.mFile.add(this.miNew);
        this.miNew.setLabel("New");
        this.mFile.add(this.miOpen);
        this.miOpen.setLabel("Open...");
        this.mFile.add(this.miSave);
        this.miSave.setLabel("Save");
        this.mFile.add(this.miSaveAs);
        this.miSaveAs.setLabel("Save As...");
        this.mFile.addSeparator();
        this.mFile.add(this.miSaveHistoryAs);
        this.miSaveHistoryAs.setLabel("Save History As...");
        this.mFile.addSeparator();
        this.mFile.add(this.miExit);
        this.miExit.setLabel("Exit");
        this.mainMenuBar.add(this.mFile);
        this.mScript.setLabel("Script");
        this.mScript.add(this.miAnalyze);
        this.miAnalyze.setLabel("Analyze Syntax (F11)");
        this.mScript.add(this.miExecute);
        this.miExecute.setLabel("Execute Statements (F12)");
        this.mScript.addSeparator();
        this.mScript.add(this.miInsert);
        this.miInsert.setLabel("Insert Fragment...");
        this.mainMenuBar.add(this.mScript);
        this.mTools.setLabel("Tools");
        this.mTools.add(this.miNavigate);
        this.miNavigate.setLabel("Database Navigator");
        this.mainMenuBar.add(this.mTools);
        this.mHelp.setLabel("Help");
        this.mHelp.add(this.miHAdvice);
        this.miHAdvice.setLabel("General Advices");
        this.mHelp.add(this.miHPrepare);
        this.miHPrepare.setLabel("Prepare Navigation");
        this.mHelp.add(this.miAbout);
        this.miAbout.setLabel("About Z Interpreter");
        this.mainMenuBar.add(this.mHelp);
        this.mainMenuBar.setHelpMenu(this.mHelp);
        this.setMenuBar(this.mainMenuBar);
        this.miNew.setShortcut(new MenuShortcut(78, false));
        this.miOpen.setShortcut(new MenuShortcut(79, false));
        this.miInsert.setShortcut(new MenuShortcut(73, false));
        this.miSave.setShortcut(new MenuShortcut(83, false));
        this.miSaveAs.setShortcut(new MenuShortcut(69, false));
        this.miSaveHistoryAs.setShortcut(new MenuShortcut(72, false));
        this.miExecute.setShortcut(new MenuShortcut(10, false));
        this.message = new Message((Frame)this, false);
        this.history = new History((Frame)this, false);
        this.report = new Report(this, false);
        this.correction = new Correction((Frame)this, false);
        MenuAction menuAction = new MenuAction();
        this.miNew.addActionListener(menuAction);
        this.miOpen.addActionListener(menuAction);
        this.miInsert.addActionListener(menuAction);
        this.miSave.addActionListener(menuAction);
        this.miSaveAs.addActionListener(menuAction);
        this.miSaveHistoryAs.addActionListener(menuAction);
        this.miExit.addActionListener(menuAction);
        this.miAnalyze.addActionListener(menuAction);
        this.miExecute.addActionListener(menuAction);
        this.miHAdvice.addActionListener(menuAction);
        this.miHPrepare.addActionListener(menuAction);
        this.miAbout.addActionListener(menuAction);
        this.miNavigate.addActionListener(menuAction);
        SymWindow symWindow = new SymWindow();
        this.addWindowListener(symWindow);
        KeyAdapter1 keyAdapter1 = new KeyAdapter1();
        this.textArea.addKeyListener(keyAdapter1);
        this.report.textArea.addKeyListener(keyAdapter1);
        this.history.textArea.addKeyListener(keyAdapter1);
        this.correction.textArea.addKeyListener(keyAdapter1);
        this.message.list.addKeyListener(keyAdapter1);
        this.openFileDialog.setDirectory(".");
        this.saveFileDialog.setDirectory(".");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        this.dim = toolkit.getScreenSize();
        if (this.dim.height >= 600 && this.dim.width >= 800) {
            n4 = this.history.getBounds().width;
            n3 = this.history.getBounds().height;
            n2 = this.dim.width - this.getBounds().width - n4;
            n = this.dim.height - n3 - this.report.getBounds().height - 30;
        } else {
            n2 = 0;
            n = 0;
            n4 = this.dim.width - this.getBounds().width;
            n3 = this.dim.height - this.report.getBounds().height - 30;
        }
        ((Component)this).setBounds(n2, n, this.getBounds().width, this.dim.height - n - this.message.getBounds().height - this.correction.getBounds().height - 30);
        ((Component)this.message).setLocation(n2, n + this.getBounds().height + 19);
        ((Component)this.correction).setLocation(n2, this.message.getBounds().y + this.message.getBounds().height);
        ((Component)this.history).setBounds(n2 + this.getBounds().width, n, n4, n3);
        ((Component)this.report).setBounds(this.history.getBounds().x, n + n3, n4, this.report.getBounds().height);
        ((Component)this.report).setVisible(true);
        ((Component)this.history).setVisible(true);
        ((Component)this.correction).setVisible(true);
        ((Component)this.message).setVisible(true);
        ((Component)this).setVisible(true);
        this.show();
        this.textArea.requestFocus();
        this.sbEntryLine = this.message.sbEntryLine;
        try {
            this.dbc = new DBConnection(string);
            this.dbPath = string = this.dbc.getBase().getPath();
            this.dbc.setStatusBar(this.message.sbDataLine);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.message.list.add(String.valueOf(String.valueOf(exception)) + ": Opening " + string);
            this.message.show();
            string = "Temporary.ass";
            new File(string).delete();
            this.dbc = new DBConnection(string);
            this.dbc.setStatusBar(this.message.sbDataLine);
        }
        try {
            if (string.length() > 40) {
                int n5 = string.length() - 40 + 3;
                this.sbDataBase.setStatusText("..." + string.substring(n5));
            } else {
                this.sbDataBase.setStatusText(string);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    void about_Action() {
        new About((Frame)this, true).show();
    }

    void addExceptionMessage(Exception exception, Statement statement) {
        String string;
        PList pList = statement.getExceptions();
        Warning warning = (Warning)pList.getFirst();
        while (warning != null) {
            ++this.excCount;
            string = String.valueOf(String.valueOf(exception)) + ": " + warning.message;
            this.message.list.add(string);
            warning = (Warning)pList.getNext();
        }
        if (exception != null) {
            ++this.excCount;
            string = String.valueOf(String.valueOf(exception)) + ": " + statement.toString();
            this.message.list.add(string);
        }
    }

    void advice_Action() {
        this.adv.show();
    }

    boolean analyseSyntax() {
        int n = this.entryText.length();
        Statement statement = null;
        int n2 = 1;
        this.setEntryLineStatus(n2);
        try {
            while (this.analysedPosition < n) {
                statement = this.dbc.createStatement(this.entryText, this.analysedPosition);
                statement.prepare();
                int n3 = statement.getBegin();
                while (this.analysedPosition < n3) {
                    if (statement.getScript().charAt(this.analysedPosition) == '\n') {
                        this.setEntryLineStatus(++n2);
                    }
                    ++this.analysedPosition;
                }
                statement.setNumber(n2);
                if (statement.getEnd() != statement.toBegin()) {
                    this.statements.add(statement);
                    if (!statement.getErrors().isEmpty()) {
                        ++this.errCount;
                        Warning warning = (Warning)statement.getErrors().getFirst();
                        String string = "Error: " + n2 + ": " + warning.message;
                        this.message.list.add(string);
                    }
                }
                ++this.analysedPosition;
                while (this.analysedPosition < statement.getEnd()) {
                    if (statement.getScript().charAt(this.analysedPosition) == '\n') {
                        ++n2;
                    }
                    ++this.analysedPosition;
                }
                statement = null;
            }
        }
        catch (Exception exception) {
            String string;
            ++this.errCount;
            ++this.excCount;
            exception.printStackTrace();
            if (statement == null) {
                string = this.entryText.length() - this.analysedPosition > 40 ? String.valueOf(this.entryText.substring(this.analysedPosition, 40)) + "..." : this.entryText.substring(this.analysedPosition);
            } else {
                this.statements.add(statement);
                statement.getExceptions().add(exception);
                string = statement.getEnd() - this.analysedPosition > 40 ? String.valueOf(this.entryText.substring(this.analysedPosition, 40)) + "..." : this.entryText.substring(this.analysedPosition, statement.getEnd());
            }
            this.message.list.add(String.valueOf(String.valueOf(exception)) + ": " + string);
            this.setEntryLineStatus();
            this.message.show();
            return false;
        }
        this.setEntryLineStatus();
        return true;
    }

    boolean analyse_Action() {
        this.entryText = new String(this.textArea.getText());
        this.statements = new PList();
        this.errCount = 0;
        this.failCount = 0;
        this.excCount = 0;
        this.message.list.removeAll();
        this.wPosition = null;
        this.correction.textArea.setText("");
        this.analysedPosition = 0;
        this.executedPosition = 0;
        try {
            this.sbProcess.setStatusText("Analysing ...");
            this.analyseSyntax();
            this.resumeAnalyse();
            this.sbProcess.setStatusText("");
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
        if (this.errCount != 0) {
            return false;
        }
        return this.statements.isEmpty() ^ true;
    }

    boolean executeStatement(Statement statement) throws IOException {
        PList pList;
        StringWriter stringWriter;
        statement.execute();
        if (!this.dbc.getBase().getPath().equals(this.dbPath)) {
            this.dbPath = this.dbc.getBase().getPath();
            try {
                if (this.dbPath.length() > 43) {
                    int n = this.dbPath.length() - 43 + 3;
                    this.sbDataBase.setStatusText("..." + this.dbPath.substring(n));
                } else {
                    this.sbDataBase.setStatusText(this.dbPath);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                propertyVetoException.printStackTrace();
            }
        }
        if ((stringWriter = this.dbc.getStringWriter()).getBuffer().length() != 0) {
            this.dbc.setStringWriter(new StringWriter());
            if (!this.dbc.isInterrupted()) {
                this.report.textArea.append(stringWriter.getBuffer().toString());
                ((Component)this.report).setVisible(true);
            }
        }
        if (!(pList = statement.getFailures()).isEmpty()) {
            Warning warning = (Warning)pList.getFirst();
            while (warning != null) {
                String string = "Failure: " + warning.message;
                this.message.list.add(string);
                ++this.failCount;
                warning = (Warning)pList.getNext();
            }
        }
        return true;
    }

    boolean executeStatements() {
        if (this.statements.isEmpty()) {
            return true;
        }
        Statement statement = null;
        int n = 1;
        int n2 = this.entryText.length();
        int n3 = 0;
        try {
            if (this.statements.hasOne()) {
                statement = (Statement)this.statements.getFirst();
                n = statement.getNumber();
                this.setEntryLineStatus(n);
                this.executeStatement(statement);
            } else {
                this.dbc.restoreSpecification();
                while (n3 < n2) {
                    this.setEntryLineStatus(n);
                    if (this.dbc.isInterrupted()) break;
                    statement = this.dbc.createStatement(this.entryText, n3);
                    statement.prepare();
                    int n4 = statement.getBegin();
                    while (n3 < n4) {
                        if (statement.getScript().charAt(n3) == '\n') {
                            this.setEntryLineStatus(++n);
                        }
                        ++n3;
                    }
                    if (statement.getIndex() != -10 || statement.hasCopula()) {
                        statement.setNumber(n);
                        this.executeStatement(statement);
                    }
                    ++n3;
                    while (n3 < statement.getEnd()) {
                        if (statement.getScript().charAt(n3) == '\n') {
                            ++n;
                        }
                        ++n3;
                    }
                }
            }
            this.dbc.store(statement);
        }
        catch (Exception exception) {
            this.executedPosition = n3;
            exception.printStackTrace();
            this.dbc.setDataLineStatus("");
            this.setEntryLineStatus();
            this.addExceptionMessage(exception, statement);
            return false;
        }
        this.executedPosition = n2;
        this.dbc.setDataLineStatus("");
        this.setEntryLineStatus();
        return true;
    }

    void execute_Action() {
        if (!this.analyse_Action()) {
            this.dbc.restoreSpecification();
            return;
        }
        try {
            this.sbProcess.setStatusText("Executing ...");
            this.executeStatements();
            this.resumeExecute();
            this.sbProcess.setStatusText("");
        }
        catch (PropertyVetoException propertyVetoException) {
            propertyVetoException.printStackTrace();
        }
    }

    void exit_Action() {
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        eventQueue.postEvent(new WindowEvent(this, 201));
    }

    String getDBPath() {
        return this.dbPath;
    }

    void insert_Action() {
        ((Dialog)this.openFileDialog).setTitle("Entry Insert");
        this.openFileDialog.setFile("*.ass;*.z;*.tab");
        this.openFileDialog.show();
        String string = this.openFileDialog.getFile();
        String string2 = this.openFileDialog.getDirectory();
        if (string == null) {
            return;
        }
        try {
            if (string.endsWith(".ass")) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("$base \"");
                stringBuffer.append(string2.replace('\\', '/'));
                stringBuffer.append(string.replace('\\', '/'));
                stringBuffer.append("\";\n");
                int n = this.textArea.getCaretPosition();
                this.textArea.insert(stringBuffer.toString(), n);
                this.textArea.requestFocus();
                return;
            }
            if (string.endsWith(".tab")) {
                int n;
                LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(String.valueOf(string2) + string));
                String string3 = lineNumberReader.readLine();
                lineNumberReader.close();
                if (string3 == null) {
                    return;
                }
                boolean bl = false;
                boolean bl2 = false;
                Fielder fielder = new Fielder(string3);
                if (!fielder.hasMoreElements()) {
                    return;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                String string4 = fielder.nextField();
                stringBuffer.append("/*").append(string4);
                stringBuffer2.append("/*");
                bl = Statement.isField(string4) ^ true;
                int n2 = string4.length();
                if (bl) {
                    n = 0;
                    while (n < n2) {
                        stringBuffer2.append('-');
                        ++n;
                    }
                } else {
                    n = 0;
                    while (n < n2) {
                        stringBuffer2.append(' ');
                        ++n;
                    }
                }
                int n3 = 1;
                while (fielder.hasMoreElements()) {
                    stringBuffer.append("; ");
                    stringBuffer2.append("; ");
                    String string5 = fielder.nextField();
                    stringBuffer.append(string5);
                    ++n3;
                    bl2 = Statement.isField(string5) ^ true;
                    bl |= bl2;
                    n2 = string5.length();
                    if (bl2) {
                        n = 0;
                        while (n < n2) {
                            stringBuffer2.append('-');
                            ++n;
                        }
                        continue;
                    }
                    n = 0;
                    while (n < n2) {
                        stringBuffer2.append(' ');
                        ++n;
                    }
                }
                stringBuffer.append("*/\n");
                stringBuffer2.append("*/\n");
                if (bl) {
                    stringBuffer.append((Object)stringBuffer2);
                    stringBuffer.append("/*Error: - Internal quoting*/");
                } else {
                    stringBuffer.append("$readTable($file \"");
                    stringBuffer.append(string2.replace('\\', '/'));
                    stringBuffer.append(string.replace('\\', '/'));
                    stringBuffer.append("\",\n           ");
                    if (!Concept.isQuote(string4)) {
                        stringBuffer.append(Concept.wrap(string4));
                    } else {
                        stringBuffer.append(string4);
                    }
                    n = 1;
                    while (n <= n3) {
                        stringBuffer.append(", #");
                        stringBuffer.append(n);
                        ++n;
                    }
                    stringBuffer.append(");\n");
                }
                int n4 = this.textArea.getCaretPosition();
                this.textArea.insert(stringBuffer.toString(), n4);
                this.textArea.requestFocus();
                return;
            }
            this.fileName = string;
            this.dirName = string2;
            File file = new File(String.valueOf(this.dirName) + this.fileName);
            byte[] byArray = new byte[(int)file.length()];
            FileInputStream fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
            fileInputStream.close();
            int n = this.textArea.getCaretPosition();
            this.textArea.insert(new String(byArray), n);
            this.textArea.requestFocus();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.message.list.add(String.valueOf(String.valueOf(iOException)) + ": Opening " + this.fileName);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        String string = "Common.ass";
        if (stringArray.length > 0) {
            string = stringArray[0];
        }
        new Entry(string);
    }

    void navigate_Action() {
        VClass vClass = new VClass(this);
        try {
            vClass.prepare(this.dbPath);
            vClass.fill();
            vClass.show();
        }
        catch (Exception exception) {
            ((Component)vClass).setVisible(false);
            vClass.dispose();
            exception.printStackTrace();
            this.message.list.add(exception.toString());
            this.message.show();
        }
    }

    void new_Action() {
        this.fileName = "Entry.z";
        this.setTitle("Sav Z Interpreter - " + this.fileName);
        this.textArea.setText("");
        this.textArea.requestFocus();
    }

    void open_Action() {
        ((Dialog)this.openFileDialog).setTitle("Entry Open");
        this.openFileDialog.setFile("*.z");
        this.openFileDialog.show();
        String string = this.openFileDialog.getFile();
        String string2 = this.openFileDialog.getDirectory();
        if (string == null) {
            return;
        }
        try {
            this.fileName = string;
            this.dirName = string2;
            this.setTitle("Sav Z Interpreter - " + this.dirName + this.fileName);
            File file = new File(String.valueOf(this.dirName) + this.fileName);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[(int)file.length()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            this.textArea.setText(new String(byArray));
            this.textArea.requestFocus();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.message.list.add(String.valueOf(String.valueOf(iOException)) + ": Opening " + this.fileName);
        }
    }

    void prepare_Action() {
        this.prep.show();
    }

    void resumeAnalyse() {
        if (this.errCount == 0) {
            this.message.list.add("Analysis successful !");
            return;
        }
        this.wPosition = new int[this.errCount];
        if (this.statements.isEmpty()) {
            return;
        }
        int n = 0;
        Statement statement = (Statement)this.statements.getFirst();
        while (statement != null) {
            if (statement.getErrors().isEmpty()) {
                if (!statement.getExceptions().isEmpty()) {
                    this.wPosition[n] = statement.getBegin();
                }
            } else {
                String string = "";
                try {
                    string = statement.getRightSentence();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    this.message.list.add(String.valueOf(String.valueOf(iOException)) + ": Correcting");
                    return;
                }
                if (!string.equals("")) {
                    this.correction.textArea.append(string);
                    this.correction.textArea.append(";\n");
                }
                Warning warning = (Warning)statement.getErrors().getFirst();
                this.wPosition[n] = warning.position;
                ++n;
            }
            statement = (Statement)this.statements.getNext();
        }
        if (this.errCount != 0) {
            if (this.correction.textArea.getText().length() != 0) {
                ((Component)this.correction).setVisible(true);
            }
            this.message.show();
            return;
        }
        ((Component)this).setVisible(true);
    }

    void resumeExecute() {
        int n = this.entryText.length();
        if (this.executedPosition != 0) {
            this.fileName = "Entry.z";
            this.setTitle("Sav Z Interpreter - " + this.fileName);
            if (this.executedPosition == n) {
                this.history.textArea.append(this.entryText);
                this.history.textArea.append("\n");
                this.history.textArea.setEditable(true);
                ((Component)this.history).setVisible(true);
                this.textArea.setText("");
            } else {
                this.history.textArea.append(this.entryText.substring(0, this.executedPosition));
                this.history.textArea.append("\n");
                this.history.textArea.setEditable(true);
                ((Component)this.history).setVisible(true);
                this.textArea.setText(this.entryText.substring(this.executedPosition));
            }
        }
        if (this.failCount == 0 && this.excCount == 0) {
            this.message.list.add("Execution successful !");
        }
        if (this.excCount != 0) {
            this.message.show();
            return;
        }
        if (this.failCount != 0) {
            ((Component)this.message).setVisible(true);
        }
        ((Component)this).setVisible(true);
    }

    void save(String string, String string2) throws IOException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "\r\n");
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
        while (stringTokenizer.hasMoreElements()) {
            String string3 = stringTokenizer.nextToken();
            printWriter.println(string3);
        }
        printWriter.close();
    }

    void saveAs_Action() {
        this.saveFileDialog.setDirectory(this.dirName);
        this.saveFileDialog.setFile(this.fileName);
        this.saveFileDialog.show();
        this.dirName = this.saveFileDialog.getDirectory();
        this.fileName = this.saveFileDialog.getFile();
        if (this.fileName != null) {
            try {
                this.save(String.valueOf(this.dirName) + this.fileName, this.textArea.getText());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.message.list.add(String.valueOf(String.valueOf(iOException)) + ": Saving as " + this.fileName);
            }
            this.setTitle("Sav Z Interpreter - " + this.dirName + this.fileName);
        }
    }

    void saveHistoryAs_Action() {
        this.saveFileDialog.setDirectory(this.history.dirName);
        this.saveFileDialog.setFile(this.history.fileName);
        this.saveFileDialog.show();
        this.history.dirName = this.saveFileDialog.getDirectory();
        this.history.fileName = this.saveFileDialog.getFile();
        if (this.history.fileName != null) {
            try {
                this.save(String.valueOf(this.history.dirName) + this.history.fileName, this.history.textArea.getText());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.message.list.add(String.valueOf(String.valueOf(iOException)) + ": Storing " + this.history.fileName);
            }
        }
        this.history.textArea.setText("");
        ((Component)this.history).setVisible(true);
    }

    void save_Action() {
        block3: {
            if (this.dirName == null) {
                this.saveFileDialog.setFile(this.fileName);
                this.saveFileDialog.show();
                this.dirName = this.saveFileDialog.getDirectory();
                this.fileName = this.saveFileDialog.getFile();
                this.setTitle("Sav Z Interpreter - " + this.dirName + this.fileName);
            }
            if (this.fileName == null) break block3;
            try {
                this.save(String.valueOf(this.dirName) + this.fileName, this.textArea.getText());
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                this.message.list.add(String.valueOf(String.valueOf(iOException)) + ": Saving " + this.fileName);
            }
        }
    }

    void setEntryLineStatus() {
        block2: {
            this.iEntryLine = 0;
            if (this.sbEntryLine == null) break block2;
            try {
                this.sbEntryLine.setStatusText("");
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    void setEntryLineStatus(int n) {
        block2: {
            this.iEntryLine = n;
            if (this.sbEntryLine == null) break block2;
            try {
                this.sbEntryLine.setStatusText("Entry..." + n);
            }
            catch (PropertyVetoException propertyVetoException) {}
        }
    }

    class KeyAdapter1
    extends KeyAdapter {
        KeyAdapter1() {
        }

        public void keyReleased(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            if (n == 123) {
                Entry.this.execute_Action();
            } else if (n == 122) {
                Entry.this.analyse_Action();
            }
            if (n == 112) {
                Entry.this.advice_Action();
            }
        }
    }

    class MenuAction
    implements ActionListener {
        MenuAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == Entry.this.miNew) {
                Entry.this.new_Action();
            } else if (object == Entry.this.miOpen) {
                Entry.this.open_Action();
            } else if (object == Entry.this.miSave) {
                Entry.this.save_Action();
            } else if (object == Entry.this.miSaveAs) {
                Entry.this.saveAs_Action();
            } else if (object == Entry.this.miSaveHistoryAs) {
                Entry.this.saveHistoryAs_Action();
            } else if (object == Entry.this.miAnalyze) {
                Entry.this.analyse_Action();
            } else if (object == Entry.this.miExecute) {
                Entry.this.execute_Action();
            } else if (object == Entry.this.miInsert) {
                Entry.this.insert_Action();
            } else if (object == Entry.this.miHAdvice) {
                Entry.this.advice_Action();
            } else if (object == Entry.this.miHPrepare) {
                Entry.this.prepare_Action();
            } else if (object == Entry.this.miAbout) {
                Entry.this.about_Action();
            } else if (object == Entry.this.miExit) {
                Entry.this.exit_Action();
            } else if (object == Entry.this.miNavigate) {
                Entry.this.navigate_Action();
            }
        }
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Entry.this.correction.dispose();
            Entry.this.report.dispose();
            Entry.this.message.dispose();
            Entry.this.history.dispose();
            Entry.this.dispose();
            System.runFinalization();
            System.exit(0);
        }
    }
}

