/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.Concept;
import Sav.Processor.Connecter;
import Sav.Processor.Core;
import Sav.Processor.Long1;
import Sav.Processor.Node;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Processor.Trace;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import java.util.Stack;

public class Association
implements Cloneable,
Observer {
    Core core;
    Node fixNode;
    Node conNode;
    Node seeNode;
    Node curNode;
    Trace fixTrace = new Trace();
    Trace conTrace = new Trace();
    Trace seeTrace = new Trace();
    Trace curTrace;
    Trace fixTraceEnd = this.fixTrace;
    Trace conTraceEnd = this.conTrace;
    long state = -1L;
    int category = 56;
    Stack conRoute = new Stack();
    Stack seeRoute = new Stack();

    public Association() {
        this.core = new Core();
        ++this.core.observation;
    }

    public Association(Core core) {
        this.core = core;
        ++core.observation;
    }

    public Association(File file) throws IOException {
        this(file, true);
    }

    public Association(File file, boolean bl) throws IOException {
        this.core = new Core(file.getPath(), bl);
        ++this.core.observation;
    }

    public Association(String string) throws IOException {
        this(string, true);
    }

    public Association(String string, String string2) throws IOException {
        this.construct(string, string2, true);
    }

    public Association(String string, String string2, boolean bl) throws IOException {
        this.construct(string, string2, bl);
    }

    public Association(String string, boolean bl) throws IOException {
        String string2;
        String string3;
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = null;
            string2 = string;
        }
        this.construct(string3, string2, bl);
    }

    void accessSet() throws IOException {
        this.accession();
        if (this.seeNode != null) {
            return;
        }
        if (this.fixNode == null) {
            this.fixNode = this.core.node.setTrace(this.fixTrace);
        }
        if (this.conNode == null) {
            this.conNode = this.fixNode.setTrace(this.conTrace);
        }
        if (this.seeTrace.next == null) {
            this.seeNode = this.conNode;
        }
    }

    boolean accession() throws IOException {
        if (this.seeNode != null) {
            return true;
        }
        if (this.state == this.core.state) {
            return false;
        }
        this.state = this.core.state;
        if (this.fixNode == null) {
            this.fixNode = this.core.node.getTrace(this.fixTrace);
            if (this.fixNode == null) {
                return false;
            }
            this.core.addObserver(this);
        }
        if (this.conNode == null) {
            this.conNode = this.fixNode.getTrace(this.conTrace);
            if (this.conNode == null || this.conNode.restore() == 0) {
                return false;
            }
        }
        if (this.seeNode == null) {
            this.seeNode = this.conNode.getTrace(this.seeTrace);
            if (this.seeNode == null || this.seeNode.restore() == 0) {
                return false;
            }
        }
        return true;
    }

    void accountForClear() throws IOException {
        this.conNode.freeAncestors();
        this.curNode = null;
        if (this.conNode.count == 0) {
            this.conNode = null;
            this.seeNode = null;
            if (this.fixNode.count == 0) {
                this.fixNode = null;
            }
        } else if (this.seeTrace.next != null) {
            this.seeNode = null;
        }
        if (this.core.countObservers() > 1) {
            this.core.reset();
        }
    }

    public boolean appendClassMean(Concept concept) throws IOException {
        return this.appendClassMean(concept, false, false, null);
    }

    public boolean appendClassMean(Concept concept, boolean bl) throws IOException {
        return this.appendClassMean(concept, bl, false, null);
    }

    public boolean appendClassMean(Concept concept, boolean bl, boolean bl2) throws IOException {
        return this.appendClassMean(concept, bl, bl2, null);
    }

    public boolean appendClassMean(Concept concept, boolean bl, boolean bl2, Association association) throws IOException {
        boolean bl3 = false;
        if (concept == null) {
            return bl3;
        }
        Long1 long1 = this.initMemory();
        Concept concept2 = this.getFirst(55);
        while (concept2 != null) {
            if (bl2 && concept2.equals(concept)) {
                this.controlMemory(long1, association);
            } else {
                this.con();
                if (association != null) {
                    association.con(concept2);
                }
                bl3 |= this.appendClassMean1(concept, bl, bl2, association);
                this.uncon();
                if (association != null) {
                    association.uncon();
                }
                this.controlMemory(long1, association);
            }
            concept2 = this.getNext(55);
        }
        return bl3;
    }

    boolean appendClassMean1(Concept concept, boolean bl, boolean bl2, Association association) throws IOException {
        boolean bl3 = false;
        boolean bl4 = false;
        Long1 long1 = this.initMemory();
        if (this.has(56)) {
            this.con(56);
            Concept concept2 = this.getFirst(55);
            while (concept2 != null) {
                if (bl2 && concept2.equals(concept)) {
                    if (association != null) {
                        association.set();
                    }
                    bl3 = true;
                } else {
                    this.con();
                    if (association != null) {
                        association.con(56).con(concept2);
                    }
                    bl4 |= this.appendClassMean1(concept, bl, bl2, association);
                    this.uncon();
                    if (association != null) {
                        association.uncon().uncon();
                    }
                }
                this.controlMemory(long1, association);
                concept2 = this.getNext(55);
            }
            this.uncon();
        }
        if (this.has()) {
            if (!bl3) {
                this.setConnection(56, concept);
                if (association != null) {
                    association.set();
                }
                bl4 |= true;
            }
            if (bl) {
                this.clear();
            }
        }
        return bl4;
    }

    public Association clear() throws IOException {
        return this.clearConnection(63);
    }

    public Association clear(Association association) throws IOException {
        Cloneable cloneable;
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        int n = this.depends(0, association);
        if (n == 0) {
            return this.clearAll();
        }
        if (n > 0) {
            cloneable = new Association();
            ((Association)cloneable).set(association);
            association = cloneable;
        }
        cloneable = null;
        Trace trace = null;
        if (this.accession() && association.accession()) {
            if (association.category < 56 && Concept.countClassDeep(association.seeTrace) != 0 && (cloneable = association.conNode.getTrace(association.category, association.seeTrace)) != null) {
                trace = association.seeTrace.getFirstPart(56);
                cloneable = this.conNode.getTrace(this.category, trace);
                if (!((Node)cloneable).clearConnect(63)) {
                    return this;
                }
                if (((Node)cloneable).count == 0 && this.conNode != cloneable) {
                    this.conNode.clearTrace(trace);
                }
                this.accountForClear();
                return this;
            }
            if (association.seeTrace.next == null && !this.conNode.correlates(association.conNode)) {
                return this;
            }
            cloneable = this.conNode.getTrace(this.category, association.seeTrace);
            if (cloneable == null) {
                return this;
            }
            if (!((Node)cloneable).clearNode(association.seeNode, this.category)) {
                return this;
            }
            trace = association.seeTrace;
            if (((Node)cloneable).count == 0 && this.conNode != cloneable) {
                this.conNode.clearTrace(trace);
            }
            this.accountForClear();
        }
        return this;
    }

    public Association clear(Concept concept) throws IOException {
        Node node;
        if (concept == null) {
            return this;
        }
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession() && (node = this.conNode.getTrace(56, concept.trace)) != null && node.clearConnect(63) && node.count == 0) {
            this.conNode.clearTrace(concept.trace);
            this.accountForClear();
        }
        return this;
    }

    public Association clear(String string) throws IOException {
        return this.clear(new Concept(string));
    }

    public Association clearAll() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession()) {
            this.conNode.clearAllSigns();
            this.accountForClear();
        }
        return this;
    }

    public Association clearAllConnection() throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession()) {
            this.conNode.clearAllConnect();
            this.accountForClear();
        }
        return this;
    }

    public Association clearConnection(int n) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession()) {
            this.conNode.clearConnect(n);
            this.accountForClear();
        }
        return this;
    }

    public Association clearConnection(int n, Association association) throws IOException {
        Object object;
        if (association == null) {
            return this.clearConnection(n);
        }
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (!association.hasAny()) {
            return this;
        }
        int n2 = this.depends(n, association);
        if (n2 > 0) {
            object = new Association();
            ((Association)object).set(association);
            association = object;
        }
        if (association.accession() && this.accession()) {
            if (association.category < 56 && Concept.countClassDeep(association.seeTrace) != 0) {
                Node node = association.conNode.getTrace(association.category, association.seeTrace);
                if (node != null && this.conNode.clearConnect(n, (Trace)(object = association.seeTrace.getFirstPart(56)), null, 0)) {
                    this.accountForClear();
                }
            } else if (this.seeNode != null && this.conNode.clearConnect(n, association.seeTrace, association.seeNode, association.category)) {
                this.accountForClear();
            }
        }
        return this;
    }

    public Association clearConnection(int n, Concept concept) throws IOException {
        if (concept == null) {
            return this;
        }
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (this.accession()) {
            this.conNode.clearConnect(n, concept.trace, null, 0);
            this.accountForClear();
        }
        return this;
    }

    public Association clearConnection(int n, String string) throws IOException {
        return this.clearConnection(n, new Concept(string));
    }

    public void clearConnections(PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = this.initMemory();
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            int n = pList.getType();
            if (association == null) {
                this.clearConnection(n);
            } else {
                this.clearConnection(n, association);
            }
            this.controlMemory(long1, association, pList);
            association = (Association)pList.getNext();
        }
    }

    public void clearDomainConnections(Association association, PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (!association.hasAny()) {
            return;
        }
        int n = association.getCategory();
        Long1 long1 = this.initMemory();
        Concept concept = association.getFirst(55);
        while (concept != null) {
            association.con();
            this.con(concept);
            if (this.has(n) && association.has(n)) {
                association.con(n);
                this.con(n);
                this.clearDomainConnections(association, pList);
                association.uncon();
                this.uncon();
            }
            if (association.has()) {
                this.clearConnections(pList);
            }
            association.uncon();
            this.uncon();
            this.controlMemory(long1, association, pList);
            concept = association.getNext(55);
        }
    }

    public void clearDomainConnections(PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = this.initMemory();
        Concept concept = this.getFirst(55);
        while (concept != null) {
            this.con(concept);
            if (this.has(this.category)) {
                this.con(this.category);
                this.clearDomainConnections(pList);
                this.uncon();
            }
            if (this.has()) {
                this.clearConnections(pList);
            }
            this.uncon();
            this.controlMemory(long1, pList);
            concept = this.getNext(55);
        }
    }

    public Object clone() {
        Association association = null;
        try {
            association = (Association)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        association.fixTrace = new Trace();
        association.fixTraceEnd = association.fixTrace.insert(this.fixTrace);
        association.conTrace = new Trace();
        association.conTraceEnd = association.conTrace.insert(this.conTrace);
        association.conRoute = (Stack)this.conRoute.clone();
        association.seeRoute = (Stack)this.seeRoute.clone();
        if (association.fixNode != null) {
            this.core.addObserver(association);
        }
        ++this.core.observation;
        return association;
    }

    public void close() throws IOException {
        this.core.close();
    }

    public Association con() {
        if (this.curTrace == null) {
            return this;
        }
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        this.conRoute.push(this.conTraceEnd);
        this.seeRoute.push(this.seeTrace);
        this.conTraceEnd = this.conTraceEnd.insert(this.curTrace);
        this.conNode = this.curNode;
        if (this.seeTrace.equals(this.curTrace, trace, trace2) && trace.next != null) {
            this.seeTrace = new Trace();
            this.seeTrace.next = trace.next;
            Concept.countClassDeep(this.seeTrace);
        } else {
            this.seeTrace = new Trace(0);
            this.seeNode = this.conNode;
        }
        this.curTrace = null;
        this.curNode = null;
        return this;
    }

    public Association con(int n) {
        Association.testConnection(n);
        Trace trace = new Trace();
        this.conRoute.push(this.conTraceEnd);
        this.seeRoute.push(this.seeTrace);
        this.conTraceEnd = this.conTraceEnd.next = new Trace(n);
        if (n <= 56 && this.seeTrace.next != null && this.seeTrace.next.sign == n) {
            trace.next = this.seeTrace.next.next;
            this.seeTrace = new Trace();
            this.seeTrace.next = trace.next;
            Concept.countClassDeep(this.seeTrace);
        } else {
            this.seeTrace = new Trace(0);
        }
        this.conNode = null;
        this.seeNode = null;
        this.state = -1L;
        this.curTrace = null;
        this.curNode = null;
        return this;
    }

    public Association con(Concept concept) {
        if (concept == null) {
            return this;
        }
        if (concept.trace == this.curTrace) {
            return this.con();
        }
        this.con(concept.trace);
        return this;
    }

    void con(Trace trace) {
        Trace trace2 = new Trace();
        Trace trace3 = new Trace();
        this.conRoute.push(this.conTraceEnd);
        this.seeRoute.push(this.seeTrace);
        this.conTraceEnd = this.conTraceEnd.insert(trace);
        this.curTrace = null;
        this.curNode = null;
        if (trace.next == null) {
            return;
        }
        if (this.seeTrace.equals(trace, trace2, trace3) && trace2.next != null) {
            this.seeTrace = new Trace();
            this.seeTrace.next = trace2.next;
            Concept.countClassDeep(this.seeTrace);
        } else {
            this.seeTrace = new Trace(0);
        }
        this.conNode = null;
        this.seeNode = null;
        this.state = -1L;
    }

    public Association con(String string) {
        return this.con(new Concept(string));
    }

    void construct(String string, String string2, boolean bl) throws IOException {
        String string3;
        if (string2.indexOf(46) < 0) {
            string2 = String.valueOf(string2) + ".ass";
        }
        if (string == null) {
            string3 = string2;
        } else {
            if (File.separatorChar == '\\') {
                string = string.replace('/', '\\');
            }
            string3 = String.valueOf(string) + File.separator + string2;
        }
        this.core = new Core(string3, bl);
        ++this.core.observation;
    }

    public void controlMemory(Long1 long1) throws IOException {
        this.controlMemory(long1, null, null, null);
    }

    public void controlMemory(Long1 long1, Association association) throws IOException {
        this.controlMemory(long1, association, null, null);
    }

    public void controlMemory(Long1 long1, Association association, Association association2) throws IOException {
        this.controlMemory(long1, association, association2, null);
    }

    public void controlMemory(Long1 long1, Association association, Association association2, Association association3) throws IOException {
        long l;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = l2 - (l = runtime.freeMemory());
        if (l3 < long1.value) {
            long1.value = l3 - PN.MEMORY_EXTENSION1;
            return;
        }
        if (l3 - long1.value > PN.MEMORY_EXTENSION) {
            this.store();
            if (association != null) {
                association.store();
                if (association2 != null) {
                    association2.store();
                    if (association3 != null) {
                        association3.store();
                    }
                }
            }
            runtime.gc();
            l2 = runtime.totalMemory();
            l = runtime.freeMemory();
            l3 = l2 - l;
            if (l3 - long1.value > PN.MEMORY_EXTENSION - PN.MEMORY_EXTENSION1) {
                long1.value = l2;
            }
        }
    }

    public void controlMemory(Long1 long1, Association association, PList pList) throws IOException {
        long l;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = l2 - (l = runtime.freeMemory());
        if (l3 < long1.value) {
            long1.value = l3 - PN.MEMORY_EXTENSION1;
            return;
        }
        if (l3 - long1.value > PN.MEMORY_EXTENSION) {
            this.store();
            if (association != null) {
                association.store();
            }
            PList pList2 = (PList)pList.clone();
            Association association2 = (Association)pList2.getFirst();
            while (pList.hasCurrent()) {
                if (association2 != null) {
                    association2.store();
                }
                association2 = (Association)pList.getNext();
            }
            runtime.gc();
            l2 = runtime.totalMemory();
            l = runtime.freeMemory();
            l3 = l2 - l;
            if (l3 - long1.value > PN.MEMORY_EXTENSION - PN.MEMORY_EXTENSION1) {
                long1.value = l2;
            }
        }
    }

    public void controlMemory(Long1 long1, PList pList) throws IOException {
        this.controlMemory(long1, null, pList);
    }

    public Concept createNewConcept() throws IOException {
        Node node;
        Trace trace;
        boolean bl = false;
        Trace trace2 = this.curTrace;
        Node node2 = this.curNode;
        Trace trace3 = this.seeTrace;
        Node node3 = this.seeNode;
        this.see(54);
        Concept concept = this.getLast(55);
        if (concept == null) {
            trace = new Trace();
            trace.next = new Trace(54);
            trace.next.next = new Trace(-1);
        } else {
            trace = concept.trace;
        }
        bl = true;
        this.accessSet();
        while ((node = this.conNode.getTrace(55, trace = trace.newInstance())) != null) {
        }
        node = this.conNode.setTrace(trace);
        if (node.setConnect(63)) {
            this.core.setUp();
            ++this.state;
        }
        this.curTrace = trace2;
        this.curNode = node2;
        this.seeTrace = trace3;
        this.seeNode = node3;
        Trace trace4 = new Trace(this.seeTrace.sign);
        Trace trace5 = trace4.insert(this.seeTrace);
        trace5.insert(trace);
        concept = new Concept(trace4);
        return concept;
    }

    public PList defCon() {
        Trace trace;
        PList pList = new PList();
        Trace trace2 = this.conTrace;
        Trace trace3 = trace = new Trace();
        while (trace2.next != null) {
            trace2 = trace2.next;
            if (trace2.sign > 56) {
                pList.add(new Concept(trace));
                pList.add(new Connecter(trace2.sign));
                trace3 = trace = new Trace();
                continue;
            }
            trace3 = trace3.next = new Trace(trace2.sign);
        }
        pList.add(new Concept(trace));
        return pList;
    }

    public Concept defSee() {
        return new Concept(this.seeTrace);
    }

    public Concept defineNewConcept() throws IOException {
        Trace trace;
        Trace trace2 = this.curTrace;
        Node node = this.curNode;
        Trace trace3 = this.seeTrace;
        Node node2 = this.seeNode;
        this.see(54);
        Concept concept = this.getLast(55);
        if (concept == null) {
            trace = new Trace();
            trace.next = new Trace(54);
            trace.next.next = new Trace(-1);
        } else {
            trace = concept.trace;
        }
        if (this.accession()) {
            Node node3;
            while ((node3 = this.conNode.getTrace(55, trace = trace.newInstance())) != null) {
            }
        } else {
            trace = trace.newInstance();
        }
        this.curTrace = trace2;
        this.curNode = node;
        this.seeTrace = trace3;
        this.seeNode = node2;
        Trace trace4 = new Trace(this.seeTrace.sign);
        Trace trace5 = trace4.insert(this.seeTrace);
        trace5.insert(trace);
        concept = new Concept(trace4);
        return concept;
    }

    public boolean delete() throws IOException {
        return this.core.delete();
    }

    int depends(int n, Association association) {
        if (this.core != association.core) {
            return -1;
        }
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        Trace trace3 = trace.insert(this.fixTrace).insert(this.conTrace);
        if (n != 0) {
            trace3.next = new Trace(n);
        }
        trace2.insert(association.fixTrace).insert(association.conTrace);
        Concept.countClassDeep(trace);
        Concept.countClassDeep(trace2);
        Trace trace4 = new Trace();
        Trace trace5 = new Trace();
        if (!trace.equals(trace2, trace4, trace5)) {
            return -1;
        }
        int n2 = -1;
        if (trace4.next == trace5.next) {
            n2 = 0;
        } else if (trace4.next != null) {
            trace3 = trace4;
            n2 = 1;
        } else {
            trace3 = trace5;
            n2 = 2;
        }
        return n2;
    }

    protected void finalize() throws IOException {
        if (--this.core.observation == 0) {
            if (this.core.path == null || this.core.path.charAt(0) == '$') {
                this.core.delete();
            } else {
                this.core.store();
            }
        }
    }

    public void fix() {
        if (this.conTraceEnd != this.conTrace) {
            this.fixTraceEnd.next = this.conTrace.next;
            this.fixTraceEnd = this.conTraceEnd;
            this.conTrace.next = null;
            this.conTraceEnd = this.conTrace;
            this.fixNode = this.conNode;
            this.conRoute = new Stack();
            this.seeRoute = new Stack();
        }
    }

    public Concept generalize(int n) throws IOException {
        Trace trace = null;
        boolean bl = false;
        if (this.accession()) {
            if (n < 56 && Concept.countClassDeep(this.seeTrace) > 0) {
                Node node = this.conNode.getTrace(n, this.seeTrace);
                if (node != null) {
                    trace = this.seeTrace.getFirstPart(56);
                }
            } else if (this.seeNode != null) {
                Node node = this.seeNode.seekKeyNode(n);
                trace = node.determinateTrace(this.conNode);
                if (n == 56 && !node.hasConcept(n)) {
                    bl = true;
                }
            }
        }
        if (trace == null) {
            return null;
        }
        Concept concept = new Concept(trace);
        if (bl) {
            concept = concept.getClassDefn();
        }
        return concept;
    }

    public Concept get() {
        if (this.curTrace != null) {
            return new Concept(this.curTrace);
        }
        return null;
    }

    public Association get(int n, Association association, int n2) throws IOException {
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        Trace trace3 = new Trace();
        int n3 = this.category < association.category ? this.category : this.category;
        if (!this.seeTrace.equals(association.seeTrace, trace, trace2, trace3) || trace.next != null && trace2.next != null && (n3 == 56 || Concept.countClassDeep(trace3) == 0)) {
            return new Association();
        }
        int n4 = this.depends(0, association);
        if (n4 >= 0) {
            Association association2 = new Association();
            association2.set(association);
            if (n4 == 0) {
                return association2;
            }
            association = association2;
        }
        Core core = new Core();
        Trace trace4 = null;
        Node node = null;
        Node node2 = null;
        Node node3 = null;
        if (this.accession() && association.accession()) {
            if (!this.conNode.correlates(association.conNode)) {
                return new Association(core);
            }
            if (n3 < 56 && Concept.countClassDeep(trace3) != 0 && (node2 = this.conNode.getTrace(n3, trace3)) != null && (node3 = association.conNode.getTrace(n3, trace3)) != null) {
                trace4 = trace3.getFirstPart(56);
            }
            if (n3 >= 56 || Concept.countClassDeep(trace3) == 0) {
                if (trace.next != null) {
                    node2 = this.seeNode;
                    node3 = association.seeNode.getTrace(n3, trace);
                    trace4 = this.seeTrace;
                } else {
                    node2 = this.seeNode.getTrace(n3, trace2);
                    node3 = association.seeNode;
                    trace4 = association.seeTrace;
                }
            }
        }
        if (trace4 == null) {
            return new Association(core);
        }
        node = node2.getNode(node3, n3, n, n2, core);
        if (node != null) {
            if (trace4.next != null) {
                node3 = core.node.setTrace(trace4);
                node3.ancestor.propagate(node3.sign, node);
                node3.setChange();
            } else {
                node.address = core.node.address;
                core.node = node;
            }
        }
        return new Association(core);
    }

    public Association get(Association association) throws IOException {
        return this.get(0, association, 0);
    }

    public Concept get(Concept concept) throws IOException {
        if (concept == null) {
            return null;
        }
        this.curTrace = concept.trace;
        this.curNode = null;
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        if (!this.seeTrace.equals(concept.trace, trace, trace2) || this.category == 56 && trace.next != null || this.category < 56 && trace.next != null && Concept.countClassDeep(this.seeTrace) == Concept.countClassDeep(trace) && trace.next.sign != 56) {
            return null;
        }
        if (this.accession()) {
            this.curNode = this.conNode.getTrace(this.category, concept.trace);
            if (this.curNode != null && !this.curNode.hasConcept(this.category)) {
                this.curNode = null;
            }
        }
        if (this.curNode == null) {
            return null;
        }
        return new Concept(this.curTrace);
    }

    public Concept get(String string) throws IOException {
        return this.get(new Concept(string));
    }

    public int getCategory() {
        return this.category;
    }

    public Association getClassDefn() throws IOException {
        Association association = new Association();
        this.getClassDefn(association);
        return association;
    }

    public Association getClassDefn(Association association) throws IOException {
        Long1 long1 = this.initMemory();
        Concept concept = this.getFirst(55);
        while (concept != null) {
            this.con();
            if (this.has(56)) {
                this.con(56);
                association.con(concept);
                this.getClassDefn1(association);
                this.uncon();
                association.uncon();
            }
            this.uncon();
            this.controlMemory(long1, association);
            concept = this.getNext(55);
        }
        return association;
    }

    public void getClassDefn1(Association association) throws IOException {
        boolean bl = false;
        Long1 long1 = this.initMemory();
        Concept concept = this.getFirst(55);
        while (concept != null) {
            this.con();
            if (this.has(56)) {
                association.con(56).con(concept);
                this.con(56);
                this.getClassDefn1(association);
                this.uncon();
                association.uncon().uncon();
            } else {
                bl = true;
            }
            this.uncon();
            this.controlMemory(long1, association);
            concept = this.getNext(55);
        }
        if (bl) {
            association.set();
        }
    }

    public Association getClassDefnOf(Concept concept) throws IOException {
        if (concept == null) {
            return this;
        }
        Association association = new Association();
        Long1 long1 = this.initMemory();
        Concept concept2 = this.getFirst(55);
        while (concept2 != null) {
            if (!concept2.equals(concept)) {
                this.con();
                if (this.has(56)) {
                    association.con(concept2);
                    this.getClassDefnOf1(concept, association);
                    association.uncon();
                }
                this.uncon();
                this.controlMemory(long1, association);
            }
            concept2 = this.getNext(55);
        }
        return association;
    }

    void getClassDefnOf1(Concept concept, Association association) throws IOException {
        Long1 long1 = this.initMemory();
        this.con(56);
        Concept concept2 = this.getFirst(55);
        while (concept2 != null) {
            if (concept2.equals(concept)) {
                association.set();
            } else {
                this.con();
                if (this.has(56)) {
                    association.setConnection(56, concept2);
                    this.getClassDefnOf1(concept, association);
                }
                this.uncon();
                this.controlMemory(long1, association);
            }
            concept2 = this.getNext(55);
        }
        this.uncon();
    }

    public Association getClassMean() throws IOException {
        Association association = new Association();
        this.getClassMean(association);
        return association;
    }

    public void getClassMean(Association association) throws IOException {
        Long1 long1 = this.initMemory();
        Concept concept = this.getFirst(55);
        while (concept != null) {
            this.con();
            if (this.has(56)) {
                this.con(56);
                this.getClassMean(association);
                this.uncon();
            } else {
                association.set(concept);
            }
            this.uncon();
            this.controlMemory(long1, association);
            concept = this.getNext(55);
        }
    }

    public void getConnections(PList pList) throws IOException {
        Long1 long1 = this.initMemory();
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            int n = pList.getType();
            if (this.hasConnection(n)) {
                if (association == null) {
                    association = new Association();
                    pList.update(n, association);
                }
                this.con(n);
                association.set(this);
                this.uncon();
                this.controlMemory(long1, pList);
            }
            association = (Association)pList.getNext();
        }
    }

    public Core getCore() {
        return this.core;
    }

    public void getDomainConnections(Association association, PList pList) throws IOException {
        if (!association.hasAny()) {
            return;
        }
        Long1 long1 = this.initMemory();
        Concept concept = association.getFirst(55);
        while (concept != null) {
            association.con();
            this.con(concept);
            int n = 56;
            while (n <= this.category && n <= association.category) {
                if (this.has(n) && association.has(n)) {
                    association.con(n);
                    this.con(n);
                    this.getDomainConnections(association, pList);
                    association.uncon();
                    this.uncon();
                }
                ++n;
            }
            if (association.has()) {
                this.getConnections(pList);
            }
            association.uncon();
            this.uncon();
            this.controlMemory(long1, association, pList);
            concept = association.getNext(55);
        }
    }

    public void getDomainConnections(PList pList) throws IOException {
        Long1 long1 = this.initMemory();
        Concept concept = this.getFirst(55);
        while (concept != null) {
            this.con(concept);
            if (this.has(this.category)) {
                this.con(this.category);
                this.getDomainConnections(pList);
                this.uncon();
            }
            if (this.has()) {
                this.getConnections(pList);
            }
            this.uncon();
            this.controlMemory(long1, pList);
            concept = this.getNext(55);
        }
    }

    public Concept getFirst() throws IOException {
        return this.getFirst(this.category);
    }

    public Concept getFirst(int n) throws IOException {
        this.curTrace = null;
        this.curNode = null;
        if (this.accession()) {
            this.curNode = n < 56 && Concept.countClassDeep(this.seeTrace) != 0 ? this.conNode.getTrace(n, this.seeTrace) : this.seeNode;
            if (this.curNode != null) {
                if (!this.curNode.hasConcept(n)) {
                    this.curNode = this.curNode.nextNode(n, this.seeNode);
                }
                if (this.curNode != null) {
                    this.curTrace = this.curNode.determinateTrace(this.conNode);
                }
            }
        }
        if (this.curNode == null) {
            return null;
        }
        return new Concept(this.curTrace);
    }

    public Concept getIfOne() throws IOException {
        return this.getIfOne(this.category);
    }

    public Concept getIfOne(int n) throws IOException {
        Trace trace = null;
        if (this.accession()) {
            Node node;
            if (n < 56 && Concept.countClassDeep(this.seeTrace) > 0) {
                Node node2 = this.conNode.getTrace(n, this.seeTrace);
                if (node2 != null) {
                    trace = this.seeTrace.getFirstPart(56);
                }
            } else if (this.seeNode != null && (node = this.seeNode.seekKeyNode(n)) != null && node.hasConcept(n) && !node.hasNotat(n)) {
                trace = node.determinateTrace(this.conNode);
            }
        }
        if (trace == null) {
            return null;
        }
        return new Concept(trace);
    }

    public Concept getLast() throws IOException {
        return this.getLast(this.category);
    }

    public Concept getLast(int n) throws IOException {
        this.curTrace = null;
        this.curNode = null;
        if (this.accession()) {
            this.curNode = n < 56 && Concept.countClassDeep(this.seeTrace) != 0 ? this.conNode.getTrace(n, this.seeTrace) : this.seeNode;
            if (this.curNode != null) {
                if (this.curNode == this.seeNode) {
                    this.curNode = this.seeNode.lastNode(this.seeNode, n);
                }
                if (this.curNode != null) {
                    this.curTrace = this.curNode.determinateTrace(this.conNode);
                }
            }
        }
        if (this.curNode == null) {
            return null;
        }
        return new Concept(this.curTrace);
    }

    public Concept getNext() throws IOException {
        return this.getNext(this.category);
    }

    public Concept getNext(int n) throws IOException {
        if (this.curTrace == null) {
            return null;
        }
        Trace trace = new Trace();
        Trace trace2 = new Trace();
        if (!this.seeTrace.equals(this.curTrace, trace, trace2) || trace.next != null) {
            this.curTrace = null;
            this.curNode = null;
            return null;
        }
        if (this.accession()) {
            if (this.curNode == null) {
                this.curNode = this.conNode.getTrace(n, this.curTrace);
            }
            if (this.curNode == null) {
                if (trace2.next != null) {
                    this.curNode = this.seeNode.getNextNode(n, this.seeNode, trace2);
                }
            } else {
                this.curNode.restore();
                this.curNode = this.curNode.nextNode(n, this.seeNode);
            }
            if (this.curNode != null) {
                this.curTrace = this.curNode.determinateTrace(this.conNode);
            }
        }
        if (this.curNode == null) {
            this.curTrace = null;
            return null;
        }
        return new Concept(this.curTrace);
    }

    public String getPath() {
        if (this.core.path == null) {
            return null;
        }
        if (File.separatorChar == '\\') {
            return this.core.path.replace('\\', '/');
        }
        return this.core.path;
    }

    public long getPower() throws IOException {
        if (this.accession()) {
            return this.conNode.getPower();
        }
        return 0L;
    }

    public boolean has() throws IOException {
        return this.seeTrace.next == null && this.accession() && this.conNode.has(63);
    }

    public boolean has(int n) throws IOException {
        return (this.seeTrace.next == null || this.seeTrace.next.sign == n) && this.accession() && this.conNode.has(n);
    }

    public boolean hasAny() throws IOException {
        return this.accession();
    }

    public boolean hasConception() throws IOException {
        return this.hasConception(this.category);
    }

    public boolean hasConception(int n) throws IOException {
        return (this.seeTrace.next == null || this.seeTrace.next.sign > n) && this.accession() && this.conNode.hasConcept(n);
    }

    public boolean hasConnection() throws IOException {
        return this.seeTrace.next == null && this.accession() && this.conNode.hasConnect();
    }

    public boolean hasConnection(int n) throws IOException {
        Association.testConnection(n);
        return this.seeTrace.next == null && this.has(n);
    }

    public boolean hasNotation() throws IOException {
        return (this.seeTrace.next == null || this.seeTrace.next.sign < 55) && this.accession() && this.conNode.hasNotat(this.category);
    }

    public Long1 initMemory() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        return new Long1(l - l2);
    }

    public void print() throws IOException {
        this.print(System.out, 0);
    }

    public void print(PrintStream printStream, int n) throws IOException {
        boolean bl = true;
        Concept concept = this.getIfOne(55);
        if (concept == null) {
            printStream.print("{ ");
            n += 2;
        }
        Long1 long1 = this.initMemory();
        Concept concept2 = this.getFirst(55);
        while (concept2 != null) {
            this.con();
            if (bl) {
                bl = false;
            } else {
                printStream.print(",");
                this.printLineSpace(printStream, n);
            }
            String string = concept2.toString();
            printStream.print(string);
            if (this.has(56)) {
                this.con(56);
                printStream.print(": ");
                this.print(printStream, n + string.length() + 2);
            }
            this.uncon();
            this.controlMemory(long1);
            concept2 = this.getNext(55);
        }
        if (concept == null) {
            this.printLineSpace(printStream, n - 2);
            printStream.print("}");
        }
        this.uncon();
        printStream.flush();
    }

    void printLineSpace(PrintStream printStream, int n) throws IOException {
        printStream.println();
        int n2 = 0;
        while (n2 < n) {
            printStream.print(' ');
            ++n2;
        }
    }

    public void regain() {
        this.conRoute = new Stack();
        this.seeRoute = new Stack();
        this.state = -1L;
        this.conTrace.next = null;
        this.conTraceEnd = this.conTrace;
        this.conNode = null;
        this.seeTrace = new Trace();
        this.seeNode = null;
        this.curTrace = null;
        this.curNode = null;
    }

    public void restore() throws IOException {
        if (this.core.path == null) {
            this.delete();
            return;
        }
        this.core.restore();
    }

    public void save() throws IOException {
        this.core.save();
    }

    public Association see(int n) {
        if (n > 56 || n < 31) {
            throw new IndexOutOfBoundsException("\nnotation = " + n + "\nNeed: PN.NATURAL, PN.CAPITAL, PN.ARITHMETICAL, PN.NUMBER, ..., or PN.CLASS (see PN class)");
        }
        this.seeTrace = new Trace();
        this.seeTrace.next = new Trace(n);
        Concept.countClassDeep(this.seeTrace);
        this.seeNode = null;
        this.state = -1L;
        this.curNode = null;
        return this;
    }

    public Association see(Concept concept) {
        if (concept == null) {
            return this;
        }
        this.seeTrace = concept.trace;
        this.seeNode = null;
        this.state = -1L;
        this.curNode = null;
        return this;
    }

    public Association see(String string) {
        return this.see(new Concept(string));
    }

    public Association set() throws IOException {
        return this.setConnection(63);
    }

    public Association set(Association association) throws IOException {
        Cloneable cloneable;
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        int n = this.depends(0, association);
        if (n == 0) {
            return this;
        }
        if (n > 0) {
            cloneable = new Association();
            ((Association)cloneable).set(association);
            association = cloneable;
        }
        if (association.accession()) {
            this.accessSet();
            if (association.category < 56 && Concept.countClassDeep(association.seeTrace) != 0) {
                Trace trace;
                cloneable = association.conNode.getTrace(association.category, association.seeTrace);
                if (cloneable != null && ((Node)(cloneable = this.conNode.setTrace(trace = association.seeTrace.getFirstPart(56)))).setConnect(63)) {
                    this.core.setUp();
                    ++this.state;
                }
                return this;
            }
            cloneable = association.seeTrace.next == null ? this.conNode.setCorrelating(association.conNode) : this.conNode.setTrace(association.seeTrace);
            if (((Node)cloneable).setNode(association.seeNode, association.category)) {
                this.core.setUp();
                ++this.state;
            }
        }
        return this;
    }

    public Association set(Concept concept) throws IOException {
        if (concept == null) {
            return this;
        }
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.accessSet();
        Node node = this.conNode.setTrace(concept.trace);
        if (node.setConnect(63)) {
            this.core.setUp();
            ++this.state;
        }
        return this;
    }

    public Association set(String string) throws IOException {
        return this.set(new Concept(string));
    }

    public void setCategory() {
        this.category = 56;
    }

    public void setCategory(int n) {
        if (n > 56 || n < 55) {
            throw new IndexOutOfBoundsException("\ncategory = " + n + "\nNeed: PN.CLASS, or PN.NAME (See Sav.PN)");
        }
        this.category = n;
    }

    public Association setConnection(int n) throws IOException {
        Association.testConnection(n);
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.accessSet();
        if (this.conNode.setConnect(n)) {
            this.core.setUp();
            ++this.state;
        }
        return this;
    }

    public Association setConnection(int n, Association association) throws IOException {
        Object object;
        if (association == null) {
            return this.setConnection(n);
        }
        Association.testConnection(n);
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (!association.hasAny()) {
            return this;
        }
        int n2 = this.depends(n, association);
        if (n2 > 0) {
            object = new Association();
            ((Association)object).set(association);
            association = object;
        }
        if (association.accession()) {
            this.accessSet();
            if (association.category < 56 && Concept.countClassDeep(association.seeTrace) != 0) {
                Node node = association.conNode.getTrace(association.category, association.seeTrace);
                if (node != null && this.conNode.setConnect(n, (Trace)(object = association.seeTrace.getFirstPart(56)), null, 0)) {
                    this.core.setUp();
                    ++this.state;
                }
            } else if (this.seeNode != null && this.conNode.setConnect(n, association.seeTrace, association.seeNode, association.category)) {
                this.core.setUp();
                ++this.state;
            }
        }
        return this;
    }

    public Association setConnection(int n, Concept concept) throws IOException {
        if (concept == null) {
            return this;
        }
        Association.testConnection(n);
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        this.accessSet();
        if (this.conNode.setConnect(n, concept.trace, null, 0)) {
            this.core.setUp();
            ++this.state;
        }
        return this;
    }

    public Association setConnection(int n, String string) throws IOException {
        return this.setConnection(n, new Concept(string));
    }

    public void setConnections(PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = this.initMemory();
        Association association = (Association)pList.getFirst();
        while (pList.hasCurrent()) {
            int n = pList.getType();
            if (association == null) {
                this.setConnection(n);
            } else {
                this.setConnection(n, association);
            }
            this.controlMemory(long1, association, pList);
            association = (Association)pList.getNext();
        }
    }

    public void setDomainConnections(Association association, PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        if (!association.hasAny()) {
            return;
        }
        int n = association.getCategory();
        Long1 long1 = this.initMemory();
        Concept concept = association.getFirst(55);
        while (concept != null) {
            association.con();
            this.con(concept);
            if (association.has(n)) {
                association.con(n);
                this.con(n);
                this.setDomainConnections(association, pList);
                association.uncon();
                this.uncon();
            }
            if (association.has()) {
                this.setConnections(pList);
            }
            association.uncon();
            this.uncon();
            this.controlMemory(long1, association, pList);
            concept = association.getNext(55);
        }
    }

    public void setDomainConnections(PList pList) throws IOException {
        if (!this.core.modifiable) {
            throw new SecurityException("\nNon-modifiable file " + this.core.path);
        }
        Long1 long1 = this.initMemory();
        Concept concept = this.getFirst(55);
        while (concept != null) {
            this.con(concept);
            if (this.has(this.category)) {
                this.con(this.category);
                this.setDomainConnections(pList);
                this.uncon();
            }
            if (this.has()) {
                this.setConnections(pList);
            }
            this.uncon();
            this.controlMemory(long1, pList);
            concept = this.getNext(55);
        }
    }

    public void store() throws IOException {
        this.core.store();
    }

    static void testConnection(int n) {
        if (n > 63 || n < 55) {
            throw new IndexOutOfBoundsException("\nconnection = " + n + "\nNeed: PN.CLASS, PN.RELATION, PN.IDENTITY, ... (See Sav.PN)");
        }
    }

    public void unclone() {
        this.core.reset();
    }

    public Association uncon() {
        if (this.conRoute.empty()) {
            return this;
        }
        this.curTrace = new Trace();
        this.conTraceEnd = (Trace)this.conRoute.pop();
        if (this.conTraceEnd.sign > 56) {
            this.curTrace = null;
            this.curNode = null;
        } else {
            this.curTrace.next = this.conTraceEnd.next;
            this.curNode = this.conNode;
        }
        this.conTraceEnd.next = null;
        this.conNode = null;
        this.seeTrace = (Trace)this.seeRoute.pop();
        this.seeNode = null;
        this.state = -1L;
        return this;
    }

    public void update(Observable observable, Object object) {
        this.state = -1L;
        if (this.fixNode != null) {
            this.fixNode = null;
            this.conNode = null;
            this.seeNode = null;
            this.curNode = null;
        }
    }
}

