/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.NonRecognizableNumberException;
import Sav.Processor.NonRecognizableWordException;
import Sav.Processor.PN;
import Sav.Processor.Trace;
import java.util.Stack;

public class Concept
implements Cloneable {
    String string;
    Trace trace;
    Trace classDefnT;
    Trace classMeanT;
    Trace nameT;
    Trace valueT;
    int number = -1;
    int classDeep;
    int type;
    boolean quoted;

    public Concept() {
        this.trace = new Trace(0);
    }

    public Concept(int n) {
        if (n > 0x3FFFFFFF || n < 0) {
            throw new NonRecognizableNumberException("\nNeed: #0 <= number <= 1073741823");
        }
        this.number = n;
        this.type = 52;
        Trace trace = this.trace = new Trace(0);
        trace = trace.next = new Trace(52);
        int n2 = PN.MAX_NUMBER_BL;
        while (n2 >= 0) {
            trace = trace.next = new Trace(n >>> n2 & 0x1F);
            n2 -= 5;
        }
    }

    Concept(Trace trace) {
        this.trace = trace;
        this.classDeep = Concept.countClassDeep(trace);
    }

    public Concept(String string) {
        if (string == null || string.equals("")) {
            this.trace = new Trace(0);
            return;
        }
        if (!Concept.isWord(string)) {
            throw new NonRecognizableWordException();
        }
        if (Concept.isNumber(string)) {
            this.type = 52;
        } else if (Concept.isString(string)) {
            this.type = 53;
        } else if (Concept.isSpecific(string)) {
            this.type = 51;
        }
        this.string = string;
        char c = string.charAt(0);
        if (this.type == 53 && c == '\"') {
            int n = string.length();
            if (n > 1 && (c = string.charAt(n - 1)) == '\"') {
                this.string = string.substring(0, n - 1);
            }
        } else if (c == '\'') {
            this.quoted = true;
            int n = string.length();
            if (n > 1 && (c = string.charAt(n - 1)) == '\'') {
                this.string = string.substring(1, n - 1);
            }
        }
        this.init();
        this.classDeep = Concept.countClassDeep(this.trace);
    }

    void analyse() {
        Trace trace;
        if (this.classDeep == 0) {
            this.classMeanT = this.trace;
            this.nameT = this.trace;
            return;
        }
        int n = 0;
        Trace trace2 = this.trace;
        while (trace2.next != null) {
            if (trace2.next.sign == 56) {
                if (++n == 1) {
                    trace = trace2.next;
                    trace2.next = null;
                    this.nameT = new Trace(0);
                    this.nameT.insert(this.trace);
                    this.valueT = new Trace();
                    this.valueT.insert(trace);
                    trace2.next = trace;
                }
                if (n == this.classDeep) break;
            }
            trace2 = trace2.next;
        }
        trace = trace2.next;
        trace2.next = null;
        this.classDefnT = new Trace(this.trace.sign - 1);
        this.classDefnT.insert(this.trace);
        trace2 = trace2.next = trace;
        this.classMeanT = new Trace(0);
        this.classMeanT.next = trace2.next;
    }

    public Concept concatName(Concept concept) {
        Concept concept2 = new Concept();
        if (this.string != null && concept.string != null) {
            concept2.string = String.valueOf(this.string) + ":" + concept.string;
        }
        concept2.trace = new Trace(this.trace.sign + concept.trace.sign);
        concept2.classDeep = this.classDeep + concept.classDeep;
        Trace trace = concept2.trace.insert(this.trace);
        ++concept2.trace.sign;
        ++concept2.classDeep;
        trace = trace.next = new Trace(56);
        trace.insert(concept.trace);
        if (this.trace.sign == 0) {
            concept2.nameT = this.trace;
            concept2.valueT = concept.trace;
        }
        if (concept.trace.sign == 0) {
            concept2.classMeanT = concept.trace;
            concept2.classDefnT = this.trace;
        }
        return concept2;
    }

    static int countClassDeep(Trace trace) {
        if (trace.sign >= 0) {
            return trace.sign;
        }
        int n = 0;
        int n2 = -1;
        Trace trace2 = trace;
        Trace trace3 = trace2.next;
        while (trace3 != null) {
            if (trace3.sign == n2) {
                trace2.next = trace3.next;
            } else {
                trace2 = trace3;
                if (trace3.sign > 31) {
                    if (trace3.sign < 55) {
                        n2 = trace3.sign;
                    } else {
                        if (trace3.sign == 56) {
                            ++n;
                        }
                        if (trace3.next == null) break;
                        if (trace3.next.sign <= 31) {
                            n2 = 49;
                            trace3 = trace3.next;
                            trace2 = trace2.next = new Trace(n2);
                            trace2.next = trace3;
                        } else {
                            n2 = -1;
                        }
                    }
                }
            }
            trace3 = trace2.next;
        }
        trace.sign = n;
        return n;
    }

    public boolean equals(Concept concept) {
        return this.trace.equals(concept.trace);
    }

    public Concept getClassDefn() {
        if (this.classDeep == 0) {
            return null;
        }
        if (this.classDefnT == null) {
            this.analyse();
        }
        return new Concept(this.classDefnT);
    }

    public Concept getClassMean() {
        if (this.classDeep == 0) {
            return this;
        }
        if (this.classMeanT == null) {
            this.analyse();
        }
        return new Concept(this.classMeanT);
    }

    public Concept getClassName() {
        if (this.classDeep == 0) {
            return this;
        }
        if (this.nameT == null) {
            this.analyse();
        }
        return new Concept(this.nameT);
    }

    public Concept getClassValue() {
        if (this.classDeep == 0) {
            return null;
        }
        if (this.valueT == null) {
            this.analyse();
        }
        return new Concept(this.valueT);
    }

    public char getFirstChar() {
        Trace trace;
        Trace trace2 = this.trace.next;
        if (trace2 == null) {
            return '\u0000';
        }
        int n = trace2.sign;
        if (n == 56) {
            return ':';
        }
        if (n == 52) {
            return '#';
        }
        if (n == 53) {
            return '\"';
        }
        if (n >= 51) {
            return '$';
        }
        Trace trace3 = trace = new Trace(0);
        trace3 = trace3.next = new Trace(n);
        trace2 = trace2.next;
        trace3.next = new Trace(trace2.sign);
        switch (n) {
            case 44: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.sign);
            }
            case 45: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.sign);
            }
            case 46: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.sign);
            }
            case 47: {
                trace2 = trace2.next;
                trace3.next = new Trace(trace2.sign);
            }
        }
        String string = this.toString(trace);
        return string.charAt(0);
    }

    public int getNotation() {
        return this.getNotation(0);
    }

    public int getNotation(int n) {
        int n2 = -1;
        int n3 = 0;
        Trace trace = this.trace.next;
        while (trace != null) {
            if (trace.sign > 31) {
                n2 = trace.sign;
                if (trace.sign >= 51) {
                    ++n3;
                }
            } else {
                ++n3;
            }
            if (n3 == n) {
                return n2;
            }
            trace = trace.next;
        }
        return -1;
    }

    /*
     * Exception decompiling
     */
    void init() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: First case is not immediately after switch.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:442)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean isNone() {
        return this.trace.next == null;
    }

    public boolean isNumber() {
        return this.trace.next != null && this.trace.next.sign == 52;
    }

    public static boolean isNumber(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '#' || n2 <= 1) {
            return false;
        }
        int n3 = 1;
        while (n3 < n2) {
            c = string.charAt(n3);
            if (c < '0' || c > '9') {
                return false;
            }
            ++n3;
        }
        return n2 > PN.MAX_NUMBER_LENGTH || (n = Integer.parseInt(string.substring(1))) <= 0x3FFFFFFF;
    }

    public static boolean isQuote(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '\'') {
            return false;
        }
        Stack<Integer> stack = new Stack<Integer>();
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(2);
        n = string.length();
        int n4 = 0;
        while (n4 < n) {
            c = string.charAt(n4);
            if (c == '\'' || c == '\"') {
                Integer n5 = stack.isEmpty() ? null : (Integer)stack.peek();
                if (c == '\'') {
                    if (n5 == n2) {
                        if (n4 != n - 1) {
                            return false;
                        }
                        stack.pop();
                    } else {
                        stack.push(n2);
                    }
                } else if (c == '\"') {
                    if (n5 == n3) {
                        stack.pop();
                    } else {
                        stack.push(n3);
                    }
                }
            }
            ++n4;
        }
        return true;
    }

    public boolean isSpecific() {
        return this.trace.next != null && this.trace.next.sign == 51;
    }

    public static boolean isSpecific(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '$' || n == 1) {
            return false;
        }
        c = string.charAt(1);
        if (c < 'A' || c > 'Z') {
            return false;
        }
        int n2 = 2;
        while (n2 < n) {
            c = string.charAt(n2);
            if (c < 'A' || c > 'Z' && c < 'a' || c > 'z') {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public boolean isString() {
        return this.trace.next != null && this.trace.next.sign == 53;
    }

    public static boolean isString(String string) {
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c != '\"') {
            return false;
        }
        return n2 <= 1 || (n = string.indexOf(34, 1)) <= 0 || n >= n2 - 1;
    }

    public static boolean isWord(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        char c = string.charAt(0);
        if (c == '\'') {
            return Concept.isQuote(string);
        }
        Stack<Integer> stack = new Stack<Integer>();
        Integer n2 = new Integer(1);
        Integer n3 = new Integer(2);
        n = string.length();
        int n4 = 0;
        while (n4 < n) {
            c = string.charAt(n4);
            if (c == '\'' || c == '\"') {
                Integer n5 = stack.isEmpty() ? null : (Integer)stack.peek();
                if (c == '\'') {
                    if (n5 == n2) {
                        return false;
                    }
                    stack.push(n2);
                } else if (c == '\"') {
                    if (n5 == n3) {
                        stack.pop();
                    } else {
                        stack.push(n3);
                    }
                }
            }
            ++n4;
        }
        return true;
    }

    public int toNumber() {
        if (this.number >= 0) {
            return this.number;
        }
        Trace trace = this.trace.next;
        if (trace == null || trace.sign != 52) {
            return -1;
        }
        trace = trace.next;
        this.number = trace.sign;
        while (trace.next != null && trace.next.sign <= 31) {
            trace = trace.next;
            this.number <<= 5;
            this.number |= trace.sign;
        }
        return this.number;
    }

    public String toString() {
        return this.toString(this.trace);
    }

    String toString(Trace trace) {
        if (this.string != null) {
            return this.string;
        }
        if (trace.next == null) {
            this.string = "";
            return this.string;
        }
        int n = 0;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            if (trace2.sign == 52) {
                while (trace2.next != null) {
                    if (trace2.next.sign > 31) break;
                    trace2 = trace2.next;
                }
                n += PN.MAX_NUMBER_LENGTH;
            } else {
                ++n;
                if (trace2.sign == 53) {
                    ++n;
                }
            }
            trace2 = trace2.next;
        }
        char[] cArray = new char[n];
        int n2 = 0;
        int n3 = 49;
        boolean bl = false;
        trace2 = trace.next;
        while (trace2 != null) {
            if (trace2.sign > 31) {
                if (trace2.sign >= 55) {
                    switch (trace2.sign) {
                        case 56: {
                            if (bl) {
                                cArray[n2++] = 34;
                                bl = false;
                            }
                            cArray[n2++] = 58;
                            cArray[n2++] = 32;
                        }
                    }
                    n3 = 49;
                } else {
                    if (trace2.sign == 53) {
                        cArray[n2++] = 34;
                        bl = true;
                    } else if (trace2.sign == 52) {
                        cArray[n2++] = 35;
                    } else if (trace2.sign == 51) {
                        cArray[n2++] = 36;
                    }
                    n3 = trace2.sign;
                }
            } else {
                switch (n3) {
                    case 52: {
                        long l = trace2.sign;
                        while (trace2.next != null && trace2.next.sign <= 31) {
                            trace2 = trace2.next;
                            l <<= 5;
                            l |= (long)trace2.sign;
                        }
                        String string = Long.toString(l);
                        int n4 = string.length();
                        string.getChars(0, n4, cArray, n2);
                        n2 += n4;
                        break;
                    }
                    case 50: {
                        cArray[n2++] = (char)(0x20 | trace2.sign);
                        break;
                    }
                    case 49: {
                        cArray[n2++] = (char)(0x60 | trace2.sign);
                        break;
                    }
                    case 48: {
                        cArray[n2++] = (char)(0x40 | trace2.sign);
                        break;
                    }
                    case 44: {
                        int n5 = n2;
                        cArray[n5] = (char)(cArray[n5] | (char)(trace2.sign << 15));
                        trace2 = trace2.next;
                    }
                    case 45: {
                        int n6 = n2;
                        cArray[n6] = (char)(cArray[n6] | (char)(trace2.sign << 10));
                        trace2 = trace2.next;
                    }
                    case 46: {
                        int n7 = n2;
                        cArray[n7] = (char)(cArray[n7] | (char)(trace2.sign << 5));
                        trace2 = trace2.next;
                    }
                    case 47: {
                        int n8 = n2++;
                        cArray[n8] = (char)(cArray[n8] | (char)trace2.sign);
                        break;
                    }
                    case 43: {
                        cArray[n2++] = (char)(trace2.sign + 1072);
                        break;
                    }
                    case 42: {
                        cArray[n2++] = (char)(trace2.sign + 1040);
                        break;
                    }
                }
            }
            trace2 = trace2.next;
        }
        if (bl) {
            cArray[n2++] = 34;
        }
        this.string = String.valueOf(cArray, 0, n2);
        return this.string;
    }

    public static String wrap(String string) {
        if (Concept.isNumber(string) || Concept.isString(string) || Concept.isSpecific(string) || Concept.isQuote(string)) {
            return string;
        }
        return "'" + string + "'";
    }
}

