/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.AssociationFile;
import Sav.Processor.Int1;
import Sav.Processor.Node;
import Sav.Processor.PN;
import java.io.IOException;
import java.util.Observable;

public class Core
extends Observable {
    Node node;
    String path;
    AssociationFile aFile;
    boolean modifiable = true;
    int activity = 0;
    long state = 0L;
    int observation = 0;

    Core() {
        this.aFile = new AssociationFile();
        this.modifiable = this.aFile.modifiable;
        this.node = new Node(this);
    }

    Core(String string, boolean bl) throws IOException {
        this.path = string;
        this.aFile = new AssociationFile(string, bl);
        this.modifiable = this.aFile.modifiable;
        this.node = new Node(this);
        if (!this.aFile.open()) {
            return;
        }
        Int1 int1 = new Int1(0);
        this.node.count = -1;
        this.node.block = this.aFile.read(0);
        this.node.onset = PN.readSize(this.node.block, 0, int1);
        this.node.size = int1.value;
        this.node.address = 0;
    }

    synchronized void activate() {
        ++this.activity;
    }

    void close() throws IOException {
        this.reset();
        this.save();
        this.aFile.close();
        if (this.node.address < 0) {
            return;
        }
        if (this.node.count > 0) {
            this.node.descendant = null;
            this.node.posterity = null;
            this.node.count = -1;
        }
        this.node.block = new byte[4];
        this.node.onset = 0;
        this.node.size = PN.writeAddress(this.node.address, this.node.block, 0);
        this.node.address = -1;
        this.node.changed = false;
    }

    synchronized void deactivate() {
        --this.activity;
    }

    boolean delete() throws IOException {
        this.reset();
        this.aFile.close();
        if (!this.aFile.delete()) {
            return false;
        }
        if (this.node.count > 0) {
            this.node.descendant = null;
            this.node.posterity = null;
        }
        this.node.count = 0;
        this.node.block = null;
        this.node.onset = 0;
        this.node.size = 0;
        this.node.address = -1;
        this.node.changed = false;
        return true;
    }

    void reset() {
        this.setChanged();
        this.notifyObservers();
        this.deleteObservers();
        this.state = 0L;
    }

    void restore() throws IOException {
        if (!this.node.changed) {
            return;
        }
        this.reset();
        if (this.node.count > 0) {
            this.node.descendant = null;
            this.node.posterity = null;
            this.node.count = -1;
        }
        if (this.node.address < 0) {
            return;
        }
        this.node.block = new byte[4];
        this.node.onset = 0;
        this.node.size = PN.writeAddress(this.node.address, this.node.block, 0);
        this.node.address = -1;
        this.aFile.restore();
    }

    void save() throws IOException {
        if (!this.node.changed) {
            return;
        }
        if (this.node.count == 0) {
            this.delete();
            return;
        }
        if (this.node.address < 0) {
            this.node.address = this.aFile.alloc();
        }
        this.node.pack();
        this.node.save();
    }

    void setUp() {
        ++this.state;
    }

    void store() throws IOException {
        this.save();
        this.reset();
        this.aFile.store();
        if (this.node.count > 0) {
            this.node.descendant = null;
            this.node.posterity = null;
            this.node.count = -1;
        }
    }
}

