/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

import Sav.Processor.Core;
import Sav.Processor.Int1;
import Sav.Processor.NodeEnumerator;
import Sav.Processor.PN;
import Sav.Processor.Trace;
import java.io.IOException;
import java.io.PrintStream;

class Node
implements Cloneable {
    int notation;
    int sign;
    int count = 0;
    int nextType;
    int first;
    int last;
    Node descendant;
    Node[] posterity;
    Node ancestor;
    boolean changed = false;
    Core core;
    int onset;
    int size = 0;
    byte[] block;
    int address = -1;
    long power;
    Node powerNode;

    Node() {
        this.sign = 63;
    }

    Node(int n) {
        this.sign = n;
    }

    Node(Core core) {
        this.notation = 49;
        this.sign = 63;
        this.core = core;
    }

    Node(byte[] byArray, int n, int n2) {
        if (n2 == 0) {
            this.count = 0;
        } else {
            this.count = -1;
            this.size = n2;
            this.onset = n;
            this.block = byArray;
        }
    }

    int assess(Trace trace) throws IOException {
        if (this.restore() == 0) {
            return 0;
        }
        if (this.nextType == 0) {
            if (this.count != 1) {
                return this.count;
            }
            trace.next = new Trace(this.first);
            return this.descendant.assess(trace.next);
        }
        if (this.first > 56) {
            return 1;
        }
        if (this.count == 1) {
            Node node = this.descendant;
            trace.next = new Trace(this.first);
            return node.assess(trace.next);
        }
        int n = 24;
        int n2 = this.last & 0x1F;
        int n3 = this.count;
        int n4 = n2;
        while (n4 > n) {
            if (this.posterity[n4] != null) {
                --n3;
            }
            --n4;
        }
        if (this.last > 56) {
            ++n3;
        }
        return n3;
    }

    boolean clearAllConnect() throws IOException {
        if (this.restore() == 0 || this.last < 55) {
            return false;
        }
        if (this.first >= 55) {
            this.clearAllSigns();
            return true;
        }
        int n = this.first < 55 ? 23 : this.first & 0x1F;
        int n2 = this.last & 0x1F;
        int n3 = n;
        while (n3 <= n2) {
            Node node = this.posterity[n3];
            if (node != null) {
                node.clearAllSigns();
                if (node.address >= 0) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                }
                this.posterity[n3] = null;
            }
            ++n3;
        }
        return true;
    }

    boolean clearAllSigns() throws IOException {
        if (this.restore() == 0) {
            return false;
        }
        this.clearAllSigns1();
        this.setChange();
        return true;
    }

    void clearAllSigns1() throws IOException {
        if (this.restore() == 0) {
            return;
        }
        if (this.last >= 55) {
            this.lowerPower();
        }
        if (this.count == 1) {
            Node node = this.descendant;
            node.clearAllSigns1();
            if (node.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            }
            this.count = 0;
            this.descendant = null;
            return;
        }
        int n = this.first & 0x1F;
        int n2 = this.last & 0x1F;
        int n3 = n;
        while (n3 <= n2) {
            Node node = this.posterity[n3];
            if (node != null) {
                node.clearAllSigns1();
                if (node.address >= 0) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                }
            }
            ++n3;
        }
        this.count = 0;
        this.posterity = null;
    }

    boolean clearConnect(int n) throws IOException {
        return this.clearConnect(n, null, null, 0);
    }

    boolean clearConnect(int n, Trace trace, Node node, int n2) throws IOException {
        boolean bl;
        if (this.restore() == 0) {
            return false;
        }
        Node node2 = this.getSign(n);
        if (node2 == null) {
            return false;
        }
        if (trace != null) {
            Node node3 = node2.getTrace(56, trace);
            if (node3 == null) {
                return false;
            }
            bl = node != null ? node3.clearNode(node, n2) : node3.clearConnect(63);
            if (node3.count == 0) {
                node2.clearTrace(trace);
            }
        } else {
            if (node2.restore() == 0) {
                this.setChange();
            } else {
                node2.clearAllSigns();
            }
            bl = true;
        }
        if (!bl || node2.count != 0) {
            return bl;
        }
        if (node2.address >= 0) {
            this.core.aFile.free(node2.address);
            node2.address = -1;
        }
        this.clearSign(n);
        return true;
    }

    boolean clearNode(Node node, int n) throws IOException {
        if (this.restore() == 0 || node.restore() == 0) {
            return false;
        }
        boolean bl = false;
        Node node2 = this;
        if (node2.nextType < node.nextType) {
            if ((node = node.getSign(node2.notation)) == null) {
                return false;
            }
            return node2.clearNode(node, n);
        }
        if (node2.nextType > node.nextType) {
            Node node3 = node2.getSign(node.notation);
            if (node3 == null) {
                return false;
            }
            if (node3.clearNode(node, n)) {
                if (node3.count != 0) {
                    return true;
                }
                if (node3.address >= 0) {
                    this.core.aFile.free(node3.address);
                    node3.address = -1;
                }
                node2.clearSign(node2.notation);
                return true;
            }
            return false;
        }
        if (node2.first <= n && node.first <= n) {
            NodeEnumerator nodeEnumerator = new NodeEnumerator(node, n);
            nodeEnumerator.node0 = node2;
            while (nodeEnumerator.hasMoreNodes()) {
                Node node4 = nodeEnumerator.nextNode();
                Node node5 = node2.getSign(node4.sign);
                if (node5 == null || !node5.clearNode(node4, n)) continue;
                if (node5.count == 0) {
                    if (node5.address >= 0) {
                        this.core.aFile.free(node5.address);
                        node5.address = -1;
                    }
                    node2.clearSign(node4.sign);
                    if (node2.count == 0) {
                        return true;
                    }
                }
                bl = true;
            }
        }
        if (node2.last <= 56 || !node.hasConcept(n)) {
            return bl;
        }
        return node2.clearConnect(63) || bl;
    }

    boolean clearSign(int n) throws IOException {
        if (this.count == 0) {
            return false;
        }
        if (n >= 55) {
            this.lowerPower();
        }
        if (this.count == 1) {
            if (this.first == n) {
                this.count = 0;
                this.descendant = null;
                return true;
            }
            return false;
        }
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        int n4 = n & 0x1F;
        if (this.posterity[n4] == null) {
            return false;
        }
        --this.count;
        if (this.count == 1) {
            if (n4 == n2) {
                this.first = this.last;
            } else {
                this.last = this.first;
            }
            this.descendant = this.posterity[this.first & 0x1F];
            this.posterity = null;
        } else {
            this.posterity[n4] = null;
            if (n4 == n2) {
                n4 = n2 + 1;
                while (this.posterity[n4] == null) {
                    ++n4;
                }
                this.first = this.nextType | n4;
            } else if (n4 == n3) {
                n4 = n3 - 1;
                while (this.posterity[n4] == null) {
                    --n4;
                }
                this.last = this.nextType | n4;
            }
        }
        return true;
    }

    Node clearTrace(Trace trace) throws IOException {
        int n;
        if (this.restore() == 0) {
            return this;
        }
        if (trace.next == null) {
            return this;
        }
        int n2 = trace.next.sign & 0x20;
        if (this.nextType < n2) {
            if (this.notation != trace.next.sign) {
                return this;
            }
            return this.clearTrace(trace.next);
        }
        if (this.nextType > n2) {
            n = this.notation;
        } else {
            trace = trace.next;
            n = trace.sign;
        }
        Node node = this.getSign(n);
        if (node == null) {
            return this;
        }
        Node node2 = node.clearTrace(trace);
        if (node.count != 0) {
            return node2;
        }
        if (node.address >= 0) {
            this.core.aFile.free(node.address);
            node.address = -1;
        }
        this.clearSign(n);
        return this;
    }

    public Object clone(Node node) {
        Node node2 = null;
        try {
            node2 = (Node)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        if (this.count == 1) {
            node2.descendant = (Node)this.descendant.clone(node2);
        } else if (this.count > 1) {
            int n = this.last & 0x1F;
            node2.posterity = new Node[32];
            int n2 = this.first & 0x1F;
            while (n2 <= n) {
                if (this.posterity[n2] != null) {
                    node2.posterity[n2] = (Node)this.posterity[n2].clone(node2);
                }
                ++n2;
            }
        }
        node2.ancestor = node;
        if (this.block != null) {
            node2.block = new byte[this.block.length];
            System.arraycopy(this.block, 0, node2.block, 0, this.block.length);
        }
        return node2;
    }

    boolean correlates(Node node) {
        return this.nextType != 0 || node.nextType != 0 || this.notation == node.notation;
    }

    void definePower() throws IOException {
        int n;
        int n2 = this.first & 0x1F;
        if (this.last < 55) {
            n = this.last & 0x1F;
        } else {
            this.power = 1L;
            n = 22;
        }
        if (n < n2) {
            return;
        }
        if (this.count == 1) {
            this.power += this.descendant.power;
            this.descendant.power = 0L;
            return;
        }
        int n3 = n2;
        while (n3 <= n) {
            Node node = this.posterity[n3];
            if (node != null) {
                this.power += node.power;
                node.power = 0L;
            }
            ++n3;
        }
    }

    Trace determinateTrace(Node node) {
        Trace trace;
        Trace trace2 = new Trace();
        Node node2 = this;
        while (node2 != node) {
            trace2.sign = node2.sign;
            node2 = node2.ancestor;
            trace = trace2;
            trace2 = new Trace();
            trace2.next = trace;
        }
        if (trace2.next != null && trace2.next.sign <= 31) {
            trace2.sign = node2.notation;
            trace = trace2;
            trace2 = new Trace();
            trace2.next = trace;
        }
        return trace2;
    }

    Node freeAncestors() throws IOException {
        Node node = this;
        while (node.count == 0 && node.ancestor != null) {
            if (node.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            }
            int n = node.sign;
            node = node.ancestor;
            node.clearSign(n);
        }
        return node;
    }

    Node getNextNode(int n, Node node, Trace trace) throws IOException {
        if (this.restore() == 0) {
            throw new IndexOutOfBoundsException("\nUnexpected empty node\nSystem error, please direct to TechCenter");
        }
        if (trace.next == null) {
            return this.nextNode(n, node);
        }
        int n2 = trace.next.sign & 0x20;
        if (this.nextType < n2) {
            if (this.notation != trace.next.sign) {
                return this.nextNode(n, node);
            }
            return this.getNextNode(n, node, trace.next);
        }
        Node node2 = this.nextType > n2 ? this.getSign(this.notation) : this.getSign(trace.next.sign);
        if (node2 == null) {
            return this.nextNode(n, node);
        }
        return node2.getNextNode(n, node, trace.next);
    }

    Node getNode(Node node, int n, int n2, int n3, Core core) throws IOException {
        if (this.restore() == 0 || node.restore() == 0) {
            return null;
        }
        Node node2 = this;
        if (node2.nextType < node.nextType) {
            if ((node = node.getSign(node2.notation)) == null) {
                return null;
            }
            return node2.getNode(node, n, n2, n3, core);
        }
        if (node2.nextType > node.nextType) {
            if ((node2 = node2.getSign(node.notation)) == null) {
                return null;
            }
            return node2.getNode(node, n, n2, n3, core);
        }
        Node node3 = new Node(core);
        node3.notation = node.notation;
        if (node2.first <= n && node.first <= n) {
            if (node2.count < node.count) {
                NodeEnumerator nodeEnumerator = new NodeEnumerator(node2, n);
                nodeEnumerator.node0 = node;
                nodeEnumerator.result = node3;
                while (nodeEnumerator.hasMoreNodes()) {
                    Node node4;
                    Node node5 = nodeEnumerator.nextNode();
                    Node node6 = node.getSign(node5.sign);
                    if (node6 == null || (node4 = node5.getNode(node6, n, n2, n3, core)) == null) continue;
                    node3.setSign(node6.sign, node4);
                }
            } else {
                NodeEnumerator nodeEnumerator = new NodeEnumerator(node, n);
                nodeEnumerator.node0 = node2;
                nodeEnumerator.result = node3;
                while (nodeEnumerator.hasMoreNodes()) {
                    Node node7;
                    Node node8 = nodeEnumerator.nextNode();
                    Node node9 = node2.getSign(node8.sign);
                    if (node9 == null || (node7 = node9.getNode(node8, n, n2, n3, core)) == null) continue;
                    node3.setSign(node8.sign, node7);
                }
            }
        }
        node2.resumeGetNode(node, n, n2, n3, node3);
        if (node3.count == 0) {
            return null;
        }
        if (node3.count == 1 && node3.notation == node3.first) {
            node3 = node3.descendant;
            node3.ancestor = null;
            node3.sign = 63;
            return node3;
        }
        node3.definePower();
        node3.changed = true;
        return node3;
    }

    long getPower() throws IOException {
        if (this.power != 0L) {
            return this.power;
        }
        if (this.powerNode == null) {
            return 0L;
        }
        Node node = this.powerNode;
        while (node.restore() != 0) {
            node = node.descendant;
            this.power = this.power << 5 | (long)node.sign;
        }
        return this.power;
    }

    Node getSign(int n) {
        if (this.count == 0) {
            return null;
        }
        if (this.count == 1) {
            if (n == this.first) {
                return this.descendant;
            }
            return null;
        }
        return this.posterity[n & 0x1F];
    }

    Node getTrace(int n, Trace trace) throws IOException {
        Node node = this;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            if (trace2.sign > n) {
                if (node.hasConcept(n)) {
                    return node;
                }
                return null;
            }
            if ((node = node.getTraceSign(trace2.sign)) == null) {
                return null;
            }
            trace2 = trace2.next;
        }
        return node;
    }

    Node getTrace(Trace trace) throws IOException {
        Node node = this;
        Trace trace2 = trace.next;
        while (trace2 != null) {
            if ((node = node.getTraceSign(trace2.sign)) == null) {
                return null;
            }
            trace2 = trace2.next;
        }
        return node;
    }

    Node getTraceSign(int n) throws IOException {
        if (this.restore() == 0) {
            return null;
        }
        if (this.nextType < (n & 0x20)) {
            if (this.notation == n) {
                return this;
            }
            return null;
        }
        if (this.nextType > (n & 0x20)) {
            Node node = this.getSign(this.notation);
            if (node == null) {
                return null;
            }
            return node.getTraceSign(n);
        }
        return this.getSign(n);
    }

    boolean has(int n) throws IOException {
        return this.getTraceSign(n) != null;
    }

    boolean hasConcept(int n) throws IOException {
        if (this.restore() == 0) {
            return false;
        }
        return this.last > n;
    }

    boolean hasConnect() throws IOException {
        if (this.restore() == 0) {
            return false;
        }
        return this.last >= 55;
    }

    boolean hasNotat(int n) throws IOException {
        if (this.restore() == 0) {
            return false;
        }
        return this.first <= n;
    }

    void infix() throws IOException {
        Node node = new Node();
        this.propagate(this.notation, node);
        node.size = this.size;
        node.onset = this.onset;
        node.block = this.block;
        node.address = -1;
        node.count = this.count;
        node.changed = this.changed;
        node.nextType = this.nextType;
        node.first = this.first;
        node.last = this.last;
        node.descendant = this.descendant;
        node.posterity = this.posterity;
        if (this.count == 1) {
            this.descendant.ancestor = node;
        } else {
            int n = this.first & 0x1F;
            int n2 = this.last & 0x1F;
            int n3 = n;
            while (n3 <= n2) {
                Node node2 = this.posterity[n3];
                if (node2 != null) {
                    node2.ancestor = node;
                }
                ++n3;
            }
            this.posterity = null;
        }
        this.count = 0;
        this.setSign(this.notation, node);
    }

    void jam(Node node) throws IOException {
        node.restore();
        if (node.address >= 0) {
            if (this.address >= 0) {
                this.core.aFile.free(node.address);
                node.address = -1;
            } else {
                this.address = node.address;
            }
        }
        if (node.count == 1 && node.first == node.notation) {
            this.jam(node.descendant);
            return;
        }
        if (!node.changed) {
            this.size = node.size;
            this.onset = node.onset;
            this.block = node.block;
        }
        this.count = node.count;
        this.changed = node.changed;
        this.nextType = node.nextType;
        this.first = node.first;
        this.last = node.last;
        this.descendant = node.descendant;
        this.posterity = node.posterity;
        if (this.count == 1) {
            this.descendant.ancestor = this;
        } else {
            int n = this.first & 0x1F;
            int n2 = this.last & 0x1F;
            int n3 = n;
            while (n3 <= n2) {
                if (this.posterity[n3] != null) {
                    this.posterity[n3].ancestor = this;
                }
                ++n3;
            }
        }
    }

    Node lastNode(Node node, int n) throws IOException {
        Node node2;
        if (this.restore() == 0) {
            return null;
        }
        if (this.first > n) {
            return this;
        }
        int n2 = this.first & 0x1F;
        if (this.last > n) {
            node2 = null;
            int n3 = n & 0x1F;
            while (n3 >= n2) {
                node2 = this.posterity[n3];
                if (node2 == null) {
                    --n3;
                    continue;
                }
                break;
            }
        } else {
            node2 = this.count == 1 ? this.descendant : this.posterity[this.last & 0x1F];
        }
        return node2.lastNode(node, n);
    }

    void lowerPower() throws IOException {
        if (this.sign < 55 && this.ancestor != null) {
            this.ancestor.lowerPower();
            return;
        }
        if (this.power == 0L) {
            this.power = this.getPower();
            this.powerNode = null;
        }
        --this.power;
    }

    Node nextNode(int n, Node node) throws IOException {
        Node node2;
        if (this.first <= n) {
            node2 = this.count == 1 ? this.descendant : this.posterity[this.first & 0x1F];
            if (node2.restore() != 0) {
                if (node2.hasConcept(n)) {
                    return node2;
                }
                return node2.nextNode(n, node);
            }
        } else {
            node2 = this;
        }
        while (node2 != node) {
            int n2 = node2.sign & 0x1F;
            node2 = node2.ancestor;
            if (node2.count <= 1) continue;
            int n3 = node2.last > n ? n & 0x1F : node2.last & 0x1F;
            while (++n2 <= n3) {
                if (node2.posterity[n2] == null) continue;
                node2 = node2.posterity[n2];
                node2.restore();
                if (node2.hasConcept(n)) {
                    return node2;
                }
                return node2.nextNode(n, node);
            }
        }
        return null;
    }

    void pack() throws IOException {
        int n;
        Node node = null;
        if (this.count <= 0) {
            return;
        }
        if (this.size > 0) {
            return;
        }
        if (this.power > 0L) {
            this.packPower();
        }
        if (this.powerNode == null) {
            if (this.count == 1 && this.first == this.notation) {
                this.jam(this.descendant);
            }
        } else if (this.nextType == 0) {
            this.infix();
        }
        if (this.count == 1 && this.powerNode == null) {
            node = this.descendant;
            int n2 = 1;
            if (this.nextType == 0) {
                while (node.count == 1) {
                    if (node.first == node.notation) {
                        node.jam(node.descendant);
                    }
                    if (node.nextType != 0 || node.address >= 0 && node.size + n2 > 8190) break;
                    node = node.descendant;
                    if (++n2 != 32) continue;
                }
                if (n2 == 2) {
                    node = this.descendant;
                    n2 = 1;
                }
            }
            if (n2 == 1) {
                this.size = 1;
                this.block = new byte[this.size];
                this.block[0] = (byte)node.sign;
            } else {
                this.size = (int)Math.ceil((double)n2 * 5.0 / 8.0) + 1;
                this.block = new byte[this.size];
                this.block[0] = (byte)(0x40 | this.nextType | n2 - 1);
                int n3 = 1;
                int n4 = 0;
                int n5 = 0;
                node = this.descendant;
                while (true) {
                    n5 |= (node.sign & 0x1F) << n4;
                    if ((n4 += 5) > 7) {
                        this.block[n3++] = (byte)n5;
                        n5 >>= 8;
                        n4 -= 8;
                    }
                    if (--n2 == 0) break;
                    if (node.address >= 0) {
                        this.core.aFile.free(node.address);
                        node.address = -1;
                    }
                    if (!node.changed) {
                        node.changed = true;
                        node.size = 0;
                        node.block = null;
                        node.onset = 0;
                    }
                    node = node.descendant;
                }
                if (n4 > 0) {
                    this.block[n3++] = (byte)n5;
                }
            }
            node.pack();
            if (node.address >= 0) {
                if (this.size + node.size <= 8190) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                    this.size += node.size;
                } else {
                    this.size = node.address > 0x1FFFFF ? (this.size += 4) : (this.size += 3);
                }
            } else if (this.size + node.size > 8190) {
                node.address = this.core.aFile.alloc();
                node.changed = true;
                this.size = node.address > 0x1FFFFF ? (this.size += 4) : (this.size += 3);
            } else {
                this.size += node.size;
            }
            return;
        }
        int n6 = 0;
        int n7 = -1;
        int n8 = 8190;
        int n9 = 0;
        int n10 = this.first & 0x1F;
        int n11 = this.last & 0x1F;
        if (this.powerNode != null) {
            n6 = 1;
            n = this.powerNode.size;
            this.size = n > 127 ? (this.size += n + 2) : (this.size += n + 1);
        }
        if (this.count == 1) {
            node = this.descendant;
            n6 |= 1 << (node.sign & 0x1F);
            node.pack();
            if (node.address >= 0) {
                if (node.size <= 4095) {
                    this.core.aFile.free(node.address);
                    node.address = -1;
                    n = node.size;
                } else {
                    n = node.address > 0x1FFFFF ? 4 : 3;
                }
            } else {
                n = node.size;
            }
            this.size = n > 127 ? (this.size += n + 2) : (this.size += n + 1);
        } else {
            n9 = n10;
            while (n9 <= n11) {
                node = this.posterity[n9];
                if (node != null) {
                    n6 |= 1 << n9;
                    node.pack();
                    if (node.address >= 0) {
                        if (node.size <= 4095 && node.size < n8) {
                            n7 = n9;
                            n8 = node.size;
                        }
                        n = node.address > 0x1FFFFF ? 4 : 3;
                    } else {
                        n = node.size;
                    }
                    this.size = n > 127 ? (this.size += n + 2) : (this.size += n + 1);
                }
                ++n9;
            }
        }
        int n12 = 1;
        int n13 = 0x80 | this.nextType;
        int n14 = 255;
        int n15 = 0;
        while (n15 < 4) {
            if ((n6 & n14) != 0) {
                ++n12;
                n13 |= 1 << n15;
            }
            n14 <<= 8;
            ++n15;
        }
        this.size += n12;
        this.block = new byte[n12];
        this.block[0] = (byte)n13;
        int n16 = 1;
        n15 = 0;
        while (n15 < 4) {
            n14 = n6 & 0xFF;
            if (n14 != 0) {
                this.block[n16++] = (byte)n14;
            }
            n6 >>>= 8;
            ++n15;
        }
        while (n7 >= 0) {
            if (this.size - 2 + n8 > 8190) break;
            node = this.posterity[n7];
            this.size = node.address > 0x1FFFFF ? (this.size -= 4) : (this.size -= 3);
            this.core.aFile.free(node.address);
            node.address = -1;
            this.size += n8;
            if (n8 > 127) {
                ++this.size;
            }
            n7 = -1;
            n8 = 8190;
            if (this.size > 4095) continue;
            n9 = n10;
            while (n9 <= n11) {
                node = this.posterity[n9];
                if (node != null && node.address >= 0 && node.size < 4095 && node.size < n8) {
                    n8 = node.size;
                    n7 = n9;
                }
                ++n9;
            }
        }
        while (this.size > 8190) {
            n = 0;
            n9 = n10;
            while (n9 <= n11) {
                node = this.posterity[n9];
                if (node != null && node.count != 0 && node.address < 0 && node.size > n) {
                    n14 = n9;
                    n = node.size;
                }
                ++n9;
            }
            node = this.posterity[n14];
            this.size -= n;
            if (n > 127) {
                --this.size;
            }
            node.address = this.core.aFile.alloc();
            node.changed = true;
            if (node.address > 0x1FFFFF) {
                this.size += 4;
                continue;
            }
            this.size += 3;
        }
    }

    void packPower() throws IOException {
        this.powerNode = new Node(32);
        this.powerNode.notation = 32;
        this.powerNode.core = this.core;
        this.powerNode.setTrace(new Trace(this.power));
        this.powerNode.pack();
    }

    void print() throws IOException {
        this.print(System.out);
    }

    void print(PrintStream printStream) throws IOException {
        printStream.print("Node=");
        this.printAncestor(printStream);
        printStream.println();
        this.printDescendants(printStream, 0);
        printStream.println();
        printStream.flush();
    }

    void printAncestor(PrintStream printStream) throws IOException {
        if (this.ancestor != null) {
            this.ancestor.printAncestor(printStream);
            printStream.print(':');
        }
        printStream.print(this.sign);
    }

    void printDescendants(PrintStream printStream, int n) throws IOException {
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        String string = String.valueOf(this.sign);
        printStream.print(string);
        if (this.count <= 0) {
            return;
        }
        printStream.print(':');
        n += string.length() + 1;
        boolean bl = true;
        if (this.count == 1) {
            this.descendant.printDescendants(printStream, n);
        } else {
            int n4 = n2;
            while (n4 <= n3) {
                if (this.posterity[n4] != null) {
                    if (bl) {
                        bl = false;
                    } else {
                        this.printLineSpace(printStream, n);
                    }
                    this.posterity[n4].printDescendants(printStream, n);
                }
                ++n4;
            }
        }
    }

    void printLineSpace(PrintStream printStream, int n) throws IOException {
        printStream.println();
        int n2 = 0;
        while (n2 < n) {
            printStream.print(' ');
            ++n2;
        }
    }

    void propagate(int n, Node node) {
        node.ancestor = this;
        node.core = this.core;
        node.sign = n;
        node.notation = n >= 55 ? 49 : (n > 31 ? n : this.notation);
    }

    synchronized int restore() throws IOException {
        Node node;
        int n;
        int n2;
        if (this.count >= 0) {
            return this.count;
        }
        Int1 int1 = new Int1(0);
        int n3 = this.onset;
        if (this.block == null) {
            this.count = 0;
            return this.count;
        }
        if ((n2 = this.block[n3++] & 0xFF) >= 192) {
            PN.readAddress(this.block, this.onset, int1);
            this.address = int1.value;
            this.block = this.core.aFile.read(this.address);
            if (this.block == null) {
                this.count = 0;
                this.address = -1;
                return this.count;
            }
            n3 = PN.readSize(this.block, 0, int1);
            this.size = int1.value;
            this.onset = n3;
            n2 = this.block[n3++] & 0xFF;
        }
        this.nextType = n2 & 0x20;
        if (n2 >= 128) {
            int n4;
            int n5 = 0;
            this.first = 3;
            int n6 = 0;
            while (n6 < 4) {
                if ((n2 & 1 << n6) != 0) {
                    n5 |= (this.block[n3++] & 0xFF) << (n6 << 3);
                    if (this.first > n6) {
                        this.first = n6;
                    }
                    this.last = n6;
                }
                ++n6;
            }
            this.last = (this.last << 3) + 7;
            int n7 = 1 << this.last;
            while ((n5 & n7) == 0) {
                --this.last;
                n7 >>>= 1;
            }
            this.first <<= 3;
            n7 = 1 << this.first;
            while ((n5 & n7) == 0) {
                ++this.first;
                n7 <<= 1;
            }
            if (this.nextType > 0 && this.first == 0) {
                n3 = PN.readSize(this.block, n3, int1);
                n4 = int1.value;
                this.powerNode = new Node(this.block, n3, n4);
                n3 += n4;
                ++this.first;
                n7 <<= 1;
                while ((n5 & n7) == 0) {
                    ++this.first;
                    n7 <<= 1;
                }
                if (this.first == this.last) {
                    this.count = 1;
                    n3 = PN.readSize(this.block, n3, int1);
                    n4 = int1.value;
                    this.descendant = new Node(this.block, n3, n4);
                    this.propagate(this.nextType | this.first, this.descendant);
                    this.first |= this.nextType;
                    this.last |= this.nextType;
                    return this.count;
                }
            }
            this.count = 0;
            this.posterity = new Node[32];
            int n8 = this.first;
            while (n8 <= this.last) {
                if ((n5 & n7) != 0) {
                    ++this.count;
                    n3 = PN.readSize(this.block, n3, int1);
                    n4 = int1.value;
                    this.posterity[n8] = new Node(this.block, n3, n4);
                    n3 += n4;
                    this.propagate(this.nextType | n8, this.posterity[n8]);
                }
                ++n8;
                n7 <<= 1;
            }
            this.first |= this.nextType;
            this.last |= this.nextType;
            return this.count;
        }
        int n9 = 0;
        int n10 = n3;
        Node node2 = this;
        if (n2 >= 64) {
            int n11 = n2 & 0x1F;
            int n12 = this.block[n3++] & 0xFF;
            int n13 = 8;
            while (true) {
                n9 = n12 & 0x1F;
                n = this.nextType | n9;
                n12 >>= 5;
                n13 -= 5;
                if (n11-- == 0) break;
                node = new Node();
                node2.count = 1;
                node2.nextType = this.nextType;
                node2.first = n;
                node2.last = n;
                node2.descendant = node;
                node2.propagate(n, node);
                node2 = node;
                if (n13 >= 5) continue;
                n12 |= (this.block[n3++] & 0xFF) << n13;
                n13 += 8;
            }
            node = new Node(this.block, n3, this.size - 1 - (n3 - n10));
        } else {
            n9 = n2 & 0x1F;
            n = this.nextType | n9;
            node = new Node(this.block, n3, this.size - 1);
        }
        node2.count = 1;
        node2.nextType = this.nextType;
        node2.first = n;
        node2.last = n;
        node2.descendant = node;
        node2.propagate(n, node);
        return 1;
    }

    void resumeGetNode(Node node, int n, int n2, int n3, Node node2) throws IOException {
        Node node3;
        Node node4;
        Node node5;
        if (this.hasConcept(n) && node.hasConcept(n)) {
            node2.setSign(63, new Node());
        }
        if (n2 == 0 || !this.hasConcept(n) && !node.hasConcept(n)) {
            return;
        }
        if (node.hasConcept(n) && !node.has(n3) && this.has(n3) && (node5 = this.getSign(n3)) != null) {
            node4 = new Node();
            node2.setSign(n3, node4);
            node4.setNode(node5, n);
        }
        if (this.hasConcept(n) && !this.has(n2) && node.has(n2) && (node3 = node.getSign(n2)) != null) {
            node4 = new Node();
            node2.setSign(n2, node4);
            node4.setNode(node3, n);
        }
    }

    void save() throws IOException {
        if (!this.changed) {
            return;
        }
        this.core.aFile.openSaving();
        byte[] byArray = new byte[8192];
        int n = PN.writeSize(this.size, byArray, 0);
        this.save1(byArray, n);
        if (this.address == 0) {
            Int1 int1 = new Int1(0);
            n = PN.readSize(byArray, 0, int1);
            if ((n += int1.value) + 3 < 8192) {
                PN.writeAddress(this.sign, byArray, n);
            }
        }
        this.core.aFile.write(byArray, this.address);
        this.core.aFile.closeSaving();
    }

    void save1(byte[] byArray, int n) throws IOException {
        this.changed = false;
        if (this.count == 0) {
            return;
        }
        if (this.onset > 0) {
            System.arraycopy(this.block, this.onset, byArray, n, this.size);
            this.block = byArray;
            this.onset = n;
            return;
        }
        int n2 = this.block.length;
        System.arraycopy(this.block, 0, byArray, n, n2);
        this.block = byArray;
        this.onset = n;
        n += n2;
        if (this.count == 1 && this.powerNode == null) {
            this.descendant.save2(byArray, n);
            return;
        }
        if (this.powerNode != null) {
            n = PN.writeSize(this.powerNode.size, byArray, n);
            this.powerNode.save2(byArray, n);
            n += this.powerNode.size;
        }
        if (this.count == 1) {
            n = PN.writeSize(this.descendant.size, byArray, n);
            this.descendant.save1(byArray, n);
            n += this.descendant.size;
            return;
        }
        int n3 = this.first & 0x1F;
        int n4 = this.last & 0x1F;
        int n5 = n3;
        while (n5 <= n4) {
            Node node = this.posterity[n5];
            if (node != null) {
                if (node.address >= 0) {
                    int n6 = node.address > 0x1FFFFF ? 4 : 3;
                    n = PN.writeSize(n6, byArray, n);
                    n = PN.writeAddress(node.address, byArray, n);
                    node.save3();
                } else {
                    n = PN.writeSize(node.size, byArray, n);
                    node.save1(byArray, n);
                    n += node.size;
                }
            }
            ++n5;
        }
    }

    void save2(byte[] byArray, int n) throws IOException {
        if (this.count == 1 && this.size == 0) {
            this.descendant.save2(byArray, n);
            this.changed = false;
            return;
        }
        if (this.address >= 0) {
            PN.writeAddress(this.address, byArray, n);
            this.save3();
            return;
        }
        this.save1(byArray, n);
    }

    void save3() throws IOException {
        if (!this.changed) {
            return;
        }
        byte[] byArray = new byte[8192];
        int n = PN.writeSize(this.size, byArray, 0);
        this.save1(byArray, n);
        this.core.aFile.write(byArray, this.address);
    }

    Node seekKeyNode(int n) throws IOException {
        if (this.hasConcept(n) || this.count > 1) {
            return this;
        }
        if (this.count == 0) {
            return null;
        }
        return this.descendant.seekKeyNode(n);
    }

    void setChange() {
        Node node = this;
        while (node != null) {
            if (node.changed && node.size == 0) {
                return;
            }
            node.changed = true;
            node.size = 0;
            node.block = null;
            node.onset = 0;
            node = node.ancestor;
        }
    }

    boolean setConnect(int n) throws IOException {
        return this.setConnect(n, null, null, 0);
    }

    boolean setConnect(int n, Trace trace, Node node, int n2) throws IOException {
        boolean bl = false;
        Node node2 = this.getTraceSign(n);
        if (node2 == null) {
            if (this.count > 0 && this.nextType == 0) {
                this.infix();
            }
            node2 = new Node();
            this.setSign(n, node2);
            bl = true;
        }
        if (trace != null) {
            Node node3 = node2.setTrace(trace);
            bl = node == null ? node3.setConnect(63) : node3.setNode(node, n2);
        } else {
            if (n == 63) {
                if (bl) {
                    this.setChange();
                }
                return bl;
            }
            bl = node2.setConnect(63);
        }
        return bl;
    }

    Node setCorrelating(Node node) throws IOException {
        if (this.correlates(node)) {
            return this;
        }
        Node node2 = new Node();
        this.setSign(node.notation, node2);
        return node2;
    }

    boolean setNode(Node node, int n) throws IOException {
        if (node.restore() == 0) {
            return false;
        }
        boolean bl = false;
        Node node2 = this;
        if (node.count == 1 && node.first == node2.notation) {
            node = node.getSign(node2.notation);
            return node2.setNode(node, n);
        }
        if (node2.restore() == 0) {
            if (node.first <= n) {
                NodeEnumerator nodeEnumerator = new NodeEnumerator(node, n);
                nodeEnumerator.node0 = node2;
                while (nodeEnumerator.hasMoreNodes()) {
                    Node node3 = nodeEnumerator.nextNode();
                    Node node4 = new Node();
                    node2.setSign(node3.sign, node4);
                    node4.setNode(node3, n);
                }
            }
            if (node.hasConcept(n)) {
                node2.setSign(63, new Node());
                node2.setChange();
            }
            return true;
        }
        if (node2.nextType < node.nextType) {
            node2.infix();
        } else if (node2.nextType > node.nextType) {
            Node node5 = node2.getSign(node.notation);
            if (node5 == null) {
                node5 = new Node();
                node2.setSign(node.notation, node5);
            }
            node2 = node5;
            return node2.setNode(node, n);
        }
        if (node.first <= n) {
            NodeEnumerator nodeEnumerator = new NodeEnumerator(node, n);
            nodeEnumerator.node0 = node2;
            while (nodeEnumerator.hasMoreNodes()) {
                Node node6 = nodeEnumerator.nextNode();
                Node node7 = node2.getSign(node6.sign);
                if (node7 == null) {
                    node7 = new Node();
                    node2.setSign(node6.sign, node7);
                    bl = true;
                }
                node7.setNode(node6, n);
            }
        }
        if (node.hasConcept(n) && node2.last != 63) {
            node2.setSign(63, new Node());
            node2.setChange();
            bl = true;
        }
        return bl;
    }

    void setSign(int n, Node node) throws IOException {
        int n2 = this.first & 0x1F;
        int n3 = this.last & 0x1F;
        int n4 = n & 0x1F;
        if (n >= 55) {
            this.upperPower();
        }
        if (this.count == 0) {
            this.count = 1;
            this.nextType = n & 0x20;
            this.first = n;
            this.last = n;
            this.descendant = node;
            this.propagate(n, node);
            return;
        }
        if (this.count == 1) {
            if (n2 == n4) {
                return;
            }
            this.posterity = new Node[32];
            this.posterity[n2] = this.descendant;
            this.descendant = null;
        }
        ++this.count;
        if (n4 < n2) {
            this.first = this.nextType | n4;
        } else if (n4 > n3) {
            this.last = this.nextType | n4;
        }
        this.posterity[n4] = node;
        this.propagate(n, node);
    }

    Node setTrace(Trace trace) throws IOException {
        int n;
        if (trace.next == null) {
            return this;
        }
        if (this.notation == trace.next.sign) {
            return this.setTrace(trace.next);
        }
        if (this.restore() == 0) {
            trace = trace.next;
            Node node = new Node();
            this.setSign(trace.sign, node);
            return node.setTrace(trace);
        }
        int n2 = trace.next.sign & 0x20;
        if (this.nextType < n2) {
            this.infix();
        }
        if (this.nextType > n2) {
            n = this.notation;
        } else {
            trace = trace.next;
            n = trace.sign;
        }
        Node node = this.getSign(n);
        if (node == null) {
            node = new Node();
            this.setSign(n, node);
        }
        return node.setTrace(trace);
    }

    void store(int n, int n2) throws IOException {
        if (this.count <= 0 || n > (this.last & 0x1F) || n2 < (this.first & 0x1F)) {
            return;
        }
        if (this.core.node.address < 0) {
            this.core.node.address = this.core.aFile.alloc();
        }
        this.pack();
        this.core.aFile.openSaving();
        if (this.count == 1) {
            this.descendant.store1();
        } else {
            int n3 = n;
            while (n3 <= n2) {
                if (this.posterity[n3] != null) {
                    this.posterity[n3].store1();
                }
                ++n3;
            }
        }
        this.core.aFile.closeSaving();
        this.core.aFile.store();
    }

    void store1() throws IOException {
        if (this.changed) {
            byte[] byArray = this.address >= 0 ? new byte[8192] : new byte[this.size + 2];
            int n = PN.writeSize(this.size, byArray, 0);
            this.save1(byArray, n);
            if (this.address >= 0) {
                this.core.aFile.write(byArray, this.address);
            }
        }
        this.count = -1;
        this.descendant = null;
        this.posterity = null;
    }

    void upperPower() throws IOException {
        if (this.sign < 55 && this.ancestor != null) {
            this.ancestor.upperPower();
            return;
        }
        if (this.power == 0L) {
            this.power = this.getPower();
            this.powerNode = null;
        }
        ++this.power;
    }
}

