/*
 * Decompiled with CFR 0.152.
 */
package Sav.Processor;

class Trace {
    int sign;
    Trace next = null;

    Trace() {
        this.sign = -1;
    }

    Trace(int n) {
        this.sign = n;
    }

    Trace(long l) {
        Trace trace = null;
        while (l > 0L) {
            Trace trace2 = new Trace((int)(l & 0x1FL));
            trace2.next = trace;
            trace = trace2;
            l >>>= 5;
        }
        this.sign = -1;
        this.next = trace;
    }

    boolean equals(Trace trace) {
        Trace trace2 = this;
        Trace trace3 = trace;
        while (trace3.next != null) {
            if (trace2.next == null) {
                return false;
            }
            if (trace3.next.sign != trace2.next.sign) {
                return false;
            }
            trace3 = trace3.next;
            trace2 = trace2.next;
        }
        return trace2.next == null;
    }

    boolean equals(Trace trace, Trace trace2, Trace trace3) {
        Trace trace4 = this;
        Trace trace5 = trace;
        while (trace5.next != null) {
            if (trace4.next == null) break;
            if (trace5.next.sign != trace4.next.sign) {
                trace2.next = trace4.next;
                trace3.next = trace5.next;
                return false;
            }
            trace5 = trace5.next;
            trace4 = trace4.next;
        }
        trace2.next = trace4.next;
        trace3.next = trace5.next;
        return true;
    }

    boolean equals(Trace trace, Trace trace2, Trace trace3, Trace trace4) {
        Trace trace5 = this;
        Trace trace6 = trace;
        Trace trace7 = trace4;
        while (trace6.next != null) {
            if (trace5.next == null) break;
            if (trace5.next.sign != trace6.next.sign) {
                trace2.next = trace5.next;
                trace3.next = trace6.next;
                return trace4.next != null;
            }
            trace7 = trace7.next = new Trace(trace5.next.sign);
            trace5 = trace5.next;
            trace6 = trace6.next;
        }
        trace2.next = trace5.next;
        trace3.next = trace6.next;
        return true;
    }

    Trace getFirstPart(int n) {
        Trace trace = new Trace();
        Trace trace2 = trace.next;
        Trace trace3 = this.next;
        while (trace3 != null && trace3.sign != n) {
            trace2 = new Trace(trace3.sign);
            trace2 = trace2.next;
            trace3 = trace3.next;
        }
        return trace;
    }

    Trace getLast() {
        Trace trace = this;
        while (trace.next != null) {
            trace = trace.next;
        }
        return trace;
    }

    Trace insert(Trace trace) {
        Trace trace2 = this;
        Trace trace3 = this.next;
        while (trace.next != null) {
            trace = trace.next;
            trace2 = trace2.next = new Trace(trace.sign);
        }
        trace2.next = trace3;
        return trace2;
    }

    Trace newInstance() {
        Trace trace = new Trace();
        trace.insert(this);
        Trace trace2 = trace.getLast();
        if (trace2.sign < 31 && trace2.sign >= -1) {
            ++trace2.sign;
        } else {
            trace2.next = new Trace(0);
        }
        return trace;
    }

    Trace substitute(Trace trace) {
        Trace trace2 = this;
        while (trace2.next != null) {
            if (trace.next == null) {
                trace2.next = null;
                return trace2;
            }
            trace2 = trace2.next;
            trace = trace.next;
            trace2.sign = trace.sign;
        }
        return trace2.insert(trace);
    }

    long toNumber() {
        if (this.next == null) {
            return 0L;
        }
        Trace trace = this.next;
        long l = trace.sign;
        while (trace.next != null) {
            trace = trace.next;
            l <<= 5;
            l |= (long)trace.sign;
        }
        return l;
    }
}

