/*
 * Decompiled with CFR 0.152.
 */
package Sav.Z;

import Sav.Processor.Association;
import Sav.Processor.Concept;
import Sav.Processor.Long1;
import Sav.Processor.PList;
import Sav.Processor.PN;
import Sav.Z.Copula;
import Sav.Z.Interface;
import Sav.Z.Procedure;
import Sav.Z.Statement;
import Sav.Z.Warning;
import java.io.File;
import java.io.IOException;

class Expression
implements Interface {
    static Expression eNull = new Expression();
    int index;
    Concept cnc;
    Association ass;
    String script;
    int begin;
    int end;
    Copula copula;
    PList list = new PList();
    boolean no;
    String type;
    Statement stm;
    File baseFile;
    File file;
    Procedure proc;
    Expression eContext;
    int property;

    static {
        Expression.eNull.index = -10;
    }

    Expression() {
    }

    Expression(Statement statement) {
        this.stm = statement;
        this.script = this.stm.script;
    }

    void add(Expression expression, Copula copula) {
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(expression);
    }

    void add(Expression expression, Copula copula, Expression expression2) {
        this.begin = expression.begin;
        this.end = expression2.end;
        this.copula = copula;
        this.index = copula.index;
        this.list.add(expression);
        this.list.add(expression2);
    }

    void affect(Expression expression) {
        this.index = expression.index;
        this.cnc = expression.cnc;
        this.ass = expression.ass;
        this.script = expression.script;
        this.begin = expression.begin;
        this.end = expression.end;
        this.copula = expression.copula;
        this.list = expression.list;
        this.no = expression.no;
        this.type = expression.type;
        this.stm = expression.stm;
        this.baseFile = expression.baseFile;
        this.file = expression.file;
        this.proc = expression.proc;
    }

    void construe(Expression expression, int n) throws IOException {
        Expression expression2;
        switch (this.index) {
            case 0: {
                this.construeSpecific(expression, n);
                break;
            }
            case 5: {
                this.construeSpace(expression, n);
                break;
            }
            case 6: {
                this.construeBrace(expression, n);
                break;
            }
            case 11: {
                expression2 = (Expression)this.list.getFirst();
                if (expression2.index == -10) {
                    n &= 0xFFFFFFFE;
                }
            }
            case 12: {
                this.construeComposition(expression, n);
                break;
            }
            case 14: {
                this.construeEquality(expression, n);
                break;
            }
            case 15: {
                this.construeComposition(expression, n);
                break;
            }
        }
        if (this.list.hasOne()) {
            if (this.index >= 11) {
                expression2 = (Expression)this.list.getFirst();
                if (expression2.index == -10) {
                    this.index = -10;
                } else {
                    this.affect(expression2);
                }
            }
        } else if (this.list.isEmpty()) {
            if (this.index == -4) {
                this.warnErr1("Missing procedure's parentheses");
                this.list.add(this.stm.createExpression(this.end, -10));
                this.proc = new Procedure(this);
                this.proc.construe();
            } else if (this.index > 0) {
                this.index = -10;
            }
        }
    }

    void construeBrace(Expression expression, int n) throws IOException {
        Expression expression2 = (Expression)this.list.getFirst();
        if (expression2.index == -10) {
            Expression expression3 = (Expression)this.list.getNext();
            this.end = expression3.end + 1;
            this.list = expression3.list;
            if (this.copula.mark == '{') {
                this.index = 6;
                this.construeComposition(expression, n);
            } else if (this.copula.mark == '[') {
                this.index = 7;
                this.construeComposition(null, n);
            } else if (this.copula.mark == '(') {
                this.index = 8;
                this.construeComposition(null, n);
            }
            return;
        }
        this.property = n;
        expression2.index = -4;
        expression2.construeSpecific(null, n);
        if (expression2.index != -10 && expression2.index != -4) {
            expression2.warnErr("Unrecognized procedure name", expression2.begin + 1);
            expression2.index = -10;
        }
        if (expression2.index == -10) {
            this.index = -10;
            return;
        }
        this.begin = expression2.begin;
        this.index = -4;
        this.cnc = expression2.cnc;
        Expression expression4 = (Expression)this.list.getNext();
        this.end = expression4.end + 1;
        this.list = expression4.list;
        this.proc = new Procedure(this);
        this.proc.construe();
    }

    void construeComposition(Expression expression, int n) throws IOException {
        Expression expression2;
        Expression expression3 = null;
        this.eContext = expression;
        this.property = n;
        if (this.index == 14) {
            expression2 = (Expression)this.list.getLast();
            if (expression2.index == -10) {
                n |= 1;
            }
            expression3 = (Expression)this.list.getFirst();
            if (expression3.index == -10) {
                n &= 0xFFFFFFFE;
            }
        }
        if (this.index <= 12) {
            n |= 4;
        }
        if (this.index == 8 || this.index == 7) {
            n &= 0xFFFFFFF7;
        }
        expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            expression2.construe(expression, n);
            if (this.index == 12) {
                n |= 8;
            }
            if (expression2.index != -10) {
                if (this.index == 12) {
                    expression = expression2;
                }
            } else if (expression2.copula != null) {
                this.list.remove();
            } else if (this.index == 6 || this.index == 7 || this.index == 8 || this.index == 15) {
                expression2.warnErr0("Unexpected indefinitude");
                this.list.remove();
            } else if (this.list.hasBack()) {
                if (this.list.hasNext()) {
                    expression2.warnErr0("Unexpected indefinitude");
                    this.list.remove();
                } else {
                    if (this.index == 14) {
                        if (expression3.index != -10) break;
                        expression2.warnErr0("Unexpected indefinitude");
                        this.list.remove();
                        break;
                    }
                    if (this.index != 12) break;
                    expression3 = (Expression)this.list.getBack();
                    this.list.getNext();
                    if (expression3.index != -10) break;
                    expression2.warnErr0("Unexpected indefinitude");
                    this.list.remove();
                    break;
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeEquality(Expression expression, int n) throws IOException {
        this.construeComposition(expression, n);
        Expression expression2 = (Expression)this.list.getFirst();
        Expression expression3 = (Expression)this.list.getNext();
        if (expression3 == null) {
            return;
        }
        if (expression2.index == -10) {
            if (expression3.no && n != 1) {
                expression2.warnErr1("Unexpected inequality");
                this.index = -10;
                return;
            }
            return;
        }
        if (expression2.index == -4 || expression2.index == -2) {
            this.warnErr("Irregular =/~ equality", this.copula.position);
            while (expression3 != null) {
                this.list.remove();
                expression3 = (Expression)this.list.getNext();
            }
            return;
        }
        if (expression2.index == -1 && (expression3.index != -10 || this.list.hasNext())) {
            this.list.getFirst();
            this.warnErr("Irregular =/~ equality", this.copula.position);
            while (expression3 != null) {
                this.list.remove();
                expression3 = (Expression)this.list.getNext();
            }
            return;
        }
    }

    void construeNumber() {
        int n = this.end - this.begin - 1;
        if (n == 0) {
            return;
        }
        long l = Long.parseLong(this.script.substring(this.begin + 1, this.end));
        if (l > 0x3FFFFFFFL) {
            this.warnErr0("Number > PN.MAX_NUMBER(1073741823)");
            this.index = -10;
            return;
        }
        this.cnc = new Concept((int)l);
    }

    void construeSpace(Expression expression, int n) throws IOException {
        this.eContext = expression;
        this.property = n;
        Expression expression2 = (Expression)this.list.getFirst();
        while (expression2 != null) {
            switch (expression2.index) {
                case 4: {
                    expression2.construeWord();
                    break;
                }
                case 2: {
                    expression2.construeNumber();
                    break;
                }
                case 3: {
                    expression2.construeString();
                    break;
                }
                case 1: {
                    if (this.list.hasBack() || (n & 8) != 0) break;
                    expression2.warnErr0("Unexpected * ellipsis");
                    this.index = -10;
                    return;
                }
            }
            expression2 = (Expression)this.list.getNext();
        }
    }

    void construeSpecific(Expression expression, int n) throws IOException {
        Concept concept;
        Concept concept2;
        boolean bl;
        int n2;
        int n3;
        int n4;
        this.eContext = expression;
        this.property = n;
        if (this.script.charAt(this.begin) == '$') {
            String string;
            int n5 = this.begin + 1;
            if (this.script.charAt(n5) != '\"' && this.script.charAt(n5) != '\'') {
                n4 = n5;
                while (n4 < this.end) {
                    if (this.script.charAt(n4) == '\"' || this.script.charAt(n4) == '\'' || this.script.charAt(n4) == ' ' || this.script.charAt(n4) == '*') break;
                    ++n4;
                }
                string = this.script.substring(n5, n4);
            } else {
                string = "";
                n4 = n5;
            }
            Integer n6 = (Integer)Statement.hTypeObjects.get(string);
            if (n6 != null) {
                this.index = n6;
                while (n4 < this.end) {
                    if (this.script.charAt(n4) != ' ') break;
                    ++n4;
                }
                n3 = n4;
            } else {
                n3 = n5;
            }
        } else {
            n3 = this.begin;
        }
        if (this.script.charAt(this.end - 1) == '*') {
            n2 = this.end - 1;
            bl = true;
        } else {
            n2 = this.end;
            bl = false;
        }
        if (this.script.charAt(n2 - 1) == '\"' || this.script.charAt(n2 - 1) == '\'') {
            --n2;
        }
        StringBuffer stringBuffer = new StringBuffer();
        n4 = n3;
        while (n4 < n2) {
            char c = this.script.charAt(n4);
            if (c != '\"' && c != '\'' && c != ' ') {
                stringBuffer.append(c);
            } else {
                if (c == ' ') {
                    ++n4;
                    while (n4 < n2) {
                        c = this.script.charAt(n4);
                        if (c != ' ') break;
                        ++n4;
                    }
                    if (n4 == n2) break;
                }
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(' ');
                }
                if (c == '\"' || c == '\'') {
                    ++n4;
                    while (n4 < n2) {
                        stringBuffer.append(this.script.charAt(n4));
                        ++n4;
                    }
                    break;
                }
                stringBuffer.append(this.script.charAt(n4));
            }
            ++n4;
        }
        String string = stringBuffer.toString();
        if (this.index < 0) {
            concept2 = new Concept(-this.index);
            this.type = Statement.types[-this.index];
        } else {
            concept2 = null;
        }
        if (this.index == -1 && string.equals("")) {
            string = this.stm.dbc.base.getPath();
        }
        this.cnc = concept = new Concept(string);
        Concept concept3 = null;
        Concept concept4 = null;
        if (bl) {
            if (concept2 == null) {
                this.stm.dbc.spec.con(60);
                this.stm.dbc.spec.see(concept);
                concept3 = this.stm.dbc.spec.getFirst(55);
                if (concept3 != null) {
                    if (this.stm.dbc.spec.getNext(55) != null) {
                        this.warnErr("Ambiguous specific name " + string + "*", n3);
                        this.cnc = concept3;
                    }
                    this.stm.dbc.spec.con(concept3).con(60);
                    concept4 = this.stm.dbc.spec.getFirst(55);
                    if (this.stm.dbc.spec.getNext(55) != null) {
                        this.warnErr("Ambiguous specific type", this.begin + 1);
                        this.type = Statement.types[concept4.toNumber()];
                    }
                }
            } else {
                this.stm.dbc.spec.con(56).con(concept2);
                if (this.stm.dbc.spec.has(56)) {
                    concept4 = concept2;
                    this.stm.dbc.spec.con(56);
                    this.stm.dbc.spec.see(concept);
                    concept3 = this.stm.dbc.spec.getFirst(55);
                    if (concept3 != null && this.stm.dbc.spec.getNext(55) != null) {
                        this.warnErr("Ambiguous specific name " + string + "*", n3);
                        this.cnc = concept3;
                    }
                }
            }
            this.stm.dbc.spec.regain();
        } else {
            if (concept2 == null) {
                this.stm.dbc.spec.con(60).con(concept);
                if (this.stm.dbc.spec.has(60)) {
                    concept3 = concept;
                    this.stm.dbc.spec.con(60);
                    concept4 = this.stm.dbc.spec.getFirst(55);
                    if (this.stm.dbc.spec.getNext(55) != null) {
                        this.warnErr("Ambiguous specific type", this.begin + 1);
                        this.type = Statement.types[concept4.toNumber()];
                    }
                }
            } else {
                this.stm.dbc.spec.con(56).con(concept2);
                if (this.stm.dbc.spec.has(56)) {
                    concept4 = concept2;
                    this.stm.dbc.spec.con(56);
                    concept3 = this.stm.dbc.spec.get(concept);
                }
            }
            this.stm.dbc.spec.regain();
        }
        if (concept3 == null) {
            if (bl) {
                this.warnErr("Unrecognized specific name " + string + "*", n3);
                this.index = -10;
                return;
            }
        } else if (bl) {
            this.cnc = concept3;
            concept = concept3;
            string = concept3.toString();
        }
        if (concept4 == null) {
            if (concept2 == null) {
                this.index = -3;
                concept2 = new Concept(-this.index);
                this.type = "mul";
            }
        } else if (concept2 == null) {
            this.index = -concept4.toNumber();
            concept2 = concept4;
        }
        if (this.index == -4) {
            if (n != 1) {
                this.warnErr0("Unexpected procedure");
                this.index = -10;
            } else if (concept3 == null) {
                this.warnErr("Unrecognized procedure name", n3);
                this.index = -10;
            }
            return;
        }
        if (this.index == -3) {
            if (this.ass == null) {
                this.ass = (Association)this.stm.dbc.mul.clone();
                this.ass.con(concept).con(56);
                this.ass.fix();
            }
        } else if (this.index == -2) {
            if ((n & 0xC) != 0) {
                this.warnErr0("Unexpected file variable");
                this.index = -10;
                return;
            }
            if (!string.equals("")) {
                String string2;
                File file;
                if (File.separatorChar == '\\') {
                    string = string.replace('/', '\\');
                }
                int n7 = string.lastIndexOf(58);
                int n8 = string.lastIndexOf(File.separatorChar);
                int n9 = n8 >= 0 ? n8 : (n7 >= 0 ? n7 : -1);
                if (n9 >= 0 && !(file = new File(string2 = string.substring(0, n9))).isDirectory()) {
                    this.warnErr0("File name is not correct");
                    this.index = -10;
                    return;
                }
                this.file = new File(string);
                if ((n & 1) != 0) {
                    if (this.file.exists() && !this.file.canWrite()) {
                        this.warnErr0("Non-modifiable file");
                        this.index = -10;
                        return;
                    }
                } else if (this.file.exists() && !this.file.canRead()) {
                    this.warnErr0("Non-readable file");
                    this.index = -10;
                    return;
                }
            }
        } else if (this.index == -1) {
            String string3;
            File file;
            if (n != 1) {
                this.warnErr0("Unexpected base variable");
                this.index = -10;
                return;
            }
            if (File.separatorChar == '\\') {
                string = string.replace('/', '\\');
            }
            int n10 = string.lastIndexOf(58);
            int n11 = string.lastIndexOf(File.separatorChar);
            int n12 = n11 >= 0 ? n11 : (n10 >= 0 ? n10 : -1);
            if (n12 >= 0 && !(file = new File(string3 = string.substring(0, n12))).isDirectory()) {
                this.warnErr0("Base name is not correct");
                this.index = -10;
                return;
            }
            if (string.indexOf(46) < 0) {
                string = String.valueOf(string) + ".ass";
            }
            this.baseFile = new File(string);
        }
        if (concept4 == null || concept3 == null) {
            this.stm.dbc.spec.con(60).con(concept);
            this.stm.dbc.spec.setConnection(60, concept2);
            this.stm.dbc.spec.regain();
            this.stm.dbc.spec.con(56).con(concept2);
            this.stm.dbc.spec.setConnection(56, concept);
            this.stm.dbc.spec.regain();
        }
    }

    void construeString() {
        this.cnc = new Concept(this.script.substring(this.begin, this.end));
    }

    void construeWord() {
        if (this.cnc == null) {
            this.cnc = new Concept(this.script.substring(this.begin, this.end));
        }
    }

    void controlMemory(Long1 long1) throws IOException {
        this.stm.dbc.base.controlMemory(long1, this.ass);
    }

    void controlMemory(Long1 long1, Association association) throws IOException {
        this.stm.dbc.base.controlMemory(long1, this.ass, association);
    }

    void controlMemory(Long1 long1, PList pList) throws IOException {
        long l;
        Runtime runtime = Runtime.getRuntime();
        long l2 = runtime.totalMemory();
        long l3 = l2 - (l = runtime.freeMemory());
        if (l3 < long1.value) {
            long1.value = l3 - PN.MEMORY_EXTENSION1;
            return;
        }
        if (l3 - long1.value > PN.MEMORY_EXTENSION) {
            this.stm.dbc.base.store();
            if (this.ass != null) {
                this.ass.store();
            }
            PList pList2 = (PList)pList.clone();
            Expression expression = (Expression)pList2.getFirst();
            while (expression != null) {
                if (expression.ass != null) {
                    expression.ass.store();
                }
                expression = (Expression)pList2.getNext();
            }
            runtime.gc();
            l2 = runtime.totalMemory();
            l = runtime.freeMemory();
            l3 = l2 - l;
            if (l3 - long1.value > PN.MEMORY_EXTENSION - PN.MEMORY_EXTENSION1) {
                long1.value = l2;
            }
        }
    }

    boolean describe(Association association) throws IOException {
        switch (this.index) {
            case -1: {
                this.stm.dbc.changeBase(this, this.stm);
                return false;
            }
            case -3: {
                return this.describeMultitude(association);
            }
            case -4: {
                return this.proc.execute();
            }
            case 5: {
                return this.describeSpace(association);
            }
            case 6: {
                return this.describeBrace(association);
            }
            case 7: {
                return this.describeBracket(association);
            }
            case 8: {
                return this.describeComma();
            }
            case 11: {
                return this.stm.dbc.describeParenthesisTerm(association, this);
            }
            case 12: {
                return this.describeColon(association);
            }
            case 14: {
                return this.equal(association);
            }
            case 15: {
                return this.describeComma();
            }
        }
        return false;
    }

    boolean describeBrace(Association association) throws IOException {
        boolean bl = true;
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.describe(association)) {
                if (bl) {
                    this.ass = expression.ass;
                    bl = false;
                } else {
                    this.ass.set(expression.ass);
                }
                expression.ass = null;
            }
            this.controlMemory(long1);
            expression = (Expression)this.list.getNext();
        }
        return this.ass != null;
    }

    boolean describeBracket(Association association) throws IOException {
        this.ass = new Association();
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.describe(null)) {
                expression.ass.getClassMean(this.ass);
            }
            expression.ass = null;
            this.controlMemory(long1);
            expression = (Expression)this.list.getNext();
        }
        if (!this.ass.hasAny()) {
            this.ass = null;
            return false;
        }
        this.ass = this.stm.dbc.insertClass(association, this.ass);
        return this.yields1();
    }

    boolean describeColon(Association association) throws IOException {
        boolean bl = true;
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            block6: {
                block5: {
                    block4: {
                        if (!bl) break block4;
                        bl = false;
                        if (expression.index != -10) break block5;
                        if (association == null) {
                            association = PN.aNull;
                        }
                        break block6;
                    }
                    if (expression.index == -10) {
                        return this.stm.dbc.deriveInstances(this);
                    }
                }
                if (!expression.describe(association)) {
                    this.ass = null;
                    return false;
                }
                this.ass = expression.ass;
                expression.ass = null;
                association = this.ass;
                this.controlMemory(long1);
            }
            expression = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean describeComma() throws IOException {
        boolean bl = false;
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            bl |= expression.describe(null);
            this.controlMemory(long1, this.list);
            expression = (Expression)this.list.getNext();
        }
        return bl;
    }

    boolean describeMultitude(Association association) throws IOException {
        if (!this.yields()) {
            return false;
        }
        if (association == null || association == PN.aNull) {
            return true;
        }
        this.ass = this.stm.dbc.insertClasses(association, this.ass);
        return this.yields1();
    }

    boolean describeSpace(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (expression.index != 2 || expression.cnc != null) {
            this.stm.noWarningFail = true;
            if (this.requestSpace(association)) {
                this.stm.noWarningFail = false;
                return true;
            }
            this.stm.noWarningFail = false;
        }
        if (expression.index == 2 || expression.index == 3) {
            this.ass = this.stm.dbc.insertValues(association, 56, expression.cnc);
            return true;
        }
        if (expression.index == 1) {
            if (association != null && association != PN.aNull) {
                this.ass = association;
                return true;
            }
            return false;
        }
        this.ass = this.stm.dbc.insertNames(association, this.list);
        return true;
    }

    boolean equal(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        switch (expression.index) {
            case -1: {
                Expression expression2 = (Expression)this.list.getNext();
                if (expression2.no) {
                    this.stm.dbc.changeBase1(expression, this.stm);
                } else {
                    this.stm.dbc.changeBase(expression, this.stm);
                }
                return false;
            }
            case -10: {
                return this.equalNone(association);
            }
            case -3: {
                return this.equalMultitude(association);
            }
        }
        return this.equalConcept(association);
    }

    boolean equalConcept(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        if (!expression.execute(association)) {
            return false;
        }
        this.ass = expression.ass;
        expression.ass = null;
        Long1 long1 = this.initMemory();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            if (expression2.index == -10) {
                if (expression2.no) {
                    this.stm.dbc.deleteAllRelation(this);
                } else {
                    this.stm.dbc.insertAss(association, this.ass);
                }
                return true;
            }
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3 != null && expression3.index == -10) {
                if (expression2.index == 11) {
                    this.updateRelation(expression2);
                } else {
                    this.updateClass(association, expression2);
                }
            } else if (expression2.execute(association)) {
                if (expression2.no) {
                    this.stm.dbc.deleteEquality(this.ass, expression2.ass);
                } else {
                    this.stm.dbc.insertEquality(this.ass, expression2.ass);
                }
            }
            expression2.ass = null;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean equalMultitude(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        this.ass = expression.ass;
        expression.ass = null;
        Long1 long1 = this.initMemory();
        Expression expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            if (expression2.index == -10) {
                if (expression2.no) {
                    this.ass.clearAll();
                    break;
                }
                this.stm.dbc.insertAss(association, this.ass);
                break;
            }
            Expression expression3 = (Expression)expression2.list.getFirst();
            if (expression3 != null && expression3.index == -10) {
                if (expression2.index == 11) {
                    this.updateRelation(expression2);
                } else {
                    this.updateClass(association, expression2);
                }
            } else if (expression2.execute(association)) {
                if (expression2.no) {
                    this.ass.clear(expression2.ass);
                } else {
                    this.ass.set(expression2.ass);
                }
            }
            expression2.ass = null;
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        if (this.property != 1) {
            return this.yields1();
        }
        if (!this.ass.hasAny()) {
            this.ass = null;
        }
        return this.ass != null;
    }

    boolean equalNone(Association association) throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        Expression expression2 = (Expression)this.list.getNext();
        if (!expression2.request(association)) {
            return false;
        }
        if (!expression2.requestEquality(association)) {
            return false;
        }
        this.ass = expression2.ass;
        expression2.ass = null;
        boolean bl = expression2.no;
        Long1 long1 = this.initMemory();
        expression2 = (Expression)this.list.getNext();
        while (expression2 != null) {
            if (expression2.request(association) && expression2.requestEquality(association)) {
                if (expression2.no) {
                    this.ass.clear(expression2.ass);
                } else {
                    this.ass = this.ass.get(expression2.ass);
                }
                expression2.ass = null;
                if (!this.yields1()) {
                    return false;
                }
            } else if (!expression2.no) {
                return false;
            }
            this.controlMemory(long1);
            expression2 = (Expression)this.list.getNext();
        }
        if (!this.yields1()) {
            return false;
        }
        if (bl) {
            this.stm.dbc.deleteAss(this.ass);
            this.ass = null;
            return false;
        }
        return true;
    }

    void equip() {
        int n;
        char c;
        char c2 = '\u0000';
        int n2 = this.script.length();
        this.begin = this.stm.position;
        if (this.begin >= n2) {
            this.begin = n2;
            this.end = n2;
            this.index = -10;
            this.stm.position = this.end;
            return;
        }
        c2 = this.script.charAt(this.begin);
        this.end = this.begin;
        if (c2 == ';') {
            this.index = -10;
            this.stm.position = this.end;
            return;
        }
        int n3 = c2 >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z' ? -1 : this.stm.keyString.indexOf(c2);
        if (n3 == 0 && this.end + 1 < n2 && this.script.charAt(this.end + 1) != ' ') {
            c = this.script.charAt(this.end + 1);
            n = this.stm.keyString.indexOf(c);
            if (!(c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || n >= 0 && c != '\"' && c != '\'')) {
                ++this.end;
                while (this.end < n2) {
                    c = this.script.charAt(this.end);
                    n = this.stm.keyString.indexOf(c);
                    if (n >= 0 && c != ' ') {
                        if (c == '/' && this.end + 1 < n2 && (this.script.charAt(this.end + 1) == '/' || this.script.charAt(this.end + 1) == '*')) break;
                        if (c == '*') {
                            ++this.end;
                            break;
                        }
                        if (c != '\"' && c != '\'') break;
                        char c3 = c;
                        int n4 = this.end + 1;
                        while (n4 < n2) {
                            if (this.script.charAt(n4) == c3) break;
                            ++n4;
                        }
                        if (n4 >= n2) break;
                        this.end = n4 + 1;
                        if (this.end >= n2 || this.script.charAt(this.end) != '*') break;
                        ++this.end;
                        break;
                    }
                    ++this.end;
                }
                this.index = 0;
                this.copula = this.stm.createCopula(this.begin, this.index, '$');
                this.stm.position = this.end;
                return;
            }
        }
        if (n3 <= 0) {
            while (++this.end < n2) {
                c = this.script.charAt(this.end);
                if (c <= ' ' || c == '/' && this.end + 1 < n2 && (this.script.charAt(this.end + 1) == '/' || this.script.charAt(this.end + 1) == '*') || !(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (n = this.stm.keyString.indexOf(c)) >= 0) break;
            }
            this.index = 4;
            this.copula = c2 == '$' ? this.stm.createCopula(this.begin, this.index, '$') : this.stm.createCopula(this.begin, this.index, '\u0000');
            this.stm.position = this.end;
            return;
        }
        if (n3 == 1) {
            this.index = 1;
            this.copula = this.stm.createCopula(this.begin, this.index, '*');
            this.stm.position = ++this.end;
            return;
        }
        if (n3 == 2) {
            while (++this.end < n2) {
                char c4 = this.script.charAt(this.end);
                if (c4 < '0' || c4 > '9') break;
            }
            this.index = 2;
            this.copula = this.stm.createCopula(this.begin, this.index, '#');
            this.stm.position = this.end;
            return;
        }
        if (n3 == 3 || n3 == 4) {
            char c5 = c2;
            while (++this.end < n2) {
                if (this.script.charAt(this.end) == c5) break;
            }
            if (this.end == n2) {
                this.warnErr0("Unclosed " + c5 + " left quote");
                this.stm.position = ++this.begin;
                this.equip();
                return;
            }
            this.index = n3;
            this.copula = this.stm.createCopula(this.begin, this.index, c2);
            this.stm.position = ++this.end;
            return;
        }
        if (this.stm.copula != null && this.stm.copula.index == n3 && n3 >= 12 && n3 <= 14) {
            this.warnErr1("Redundant or duplicate " + c2 + " symbol");
            this.stm.position = ++this.end;
            this.equip();
            return;
        }
        this.index = -10;
        this.stm.position = this.end;
        this.end = this.begin;
    }

    boolean execute(Association association) throws IOException {
        if ((this.property & 1) == 0) {
            return this.request(association);
        }
        return this.describe(association);
    }

    boolean focus(int n) {
        if (this.index == 5 && this.list.hasOne()) {
            Expression expression = (Expression)this.list.getFirst();
            if (expression.index == n) {
                this.affect(expression);
                return true;
            }
        }
        return false;
    }

    void freeInnerExpression() throws IOException {
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            expression.ass = null;
            expression = (Expression)this.list.getNext();
        }
    }

    Long1 initMemory() throws IOException {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        return new Long1(l - l2);
    }

    void insert(Expression expression) {
        this.begin = expression.begin;
        this.list.getFirst();
        this.list.insert(expression);
    }

    Association makeTempAss() throws IOException {
        if (this.ass.getPath() == null) {
            return this.ass;
        }
        Association association = new Association();
        association.set(this.ass);
        return association;
    }

    boolean request(Association association) throws IOException {
        switch (this.index) {
            case -3: {
                return this.requestMultitude(association);
            }
            case 5: {
                return this.requestSpace(association);
            }
            case 6: {
                return this.requestBrace(association);
            }
            case 7: {
                return this.requestBracket(association);
            }
            case 8: {
                return this.requestComma(false);
            }
            case 11: {
                return this.stm.dbc.requestParenthesisTerm(association, this);
            }
            case 12: {
                return this.requestColon(association);
            }
            case 14: {
                return this.equal(association);
            }
        }
        return false;
    }

    boolean requestBrace(Association association) throws IOException {
        boolean bl = true;
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.request(association)) {
                if (bl) {
                    this.ass = expression.ass;
                    bl = false;
                } else {
                    this.ass.set(expression.ass);
                }
                expression.ass = null;
            }
            this.controlMemory(long1, association);
            expression = (Expression)this.list.getNext();
        }
        return this.ass != null;
    }

    boolean requestBracket(Association association) throws IOException {
        this.ass = new Association();
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            if (expression.request(null)) {
                expression.ass.getClassMean(this.ass);
            }
            expression.ass = null;
            this.controlMemory(long1);
            expression = (Expression)this.list.getNext();
        }
        if (!this.ass.hasAny()) {
            this.ass = null;
            return false;
        }
        this.ass = this.stm.dbc.selectClass(association, this.ass);
        return this.yields1();
    }

    boolean requestColon(Association association) throws IOException {
        boolean bl = true;
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            block6: {
                block5: {
                    block4: {
                        if (!bl) break block4;
                        bl = false;
                        if (expression.index != -10) break block5;
                        if (association == null) {
                            association = PN.aNull;
                        }
                        break block6;
                    }
                    if (expression.index == -10) {
                        return this.stm.dbc.deriveInstances(this);
                    }
                }
                if (!expression.request(association)) {
                    this.ass = null;
                    return false;
                }
                association = expression.ass;
                expression.ass = null;
                this.ass = association;
                this.controlMemory(long1);
            }
            expression = (Expression)this.list.getNext();
        }
        return true;
    }

    boolean requestComma(boolean bl) throws IOException {
        boolean bl2 = false;
        Long1 long1 = this.initMemory();
        Expression expression = (Expression)this.list.getFirst();
        while (expression != null) {
            boolean bl3 = expression.request(null);
            this.controlMemory(long1, this.list);
            if (bl && !bl3) {
                return false;
            }
            bl2 |= bl3;
            expression = (Expression)this.list.getNext();
        }
        return bl2;
    }

    boolean requestEquality(Association association) throws IOException {
        if (this.index == -3) {
            this.ass = this.stm.dbc.selectAss(this.ass);
        } else if (this.index == 5) {
            Expression expression = (Expression)this.list.getFirst();
            if (!(expression.index != 3 && expression.index != 2 || association != null && association != PN.aNull)) {
                this.ass = this.stm.dbc.selectAss(this.ass);
            }
        }
        return this.yields1();
    }

    boolean requestMultitude(Association association) throws IOException {
        if (!this.yields()) {
            return false;
        }
        if (association == null || association == PN.aNull) {
            return true;
        }
        this.ass = this.stm.dbc.selectClasses(association, this.ass);
        return this.yields1();
    }

    boolean requestSpace(Association association) throws IOException {
        Expression expression = (Expression)this.list.getLast();
        boolean bl = expression.index == 1;
        Expression expression2 = (Expression)this.list.getFirst();
        this.ass = expression2.index == 2 || expression2.index == 3 || expression2.index == 1 ? this.stm.dbc.selectValues(association, 56, expression2.index, expression2.cnc, bl) : this.stm.dbc.selectNames(association, this.list, bl);
        return this.yields1();
    }

    void takeToString(StringBuffer stringBuffer) {
        String string;
        if (this.index == -10) {
            return;
        }
        if (this.list.isEmpty()) {
            if (this.index <= 0) {
                stringBuffer.append('$');
                if (this.type != null) {
                    stringBuffer.append(this.type).append(" ");
                }
                if (this.script.charAt(this.end - 1) == '\"' || this.script.charAt(this.end - 1) == '\'') {
                    stringBuffer.append('\'');
                    stringBuffer.append(this.cnc.toString());
                    stringBuffer.append('\'');
                } else {
                    stringBuffer.append(this.cnc.toString());
                }
                return;
            }
            stringBuffer.append(this.script.substring(this.begin, this.end));
            return;
        }
        if (this.index == -4) {
            stringBuffer.append('$');
            if (this.type != null) {
                stringBuffer.append(this.type).append(" ");
            }
            stringBuffer.append(this.cnc.toString());
            stringBuffer.append(this.copula.mark);
            string = ", ";
        } else if (this.index == 6 || this.index == 7 || this.index == 8) {
            if (this.copula.mark == '{') {
                stringBuffer.append("{ ");
            } else {
                stringBuffer.append(this.copula.mark);
            }
            string = ", ";
        } else {
            string = this.index == 10 || this.index == 11 ? " " : String.valueOf(this.copula.mark) + " ";
        }
        Expression expression = (Expression)this.list.getFirst();
        if (expression != null) {
            expression.takeToString(stringBuffer);
        }
        while (this.list.hasNext()) {
            expression = (Expression)this.list.getNext();
            if (this.index == 14) {
                if (expression.no) {
                    stringBuffer.append(" ~");
                } else {
                    stringBuffer.append(" =");
                }
                Expression expression2 = (Expression)expression.list.getFirst();
                if (expression2 == null || expression2.index != -10) {
                    stringBuffer.append(" ");
                }
            } else if (this.index == 5) {
                if (expression.index != 1) {
                    stringBuffer.append(" ");
                }
            } else {
                stringBuffer.append(string);
            }
            expression.takeToString(stringBuffer);
        }
        if (this.copula.mark == '{') {
            stringBuffer.append(" }");
        } else if (this.copula.mark == '[') {
            stringBuffer.append(']');
        } else if (this.copula.mark == '(') {
            stringBuffer.append(')');
        }
    }

    void updateClass(Association association, Expression expression) throws IOException {
        if (!this.ass.hasAny()) {
            return;
        }
        Expression expression2 = (Expression)expression.list.get();
        expression.list.remove();
        if (expression.execute(association)) {
            if (expression.no) {
                this.stm.dbc.deleteClasses(this.ass, expression.ass);
            } else {
                this.stm.dbc.insertClasses(this.ass, expression.ass);
            }
        }
        expression.ass = null;
        expression.list.getFirst();
        expression.list.insert(expression2);
    }

    void updateRelation(Expression expression) throws IOException {
        PList pList = new PList();
        if (!this.ass.hasAny()) {
            return;
        }
        Long1 long1 = this.initMemory();
        Expression expression2 = (Expression)expression.list.getNext();
        while (expression2 != null) {
            if (expression2.requestComma(false)) {
                Expression expression3 = (Expression)expression2.list.getFirst();
                while (expression3 != null) {
                    if (expression3.ass != null) {
                        pList.add(57, expression3.ass);
                        expression3.ass = null;
                        this.controlMemory(long1, pList);
                    }
                    expression3 = (Expression)expression2.list.getNext();
                }
            }
            expression2 = (Expression)expression.list.getNext();
        }
        if (expression.no) {
            this.stm.dbc.deleteRelList(this.ass, pList);
        } else {
            this.stm.dbc.insertRelList(this.ass, pList);
        }
    }

    void warnErr(String string, int n) {
        this.stm.errors.add(new Warning(string, n));
    }

    void warnErr0(String string) {
        this.stm.errors.add(new Warning(string, this.begin));
    }

    void warnErr1(String string) {
        this.stm.errors.add(new Warning(string, this.end));
    }

    void warnExc(String string, int n) {
        this.stm.exceptions.add(new Warning(string, n));
    }

    void warnExc0(String string) {
        this.stm.exceptions.add(new Warning(string, this.begin));
    }

    void warnExc1(String string) {
        this.stm.exceptions.add(new Warning(string, this.end));
    }

    void warnFail(Expression expression, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        PList pList = new PList();
        while (expression != null) {
            pList.insert(expression);
            expression = expression.eContext;
        }
        Expression expression2 = (Expression)pList.getFirst();
        while (expression2 != null) {
            expression2.takeToString(stringBuffer);
            stringBuffer.append(": ");
            expression2 = (Expression)pList.getNext();
        }
        this.takeToString(stringBuffer);
        this.stm.failures.add(new Warning(String.valueOf(String.valueOf(stringBuffer)) + " " + string));
    }

    void warnFail(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        this.takeToString(stringBuffer);
        this.stm.failures.add(new Warning(String.valueOf(String.valueOf(stringBuffer)) + " " + string));
    }

    boolean yields() throws IOException {
        if (this.ass != null && this.ass.hasAny()) {
            return true;
        }
        this.ass = null;
        if (!this.stm.noWarningFail) {
            this.warnFail("");
        }
        return false;
    }

    boolean yields1() throws IOException {
        if (this.ass != null && this.ass.hasAny()) {
            return true;
        }
        this.ass = null;
        if (!this.stm.noWarningFail) {
            this.warnFail(this.eContext, "");
        }
        return false;
    }
}

