/*
 * Decompiled with CFR 0.152.
 */
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class Calc
extends Snode {
    private double val = 0.0;
    private Snode scope;
    private Stack stack;
    private Vector image;

    Calc(Snode nameScope) {
        super(null, 15);
        this.scope = nameScope;
        this.stack = new Stack();
        this.image = new Vector();
    }

    public Snode getScope() {
        return this.scope;
    }

    private double pop() {
        return (Double)this.stack.pop();
    }

    private void push(double op) {
        this.stack.push(new Double(op));
    }

    private void push(String str) {
        this.stack.push(Double.valueOf(str));
    }

    public double getValue() {
        try {
            this.val = this.pop();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return this.val;
    }

    public void append(String s) {
        this.image.addElement(s);
    }

    public void add() {
        double a = this.pop() + this.pop();
        this.push(a);
    }

    public void multiply() {
        double a = this.pop() * this.pop();
        this.push(a);
    }

    public void minus() {
        double a = this.pop();
        double b = this.pop();
        this.push(b - a);
    }

    public void divide() {
        double a = this.pop();
        double b = this.pop();
        this.push(b / a);
    }

    public void modulus() {
        double a = this.pop();
        double b = this.pop();
        this.push(b % a);
    }

    public void and() {
        long a = (long)this.pop();
        long b = (long)this.pop();
        this.push(a &= b);
    }

    public void or() {
        long a = (long)this.pop();
        long b = (long)this.pop();
        this.push(a |= b);
    }

    public void xor() {
        long a = (long)this.pop();
        long b = (long)this.pop();
        this.push(a ^= b);
    }

    public void rshift() {
        int shift = (int)this.pop();
        long op = (long)this.pop();
        this.push(op >>= shift);
    }

    public void lshift() {
        int shift = (int)this.pop();
        long op = (long)this.pop();
        this.push(op <<= shift);
    }

    public void negate() {
        double a = this.pop();
        this.push(-a);
    }

    public void complement() {
        int a = (int)this.pop();
        this.push(~a);
    }

    public void constant(Snode s, double v) {
        this.push(v);
        this.image.addElement(s);
    }

    private static Integer prepareLiteral(String lit, int radix) {
        char lastChar;
        if (radix == 16) {
            lit = lit.substring(2);
        } else if (radix == 8) {
            lit = lit.substring(1);
        }
        int len = lit.length();
        if (len > 0 && ((lastChar = Character.toUpperCase(lit.charAt(len - 1))) == 'U' || lastChar == 'L')) {
            lit = lit.substring(0, len - 1);
        }
        return Integer.valueOf(lit, radix);
    }

    public static Integer intLiteral(Token t) throws NumberFormatException {
        int radix = -1;
        if (t.kind == 73) {
            radix = 10;
        } else if (t.kind == 74) {
            radix = 16;
        } else if (t.kind == 72) {
            radix = 8;
        }
        String lit = t.image;
        if (radix > 0) {
            Integer i = Calc.prepareLiteral(lit, radix);
            return i;
        }
        return null;
    }

    public void literal(Token t) {
        try {
            Integer val = Calc.intLiteral(t);
            if (val == null) {
                this.push(t.image);
            } else {
                this.push(val.doubleValue());
            }
        }
        catch (NumberFormatException ee) {
            this.stack.push(new Double(Double.NaN));
        }
        this.append(t.image);
    }

    public Token getTok() {
        this.setId(this.getId());
        return super.getTok();
    }

    public String get_id(int mode) {
        StringBuffer s = new StringBuffer("");
        Enumeration e = this.image.elements();
        block17: while (e.hasMoreElements()) {
            Object o = e.nextElement();
            try {
                String n = (String)o;
                if (n.equals("FALSE")) {
                    switch (mode) {
                        case 2: {
                            n = "CORBA_FALSE";
                            break;
                        }
                        case 4: {
                            n = "false";
                            break;
                        }
                        case 3: {
                            n = "CORBA::FALSE";
                            break;
                        }
                    }
                } else if (n.equals("TRUE")) {
                    switch (mode) {
                        case 2: {
                            n = "CORBA_TRUE";
                            break;
                        }
                        case 4: {
                            n = "true";
                            break;
                        }
                        case 3: {
                            n = "CORBA::TRUE";
                            break;
                        }
                    }
                }
                s.append(n);
            }
            catch (ClassCastException err) {
                Snode n = (Snode)o;
                switch (mode) {
                    case 2: {
                        s.append(n.cId());
                        continue block17;
                    }
                    case 3: {
                        s.append(n.cppFullId());
                        continue block17;
                    }
                    case 4: {
                        s.append(n.javaFullName());
                        continue block17;
                    }
                }
                s.append(n.getId());
            }
        }
        return s.toString();
    }

    public String cppId() {
        return this.get_id(3);
    }

    public String getId() {
        return this.get_id(1);
    }

    public String cId() {
        return this.get_id(2);
    }

    public String javaFullName() {
        return this.get_id(4);
    }
}

