/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

class IdlArgs {
    String ipFile = null;
    String opFile = null;
    String dirSep = System.getProperty("file.separator");
    String opDir = ".";
    String baseOp = null;
    String val;
    String msg = "";
    Vector enclose = null;
    Vector filesProduced = new Vector(6, 5);
    int errors = 0;
    int mode = 0;
    int argpos = 0;
    int level = 0;
    boolean useDate = true;
    boolean dosFormat;
    boolean namespace = false;
    boolean vcpp = false;
    boolean netscape = false;

    IdlArgs(String[] args) {
        while (this.argpos < args.length) {
            String arg = args[this.argpos];
            if (arg.startsWith("-o")) {
                this.errors += this.extract("-o", args);
                if (this.val != null) {
                    FileNameParse f = new FileNameParse(this.val);
                    if (!f.dir.equals("")) {
                        this.msg = String.valueOf(this.msg).concat(String.valueOf(String.valueOf(arg).concat(String.valueOf(" : -o should not contain path info, use -d option\n"))));
                        ++this.errors;
                    } else {
                        this.baseOp = f.base;
                        this.opFile = f.base;
                    }
                }
            } else if (arg.startsWith("-d")) {
                this.errors += this.extract("-d", args);
                if (this.val != null) {
                    this.opDir = this.val;
                    if (this.opDir.indexOf(92) != -1) {
                        this.dirSep = "\\";
                    } else if (this.opDir.indexOf(47) != -1) {
                        this.dirSep = "/";
                    }
                }
            } else if (arg.startsWith("-enc")) {
                this.errors += this.extract("-enc", args);
                if (this.val != null) {
                    int indx;
                    while ((indx = this.val.indexOf("::")) != -1) {
                        String s = this.val.substring(0, indx);
                        if (this.badModuleName(s)) {
                            ++this.errors;
                        } else {
                            this.addModule(s);
                        }
                        this.val = this.val.substring(indx + 2);
                    }
                    if (this.badModuleName(this.val)) {
                        ++this.errors;
                    } else {
                        this.addModule(this.val);
                    }
                }
            } else if (arg.compareTo("-ns") == 0) {
                this.namespace = true;
            } else if (arg.compareTo("-netscape") == 0) {
                this.netscape = true;
            } else if (arg.compareTo("-idl") == 0) {
                this.mode = 1;
            } else if (arg.compareTo("-c++") == 0) {
                this.mode = 3;
            } else if (arg.compareTo("-vc++") == 0) {
                this.mode = 3;
                this.vcpp = true;
            } else if (arg.compareTo("-c") == 0) {
                this.mode = 2;
            } else if (arg.compareTo("-java") == 0) {
                this.mode = 4;
            } else if (arg.compareTo("-nd") == 0) {
                this.useDate = false;
            } else if (arg.startsWith("-")) {
                this.msg = String.valueOf(this.msg).concat(String.valueOf(String.valueOf(String.valueOf("Unknown option ").concat(String.valueOf(arg))).concat(String.valueOf('\n'))));
                ++this.errors;
            } else {
                this.ipFile = arg;
            }
            ++this.argpos;
        }
        if (this.mode != 1 && this.opFile == null) {
            if (this.ipFile == null) {
                this.msg = String.valueOf(this.msg).concat(String.valueOf("No input file\n"));
            } else {
                FileNameParse f = new FileNameParse(this.ipFile);
                this.opFile = f.base;
                this.baseOp = f.base;
                if (this.opDir.equals("")) {
                    this.opDir = f.dir;
                }
            }
        }
        if (!this.opDir.equals("") && this.opDir.endsWith(this.dirSep)) {
            this.opDir = this.opDir.substring(0, this.opDir.length() - 1);
        }
    }

    void addFile(String fname) {
        this.filesProduced.addElement(fname);
    }

    private void addModule(String name) {
        if (this.enclose == null) {
            this.enclose = new Vector(2);
        }
        this.enclose.addElement(name);
    }

    public Module firstModule(Module root) {
        Module m = root;
        if (this.enclose == null) {
            return root;
        }
        Enumeration e = this.enclose.elements();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Module newM = new Module(new ExToken(name));
            m.addChild(newM);
            m = newM;
        }
        return m;
    }

    private boolean badModuleName(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean ok = i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
            if (ok) continue;
            System.err.println(String.valueOf("Bad module name component ").concat(String.valueOf(name)));
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int extract(String prefix, String[] args) {
        String arg = args[this.argpos];
        this.val = null;
        if (!arg.startsWith(prefix)) return 0;
        if (arg.compareTo(prefix) != 0) {
            this.val = arg.substring(prefix.length());
            return 0;
        }
        if (this.argpos + 1 < args.length) {
            this.val = args[++this.argpos];
            return 0;
        }
        this.msg = String.valueOf(this.msg).concat(String.valueOf(String.valueOf(String.valueOf("Expected argument to follow ").concat(String.valueOf(prefix))).concat(String.valueOf('\n'))));
        return 1;
    }

    public void usage(int code) {
        String product = "Mitch Britton's IDL Compiler Version 1.21\nCopyright (c) 1998-1999 Mitch Britton";
        System.err.println(product);
        if (code != 0) {
            System.err.println(String.valueOf('\n').concat(String.valueOf(this.msg)));
            System.err.println("\nusage:");
            System.err.println("\tjava idl [ -c | -c++ | -java ] [ -d<dir> ] [ -o<opfile> ] <inputfile> ");
            System.err.println("\nwhere");
            System.err.println("      -c             Generate 'C' files");
            System.err.println("      -c++           Generate C++ files");
            System.err.println("      -vc++          You might need this one if using Visual C++");
            System.err.println("      -java          Generate Java files");
            System.err.println("      -o<opfile>     <opfile> is used as the base name for generated 'C' files");
            System.err.println("      -d<dir>        Use <dir> as the output directory for files");
            System.err.println("      -ns            Generate code for C++ namespaces");
            System.err.println("      -netscape      Generate client code for Netscape/Visigenic ORB");
            System.err.println("      -enc <module>  Generate as if enclosed by <module>");
            System.err.println("\nIf no input file name is specified stdin is read");
            System.err.println("Otherwise the input file name is used");
            System.exit(code);
        }
    }

    public String banner(String fileName) {
        String quote = "";
        String op = "";
        String nl = Snode.nl;
        switch (this.mode) {
            case 3: 
            case 4: {
                quote = "//";
                break;
            }
            case 5: {
                quote = "#";
                break;
            }
            default: {
                quote = "*";
            }
        }
        int l = fileName.length();
        StringBuffer ul = new StringBuffer(l);
        for (int i = 0; i < l; ++i) {
            ul.append('-');
        }
        if (this.mode == 2) {
            op = String.valueOf(op).concat(String.valueOf(String.valueOf("/**").concat(String.valueOf(nl))));
        }
        op = String.valueOf(op).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(quote).concat(String.valueOf('\t'))).concat(String.valueOf(fileName))).concat(String.valueOf(nl))));
        op = String.valueOf(op).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(quote).concat(String.valueOf('\t'))).concat(String.valueOf(ul.toString()))).concat(String.valueOf(nl))).concat(String.valueOf(quote))).concat(String.valueOf(nl))));
        op = String.valueOf(op).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(quote).concat(String.valueOf("\tTHIS IS NOT SOURCE CODE - DO NOT EDIT IT"))).concat(String.valueOf(nl))).concat(String.valueOf(quote))).concat(String.valueOf(nl))));
        op = String.valueOf(op).concat(String.valueOf(String.valueOf(String.valueOf(quote).concat(String.valueOf("\tIt was created by Mitch Britton's IDL compiler"))).concat(String.valueOf(nl))));
        if (this.useDate) {
            Date d = new Date();
            op = String.valueOf(op).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(quote).concat(String.valueOf("\tOn "))).concat(String.valueOf(d))).concat(String.valueOf(nl))));
        }
        op = String.valueOf(op).concat(String.valueOf(String.valueOf(quote).concat(String.valueOf(nl))));
        if (this.mode == 2) {
            op = String.valueOf(op).concat(String.valueOf(String.valueOf("**/").concat(String.valueOf(nl))));
        }
        return String.valueOf(op).concat(String.valueOf(nl));
    }
}

