/*
 * Decompiled with CFR 0.152.
 */
public class ParseException
extends Exception {
    protected boolean specialConstructor;
    public Token currentToken;
    public int[][] expectedTokenSequences;
    public String[] tokenImage;
    protected String eol = System.getProperty("line.separator", "\n");

    public ParseException(Token currentTokenVal, int[][] expectedTokenSequencesVal, String[] tokenImageVal) {
        super("");
        this.specialConstructor = true;
        this.currentToken = currentTokenVal;
        this.expectedTokenSequences = expectedTokenSequencesVal;
        this.tokenImage = tokenImageVal;
    }

    public ParseException() {
        this.specialConstructor = false;
    }

    public ParseException(String message) {
        super(message);
        this.specialConstructor = false;
    }

    public String getMessage() {
        if (!this.specialConstructor) {
            return super.getMessage();
        }
        String expected = "Was expecting ";
        int maxSize = 0;
        for (int i = 0; i < this.expectedTokenSequences.length; ++i) {
            if (i > 0) {
                expected = String.valueOf(expected).concat(String.valueOf(" or "));
            }
            if (maxSize < this.expectedTokenSequences[i].length) {
                maxSize = this.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < this.expectedTokenSequences[i].length; ++j) {
                expected = String.valueOf(expected).concat(String.valueOf(String.valueOf(this.tokenImage[this.expectedTokenSequences[i][j]]).concat(String.valueOf(" "))));
            }
        }
        String retval = "Found \"";
        Token tok = this.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                retval = String.valueOf(retval).concat(String.valueOf(" "));
            }
            if (tok.kind == 0) {
                retval = String.valueOf(retval).concat(String.valueOf(this.tokenImage[0]));
                break;
            }
            retval = String.valueOf(retval).concat(String.valueOf(this.add_escapes(tok.image)));
            tok = tok.next;
        }
        retval = String.valueOf(retval).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("\" at line ").concat(String.valueOf(this.currentToken.next.beginLine))).concat(String.valueOf(", column "))).concat(String.valueOf(this.currentToken.next.beginColumn))).concat(String.valueOf("."))).concat(String.valueOf(this.eol))));
        retval = String.valueOf(retval).concat(String.valueOf(expected));
        return retval;
    }

    protected String add_escapes(String str) {
        StringBuffer retval = new StringBuffer();
        block11: for (int i = 0; i < str.length(); ++i) {
            switch (str.charAt(i)) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    char ch = str.charAt(i);
                    if (ch < ' ' || ch > '~') {
                        String s = String.valueOf("0000").concat(String.valueOf(Integer.toString(ch, 16)));
                        retval.append(String.valueOf("\\u").concat(String.valueOf(s.substring(s.length() - 4, s.length()))));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }
}

