/*
 * Decompiled with CFR 0.152.
 */
import java.util.Stack;

public class TreeState {
    private NodeStack nodes = new NodeStack();
    private Stack current_nodes = new Stack();
    private boolean node_created;

    TreeState() {
    }

    boolean nodeCreated() {
        return this.node_created;
    }

    void updateCurrentNode(int n) {
        for (int i = 0; i < n; ++i) {
            this.current_nodes.pop();
        }
    }

    void reset() {
        this.nodes.empty();
        this.current_nodes = new Stack();
    }

    Node rootNode() {
        return this.nodes.elementAt(0);
    }

    Node currentNode() {
        return (Node)this.current_nodes.peek();
    }

    void pushNode(Node n) {
        this.nodes.push(n);
    }

    Node popNode() {
        return this.nodes.pop();
    }

    Node peekNode() {
        return this.nodes.peek();
    }

    void openIndefiniteNode(Node n) {
        this.current_nodes.push(n);
        this.nodes.mark();
    }

    void closeIndefiniteNode() {
        Node n = this.currentNode();
        n.open();
        NodeEnum e = this.nodes.elementsSinceLastMark();
        while (e.hasMoreElements()) {
            Node c = (Node)e.nextElement();
            c.setParent(n);
            n.addChild(c);
        }
        this.nodes.popToLastMark();
        n.close();
        this.nodes.push(n);
        this.node_created = true;
    }

    void openDefiniteNode(Node n) {
        this.current_nodes.push(n);
    }

    void closeDefiniteNode(int num) {
        Node n = this.currentNode();
        n.open();
        NodeEnum e = this.nodes.elementsTop(num);
        while (e.hasMoreElements()) {
            Node c = (Node)e.nextElement();
            c.setParent(n);
            n.addChild(c);
        }
        this.nodes.popTop(num);
        n.close();
        this.nodes.push(n);
        this.node_created = true;
    }

    void openGTNode(Node n) {
        this.current_nodes.push(n);
        this.nodes.mark();
    }

    void closeGTNode(int num) {
        if (this.nodes.numElementsSinceLastMark() > num) {
            this.closeIndefiniteNode();
        } else {
            this.nodes.removeLastMark();
            this.node_created = false;
        }
    }
}

