/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import org.omg.CORBA.StringHolder;

public class TypeSpec
extends Snode {
    private int builtInType = 0;
    protected int isVar = -1;
    protected int scale = -1;
    protected String len = null;
    boolean nested = false;
    public static final int CHAR = 1;
    public static final int WIDE_CHAR = 2;
    public static final int BOOLEAN = 3;
    public static final int SHORT = 4;
    public static final int UNSIGNED_SHORT = 5;
    public static final int LONG = 6;
    public static final int LONG_LONG = 7;
    public static final int UNSIGNED_LONG_LONG = 8;
    public static final int UNSIGNED_LONG = 9;
    public static final int FLOAT = 10;
    public static final int DOUBLE = 11;
    public static final int LONG_DOUBLE = 12;
    public static final int ANY = 13;
    public static final int OCTET = 14;
    public static final int STRING = 15;
    public static final int WIDE_STRING = 16;
    public static final int FIXED = 17;
    public static final int OBJECT = 18;
    public static final int VOID = 19;

    public TypeSpec(Token tok, int type) {
        super(tok, type);
    }

    public TypeSpec(Token tk) {
        this(tk, 64);
    }

    public TypeSpec() {
        this(null, 64);
    }

    public TypeSpec type() {
        return this;
    }

    public void setNested() {
        this.nested = true;
    }

    public boolean isReference() {
        return false;
    }

    public boolean isTypeSpec() {
        return true;
    }

    public boolean isVariable() {
        if (this.isVar == 1) {
            return true;
        }
        return this.isInterface();
    }

    public boolean isObjRef() {
        int t = this.getType();
        return t == 193 || t == 194;
    }

    public boolean isInterface() {
        if (this.getType() == 193) {
            this.isVar = 1;
            return true;
        }
        return false;
    }

    public boolean isString() {
        switch (this.typeType()) {
            case 15: 
            case 16: {
                return true;
            }
        }
        return false;
    }

    public String cppServerFree(String pfx, String id, int paramType) {
        int mod = this.cppIMod(paramType);
        String s = null;
        String ts = this.cppTypeId();
        block0 : switch (this.typeType()) {
            case 15: {
                break;
            }
            case 16: {
                break;
            }
            default: {
                switch (paramType) {
                    case 2: {
                        if (mod == 6) {
                            s = String.valueOf(String.valueOf(String.valueOf("delete ").concat(String.valueOf(id))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl));
                            break block0;
                        }
                        if (mod != 9) break block0;
                        s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(ts).concat(String.valueOf("_free( "))).concat(String.valueOf(id))).concat(String.valueOf(" ) ;"))).concat(String.valueOf(Snode.nl));
                        break block0;
                    }
                    case 4: {
                        if (mod == 1) {
                            s = String.valueOf(String.valueOf(String.valueOf("delete ").concat(String.valueOf(id))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl));
                            break block0;
                        }
                        if (mod != 3) break block0;
                        s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(ts).concat(String.valueOf("_free( "))).concat(String.valueOf(id))).concat(String.valueOf(" ) ;"))).concat(String.valueOf(Snode.nl));
                    }
                }
            }
        }
        if (s == null) {
            return "";
        }
        return String.valueOf(pfx).concat(String.valueOf(s));
    }

    public boolean isSimpleType() {
        return this.isBasicType() || this.isString();
    }

    public boolean isLong() {
        switch (this.typeType()) {
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isFixedArray() {
        return this.isArray() && !this.isVariable();
    }

    public boolean allocFunc() {
        return this.isArray() || this.isSequence() || this.isConstructedType() && this.isVariable();
    }

    public boolean canAllocate() {
        if (this.isArray()) {
            return true;
        }
        return !this.isBasicType() && !this.isEnum() && this.isVariable();
    }

    public boolean cSetRelease() {
        return this.isSequence();
    }

    public String cAllocFuncName() {
        switch (this.builtInType) {
            case 15: {
                return "CORBA_string_alloc";
            }
            case 16: {
                return "CORBA_wstring_alloc";
            }
            case 13: {
                return "CORBA_any_alloc";
            }
        }
        return String.valueOf(this.cTypeId()).concat(String.valueOf("__alloc"));
    }

    public String cFreeFuncName() {
        String deflt = "CORBA_conditionalFree";
        switch (this.builtInType) {
            case 13: 
            case 15: 
            case 16: {
                return deflt;
            }
        }
        if (this.isSequence() || this.isInterface()) {
            return deflt;
        }
        return String.valueOf(this.cTypeId()).concat(String.valueOf("__free"));
    }

    public String allocate() {
        if (!this.canAllocate()) {
            return "";
        }
        String param = "";
        String fname = this.allocFunc() || this.isVariable() ? this.cAllocFuncName() : String.valueOf(String.valueOf("CORBA_alloc( CORBA_MA_FIXED, sizeof( ").concat(String.valueOf(this.cTypeId()))).concat(String.valueOf(", CORBA_FALSE ) )"));
        switch (this.builtInType) {
            case 15: 
            case 16: {
                String size = this.len == null ? "255" : this.len;
                param = String.valueOf(String.valueOf(' ').concat(String.valueOf(size))).concat(String.valueOf(' '));
            }
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(" = ").concat(String.valueOf(fname))).concat(String.valueOf("("))).concat(String.valueOf(param))).concat(String.valueOf(")"));
    }

    public String cInitialize() {
        switch (this.builtInType) {
            case 15: 
            case 16: {
                return " = NULL";
            }
        }
        return "";
    }

    public int typeType() {
        return this.builtInType;
    }

    public boolean isRealConstructedType() {
        if (this.isSequence()) {
            return true;
        }
        return this.builtInType <= 0 && !this.isInterface();
    }

    public boolean isConstructedType() {
        return this.isRealConstructedType();
    }

    public double setValue(double value) {
        switch (this.builtInType) {
            case 5: {
                int shortVal = (int)value;
                int intVal = shortVal < 0 ? (int)value : shortVal;
                if (intVal < 0) {
                    intVal = 1 - intVal;
                }
                value = intVal;
                break;
            }
            case 9: {
                int intVal = (int)value;
                long longVal = intVal;
                value = longVal;
                break;
            }
        }
        return value;
    }

    public boolean isBasicType() {
        switch (this.builtInType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                return true;
            }
        }
        return false;
    }

    public boolean requiresPointer() {
        return this.typeType() == 13 || this.isFixed() || this.isSequence();
    }

    public boolean requiresInRef() {
        return this.requiresPointer();
    }

    public int cppReturnMod() {
        if (this.isArray()) {
            return 3;
        }
        if (this.isFixed()) {
            return 5;
        }
        if (this.isInterface()) {
            return 7;
        }
        if (this.isString()) {
            return 0;
        }
        if (this.isVariable()) {
            return 1;
        }
        return 0;
    }

    public int cppInMod() {
        if (this.isInterface()) {
            return 7;
        }
        if (this.requiresInRef()) {
            return 5;
        }
        return 0;
    }

    public int cppInOutMod() {
        if (this.isArray()) {
            return 0;
        }
        if (this.isInterface()) {
            return 8;
        }
        return 5;
    }

    public int cppOutMod() {
        if (this.isInterface()) {
            return 8;
        }
        if (this.isArray()) {
            if (this.isVariable()) {
                return 9;
            }
            return 0;
        }
        if (this.isVariable() && !this.isString()) {
            return 6;
        }
        return 5;
    }

    public boolean isNestedType() {
        return this.nested;
    }

    public boolean isFixed() {
        return this.builtInType == 17;
    }

    public boolean isWideString() {
        return this.builtInType == 16;
    }

    public void setLen(String l) {
        this.len = l;
    }

    public boolean isBuiltIn() {
        return this.builtInType > 0;
    }

    public void setLen(int l) {
        this.len = String.valueOf(l);
    }

    public String setScale(int s) {
        String msg = null;
        this.scale = s;
        try {
            int l = Integer.parseInt(this.len);
            if (s > l) {
                msg = String.valueOf(String.valueOf(String.valueOf(String.valueOf(" : The scale (").concat(String.valueOf(s))).concat(String.valueOf(") is larger than the precision ("))).concat(String.valueOf(this.len))).concat(String.valueOf(')'));
            }
        }
        catch (NumberFormatException e) {
            msg = "The length cannot be converted to a number";
        }
        return msg;
    }

    protected boolean isUnbounded() {
        return this.len == null;
    }

    protected int stringLen() {
        return this.len == null ? 0 : Integer.parseInt(this.len);
    }

    public String stringMod() {
        return this.isString() ? String.valueOf(", ").concat(String.valueOf(this.stringLen())) : "";
    }

    public boolean isAny() {
        return this.builtInType == 13;
    }

    public String C_and_idlTypeId(char sep) {
        switch (this.builtInType) {
            case 1: {
                return "char";
            }
            case 3: {
                return "boolean";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return String.valueOf(String.valueOf("unsigned").concat(String.valueOf(sep))).concat(String.valueOf("short"));
            }
            case 6: {
                return "long";
            }
            case 9: {
                return String.valueOf(String.valueOf("unsigned").concat(String.valueOf(sep))).concat(String.valueOf("long"));
            }
            case 15: {
                return "string";
            }
            case 16: {
                return "wstring";
            }
            case 10: {
                return "float";
            }
            case 11: {
                return "double";
            }
            case 13: {
                return "any";
            }
            case 14: {
                return "octet";
            }
            case 12: {
                return String.valueOf(String.valueOf("long").concat(String.valueOf(sep))).concat(String.valueOf("double"));
            }
            case 2: {
                return "wchar";
            }
            case 8: {
                return String.valueOf(String.valueOf(String.valueOf(String.valueOf("unsigned").concat(String.valueOf(sep))).concat(String.valueOf("long"))).concat(String.valueOf(sep))).concat(String.valueOf("long"));
            }
            case 7: {
                return String.valueOf(String.valueOf("long").concat(String.valueOf(sep))).concat(String.valueOf("long"));
            }
            case 17: {
                return "fixed";
            }
            case 19: {
                return "void";
            }
        }
        return null;
    }

    protected String idlTypeId(char sep) {
        String id = this.C_and_idlTypeId(sep);
        if (id == null) {
            id = this.getId();
        }
        return id;
    }

    private String idlTypeId() {
        return this.idlTypeId(' ');
    }

    private String cBuiltInId() {
        switch (this.builtInType) {
            case 1: {
                return "CORBA_char";
            }
            case 3: {
                return "CORBA_boolean";
            }
            case 4: {
                return "CORBA_short";
            }
            case 5: {
                return "CORBA_unsigned_short";
            }
            case 6: {
                return "CORBA_long";
            }
            case 9: {
                return "CORBA_unsigned_long";
            }
            case 15: {
                return "CORBA_char *";
            }
            case 10: {
                return "CORBA_float";
            }
            case 11: {
                return "CORBA_double";
            }
            case 13: {
                return "CORBA_any";
            }
            case 14: {
                return "CORBA_octet";
            }
            case 19: {
                return "void";
            }
            case 12: {
                return "CORBA_long_double";
            }
            case 2: {
                return "CORBA_wchar";
            }
            case 8: {
                return "CORBA_unsigned_long_long";
            }
            case 7: {
                return "CORBA_long_long";
            }
            case 16: {
                return "CORBA_wchar *";
            }
            case 17: {
                return String.valueOf(String.valueOf(String.valueOf("CORBA_fixed_").concat(String.valueOf(this.len))).concat(String.valueOf('_'))).concat(String.valueOf(this.scale));
            }
        }
        return null;
    }

    private String javaBuiltInId() {
        switch (this.builtInType) {
            case 1: {
                return "char";
            }
            case 3: {
                return "boolean";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "short";
            }
            case 6: {
                return "int";
            }
            case 9: {
                return "int";
            }
            case 15: {
                return "java.lang.String";
            }
            case 10: {
                return "float";
            }
            case 11: {
                return "double";
            }
            case 13: {
                return "org.omg.CORBA.Any";
            }
            case 14: {
                return "byte";
            }
            case 19: {
                return "void";
            }
            case 12: {
                return "org.omg.CORBA.Long_Double";
            }
            case 2: {
                return "char";
            }
            case 8: {
                return "long";
            }
            case 7: {
                return "long";
            }
            case 16: {
                return "java.lang.String";
            }
            case 17: {
                return "java.math.BigDecimal";
            }
        }
        return null;
    }

    public String returnType(int lang) {
        String op = "";
        if (lang == 2) {
            op = String.valueOf(this.cTypeId()).concat(String.valueOf(this.cModification(4)));
        }
        return op;
    }

    public String cModification(int type) {
        switch (this.modification(type)) {
            case 0: {
                return "";
            }
            case 1: {
                return " *";
            }
            case 2: {
                return " **";
            }
            case 3: {
                return "_slice *";
            }
            case 4: {
                return "_slice **";
            }
        }
        return "What ??";
    }

    private boolean cDerefInoutParam() {
        return !this.isFixed() && (this.isBasicType() || this.isEnum() || this.isObjRef());
    }

    private boolean isComplex() {
        return !this.isEnum() && this.isConstructedType();
    }

    public boolean javaStreamable() {
        return !this.javaStreamName().equals("");
    }

    public String javaStreamName() {
        String f = "";
        switch (this.builtInType) {
            case 1: {
                f = "char";
                break;
            }
            case 3: {
                f = "boolean";
                break;
            }
            case 5: {
                f = "ushort";
                break;
            }
            case 4: {
                f = "short";
                break;
            }
            case 9: {
                f = "ulong";
                break;
            }
            case 6: {
                f = "long";
                break;
            }
            case 15: {
                f = "string";
                break;
            }
            case 10: {
                f = "float";
                break;
            }
            case 11: {
                f = "double";
                break;
            }
            case 13: {
                f = "any";
                break;
            }
            case 14: {
                f = "octet";
                break;
            }
            case 2: {
                f = "wchar";
                break;
            }
            case 8: {
                f = "ulonglong";
                break;
            }
            case 7: {
                f = "longlong";
                break;
            }
            case 16: {
                f = "wstring";
                break;
            }
            case 17: {
                f = "fixed";
            }
        }
        return f;
    }

    public String cServerDeclare(int type) {
        String mod = " ";
        boolean var = this.isVariable();
        boolean arr = this.isArray();
        if (var) {
            if (arr) {
                return "_slice * ";
            }
            if (!this.isString()) {
                return " * ";
            }
        }
        switch (type) {
            case 1: 
            case 3: {
                break;
            }
        }
        return mod;
    }

    public String cServerCall(int type) {
        boolean var = this.isVariable();
        boolean arr = this.isArray();
        switch (type) {
            case 1: {
                if (var) {
                    return "";
                }
                if (!this.isFixed() && !this.isComplex()) break;
                return "&";
            }
            case 3: {
                if (var && !this.isString()) {
                    return "";
                }
            }
            case 2: {
                if (arr && !var) {
                    return "";
                }
                if (this.isInterface()) {
                    return "";
                }
                return "&";
            }
        }
        return "";
    }

    public String cServerCallModification(boolean encode, int type) {
        boolean var = this.isVariable();
        boolean arr = this.isArray();
        boolean iface = this.isInterface();
        if (var && !this.isString()) {
            return "";
        }
        switch (type) {
            case 1: 
            case 3: {
                if (encode ? !this.isFixed() && !this.isComplex() : arr && !var) {
                    return "";
                }
                return "&";
            }
            case 2: 
            case 4: {
                if (!encode || !this.isFixed() && !this.isComplex()) break;
                return "&";
            }
        }
        return encode ? "" : "&";
    }

    public String cClientCallModification(boolean encode, int type) {
        boolean var = this.isVariable();
        boolean arr = this.isArray();
        boolean iface = this.isInterface();
        switch (type) {
            case 1: {
                break;
            }
            case 3: {
                if (encode && (this.isString() || this.cDerefInoutParam())) {
                    return "*";
                }
                return "";
            }
            case 2: {
                if (this.isString() && !encode) {
                    return "";
                }
                if (var) {
                    return "*";
                }
                return encode ? "*" : "";
            }
            case 4: {
                if (this.isString() && !encode) {
                    return "&";
                }
                if (var) {
                    if (arr) {
                        return "";
                    }
                    return encode ? "*" : "";
                }
                if (!arr || encode) break;
                return "";
            }
        }
        return encode ? "" : "&";
    }

    public String cAllocateModification(int type) {
        boolean var = this.isVariable();
        boolean arr = this.isArray();
        boolean iface = this.isInterface();
        switch (type) {
            case 1: {
                break;
            }
            case 3: {
                if (!iface) break;
                return "ifdssds";
            }
            case 2: 
            case 4: {
                if (var) {
                    return "*";
                }
                if (iface) {
                    return "ifdssds";
                }
                if (!arr || type != 4) break;
                return "_slice *";
            }
        }
        return "";
    }

    public int modification(int type) {
        int mod = 0;
        if (type == 1) {
            if (this.requiresPointer() || this.requiresInRef()) {
                mod = 1;
            }
        } else if (type == 4) {
            if (this.requiresPointer() && this.isVariable()) {
                mod = 1;
            } else if (this.isArray()) {
                mod = 3;
            }
        } else {
            if (!this.isArray()) {
                mod = 1;
            }
            if (type == 2) {
                if (this.isArray() && this.isVariable()) {
                    mod = 4;
                } else if (this.requiresPointer() && !this.isFixed()) {
                    mod = 2;
                }
            }
        }
        return mod;
    }

    public String cTypeId() {
        return this.cBaseTypeId();
    }

    public String exceptionId(boolean quotes) {
        String id = quotes ? this.repositoryId() : String.valueOf("ex_").concat(String.valueOf(this.cId()));
        return id;
    }

    private String cBaseTypeId() {
        String id = this.cBuiltInId();
        if (id == null) {
            id = this.cId();
        }
        return id;
    }

    public String javaTypeId(boolean full) {
        return this.javaParamTypeId(full, false);
    }

    public String javaHolderName(boolean full) {
        String id = this.javaBuiltInId();
        if (id != null) {
            switch (this.builtInType) {
                case 13: {
                    break;
                }
                case 17: {
                    id = "org.omg.CORBA.Fixed";
                    break;
                }
                case 15: 
                case 16: {
                    id = "org.omg.CORBA.String";
                    break;
                }
                default: {
                    id = String.valueOf(String.valueOf("org.omg.CORBA.").concat(String.valueOf(Character.toUpperCase(id.charAt(0))))).concat(String.valueOf(id.substring(1)));
                    break;
                }
            }
        } else {
            id = full ? this.javaFullName() : this.javaId();
        }
        return String.valueOf(id).concat(String.valueOf("Holder"));
    }

    public String javaBaseId() {
        return this.javaParamTypeId(false, false);
    }

    public String javaParamTypeId(boolean full, boolean holder) {
        String id;
        block1: {
            boolean builtIn;
            id = this.javaBuiltInId();
            boolean bl = builtIn = id != null;
            if (!builtIn) {
                id = full ? this.javaFullName() : this.javaId();
            }
            if (!holder) break block1;
            id = this.javaHolderName(full);
        }
        return id;
    }

    public TypeSpec sequenceBaseType() {
        return null;
    }

    public String javaRWType() {
        if (this.isSequence()) {
            TypeSpec ts = this.sequenceBaseType();
            String f = ts.javaRWType();
            if (ts.isBuiltIn()) {
                f = String.valueOf(f).concat(String.valueOf("_array"));
            }
            return f;
        }
        String f = this.javaStreamName();
        if (f.equals("")) {
            f = this.builtInType == 12 ? "org.omg.CORBA.Long_DoubleHelper" : this.javaHelperName(true);
        }
        if (this.isBuiltIn() && this.isArray()) {
            f = String.valueOf(f).concat(String.valueOf("_array"));
        }
        return f;
    }

    public String javaHelperName(boolean full) {
        String name = full ? this.javaFullName() : this.javaId();
        return String.valueOf(name).concat(String.valueOf("Helper"));
    }

    public String javaMarshal(boolean write, String prefix, String jid) {
        String f = this.javaRWType();
        if (this.javaStreamable()) {
            if (write) {
                f = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("_er_output.write_").concat(String.valueOf(f))).concat(String.valueOf("( "))).concat(String.valueOf(prefix))).concat(String.valueOf(jid))).concat(String.valueOf(" ) ;"));
            } else {
                String fcast = "";
                if (this.builtInType == 17) {
                    fcast = "( java.math.BigDecimal )";
                }
                f = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(jid))).concat(String.valueOf(" = "))).concat(String.valueOf(fcast))).concat(String.valueOf("_er_input.read_"))).concat(String.valueOf(f))).concat(String.valueOf("() ;"));
            }
        } else {
            f = write ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(f).concat(String.valueOf(".write( _er_output, "))).concat(String.valueOf(prefix))).concat(String.valueOf(jid))).concat(String.valueOf(" ) ;")) : String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(jid))).concat(String.valueOf(" = "))).concat(String.valueOf(f))).concat(String.valueOf(".read( _er_input ) ;"));
        }
        return f;
    }

    public String javaTypeCode(String orb) {
        String f = this.javaStreamName();
        if (this.builtInType == 12) {
            f = "longdouble";
        }
        f = f.equals("") ? String.valueOf(this.javaHelperName(true)).concat(String.valueOf(".type()")) : (f.equals("string") ? String.valueOf(String.valueOf(String.valueOf(orb).concat(String.valueOf(".create_string_tc( "))).concat(String.valueOf(this.len == null ? "0" : this.len))).concat(String.valueOf(" )")) : String.valueOf(String.valueOf(String.valueOf(orb).concat(String.valueOf(".get_primitive_tc( org.omg.CORBA.TCKind.tk_"))).concat(String.valueOf(f))).concat(String.valueOf(" )")));
        return f;
    }

    protected String javaAnyInsert(String id, String val) {
        String f = this.javaStreamName();
        f = f.equals("") ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(this.javaHelperName(false)).concat(String.valueOf(".insert( "))).concat(String.valueOf(id))).concat(String.valueOf(", "))).concat(String.valueOf(val))).concat(String.valueOf(" ) ;")) : String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(id).concat(String.valueOf(".insert_"))).concat(String.valueOf(f))).concat(String.valueOf("( "))).concat(String.valueOf(val))).concat(String.valueOf(" ) ;"));
        return f;
    }

    protected String javaAnyIE(String id, boolean extract, boolean holder) {
        String hold;
        String f = this.javaStreamName();
        String s = extract ? ".extract" : ".insert";
        String string = hold = holder ? ".value" : "";
        if (f.equals("")) {
            String val = String.valueOf("( _er_").concat(String.valueOf(id));
            if (!extract) {
                val = String.valueOf(val).concat(String.valueOf(String.valueOf(String.valueOf(", ").concat(String.valueOf(id))).concat(String.valueOf(hold))));
            }
            val = String.valueOf(val).concat(String.valueOf(" )"));
            f = String.valueOf(String.valueOf(this.javaHelperName(true)).concat(String.valueOf(s))).concat(String.valueOf(val));
        } else {
            String val = extract ? "()" : String.valueOf(String.valueOf(String.valueOf("( ").concat(String.valueOf(id))).concat(String.valueOf(hold))).concat(String.valueOf(" )"));
            f = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("_er_").concat(String.valueOf(id))).concat(String.valueOf(s))).concat(String.valueOf('_'))).concat(String.valueOf(f))).concat(String.valueOf(val));
        }
        if (extract) {
            f = String.valueOf(String.valueOf(String.valueOf(id).concat(String.valueOf(hold))).concat(String.valueOf(" = "))).concat(String.valueOf(f));
        }
        return f;
    }

    public String javaAnyExtract(String id, boolean holder) {
        return this.javaAnyIE(id, true, holder);
    }

    public String javaAnyInsert(String id, boolean holder) {
        return this.javaAnyIE(id, false, holder);
    }

    public String javaSetTypeCode(String orb) {
        return String.valueOf(String.valueOf(".type( ").concat(String.valueOf(this.javaTypeCode(orb)))).concat(String.valueOf(" ) ;"));
    }

    public String javaMarshalArray(boolean write, String prefix, String jid, String size) {
        String f = this.javaRWType();
        if (!this.isString() && this.isBuiltIn()) {
            f = String.valueOf(f).concat(String.valueOf("_array"));
            String p = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(f).concat(String.valueOf("( "))).concat(String.valueOf(prefix))).concat(String.valueOf(jid))).concat(String.valueOf(", 0, "))).concat(String.valueOf(size))).concat(String.valueOf(" ) ;"));
            f = write ? String.valueOf("_er_output.write_").concat(String.valueOf(p)) : String.valueOf("_er_input.read_").concat(String.valueOf(p));
        } else {
            String tmp = Snode.getTmpVar();
            String p = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("for ( int ").concat(String.valueOf(tmp))).concat(String.valueOf(" = 0 ; "))).concat(String.valueOf(tmp))).concat(String.valueOf(" < "))).concat(String.valueOf(size))).concat(String.valueOf(" ; "))).concat(String.valueOf(tmp))).concat(String.valueOf("++ )"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(this.pfx()));
            String index = String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(jid))).concat(String.valueOf("[ "))).concat(String.valueOf(tmp))).concat(String.valueOf(" ]"));
            f = this.isString() ? (write ? String.valueOf(String.valueOf(String.valueOf(p).concat(String.valueOf("_er_output.write_string( "))).concat(String.valueOf(index))).concat(String.valueOf(" ) ;")) : String.valueOf(String.valueOf(p).concat(String.valueOf(index))).concat(String.valueOf(" = _er_input.read_string() ;"))) : (write ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(p).concat(String.valueOf(f))).concat(String.valueOf(".write( _er_output, "))).concat(String.valueOf(index))).concat(String.valueOf(" ) ;")) : String.valueOf(String.valueOf(String.valueOf(String.valueOf(p).concat(String.valueOf(index))).concat(String.valueOf(" = "))).concat(String.valueOf(f))).concat(String.valueOf(".read( _er_input ) ;")));
        }
        return f;
    }

    public String encodeDecode(boolean encode, int lang) {
        String dir = encode ? "_write" : "_read";
        String op = null;
        if (lang == 2) {
            op = this.builtInType == 15 ? String.valueOf("CORBA_string").concat(String.valueOf(dir)) : (this.builtInType == 16 ? String.valueOf("CORBA_wstring").concat(String.valueOf(dir)) : (this.isEnum() ? String.valueOf("CORBA_long").concat(String.valueOf(dir)) : (this.isObjRef() ? String.valueOf("CORBA_objref").concat(String.valueOf(dir)) : String.valueOf(this.cTypeId()).concat(String.valueOf(dir)))));
        }
        return op;
    }

    public void builtIn(int type) {
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 17: 
            case 19: {
                this.builtInType = type;
                this.isVar = 0;
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                this.builtInType = type;
                this.isVar = 1;
                break;
            }
        }
    }

    public boolean isSequence() {
        return false;
    }

    public void cAllocFuncAlways() {
        String cid = this.cTypeId();
        String arrMod = this.isArray() ? "_slice" : "";
        String fType = String.valueOf(String.valueOf(cid).concat(String.valueOf(arrMod))).concat(String.valueOf(" * "));
        String name = String.valueOf(this.cAllocFuncName()).concat(String.valueOf("( void )"));
        int stream = this.isFixedArray() ? 2 : 0;
        this.Println(stream, String.valueOf(Snode.nl).concat(String.valueOf(this.cfuncDEF(fType, name, true))));
        this.Print(1, String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.nl).concat(String.valueOf(this.cfuncDEF(fType, name, false)))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2)));
        if (this.isVariable()) {
            this.Print(1, String.valueOf(String.valueOf(String.valueOf(String.valueOf("return CORBA_varAlloc( ( CORBA_iFreeFunc )").concat(String.valueOf(this.cFreeFuncName()))).concat(String.valueOf(", sizeof( "))).concat(String.valueOf(cid))).concat(String.valueOf(" )")));
        } else {
            this.Print(1, String.valueOf(String.valueOf("return CORBA_alloc( CORBA_MA_FIXED, sizeof( ").concat(String.valueOf(cid))).concat(String.valueOf(" ), CORBA_FALSE")));
        }
        this.Println(1, String.valueOf(String.valueOf(String.valueOf(" ) ;").concat(String.valueOf(Snode.nl))).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl)));
    }

    public void cFreeFunc(String body) {
        if (this.isVariable()) {
            String cid = this.cTypeId();
            String arrMod = this.isArray() ? "_slice" : "";
            String free = this.cFreeFuncName();
            String fType = "void ";
            String freeFunc = String.valueOf(String.valueOf(String.valueOf(String.valueOf(free).concat(String.valueOf("( "))).concat(String.valueOf(cid))).concat(String.valueOf(arrMod))).concat(String.valueOf(" * s )"));
            this.Println(2, String.valueOf(Snode.nl).concat(String.valueOf(this.cfuncDEF(fType, freeFunc, true))));
            this.Println(1, String.valueOf(String.valueOf(String.valueOf(Snode.nl).concat(String.valueOf(this.cfuncDEF(fType, freeFunc, false)))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{')));
            body = String.valueOf(body).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.lev2).concat(String.valueOf("/* return sizeof( "))).concat(String.valueOf(this.cTypeId()))).concat(String.valueOf(" ) ; */"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl))));
            this.Println(1, body);
        }
    }

    public String TypeCode() {
        String f = this.typeType() == 12 ? "longdouble" : this.javaStreamName();
        f = f.equals("") ? String.valueOf(String.valueOf('&').concat(String.valueOf(this.cId()))).concat(String.valueOf("_tc")) : String.valueOf("&CORBA__tk_").concat(String.valueOf(f));
        return f;
    }

    public boolean isEnumInUnion() {
        return this instanceof Enum && this.getParent().getType() == 67;
    }

    public String TypeCodeFunc(int mode, int level) {
        String sep;
        String fid;
        String pf2;
        if (mode == 2) {
            pf2 = "";
            fid = this.cppFullId();
            sep = "_";
        } else {
            pf2 = Snode.pfx(level);
            fid = this.cppId();
            sep = "::";
        }
        String mod = this.isEnumInUnion() ? "static " : this.namespace_static();
        String s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.nl).concat(String.valueOf(pf2))).concat(String.valueOf(mod))).concat(String.valueOf("CORBA"))).concat(String.valueOf(sep))).concat(String.valueOf("TypeCode * "))).concat(String.valueOf(fid))).concat(String.valueOf("_type() ; "))).concat(String.valueOf(Snode.nl));
        return s;
    }

    public String cGenTypeCode(int mode) {
        String fid;
        String sep;
        String cid = this.cId();
        if (mode == 2) {
            sep = "_";
            fid = cid;
        } else {
            sep = "::";
            fid = this.cppFullId();
        }
        String s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("CORBA").concat(String.valueOf(sep))).concat(String.valueOf("TypeCode * "))).concat(String.valueOf(fid))).concat(String.valueOf("_type()"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl));
        s = mode == 3 ? String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.lev2).concat(String.valueOf("static CORBA::TypeCode tc( &"))).concat(String.valueOf(cid))).concat(String.valueOf("_tc ) ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf("return &tc ;")))) : String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf("return &").concat(String.valueOf(cid))).concat(String.valueOf("tc"))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(Snode.nl).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl))));
        return s;
    }

    public void cAllocFunc() {
        if (this.isArray() || this.isVariable()) {
            this.cAllocFuncAlways();
        }
    }

    protected void cDoSequences(int level) {
        if (this.children != null) {
            Enumeration e = this.children.elements();
            while (e.hasMoreElements()) {
                TypeSpec ts;
                Snode n = (Snode)e.nextElement();
                int t = n.getType();
                if (t != 10 && t != 6 || (ts = ((TypedList)n).typeSpec).isReference() || !ts.isSequence()) continue;
                ts.cDump(level);
            }
        }
    }

    private void cFixedDef() {
        String p = Snode.pfx(2);
        String fixedType = this.cTypeId();
        String size = String.valueOf(String.valueOf("( ( ").concat(String.valueOf(this.len))).concat(String.valueOf(" + 2 )/2 )"));
        this.Println(1, String.valueOf(Snode.ifndef(String.valueOf(fixedType).concat(String.valueOf("_funcs")))).concat(String.valueOf(Snode.nl)));
        this.Println(2, String.valueOf(String.valueOf(String.valueOf(String.valueOf("#define ").concat(String.valueOf(fixedType))).concat(String.valueOf("_read( A, B ) CORBA_Fixed_Type_Read( A, (B)->_value, "))).concat(String.valueOf(size))).concat(String.valueOf(" )")));
        this.Println(2, String.valueOf(String.valueOf(String.valueOf(String.valueOf("#define ").concat(String.valueOf(fixedType))).concat(String.valueOf("_write( A, B ) CORBA_Fixed_Type_Write( A, (B)->_value, "))).concat(String.valueOf(size))).concat(String.valueOf(" )")));
        this.println(Snode.ifndef(fixedType));
        this.println(String.valueOf(String.valueOf(String.valueOf(Snode.nl).concat(String.valueOf("typedef struct"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{')));
        this.println(String.valueOf(p).concat(String.valueOf("CORBA_unsigned_short _digits ;")));
        this.println(String.valueOf(p).concat(String.valueOf("CORBA_short _scale ;")));
        this.println(String.valueOf(String.valueOf(String.valueOf(p).concat(String.valueOf("CORBA_char _value[ "))).concat(String.valueOf(size))).concat(String.valueOf(" ] ;")));
        this.println(String.valueOf(String.valueOf(String.valueOf(String.valueOf('}').concat(String.valueOf(Snode.nl))).concat(String.valueOf(fixedType))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl)));
        this.cAllocFuncAlways();
        this.println(String.valueOf(Snode.nl).concat(String.valueOf(this.endif())));
        this.Println(1, String.valueOf(Snode.nl).concat(String.valueOf(this.endif())));
    }

    public void genFixed(int level, int mode) {
        if (!this.isFixed()) {
            return;
        }
        if (mode == 2) {
            this.cFixedDef();
        }
    }

    public void cDump(int level) {
        String str = this.cTypeId();
        this.print(str);
    }

    public void dump(int level) {
        String str = this.idlTypeId();
        this.print(str);
        if (this.len != null) {
            this.print(String.valueOf("<").concat(String.valueOf(this.len)));
            if (this.scale >= 0) {
                this.print(String.valueOf(",").concat(String.valueOf(this.scale)));
            }
            this.print(">");
        }
    }

    public String cppPMod(int pType) {
        int mod = this.cppIMod(pType);
        return Snode.cppMod(mod);
    }

    public int cppIMod(int pType) {
        int mod = 999;
        switch (pType) {
            case 1: {
                mod = this.cppInMod();
                break;
            }
            case 3: {
                mod = this.cppInOutMod();
                break;
            }
            case 2: {
                mod = this.cppOutMod();
                break;
            }
            case 4: {
                mod = this.cppReturnMod();
            }
        }
        return mod;
    }

    public String cppAlloc(String id, int pType, boolean server) {
        String s = "";
        String t = this.cppTypeId();
        int Imod = this.cppIMod(pType);
        if (this.isInterface()) {
            s = String.valueOf(String.valueOf(t).concat(String.valueOf("_ptr "))).concat(String.valueOf(id));
            if (server) {
                if (pType != 4) {
                    s = String.valueOf(s).concat(String.valueOf(" = NULL"));
                }
            } else {
                s = String.valueOf(s).concat(String.valueOf(" = NULL"));
            }
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(" ;").concat(String.valueOf(Snode.nl))));
            return s;
        }
        if (this.isFixed() && !server) {
            return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(t).concat(String.valueOf(" * "))).concat(String.valueOf(id))).concat(String.valueOf(" = new "))).concat(String.valueOf(t))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl));
        }
        if (Imod == 1) {
            String mod = "*";
            s = String.valueOf(String.valueOf(t).concat(String.valueOf(" * "))).concat(String.valueOf(id));
        } else {
            s = Imod == 3 ? String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(t).concat(String.valueOf("_slice * "))).concat(String.valueOf(id)))) : String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(t).concat(String.valueOf(" "))).concat(String.valueOf(id))));
        }
        if (this.isString() && (!server || pType != 4)) {
            s = String.valueOf(s).concat(String.valueOf(" = NULL"));
        }
        if (server && this.isString()) {
            s = this.typeType() == 15 ? "CORBA::String_var " : "CORBA::WString_var ";
            s = String.valueOf(s).concat(String.valueOf(id));
        }
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(" ;").concat(String.valueOf(Snode.nl))));
        return s;
    }

    protected String cppBuiltInId() {
        switch (this.builtInType) {
            case 1: {
                return "Char";
            }
            case 3: {
                return "Boolean";
            }
            case 4: {
                return "Short";
            }
            case 5: {
                return "UShort";
            }
            case 6: {
                return "Long";
            }
            case 9: {
                return "ULong";
            }
            case 15: {
                return "char *";
            }
            case 10: {
                return "Float";
            }
            case 11: {
                return "Double";
            }
            case 13: {
                return "Any";
            }
            case 14: {
                return "Octet";
            }
            case 19: {
                return "void";
            }
            case 12: {
                return "LongDouble";
            }
            case 2: {
                return "WChar";
            }
            case 16: {
                return "WChar *";
            }
            case 8: {
                return "ULongLong";
            }
            case 7: {
                return "LongLong";
            }
            case 17: {
                return String.valueOf(String.valueOf(String.valueOf(String.valueOf("Fixed<").concat(String.valueOf(this.len))).concat(String.valueOf(','))).concat(String.valueOf(this.scale))).concat(String.valueOf(">"));
            }
        }
        return null;
    }

    public String cppTypeId() {
        String id = this.cppBuiltInId();
        if (id != null) {
            if (this.builtInType == 17) {
                return String.valueOf("CORBA_").concat(String.valueOf(id));
            }
            if (this.builtInType != 19 && this.builtInType != 15) {
                return String.valueOf("CORBA::").concat(String.valueOf(id));
            }
            return id;
        }
        return this.cppFullId();
    }

    public String cppTypeId2() {
        String id = this.cppBuiltInId();
        if (id != null) {
            if (this.builtInType == 15) {
                return "CORBA::String_var";
            }
            if (this.builtInType == 16) {
                return "CORBA::WString_var";
            }
            if (this.builtInType == 17) {
                return String.valueOf("CORBA_").concat(String.valueOf(id));
            }
            if (this.builtInType != 19) {
                return String.valueOf("CORBA::").concat(String.valueOf(id));
            }
            return id;
        }
        id = this.cppFullId();
        if (this.isInterface()) {
            id = String.valueOf(id).concat(String.valueOf("_ptr"));
        }
        return id;
    }

    public String cppWriteOut(TypeSpec t, String id, int level) {
        String s = this.isString() ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.pfx(level)).concat(String.valueOf("_er_os.setBounds(  "))).concat(String.valueOf(this.stringLen()))).concat(String.valueOf(" ) ;"))).concat(String.valueOf(Snode.nl)) : "";
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.pfx(level)).concat(String.valueOf("_er_os << "))).concat(String.valueOf(id))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl))));
        return s;
    }

    public String cppReadIn(TypeSpec t, String id, int level) {
        String s = this.isString() ? String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.pfx(level)).concat(String.valueOf("_er_is.setBounds( "))).concat(String.valueOf(this.stringLen()))).concat(String.valueOf(" ) ;"))).concat(String.valueOf(Snode.nl)) : "";
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.pfx(level)).concat(String.valueOf("_er_is >> "))).concat(String.valueOf(id))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl))));
        return s;
    }

    public String cppCopy(TypeSpec t, String tgt, String src, int level) {
        String s = "";
        boolean isStruct = this instanceof Struct;
        s = this.isInterface() || this.isEnum() || this.isSequence() || this.isAny() || this instanceof Union || this.isBasicType() ? String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(tgt).concat(String.valueOf(" = "))).concat(String.valueOf(src))).concat(String.valueOf(" ;")))) : (this.isString() ? String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(tgt).concat(String.valueOf(" = CORBA::"))).concat(String.valueOf(this.isWideString() ? "w" : ""))).concat(String.valueOf("string_dup( "))).concat(String.valueOf(src))).concat(String.valueOf(" ) ;")))) : String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("::").concat(String.valueOf(this.cppFullId()))).concat(String.valueOf(isStruct ? String.valueOf(String.valueOf("_var::Copy( &").concat(String.valueOf(tgt))).concat(String.valueOf(", ")) : " Copy( "))).concat(String.valueOf("&"))).concat(String.valueOf(src))).concat(String.valueOf("  ) ;")))));
        return String.valueOf(String.valueOf(Snode.pfx(level)).concat(String.valueOf(s))).concat(String.valueOf(Snode.nl));
    }

    public String cppRelease(String id, int level) {
        String p = Snode.pfx(level);
        if (this.isString() || this.isInterface()) {
            return String.valueOf(String.valueOf(String.valueOf(String.valueOf(p).concat(String.valueOf("delete "))).concat(String.valueOf(id))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl));
        }
        if (this.isBasicType()) {
            return "";
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p).concat(String.valueOf("::"))).concat(String.valueOf(this.cppFullId()))).concat(String.valueOf("_var::Release( "))).concat(String.valueOf(id))).concat(String.valueOf(" ) ;"))).concat(String.valueOf(Snode.nl));
    }

    public String cppInType() {
        if (this.isBasicType() || this.isEnum() || this.isArray()) {
            return " ";
        }
        if (this.isString()) {
            return " * ";
        }
        if (this.isInterface()) {
            return "_ptr";
        }
        return " & ";
    }

    public String cppInoutType() {
        if (this.isArray()) {
            return " ";
        }
        if (this.isInterface()) {
            return "_ptr & ";
        }
        if (this.isString()) {
            return " *& ";
        }
        return " & ";
    }

    public String cppOutType() {
        if (this.isVariable()) {
            return " *& ";
        }
        if (this.isInterface()) {
            return "_ptr &";
        }
        return " & ";
    }

    public String cppReturnType() {
        if (this.isArray()) {
            return "_slice ";
        }
        if (this.isInterface()) {
            return "_ptr ";
        }
        if (this.isFixed()) {
            return " & ";
        }
        if (this.isVariable()) {
            return " * ";
        }
        return " ";
    }

    protected String cppOutTypeDump(int level) {
        String p1 = Snode.pfx(level);
        String p2 = Snode.pfx(level + 1);
        String id = this.cppId();
        String cls = String.valueOf(id).concat(String.valueOf("_out"));
        boolean iface = this instanceof Interface;
        String sfx = iface ? "_ptr " : " *& ";
        String s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.nl).concat(String.valueOf(p1))).concat(String.valueOf("class "))).concat(String.valueOf(cls))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(p1))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p1).concat(String.valueOf("private:"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(p2))).concat(String.valueOf(id))).concat(String.valueOf(sfx))).concat(String.valueOf("ptr_ ;"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p1).concat(String.valueOf("public:"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(p2))).concat(String.valueOf(cls))).concat(String.valueOf("( "))).concat(String.valueOf(id))).concat(String.valueOf(sfx))).concat(String.valueOf("& p ) : ptr_( p ) { ptr_ = "))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(iface ? String.valueOf(id).concat(String.valueOf("::_nil()")) : " NULL").concat(String.valueOf(" ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf(cls))).concat(String.valueOf("( "))).concat(String.valueOf(id))).concat(String.valueOf("_var & p ) : ptr_( p.in() ) "))));
        s = iface ? String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf("{ CORBA::release( ptr_ ) ; ptr_ = ").concat(String.valueOf(id))).concat(String.valueOf("::_nil() ; }"))).concat(String.valueOf(Snode.nl)))) : String.valueOf(s).concat(String.valueOf(String.valueOf("{ delete ptr_ ; ptr = NULL ; }").concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf(cls))).concat(String.valueOf("( "))).concat(String.valueOf(cls))).concat(String.valueOf(" & a ) : ptr_( a.ptr_ ) {}"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf(cls))).concat(String.valueOf(" & operator=( "))).concat(String.valueOf(cls))).concat(String.valueOf(" & a ) { ptr_ = a.ptr_ ; return *this ; }"))).concat(String.valueOf(Snode.nl))));
        if (iface) {
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf(cls))).concat(String.valueOf(" & operator=( const "))).concat(String.valueOf(id))).concat(String.valueOf("_var & a ) "))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(p2))).concat(String.valueOf("{ ptr_ = "))).concat(String.valueOf(id))).concat(String.valueOf("::_duplicate( a.in() ) ; return *this ; }"))).concat(String.valueOf(Snode.nl))));
        }
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf(cls))).concat(String.valueOf(" & operator=( const "))).concat(String.valueOf(id))).concat(String.valueOf(sfx))).concat(String.valueOf(" p ) { ptr_ = p ; return *this ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf("operator "))).concat(String.valueOf(id))).concat(String.valueOf(sfx))).concat(String.valueOf(" &() { return ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf(id))).concat(String.valueOf(sfx))).concat(String.valueOf(" & ptr() { return ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(p2).concat(String.valueOf(id))).concat(String.valueOf(sfx))).concat(String.valueOf(" operator->() { return ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(p1).concat(String.valueOf("} ;"))).concat(String.valueOf(Snode.nl))));
        return s;
    }

    protected boolean cppPassByRef() {
        return this.isArray() || this instanceof Struct || this instanceof Union || this.isSequence();
    }

    public String cppAny(StringHolder anyF, int level) {
        String a;
        String pfx = Snode.pfx(level);
        String pfx1 = Snode.pfx(level + 1);
        String pfx2 = Snode.pfx(level + 2);
        String id = this.cppId();
        String fid = this.cppFullId();
        String nsFriend = this.namespace_friend();
        String inline = "inline ";
        boolean byRef = this.cppPassByRef();
        String Cast = "";
        String s = String.valueOf(String.valueOf("operator<<=( CORBA::Any & any, const ").concat(String.valueOf(fid))).concat(String.valueOf(" & v )"));
        String hdr = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(pfx).concat(String.valueOf(nsFriend))).concat(String.valueOf("void "))).concat(String.valueOf(s))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.nl));
        anyF.value = String.valueOf(anyF.value).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("void ").concat(String.valueOf(this.cppNameSpace()))).concat(String.valueOf(s))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))));
        if (byRef) {
            a = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.lev2).concat(String.valueOf("any.replace( "))).concat(String.valueOf(fid))).concat(String.valueOf("_type(), vv, CORBA::TRUE ) ; "))).concat(String.valueOf(Snode.nl))).concat(String.valueOf("}"))).concat(String.valueOf(Snode.nl));
            anyF.value = String.valueOf(anyF.value).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.lev2).concat(String.valueOf(fid))).concat(String.valueOf(" * vv = v.copy() ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(a))).concat(String.valueOf(Snode.nl))));
            s = String.valueOf(String.valueOf("operator<<=( CORBA::Any & any, ").concat(String.valueOf(fid))).concat(String.valueOf(" & v )"));
            hdr = String.valueOf(hdr).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(pfx).concat(String.valueOf(nsFriend))).concat(String.valueOf("void "))).concat(String.valueOf(s))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.nl))));
            anyF.value = String.valueOf(anyF.value).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("void ").concat(String.valueOf(this.cppNameSpace()))).concat(String.valueOf(s))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))));
            a = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.lev2).concat(String.valueOf("any.replace( "))).concat(String.valueOf(fid))).concat(String.valueOf("_type(), &v, CORBA::TRUE ) ; "))).concat(String.valueOf(Snode.nl))).concat(String.valueOf("}"))).concat(String.valueOf(Snode.nl));
            anyF.value = String.valueOf(anyF.value).concat(String.valueOf(String.valueOf(a).concat(String.valueOf(Snode.nl))));
        } else {
            a = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.lev2).concat(String.valueOf("any <<= ( "))).concat(String.valueOf(this.type().cppTypeId()))).concat(String.valueOf(" )v ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf("any.setType( "))).concat(String.valueOf(fid))).concat(String.valueOf("_type() ) ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf("}"))).concat(String.valueOf(Snode.nl));
            anyF.value = String.valueOf(anyF.value).concat(String.valueOf(String.valueOf(a).concat(String.valueOf(Snode.nl))));
            String friend = "";
            String mod = "";
            if (this.isInterface()) {
                mod = "_ptr";
            }
        }
        a = String.valueOf(String.valueOf("CORBA::Boolean operator>>=( const CORBA::Any & a, ").concat(String.valueOf(fid))).concat(String.valueOf(" & v )"));
        hdr = String.valueOf(hdr).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(pfx).concat(String.valueOf(nsFriend))).concat(String.valueOf(a))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl))));
        anyF.value = String.valueOf(anyF.value).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(a).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf("( void )a ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf("( void )v ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf("return CORBA::FALSE ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf("}"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.nl))));
        return hdr;
    }

    public String cppFuncInit(StringHolder writeF, StringHolder readF, StringHolder copyF, StringHolder deleteF, int level) {
        String prefix = Snode.pfx(level);
        String pf2 = Snode.pfx(level + 1);
        String id = this.cppId();
        String fid = this.cppFullId();
        String s1 = "CORBA::Ostream & ";
        String s2 = String.valueOf(String.valueOf("operator<<( CORBA::Ostream & _er_os, const ").concat(String.valueOf(fid))).concat(String.valueOf(" & v )"));
        String f = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(pf2).concat(String.valueOf("friend "))).concat(String.valueOf(s1))).concat(String.valueOf(s2))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl));
        writeF.value = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(s1).concat(String.valueOf(this.cppNameSpace()))).concat(String.valueOf(s2))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl));
        s1 = "CORBA::Istream & ";
        s2 = String.valueOf(String.valueOf("operator>>( CORBA::Istream & _er_is, ").concat(String.valueOf(fid))).concat(String.valueOf(" & v )"));
        f = String.valueOf(f).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(pf2).concat(String.valueOf("friend "))).concat(String.valueOf(s1))).concat(String.valueOf(s2))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl))));
        readF.value = String.valueOf(readF.value).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(s1).concat(String.valueOf(this.cppNameSpace()))).concat(String.valueOf(s2))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))));
        f = String.valueOf(f).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(pf2).concat(String.valueOf(id))).concat(String.valueOf(" * copy() const ;"))).concat(String.valueOf(Snode.nl))));
        f = String.valueOf(f).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(pf2).concat(String.valueOf("void Copy( "))).concat(String.valueOf(id))).concat(String.valueOf(" * tgt ) const ;"))));
        copyF.value = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(fid).concat(String.valueOf(" * "))).concat(String.valueOf(fid))).concat(String.valueOf("::copy() const"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf(id))).concat(String.valueOf(" * _er_copy = new "))).concat(String.valueOf(id))).concat(String.valueOf("() ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf("Copy( _er_copy ) ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.lev2))).concat(String.valueOf("return _er_copy ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.nl));
        copyF.value = String.valueOf(copyF.value).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("void ").concat(String.valueOf(fid))).concat(String.valueOf("::Copy( "))).concat(String.valueOf(fid))).concat(String.valueOf(" * tgt ) const"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))));
        deleteF.value = "";
        return f;
    }

    public String cppVarDump(int level, String baseClassName) {
        String tmp1;
        String tmp;
        String prefix = Snode.pfx(level);
        String prfx = Snode.pfx(level + 1);
        String prfx2 = Snode.pfx(level + 2);
        String fid = this.cppFullId();
        String className = baseClassName;
        className = String.valueOf(className).concat(String.valueOf("_var"));
        String s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("class "))).concat(String.valueOf(className))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prefix))).concat(String.valueOf("{"))).concat(String.valueOf(Snode.nl));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("private:"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prfx))).concat(String.valueOf(baseClassName))).concat(String.valueOf(" * ptr_ ;"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("public:"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf(className))).concat(String.valueOf("() ;"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf(className))).concat(String.valueOf("( "))).concat(String.valueOf(baseClassName))).concat(String.valueOf(" * p ) { ptr_ = p ; }"))).concat(String.valueOf(Snode.nl))));
        if (this instanceof Struct) {
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf(className))).concat(String.valueOf("( const "))).concat(String.valueOf(className))).concat(String.valueOf(" & p ) { ptr_ = p.ptr_->copy() ; }"))).concat(String.valueOf(Snode.nl))));
            tmp1 = tmp = String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx2).concat(String.valueOf("return *( new "))).concat(String.valueOf(className))).concat(String.valueOf("( p->copy() ) ) ;"))).concat(String.valueOf(Snode.nl));
        } else {
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf(className))).concat(String.valueOf("( const "))).concat(String.valueOf(className))).concat(String.valueOf(" & p ) { ptr_ = p.ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
            tmp = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx2).concat(String.valueOf("return *( new "))).concat(String.valueOf(className))).concat(String.valueOf("( new "))).concat(String.valueOf(baseClassName))).concat(String.valueOf("( *p ) ) ) ;"))).concat(String.valueOf(Snode.nl));
            tmp1 = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx2).concat(String.valueOf("return *( new "))).concat(String.valueOf(className))).concat(String.valueOf("( new "))).concat(String.valueOf(baseClassName))).concat(String.valueOf("( *p.ptr_ ) ) ) ;"))).concat(String.valueOf(Snode.nl));
        }
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf("~"))).concat(String.valueOf(className))).concat(String.valueOf("() { delete ptr_ ; }"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf(className))).concat(String.valueOf(" & operator=( "))).concat(String.valueOf(baseClassName))).concat(String.valueOf(" * p ) "))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prfx))).concat(String.valueOf("{"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prfx2))).concat(String.valueOf("delete ptr_ ; "))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(tmp))).concat(String.valueOf(prfx))).concat(String.valueOf("}"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf(className))).concat(String.valueOf(" & operator=( const "))).concat(String.valueOf(className))).concat(String.valueOf(" & p )"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prfx))).concat(String.valueOf("{"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prfx2))).concat(String.valueOf("delete ptr_ ; "))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(tmp1))).concat(String.valueOf(prfx))).concat(String.valueOf("}"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf(baseClassName))).concat(String.valueOf(" * operator->() { return ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prfx).concat(String.valueOf("const "))).concat(String.valueOf(baseClassName))).concat(String.valueOf(" * operator->() const { return ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        return s;
    }

    public String inoutFuncs(int level, String id) {
        String prefix = Snode.pfx(level);
        String prfx = Snode.pfx(level + 1);
        String s = String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(id))).concat(String.valueOf(" & in() const { return *ptr_ ; }"))).concat(String.valueOf(Snode.nl));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(id))).concat(String.valueOf(" & inout() { return *ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(id))).concat(String.valueOf(" & out() { delete ptr_ ; ptr_= NULL ; return &ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(id))).concat(String.valueOf(" * _rtn() { return ptr_ ; }"))).concat(String.valueOf(Snode.nl))));
        return s;
    }

    public String cppUnionFuncPair(int level, Snode n, String m, String label) {
        String s = "";
        String prefix = Snode.pfx(level);
        String pfx2 = Snode.pfx(level + 1);
        String name = n.getId();
        String type = this.cppTypeId();
        if (this.isInterface()) {
            type = String.valueOf(type).concat(String.valueOf("_ptr"));
        }
        String set = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(Snode.nl).concat(String.valueOf(prefix))).concat(String.valueOf('{'))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(pfx2))).concat(String.valueOf("_er_d = "))).concat(String.valueOf(label))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(this.cppCopy(this, String.valueOf(m).concat(String.valueOf(name)), "v", level + 1)))).concat(String.valueOf(prefix))).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl));
        String get = String.valueOf(String.valueOf(String.valueOf(String.valueOf("{ return ").concat(String.valueOf(m))).concat(String.valueOf(name))).concat(String.valueOf(" ; }"))).concat(String.valueOf(Snode.nl));
        if (this.isConstructedType()) {
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("void "))).concat(String.valueOf(name))).concat(String.valueOf("( const "))).concat(String.valueOf(type))).concat(String.valueOf(" & v ) "))).concat(String.valueOf(set))));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("const "))).concat(String.valueOf(type))).concat(String.valueOf(" & "))).concat(String.valueOf(name))).concat(String.valueOf("() const "))).concat(String.valueOf(get))));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(type))).concat(String.valueOf(" & "))).concat(String.valueOf(name))).concat(String.valueOf("() "))).concat(String.valueOf(get))));
        } else if (this.isArray()) {
            String sliceName = String.valueOf(type).concat(String.valueOf("_slice * "));
            get = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("{ return ( ").concat(String.valueOf(sliceName))).concat(String.valueOf(" )"))).concat(String.valueOf(m))).concat(String.valueOf(name))).concat(String.valueOf(" ; }"))).concat(String.valueOf(Snode.nl));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("void "))).concat(String.valueOf(name))).concat(String.valueOf("( "))).concat(String.valueOf(type))).concat(String.valueOf(" v ) "))).concat(String.valueOf(set))));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(sliceName))).concat(String.valueOf(name))).concat(String.valueOf("() const "))).concat(String.valueOf(get))));
        } else if (this.typeType() == 15) {
            set = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("{"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(pfx2))).concat(String.valueOf("_er_d = "))).concat(String.valueOf(label))).concat(String.valueOf(" ;"))).concat(String.valueOf(Snode.nl));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("void "))).concat(String.valueOf(name))).concat(String.valueOf("( "))).concat(String.valueOf(type))).concat(String.valueOf(" v )"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(set))).concat(String.valueOf(pfx2))).concat(String.valueOf(m))).concat(String.valueOf(name))).concat(String.valueOf(" = v ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prefix))).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl))));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("void "))).concat(String.valueOf(name))).concat(String.valueOf("( const "))).concat(String.valueOf(type))).concat(String.valueOf(" v )"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(set))).concat(String.valueOf(pfx2))).concat(String.valueOf(m))).concat(String.valueOf(name))).concat(String.valueOf(" = v ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prefix))).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl))));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("void "))).concat(String.valueOf(name))).concat(String.valueOf("( const CORBA::String_var & v )"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(set))).concat(String.valueOf(pfx2))).concat(String.valueOf(m))).concat(String.valueOf(name))).concat(String.valueOf(" = v ;"))).concat(String.valueOf(Snode.nl))).concat(String.valueOf(prefix))).concat(String.valueOf('}'))).concat(String.valueOf(Snode.nl))));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("const "))).concat(String.valueOf(type))).concat(String.valueOf(' '))).concat(String.valueOf(name))).concat(String.valueOf("() const "))).concat(String.valueOf(get))));
        } else {
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf("void "))).concat(String.valueOf(name))).concat(String.valueOf("( "))).concat(String.valueOf(type))).concat(String.valueOf(" v ) "))).concat(String.valueOf(set))));
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(prefix).concat(String.valueOf(type))).concat(String.valueOf(' '))).concat(String.valueOf(name))).concat(String.valueOf("() const "))).concat(String.valueOf(get))));
        }
        return s;
    }

    public String cppDump(int level) {
        return this.cppTypeId();
    }
}

