/*
 * Decompiled with CFR 0.152.
 */
package engroom.CORBA;

import engroom.CORBA.BOA;
import engroom.CORBA.ERORB;
import engroom.CORBA.GIOP;
import engroom.CORBA.GIOP_MessageHeader_1_1;
import engroom.CORBA.GIOP_ReplyHeader;
import engroom.CORBA.GIOP_RequestHeader_1_1;
import engroom.CORBA.IOR;
import engroom.CORBA.IpStream;
import engroom.CORBA.OpStream;
import engroom.CORBA.Request;
import engroom.CORBA.TimeoutException;
import engroom.util.UnsignedConvert;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.Context;
import org.omg.CORBA.ContextList;
import org.omg.CORBA.DynamicImplementation;
import org.omg.CORBA.ExceptionList;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ImplementationDef;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;
import org.omg.CORBA.Object;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;
import org.omg.GIOP.CancelRequestHeader;
import org.omg.GIOP.CancelRequestHeaderHelper;
import org.omg.GIOP.LocateReplyHeader;
import org.omg.GIOP.LocateReplyHeaderHelper;
import org.omg.GIOP.LocateRequestHeader;
import org.omg.GIOP.LocateRequestHeaderHelper;
import org.omg.GIOP.LocateStatusType;

public class ERObject
extends Delegate {
    private static final int SO_TIMEOUT = 1000000;
    private GIOP_MessageHeader_1_1 hdr;
    private boolean responseExpected;
    private ServerSocket sSock = null;
    private IOR ior = null;
    private ObjectImpl impl = null;
    private Hashtable requests;
    protected boolean trace = false;
    protected Socket client = null;
    public IpStream in;
    public OpStream dout;
    public OpStream out;
    public ByteArrayOutputStream bout;

    public ERObject() {
    }

    public ERObject(IOR _ior) {
        this();
        this.ior = _ior;
    }

    public ERObject(ERObject o) {
        this();
    }

    private void setImplementation(ObjectImpl _impl) {
        this.impl = _impl;
    }

    public static ERObject getMe(BOA boa, Object obj) {
        ERObject ero;
        ObjectImpl _impl = (ObjectImpl)obj;
        try {
            ero = (ERObject)_impl._get_delegate();
        }
        catch (BAD_OPERATION e) {
            ero = new ERObject();
            ero.setServer();
            _impl._set_delegate(ero);
            boa.add(ero);
        }
        ero.setImplementation(_impl);
        return ero;
    }

    private String getHost() {
        if (this.sSock != null) {
            try {
                String string = InetAddress.getLocalHost().getHostAddress();
                return string;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return "XXX";
    }

    private int getPort() {
        if (this.sSock != null) {
            return this.sSock.getLocalPort();
        }
        return 0;
    }

    public byte[] objectKey() {
        return this.ior.pb.object_key;
    }

    public String toString() {
        String name;
        if (this.impl == null) {
            name = "??";
        } else {
            String[] ids = this.impl._ids();
            name = ids[ids.length - 1];
        }
        IOR ior = new IOR(this.getHost(), this.getPort(), name);
        return ior.toString();
    }

    public void setTrace() {
        this.trace = true;
    }

    public ImplementationDef get_implementation(Object self) {
        return null;
    }

    public InterfaceDef get_interface(Object self) {
        return null;
    }

    public Object duplicate(Object self) {
        return null;
    }

    public void release(Object self) {
    }

    public boolean is_a(Object self, String repository_id) {
        String[] ids = ((ObjectImpl)self)._ids();
        for (int i = 0; i < ids.length; ++i) {
            if (ids[i] == "GENERIC_IMPL") {
                return true;
            }
            if (!ids[i].equals(repository_id)) continue;
            return true;
        }
        return false;
    }

    public boolean non_existent(Object self) {
        return false;
    }

    public boolean is_equivalent(Object self, Object rhs) {
        return false;
    }

    public int hash(Object self, int max) {
        return 0;
    }

    public org.omg.CORBA.Request request(Object self, String operation) {
        return this.create_request(self, null, operation, null, null, null, null);
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result) {
        return this.create_request(self, ctx, operation, arg_list, result, null, null);
    }

    public org.omg.CORBA.Request create_request(Object self, Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList excepts, ContextList contexts) {
        return new Request(self, ctx, operation, arg_list, result, excepts, contexts);
    }

    public ImplementationDef _get_implementation() {
        return null;
    }

    public InterfaceDef _get_interface() {
        return null;
    }

    public Object _duplicate() {
        return null;
    }

    public void _release() {
    }

    public boolean _is_a(String repository_id) {
        return false;
    }

    public boolean _non_existent() {
        return false;
    }

    public boolean _is_equivalent(Object rhs) {
        return false;
    }

    public int _hash(int max) {
        return 0;
    }

    public org.omg.CORBA.Request _request(String operation) {
        return this._create_request(null, operation, null, null, null, null);
    }

    public org.omg.CORBA.Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result) {
        return this._create_request(ctx, operation, arg_list, result, null, null);
    }

    public org.omg.CORBA.Request _create_request(Context ctx, String operation, NVList arg_list, NamedValue result, ExceptionList excepts, ContextList contexts) {
        return null;
    }

    public Socket getClient() {
        return this.client;
    }

    protected void setupStreams() throws IOException {
        this.client.setSoTimeout(1000000);
        this.dout = new OpStream(this.client);
        this.bout = new ByteArrayOutputStream();
        this.out = new OpStream(this.bout);
        this.in = (IpStream)this.dout.create_input_stream();
    }

    public void connect() {
        try {
            int port = UnsignedConvert.unsigned_short(this.ior.pb.port);
            this.client = new Socket(this.ior.pb.host, port);
            this.setupStreams();
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public void disconnect() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public void setServer() {
        try {
            String name;
            this.sSock = ERORB.getServerSocket();
            if (this.impl == null) {
                name = "??";
            } else {
                String[] ids = this.impl._ids();
                name = ids[ids.length - 1];
            }
            this.ior = new IOR(this.getHost(), this.getPort(), name);
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public void server() {
        this.server((DynamicImplementation)this.impl);
    }

    public void server(DynamicImplementation imp) {
        String[] ids = imp._ids();
        while (true) {
            try {
                try {
                    Socket cl = this.sSock.accept();
                    this.server(imp, cl);
                    continue;
                }
                catch (IOException e) {
                    throw new COMM_FAILURE(e.getMessage());
                }
            }
            catch (COMM_FAILURE e) {
                System.out.println(e.getMessage());
                continue;
            }
            break;
        }
    }

    private void doRequest(DynamicImplementation imp) {
        GIOP_RequestHeader_1_1 rh = GIOP_RequestHeader_1_1.read(this.in, this.out);
        Integer rId = new Integer(rh.request_id());
        if (this.trace) {
            rh.print();
        }
        this.requests.put(rId, rh);
        try {
            imp.invoke(rh);
        }
        catch (SystemException sysE) {
            rh.systemException(sysE);
        }
        if (this.requests.containsKey(rId)) {
            this.requests.remove(rId);
            rh.writeReply(this.out, this.dout, this.bout, this.hdr.vminor);
        }
    }

    private void doLocateRequest() {
        LocateRequestHeader lrh = LocateRequestHeaderHelper.read(this.in);
        GIOP_MessageHeader_1_1.write(this.dout, (byte)4, this.hdr.vminor, 8);
        LocateReplyHeader reply = new LocateReplyHeader(lrh.request_id, LocateStatusType.OBJECT_HERE);
        LocateReplyHeaderHelper.write(this.dout, reply);
    }

    private void doCancelRequest() {
        CancelRequestHeader crh = CancelRequestHeaderHelper.read(this.in);
        Integer rId = new Integer(crh.request_id);
        if (this.requests.containsKey(rId)) {
            this.requests.remove(rId);
        } else {
            System.err.println(String.valueOf("Cancel of unknown request ").concat(String.valueOf(crh.request_id)));
        }
    }

    public void server(DynamicImplementation imp, Socket cl) {
        this.client = cl;
        this.requests = new Hashtable();
        try {
            this.setupStreams();
            block11: while (true) {
                this.bout.reset();
                this.in.alignZero();
                this.dout.flushAll();
                this.out.reserve(24);
                while (true) {
                    try {
                        this.hdr = this.in.read_message();
                    }
                    catch (TimeoutException e) {
                        System.err.println(e.getMessage());
                        continue;
                    }
                    break;
                }
                if (this.trace) {
                    this.hdr.print();
                }
                switch (this.hdr.message_type) {
                    case 0: {
                        this.doRequest(imp);
                        continue block11;
                    }
                    case 3: {
                        this.doLocateRequest();
                        continue block11;
                    }
                    case 2: {
                        this.doCancelRequest();
                        continue block11;
                    }
                    case 6: {
                        System.err.println("Got MessageError for the following");
                        this.hdr.print();
                        continue block11;
                    }
                    case 7: {
                        System.err.println("Got Fragment - can't handle");
                    }
                }
                GIOP_MessageHeader_1_1.write(this.dout, (byte)6, this.hdr.vminor, 0);
                System.err.println(String.valueOf("Unexpected GIOP message type ").concat(String.valueOf(this.hdr.message_type)));
            }
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public OutputStream _request(Object self, String operation, boolean wait) {
        this.out.reserve(12);
        GIOP_RequestHeader_1_1.write(this.out, operation, this.objectKey(), wait);
        this.responseExpected = wait;
        return this.out;
    }

    public InputStream _invoke(Object self, OutputStream pOut, StringHolder exceptionId) {
        this.out.flushAll();
        int size = this.bout.size();
        GIOP_MessageHeader_1_1.write(this.dout, (byte)0, (byte)1, size);
        this.dout.write_octet_array(this.bout.toByteArray(), 0, size);
        this.bout.reset();
        this.dout.flushAll();
        if (!this.responseExpected) {
            return this.in;
        }
        this.in.alignZero();
        this.hdr = GIOP_MessageHeader_1_1.read(this.in);
        if (this.hdr.message_type != 1) {
            throw new NO_IMPLEMENT(String.valueOf("Expected GIOP.Reply - got ").concat(String.valueOf(this.hdr.message_type)));
        }
        GIOP_ReplyHeader reply = GIOP_ReplyHeader.read(this.in);
        switch (reply.replyStatus) {
            case 0: {
                break;
            }
            case 1: {
                this.in.mark();
                exceptionId.value = this.in.read_string();
                this.in.reset();
                break;
            }
            case 2: {
                exceptionId.value = this.in.read_string();
                GIOP.readSysException(this.in, exceptionId.value);
                break;
            }
            case 3: {
                throw new NO_IMPLEMENT("LOCATION_FORWARD in reply");
            }
            default: {
                throw new INTERNAL(String.valueOf("Received reply status ").concat(String.valueOf(reply.replyStatus)));
            }
        }
        return this.in;
    }
}

