/*
 * Decompiled with CFR 0.152.
 */
package engroom.CORBA;

import engroom.CORBA.IpStream;
import engroom.CORBA.OpEncapsulate;
import engroom.CORBA.OpStream;
import engroom.util.Hex;
import java.io.ByteArrayOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.omg.CORBA.INV_OBJREF;
import org.omg.IIOP.ProfileBody_1_1;
import org.omg.IIOP.ProfileBody_1_1Helper;
import org.omg.IIOP.Version;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedProfile;

public class IOR {
    public ProfileBody_1_1 pb;
    private String name;
    public static final String normalPrefix = "IOR:";
    public static final String urlPrefix = "iiop:";

    public IOR(String host, int port, String _name) {
        Version iiop_version = new Version();
        iiop_version.major = 1;
        iiop_version.minor = 1;
        byte[] object_key = new byte[]{1};
        TaggedComponent[] components = new TaggedComponent[]{};
        this.pb = new ProfileBody_1_1(iiop_version, host, (short)port, object_key, components);
        this.name = _name;
    }

    public IOR(org.omg.IOP.IOR _ior) {
        if (_ior.profiles != null) {
            for (int i = 0; i < _ior.profiles.length; ++i) {
                TaggedProfile tp = _ior.profiles[i];
                if (tp.tag != 0) {
                    throw new INV_OBJREF(String.valueOf("prof ").concat(String.valueOf(tp.tag)));
                }
                IpStream ip = new IpStream(tp.profile_data);
                ip.read_endian();
                this.pb = ProfileBody_1_1Helper.read(ip);
                System.out.println(String.valueOf(String.valueOf(String.valueOf("host=").concat(String.valueOf(this.pb.host))).concat(String.valueOf(" port="))).concat(String.valueOf(this.pb.port)));
            }
        }
    }

    public String toString() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(2000);
        OpStream op = new OpStream(bout);
        op.write_octet((byte)0);
        op.write_string(this.name);
        TaggedProfile[] tps = new TaggedProfile[]{new TaggedProfile()};
        tps[0].tag = 0;
        op.write_long(tps.length);
        op.write_long(tps[0].tag);
        OpEncapsulate encap = new OpEncapsulate(op);
        ProfileBody_1_1Helper.write(encap, this.pb);
        encap.encapsulate();
        op.flushAll();
        byte[] stream = bout.toByteArray();
        return String.valueOf(normalPrefix).concat(String.valueOf(Hex.bytesToString(stream)));
    }

    public static IOR createIOR(String str) {
        IOR ior = null;
        if (str.toLowerCase().startsWith("iiop://")) {
            String urlStr = String.valueOf("http").concat(String.valueOf(str.substring(urlPrefix.length())));
            try {
                URL url = new URL(urlStr);
                String host = url.getHost();
                int port = url.getPort();
                if (port == -1) {
                    throw new INV_OBJREF();
                }
                String name = url.getFile().substring(1);
                ior = new IOR(host, (short)port, name);
            }
            catch (MalformedURLException ex) {
                throw new INV_OBJREF();
            }
        }
        if (str.startsWith(normalPrefix)) {
            try {
                byte[] data = Hex.stringToBytes(str.substring(normalPrefix.length()));
                IpStream ip = new IpStream(data);
                ip.read_endian();
                org.omg.IOP.IOR _ior = IORHelper.read(ip);
                ior = new IOR(_ior);
            }
            catch (NumberFormatException e) {
                throw new INV_OBJREF();
            }
        }
        return ior;
    }
}

