/*
 * Decompiled with CFR 0.152.
 */
package engroom.CORBA;

import engroom.CORBA.Any;
import engroom.CORBA.ERORB;
import engroom.CORBA.IpStream;
import engroom.CORBA.TimeoutException;
import engroom.CORBA.TypeCode;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;

public class InputStream
extends org.omg.CORBA.portable.InputStream {
    private static final int BUFF_SIZE = 1024;
    private java.io.InputStream in = null;
    private byte[] buffer = new byte[this.size];
    private boolean littleEndian = false;
    private int pos = 0;
    private int markPos = -1;
    private int size = 1024;
    private int tcs_w = 0;

    public InputStream() {
    }

    public InputStream(java.io.InputStream _in) {
        this();
        this.in = _in;
    }

    public InputStream(byte[] buff) {
        this();
        this.buffer = buff;
        this.size = this.buffer.length;
    }

    public int available() {
        try {
            int n = this.in.available();
            return n;
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public int current_offset() {
        return this.pos;
    }

    public void mark() {
        this.markPos = this.pos;
    }

    public void reset() {
        if (this.markPos != -1) {
            this.pos = this.markPos;
            this.markPos = -1;
        }
    }

    public void setPosition(int newPosition) {
        this.pos = newPosition;
    }

    public void alignZero() {
        this.pos = 0;
    }

    private void align(int size) {
        int mod = this.pos % size;
        if (mod != 0) {
            int diff = size - mod;
            this.pos += diff;
        }
    }

    protected void resize(int newSize) {
        if (newSize > this.size) {
            byte[] b = new byte[newSize];
            System.arraycopy(this.buffer, 0, b, 0, this.pos);
            this.buffer = b;
            this.size = newSize;
        }
    }

    public byte[] toByteArray() {
        return this.buffer;
    }

    public void setBigEndian() {
        this.littleEndian = false;
    }

    public void setLittleEndian() {
        this.littleEndian = true;
    }

    public void setEndian(boolean endian) {
        this.littleEndian = endian;
    }

    public boolean read_boolean() {
        return this.buffer[this.pos++] != 0;
    }

    public char read_char() {
        return (char)this.buffer[this.pos++];
    }

    public char read_wchar() {
        char c;
        switch (this.tcs_w) {
            case 1: {
                char[] wc = this.readUTF();
                c = wc[0];
                break;
            }
            default: {
                c = (char)this.read_short();
                break;
            }
        }
        return c;
    }

    public byte read_octet() {
        return this.buffer[this.pos++];
    }

    public byte read_endian() {
        byte b = this.read_octet();
        if (b > 0) {
            this.setLittleEndian();
        } else {
            this.setBigEndian();
        }
        return b;
    }

    public short read_short() {
        this.align(2);
        int b0 = this.buffer[this.pos++] & 0xFF;
        int b1 = this.buffer[this.pos++] & 0xFF;
        if (this.littleEndian) {
            return (short)((b1 << 8) + b0);
        }
        return (short)((b0 << 8) + b1);
    }

    public short read_ushort() {
        return this.read_short();
    }

    private int readUnsignedShort() {
        this.align(2);
        this.pos += 2;
        int b0 = this.buffer[this.pos++] & 0xFF;
        int b1 = this.buffer[this.pos++] & 0xFF;
        return (b0 << 8) + (b1 << 0);
    }

    public int read_long() {
        this.align(4);
        int b0 = this.buffer[this.pos++] & 0xFF;
        int b1 = this.buffer[this.pos++] & 0xFF;
        int b2 = this.buffer[this.pos++] & 0xFF;
        int b3 = this.buffer[this.pos++] & 0xFF;
        int val = this.littleEndian ? b0 + (b1 << 8) + (b2 << 16) + (b3 << 24) : (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
        return val;
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        int vh;
        int vl;
        this.align(8);
        int b0 = this.buffer[this.pos++] & 0xFF;
        int b1 = this.buffer[this.pos++] & 0xFF;
        int b2 = this.buffer[this.pos++] & 0xFF;
        int b3 = this.buffer[this.pos++] & 0xFF;
        int b4 = this.buffer[this.pos++] & 0xFF;
        int b5 = this.buffer[this.pos++] & 0xFF;
        int b6 = this.buffer[this.pos++] & 0xFF;
        int b7 = this.buffer[this.pos++] & 0xFF;
        if (this.littleEndian) {
            vl = b0 + (b1 << 8) + (b2 << 16) + (b3 << 24);
            vh = b4 + (b5 << 8) + (b6 << 16) + (b7 << 24);
        } else {
            vh = (b0 << 24) + (b1 << 16) + (b2 << 8) + b3;
            vl = (b4 << 24) + (b5 << 16) + (b6 << 8) + b7;
        }
        long val = ((long)vh << 32) + ((long)vl & 0xFFFFFFFFL);
        return val;
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public float read_float() {
        return Float.intBitsToFloat(this.read_long());
    }

    public double read_double() {
        return Double.longBitsToDouble(this.read_longlong());
    }

    private void checkString(int len) {
        int p;
        int l = len + this.pos;
        for (p = this.pos; p < l; ++p) {
            if (this.buffer[p] != 0) continue;
            throw new MARSHAL();
        }
        if (this.buffer[p] != 0) {
            throw new MARSHAL();
        }
    }

    private void checkWString(int len) {
        int p = this.pos;
        for (int i = 0; i < len; ++i) {
            if (this.buffer[p++] != 0 || this.buffer[p++] != 0) continue;
            throw new MARSHAL();
        }
        if (this.buffer[p++] != 0 || this.buffer[p++] != 0) {
            throw new MARSHAL();
        }
    }

    public String read_string() {
        int len = this.read_long();
        this.checkString(--len);
        String s = new String(this.buffer, this.pos, len);
        this.pos += len + 1;
        return s;
    }

    public String read_wstring() {
        char[] s;
        int len = this.read_long();
        switch (this.tcs_w) {
            case 1: {
                s = this.readUTF();
                break;
            }
            default: {
                s = new char[len];
                for (int i = 0; i < len; ++i) {
                    s[i] = (char)this.read_short();
                }
            }
        }
        return new String(s, 0, --len);
    }

    private char[] readUTF() {
        int utflen = this.readUnsignedShort();
        char[] str = new char[utflen];
        int count = 0;
        int strlen = 0;
        int i = 0;
        while (count < utflen) {
            int c = this.buffer[i] & 0xFF;
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    str[strlen++] = (char)c;
                    break;
                }
                case 12: 
                case 13: {
                    int char2;
                    if ((count += 2) > utflen) {
                        throw new MARSHAL("Bad UTF format (1)");
                    }
                    if (((char2 = this.buffer[++i] & 0xFF) & 0xC0) != 128) {
                        throw new MARSHAL("Bad UTF format (2)");
                    }
                    str[strlen++] = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3) > utflen) {
                        throw new MARSHAL("Bad UTF format (3)");
                    }
                    int char2 = this.buffer[++i] & 0xFF;
                    int char3 = this.buffer[++i] & 0xFF;
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new MARSHAL("Bad UTF format (4)");
                    }
                    str[strlen++] = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new MARSHAL("Bad UTF format (5)");
                }
            }
            ++i;
        }
        return str;
    }

    public void read_octet_array(byte[] value, int offset, int length) {
        System.arraycopy(this.buffer, this.pos, value, offset, length);
        this.pos += length;
    }

    public void fill(int size) {
        try {
            int read = this.in.read(this.buffer, this.pos, size);
            if (read < 0) {
                throw new COMM_FAILURE("Unexpected EOF");
            }
        }
        catch (InterruptedIOException e) {
            throw new TimeoutException(e.getMessage());
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public void read_boolean_array(boolean[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_boolean();
        }
    }

    public void read_char_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_char();
        }
    }

    public void read_wchar_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_wchar();
        }
    }

    public void read_short_array(short[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_short();
        }
    }

    public void read_ushort_array(short[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_short();
        }
    }

    public void read_long_array(int[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_long();
        }
    }

    public void read_ulong_array(int[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_long();
        }
    }

    public void read_longlong_array(long[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_longlong();
        }
    }

    public void read_ulonglong_array(long[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_longlong();
        }
    }

    public void read_float_array(float[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_float();
        }
    }

    public void read_double_array(double[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            value[offset++] = this.read_double();
        }
    }

    public Object read_Object() {
        return null;
    }

    public IpStream readEncapsulation() {
        int len = this.read_long();
        byte[] data = new byte[len];
        this.read_octet_array(data, 0, len);
        IpStream ip = new IpStream(data);
        ip.read_endian();
        return ip;
    }

    public boolean startEncapsulation() {
        int len = this.read_long();
        boolean origLittleEndian = this.littleEndian;
        this.read_endian();
        return origLittleEndian;
    }

    public org.omg.CORBA.TypeCode read_TypeCode() {
        return TypeCode.read_typecode(this);
    }

    public org.omg.CORBA.Any read_any() {
        Any value = new Any(ERORB.init());
        org.omg.CORBA.TypeCode t = this.read_TypeCode();
        value.read_value(this, t);
        return value;
    }

    public Principal read_Principal() {
        return null;
    }
}

