/*
 * Decompiled with CFR 0.152.
 */
package engroom.CORBA;

import engroom.CORBA.IpStream;
import engroom.CORBA.TypeCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.portable.InputStream;

public class OpStream
extends org.omg.CORBA.portable.OutputStream {
    private static final int BUFF_SIZE = 2048;
    private OutputStream out = null;
    private Socket socket;
    private byte[] buffer = new byte[2048];
    private int pos = 0;
    private int written = 0;
    private int reserved = 0;
    private boolean autoFlush = false;
    private boolean stubIgnore;
    private int tcs_w;
    private int size = 2048;
    public static final int TCS_W_NONE = 0;
    public static final int TCS_W_UTF_8 = 1;
    public static final int UTF_8 = 1;

    public OpStream(Socket _socket) throws IOException {
        this(_socket.getOutputStream());
        this.socket = _socket;
        this.tcs_w = 0;
    }

    public OpStream() {
    }

    public OpStream(OutputStream _out) {
        this();
        this.out = _out;
    }

    private void resize(int newSize) {
        if (newSize > this.size) {
            byte[] b = new byte[newSize];
            System.arraycopy(this.buffer, 0, b, 0, this.pos);
            this.buffer = b;
            this.size = newSize;
        }
    }

    private void require(int s) {
        if (this.pos + s > this.size) {
            this.resize(this.size + (s > 2048 ? s : 2048));
        }
    }

    protected OutputStream getOpStream() {
        return this.out;
    }

    public void stub_ignore() {
        this.stubIgnore = true;
    }

    public void copyFrom(IpStream ip, int size) {
        byte[] value = new byte[size];
        ip.read_octet_array(value, 0, size);
        this.write_octet_array(value, 0, value.length);
    }

    public InputStream create_input_stream() {
        if (this.stubIgnore) {
            this.stubIgnore = false;
            return null;
        }
        if (this.socket == null) {
            if (this.out instanceof ByteArrayOutputStream) {
                this.flush();
                byte[] b = ((ByteArrayOutputStream)this.out).toByteArray();
                return new IpStream(b);
            }
        } else {
            try {
                IpStream ipStream = new IpStream(this.socket.getInputStream());
                return ipStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private void iFlush() {
        try {
            this.out.write(this.buffer, 0, this.pos);
            this.written += this.pos;
            this.pos = 0;
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public void flush() {
        try {
            this.iFlush();
            this.out.flush();
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public int flushAll() {
        this.flush();
        int sz = this.size();
        this.written = 0;
        this.reserved = 0;
        return sz;
    }

    private void align(int sz) {
        int mod = (this.written + this.reserved + this.pos) % sz;
        if (mod != 0) {
            this.pos += sz - mod;
        }
    }

    public int size() {
        return this.pos + this.written;
    }

    public void reserve(int r) {
        this.reserved = r;
    }

    public void writeEncapsulation(OpStream op) {
        int len = op.pos;
        this.write_long(len);
        this.write_octet_array(op.buffer, 0, len);
    }

    public static OpStream createEncapsulation() {
        OpStream op = new OpStream();
        op.write_octet((byte)0);
        return op;
    }

    public void write_boolean(boolean value) {
        this.require(1);
        this.buffer[this.pos++] = (byte)(value ? 1 : 0);
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_char(char value) {
        this.require(1);
        this.buffer[this.pos++] = (byte)value;
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_wchar(char value) {
        this.require(2);
        switch (this.tcs_w) {
            case 1: {
                char[] array = new char[]{value};
                this.write_wide(array, null, 0, 1);
                break;
            }
            default: {
                this.write_short((short)value);
                break;
            }
        }
    }

    public void write_octet(byte value) {
        this.require(1);
        this.buffer[this.pos++] = value;
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_short(short value) {
        this.require(2);
        this.align(2);
        this.buffer[this.pos++] = (byte)(value >>> 8 & 0xFF);
        this.buffer[this.pos++] = (byte)(value >>> 0 & 0xFF);
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_ushort(short value) {
        this.write_short(value);
    }

    public void write_long(int value) {
        this.require(4);
        this.align(4);
        this.buffer[this.pos++] = (byte)(value >>> 24 & 0xFF);
        this.buffer[this.pos++] = (byte)(value >>> 16 & 0xFF);
        this.buffer[this.pos++] = (byte)(value >>> 8 & 0xFF);
        this.buffer[this.pos++] = (byte)(value >>> 0 & 0xFF);
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_ulong(int value) {
        this.write_long(value);
    }

    public void write_longlong(long value) {
        this.require(8);
        this.align(8);
        this.buffer[this.pos++] = (byte)(value >>> 56 & (long)255);
        this.buffer[this.pos++] = (byte)(value >>> 48 & (long)255);
        this.buffer[this.pos++] = (byte)(value >>> 40 & (long)255);
        this.buffer[this.pos++] = (byte)(value >>> 32 & (long)255);
        this.buffer[this.pos++] = (byte)(value >>> 24 & (long)255);
        this.buffer[this.pos++] = (byte)(value >>> 16 & (long)255);
        this.buffer[this.pos++] = (byte)(value >>> 8 & (long)255);
        this.buffer[this.pos++] = (byte)(value >>> 0 & (long)255);
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_ulonglong(long value) {
        this.write_longlong(value);
    }

    public void write_float(float value) {
        this.write_long(Float.floatToIntBits(value));
    }

    public void write_double(double value) {
        this.write_longlong(Double.doubleToLongBits(value));
    }

    public void write_string(String value) {
        if (value == null) {
            this.nullValue("write_string");
        }
        int len = value.length();
        this.write_long(len + 1);
        this.write_octet_array(value.getBytes(), 0, len);
        this.write_octet((byte)0);
    }

    public void write_wstring(String value) {
        if (value == null) {
            this.nullValue("write_wstring");
        }
        int len = value.length();
        this.write_long(len + 1);
        switch (this.tcs_w) {
            case 1: {
                this.write_wide(null, value, 0, value.length());
                break;
            }
            default: {
                for (int i = 0; i < len; ++i) {
                    this.write_short((short)value.charAt(i));
                }
            }
        }
        this.write_short((short)0);
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_wchar_array(char[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_wchar_array");
        }
        switch (this.tcs_w) {
            case 1: {
                this.write_wide(value, null, offset, length);
                break;
            }
            default: {
                int i = 0;
                while (i < length) {
                    this.write_short((short)value[offset]);
                    ++i;
                    ++offset;
                }
                break block0;
            }
        }
    }

    private void write_wide(char[] value, String str, int offset, int length) {
        if (value == null) {
            this.nullValue("write_wide");
        }
        int utflen = 0;
        int till = offset + length;
        int total = str == null ? value.length : str.length();
        if (till > total) {
            throw new BAD_PARAM("Offset+length exceeds size");
        }
        this.require(total * 2);
        for (int i = offset; i < till; ++i) {
            char c = str == null ? value[i] : str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new BAD_PARAM("too many chars for UTF transmission");
        }
        this.buffer[this.pos++] = (byte)(utflen >>> 8 & 0xFF);
        this.buffer[this.pos++] = (byte)(utflen >>> 0 & 0xFF);
        for (int i = offset; i < till; ++i) {
            char c = str == null ? value[i] : str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                this.buffer[this.pos++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.buffer[this.pos++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[this.pos++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[this.pos++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void writeAny(int alignment, byte[] value) {
        this.align(alignment);
        this.write_octet_array(value, 0, value.length);
    }

    public void write_octet_array(byte[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_octet_array");
        }
        int len = value.length;
        this.require(len);
        if (offset + length > len) {
            throw new MARSHAL("offset+length > array size in write_octet_array");
        }
        while (length > 0) {
            int left = this.size - this.pos;
            int copy = length > left ? left : length;
            System.arraycopy(value, offset, this.buffer, this.pos, copy);
            length -= copy;
            offset += copy;
            this.pos += copy;
        }
        if (this.autoFlush) {
            this.iFlush();
        }
    }

    public void write_boolean_array(boolean[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_boolean_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_boolean(value[offset++]);
        }
    }

    public void write_char_array(char[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_char_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_char(value[offset++]);
        }
    }

    public void write_short_array(short[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_short_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_short(value[offset++]);
        }
    }

    public void write_ushort_array(short[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_ushort_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_short(value[offset++]);
        }
    }

    public void write_long_array(int[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_long_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_long(value[offset++]);
        }
    }

    public void write_ulong_array(int[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_ulong_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_long(value[offset++]);
        }
    }

    public void write_longlong_array(long[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_longlong_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_longlong(value[offset++]);
        }
    }

    public void write_ulonglong_array(long[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_ulonglong_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_longlong(value[offset++]);
        }
    }

    public void write_float_array(float[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_float_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_float(value[offset++]);
        }
    }

    public void write_double_array(double[] value, int offset, int length) {
        if (value == null) {
            this.nullValue("write_double_array");
        }
        for (int i = 0; i < length; ++i) {
            this.write_double(value[offset++]);
        }
    }

    public void write_Object(Object value) {
    }

    public void write_TypeCode(org.omg.CORBA.TypeCode value) {
        if (value == null) {
            this.nullValue("write_TypeCode");
        }
        ((TypeCode)value).write_value(this);
    }

    public void write_any(Any value) {
        if (value == null) {
            this.nullValue("write_any");
        }
        this.write_TypeCode(value.type());
        value.write_value(this);
    }

    public void write_Principal(Principal value) {
    }

    private void nullValue(String msg) {
        throw new MARSHAL(String.valueOf("value is null in ").concat(String.valueOf(msg)));
    }
}

