/*
 * Decompiled with CFR 0.152.
 */
package engroom.CORBA;

import engroom.CORBA.ERORB;
import engroom.CORBA.ERObject;
import engroom.CORBA.GIOP_MessageHeader_1_1;
import engroom.CORBA.GIOP_ReplyHeader;
import engroom.CORBA.GIOP_RequestHeader_1_1;
import engroom.CORBA.IpStream;
import engroom.CORBA.OpStream;
import engroom.util.ThreadPoolRunnable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_IMPLEMENT;

public class Proxy
extends ERObject
implements ThreadPoolRunnable {
    private String targetAddress;
    private int targetPort;
    private int localPort;
    private Socket targetSocket;
    private ServerSocket sSock;
    private boolean reserved;
    public IpStream targetIn;
    public OpStream targetOut;

    public Proxy(String address, int port, int localP) {
        this.setAddress(address);
        this.setPort(port);
        this.targetSocket = null;
        try {
            this.sSock = localP == 0 ? ERORB.getServerSocket() : new ServerSocket(localP);
            this.sSock.setSoTimeout(10000);
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public Proxy() {
        this(null, 0, 0);
    }

    public synchronized boolean reserve() {
        if (!this.reserved) {
            this.reserved = true;
            return true;
        }
        return false;
    }

    public synchronized boolean release() {
        if (this.reserved) {
            this.reserved = false;
            return true;
        }
        return false;
    }

    public void setAddress(String address) {
        this.targetAddress = address;
    }

    public void setPort(int port) {
        this.targetPort = port;
    }

    public InetAddress getInetAddress() {
        return this.sSock.getInetAddress();
    }

    public int getLocalPort() {
        return this.sSock.getLocalPort();
    }

    /*
     * Loose catch block
     */
    private Socket waitForClientConnect() {
        while (true) {
            try {
                Socket client;
                this.sSock.setSoTimeout(10000);
                Socket socket = client = this.sSock.accept();
                return socket;
            }
            catch (InterruptedIOException e) {
                System.out.print('+');
                System.out.flush();
                continue;
            }
            break;
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public void run() {
        block4: while (true) {
            try {
                while (true) {
                    this.client = this.waitForClientConnect();
                    this.connectToTarget();
                    try {
                        this._server();
                        continue block4;
                    }
                    catch (COMM_FAILURE e) {
                        this.disconnect();
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.disconnect();
                this.release();
                System.out.println("Proxy dies");
                throw throwable;
            }
        }
    }

    protected void setupStreams() throws IOException {
        super.setupStreams();
        this.targetOut = new OpStream(this.targetSocket);
        this.targetIn = (IpStream)this.targetOut.create_input_stream();
    }

    private void connectToTarget() {
        if (this.targetAddress == null) {
            throw new COMM_FAILURE("Proxy target address not set");
        }
        if (this.targetPort == 0) {
            throw new COMM_FAILURE("Proxy target port not set");
        }
        try {
            this.targetSocket = new Socket(this.targetAddress, this.targetPort);
            this.setupStreams();
        }
        catch (IOException e) {
            throw new COMM_FAILURE(e.getMessage());
        }
    }

    public void disconnect() {
        try {
            if (this.targetSocket != null) {
                this.targetSocket.close();
                this.targetSocket = null;
            }
            if (this.client != null) {
                this.client.close();
                this.client = null;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _server() {
        GIOP_MessageHeader_1_1 hdr;
        while (true) {
            this.in.alignZero();
            this.dout.flushAll();
            hdr = GIOP_MessageHeader_1_1.read(this.in);
            if (this.trace) {
                hdr.print();
            }
            if (hdr.message_type != 0) break;
            GIOP_RequestHeader_1_1 rh = GIOP_RequestHeader_1_1.read(this.in, this.out);
            if (this.trace) {
                rh.print();
            }
            int size = hdr.message_size + 12;
            this.targetOut.copyFrom(this.in, size);
            this.targetOut.flushAll();
            this.targetIn.alignZero();
            if (!rh.respond()) continue;
            hdr = GIOP_MessageHeader_1_1.read(this.targetIn);
            if (this.trace) {
                hdr.print();
            }
            if (hdr.message_type == 1) {
                GIOP_ReplyHeader rhp = GIOP_ReplyHeader.read(this.targetIn);
                if (this.trace) {
                    rhp.print();
                }
            }
            size = hdr.message_size + 12;
            this.dout.copyFrom(this.targetIn, size);
        }
        throw new NO_IMPLEMENT(String.valueOf("Expected GIOP.Reply - got ").concat(String.valueOf(hdr.message_type)));
    }
}

