/*
 * Decompiled with CFR 0.152.
 */
package engroom.CORBA;

import engroom.CORBA.Any;
import engroom.CORBA.ERORB;
import engroom.CORBA.IpStream;
import engroom.CORBA.OpStream;
import java.util.Hashtable;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TypeCode
extends org.omg.CORBA.TypeCode {
    private static TypeCode octetType = new TypeCode(TCKind.from_int(10));
    private TCKind k;
    private String id;
    private String name;
    private StructMember[] structMembers;
    private UnionMember[] unionMembers;
    private String[] enumMembers;
    private TypeCode type;
    private int length;
    private int defaultCase;

    public TypeCode(TCKind _k) {
        this.k = _k;
        this.length = 0;
    }

    public boolean equal(org.omg.CORBA.TypeCode tc) {
        if (this == tc) {
            return true;
        }
        int v = tc.kind().value();
        if (this.k.value() != v) {
            return false;
        }
        TypeCode Tc = (TypeCode)tc;
        switch (v) {
            case 15: 
            case 22: {
                return this.structEqual(Tc);
            }
            case 16: {
                return this.unionEqual(Tc);
            }
            case 21: {
                return this.aliasEqual(Tc);
            }
            case 20: {
                return this.arrayEqual(Tc);
            }
            case 18: {
                if (Tc.length == this.length) break;
                return false;
            }
            case 19: {
                return this.sequenceEqual(Tc);
            }
            case 17: {
                return this.enumEqual(Tc);
            }
        }
        return true;
    }

    public TCKind kind() {
        return this.k;
    }

    public String id() throws BadKind {
        return this.id;
    }

    public String name() throws BadKind {
        return this.name;
    }

    public int member_count() throws BadKind {
        if (this.structMembers != null) {
            return this.structMembers.length;
        }
        if (this.unionMembers != null) {
            return this.unionMembers.length;
        }
        if (this.enumMembers != null) {
            return this.enumMembers.length;
        }
        throw new BadKind();
    }

    public String member_name(int index) throws BadKind {
        try {
            if (this.structMembers != null) {
                String string = this.structMembers[index].name;
                return string;
            }
            if (this.unionMembers != null) {
                String string = this.unionMembers[index].name;
                return string;
            }
            if (this.enumMembers != null) {
                String string = this.enumMembers[index];
                return string;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BadKind();
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode member_type(int index) throws BadKind {
        try {
            if (this.structMembers != null) {
                org.omg.CORBA.TypeCode typeCode = this.structMembers[index].type;
                return typeCode;
            }
            if (this.unionMembers != null) {
                org.omg.CORBA.TypeCode typeCode = this.unionMembers[index].type;
                return typeCode;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new BadKind();
        }
        throw new BadKind();
    }

    public org.omg.CORBA.Any member_label(int index) throws BadKind {
        if (this.unionMembers != null) {
            try {
                if (this.unionMembers != null) {
                    org.omg.CORBA.Any any = this.unionMembers[index].value;
                    return any;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new BadKind();
            }
        }
        throw new BadKind();
    }

    public org.omg.CORBA.TypeCode discriminator_type() throws BadKind {
        if (this.unionMembers != null) {
            return this.type;
        }
        throw new BadKind();
    }

    public int default_index() throws BadKind {
        if (this.unionMembers == null) {
            throw new BadKind();
        }
        for (int i = 0; i < this.unionMembers.length; ++i) {
            if (!this.unionMembers[i].name.equals("default")) continue;
            return i;
        }
        return -1;
    }

    public int length() throws BadKind {
        return this.length;
    }

    public void tooLong(int l) {
        switch (this.k.value()) {
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            default: {
                throw new MARSHAL("Type has no length");
            }
        }
        if (this.length != 0 && l > this.length) {
            throw new MARSHAL("Type too long");
        }
    }

    public org.omg.CORBA.TypeCode content_type() throws BadKind {
        throw new BadKind();
    }

    public void write_value(OutputStream os) {
        switch (this.k.value()) {
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 18: 
            case 27: {
                os.write_long(this.k.value());
                os.write_long(this.length);
                return;
            }
            case 11: 
            case 14: {
                return;
            }
            default: {
                os.write_long(this.k.value());
                return;
            }
        }
        os.write_long(this.k.value());
        OpStream enc = OpStream.createEncapsulation();
        switch (this.k.value()) {
            case 16: {
                this.writeUnion(enc);
                break;
            }
            case 21: {
                this.writeAlias(enc);
                break;
            }
            case 15: 
            case 22: {
                this.writeStruct(enc);
                break;
            }
            case 20: {
                this.writeArray(enc);
                break;
            }
            case 19: {
                this.writeSequence(enc);
                break;
            }
            case 17: {
                this.writeEnum(enc);
            }
        }
        ((OpStream)os).writeEncapsulation(enc);
    }

    public static TypeCode read_typecode(InputStream is) {
        Hashtable codes = new Hashtable();
        return TypeCode.read_tc(is, codes);
    }

    private static TypeCode read_tc(InputStream inStream, Hashtable codes) {
        IpStream is = (IpStream)inStream;
        int simple = is.read_long();
        int key = is.current_offset();
        TypeCode t = new TypeCode(TCKind.from_int(simple));
        codes.put(new Integer(key), t);
        switch (simple) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: {
                return t;
            }
            case 18: 
            case 27: {
                t.length = is.read_long();
                return t;
            }
            case -1: {
                int offset = is.read_long();
                int newKey = key + offset + 5;
                TypeCode newT = (TypeCode)codes.get(new Integer(newKey));
                if (newT == null) {
                    throw new MARSHAL(String.valueOf("No Typecode at reference ").concat(String.valueOf(offset)));
                }
                codes.put(new Integer(key), newT);
                return newT;
            }
        }
        boolean origEndian = is.startEncapsulation();
        switch (simple) {
            case 15: {
                t.readStruct(is, codes);
                break;
            }
            case 16: {
                t.readUnion(is, codes);
                break;
            }
            case 20: {
                t.readArray(is, codes);
                break;
            }
            case 21: {
                t.readAlias(is, codes);
                break;
            }
            case 19: {
                t.readSequence(is, codes);
                break;
            }
            case 17: {
                t.readEnum(is);
                break;
            }
        }
        is.setEndian(origEndian);
        return t;
    }

    public void read_value(InputStream is, OutputStream os) {
        int t = this.k.value();
        switch (t) {
            case 2: 
            case 4: {
                os.write_short(is.read_short());
                break;
            }
            case 26: {
                os.write_wchar(is.read_wchar());
                break;
            }
            case 3: 
            case 5: {
                os.write_long(is.read_long());
                break;
            }
            case 6: {
                os.write_float(is.read_float());
                break;
            }
            case 18: {
                String s = is.read_string();
                if (this.length != 0 && s.length() > this.length) {
                    throw new MARSHAL(String.valueOf(String.valueOf(String.valueOf("String is ").concat(String.valueOf(s.length()))).concat(String.valueOf(" - larger than "))).concat(String.valueOf(this.length)));
                }
                os.write_string(s);
                break;
            }
            case 27: {
                os.write_wstring(is.read_wstring());
                break;
            }
            case 12: {
                os.write_TypeCode(is.read_TypeCode());
                break;
            }
            case 7: {
                os.write_double(is.read_double());
                break;
            }
            case 23: 
            case 24: {
                os.write_longlong(is.read_longlong());
                break;
            }
            case 8: {
                os.write_boolean(is.read_boolean());
                break;
            }
            case 9: {
                os.write_char(is.read_char());
                break;
            }
            case 10: {
                os.write_octet(is.read_octet());
                break;
            }
            case 15: 
            case 22: {
                this.read_struct_value(is, os);
                break;
            }
            case 16: {
                this.read_union_value(is, os);
                break;
            }
            case 20: {
                this.read_array_value(is, os);
                break;
            }
            case 21: {
                this.read_alias_value(is, os);
                break;
            }
            case 19: {
                this.read_sequence_value(is, os);
                break;
            }
            case 17: {
                os.write_long(is.read_long());
                break;
            }
            default: {
                ERORB.notimplemented(String.valueOf("read_value ").concat(String.valueOf(t)));
                break;
            }
        }
    }

    public void struct(String _id, String _name, StructMember[] members) {
        this.id = _id;
        this.name = _name;
        this.structMembers = members;
    }

    private void readStruct(InputStream is, Hashtable codes) {
        String id = is.read_string();
        String name = is.read_string();
        int l = is.read_long();
        StructMember[] members = new StructMember[l];
        for (int i = 0; i < l; ++i) {
            String n = is.read_string();
            TypeCode t = TypeCode.read_tc(is, codes);
            members[i] = new StructMember(n, t, null);
        }
        this.struct(id, name, members);
    }

    private void read_struct_value(InputStream is, OutputStream os) {
        int l = this.structMembers.length;
        for (int i = 0; i < l; ++i) {
            ((TypeCode)this.structMembers[i].type).read_value(is, os);
        }
    }

    private void writeStruct(OutputStream out) {
        out.write_string(this.id);
        out.write_string(this.name);
        int l = this.structMembers.length;
        out.write_long(l);
        for (int i = 0; i < l; ++i) {
            out.write_string(this.structMembers[i].name);
            ((TypeCode)this.structMembers[i].type).write_value(out);
        }
    }

    private boolean StructMemberEquals(StructMember one, StructMember two) {
        if (!one.name.equals(two.name)) {
            return false;
        }
        return one.type.equal(two.type);
    }

    private boolean structEqual(TypeCode tc) {
        int len = tc.structMembers.length;
        if (tc.structMembers.length != len) {
            return false;
        }
        if (!tc.id.equals(this.id)) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < len && result; ++i) {
            result = this.StructMemberEquals(this.structMembers[i], tc.structMembers[i]);
        }
        return result;
    }

    public void alias(String _id, String _name, TypeCode original_type) {
        this.id = _id;
        this.name = _name;
        this.type = original_type;
    }

    private boolean aliasEqual(TypeCode tc) {
        return this.type.equal(tc.type);
    }

    private void readAlias(InputStream is, Hashtable codes) {
        this.id = is.read_string();
        this.name = is.read_string();
        this.type = TypeCode.read_tc(is, codes);
    }

    private void writeAlias(OutputStream out) {
        out.write_string(this.id);
        out.write_string(this.name);
        out.write_TypeCode(this.type);
    }

    private void read_alias_value(InputStream is, OutputStream os) {
        this.type.read_value(is, os);
    }

    public void union(String _id, String _name, TypeCode discriminator_type, UnionMember[] members) {
        this.id = _id;
        this.name = _name;
        this.type = discriminator_type;
        this.unionMembers = members;
        int l = this.unionMembers.length;
        this.defaultCase = -1;
        for (int i = 0; i < l; ++i) {
            if (!octetType.equal(this.unionMembers[i].value.type())) continue;
            this.defaultCase = i;
            break;
        }
    }

    private void readUnion(InputStream is, Hashtable codes) {
        this.id = is.read_string();
        this.name = is.read_string();
        this.type = TypeCode.read_tc(is, codes);
        this.defaultCase = is.read_long();
        int count = is.read_long();
        this.unionMembers = new UnionMember[count];
        for (int i = 0; i < count; ++i) {
            Any a = new Any(ERORB.init());
            a.read_value(is, this.type);
            String n = is.read_string();
            TypeCode memT = TypeCode.read_tc(is, codes);
            this.unionMembers[i] = new UnionMember(n, a, memT, null);
        }
    }

    private void writeUnion(OutputStream out) {
        out.write_string(this.id);
        out.write_string(this.name);
        out.write_TypeCode(this.type);
        out.write_long(this.defaultCase);
        int l = this.unionMembers.length;
        out.write_long(l);
        for (int i = 0; i < l; ++i) {
            this.unionMembers[i].value.write_value(out);
            out.write_string(this.unionMembers[i].name);
            out.write_TypeCode(this.unionMembers[i].type);
        }
    }

    private boolean unionEqual(TypeCode t) {
        if (!this.id.equals(t.id)) {
            return false;
        }
        if (!this.type.equal(t.type)) {
            return false;
        }
        if (this.defaultCase != t.defaultCase) {
            return false;
        }
        int l = this.unionMembers.length;
        if (l != t.unionMembers.length) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (!this.unionMembers[i].name.equals(t.unionMembers[i].name)) {
                return false;
            }
            if (this.unionMembers[i].type.equal(t.unionMembers[i].type)) continue;
            return false;
        }
        return true;
    }

    private void read_union_value(InputStream is, OutputStream os) {
        Any a = new Any(ERORB.init());
        IpStream in = (IpStream)is;
        in.mark();
        a.read_value(in, this.type);
        in.reset();
        this.type.read_value(is, os);
        int l = this.unionMembers.length;
        int use = this.defaultCase;
        for (int i = 0; i < l; ++i) {
            if (!a.equal(this.unionMembers[i].value)) continue;
            use = i;
            break;
        }
        if (use < 0) {
            throw new BAD_TYPECODE();
        }
        UnionMember m = this.unionMembers[use];
        ((TypeCode)m.type).read_value(is, os);
    }

    public void sequence(int bounds, TypeCode sequenceType) {
        this.length = bounds;
        this.type = sequenceType;
    }

    private boolean sequenceEqual(TypeCode t) {
        if (this.length != t.length) {
            return false;
        }
        return this.type.equal(t.type);
    }

    private void readSequence(InputStream is, Hashtable codes) {
        this.type = TypeCode.read_tc(is, codes);
        this.length = is.read_long();
    }

    private void writeSequence(OutputStream out) {
        out.write_TypeCode(this.type);
        out.write_long(this.length);
    }

    private void read_sequence_value(InputStream is, OutputStream os) {
        int l = is.read_long();
        if (this.length != 0 && l > this.length) {
            throw new MARSHAL(String.valueOf(String.valueOf(String.valueOf("Sequence has ").concat(String.valueOf(l))).concat(String.valueOf(" elements - longer than "))).concat(String.valueOf(this.length)));
        }
        os.write_long(l);
        for (int i = 0; i < l; ++i) {
            this.type.read_value(is, os);
        }
    }

    public void array(int len, TypeCode arrayType) {
        this.length = len;
        this.type = arrayType;
    }

    private boolean arrayEqual(TypeCode t) {
        if (this.length != t.length) {
            return false;
        }
        return this.type.equal(t.type);
    }

    private void readArray(InputStream is, Hashtable codes) {
        TypeCode t = TypeCode.read_tc(is, codes);
        int len = is.read_long();
        this.array(len, t);
    }

    private void writeArray(OutputStream out) {
        out.write_TypeCode(this.type);
        out.write_long(this.length);
    }

    private void read_array_value(InputStream is, OutputStream os) {
        for (int i = 0; i < this.length; ++i) {
            this.type.read_value(is, os);
        }
    }

    public void enum(String _id, String _name, String[] members) {
        this.id = _id;
        this.name = _name;
        this.enumMembers = members;
    }

    private boolean enumEqual(TypeCode t) {
        int l = this.enumMembers.length;
        if (l != t.enumMembers.length) {
            return false;
        }
        for (int i = 0; i < l; ++i) {
            if (this.enumMembers[i].equals(t.enumMembers[i])) continue;
            return false;
        }
        return true;
    }

    private void readEnum(InputStream is) {
        this.id = is.read_string();
        this.name = is.read_string();
        int l = is.read_long();
        this.enumMembers = new String[l];
        for (int i = 0; i < l; ++i) {
            this.enumMembers[i] = is.read_string();
        }
    }

    private void writeEnum(OutputStream out) {
        out.write_string(this.id);
        out.write_string(this.name);
        int l = this.enumMembers.length;
        out.write_long(l);
        for (int i = 0; i < l; ++i) {
            out.write_string(this.enumMembers[i]);
        }
    }

    public void interfaceTc(String _id, String _name) {
        this.id = _id;
        this.name = _name;
    }

    public void bounds(int len) {
        this.length = len;
    }
}

