/*
 * Decompiled with CFR 0.152.
 */
package engroom.util;

import engroom.util.ThreadPoolObject;
import engroom.util.ThreadPoolRunnable;
import java.util.Vector;

public class ThreadPool {
    private Vector objects;
    private int maxSize;

    public ThreadPool(int max) {
        this.setMax(max);
        this.objects = new Vector();
    }

    public ThreadPool() {
        this(-1);
    }

    public boolean noLimit() {
        return this.maxSize == -1;
    }

    public void setMax(int m) {
        this.maxSize = m;
    }

    public int size() {
        return this.objects.size();
    }

    public synchronized ThreadPoolObject reserve() {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            ThreadPoolObject o = (ThreadPoolObject)this.objects.elementAt(i);
            if (!o.reserve()) continue;
            return o;
        }
        return null;
    }

    public synchronized ThreadPoolObject addElement(ThreadGroup tg, ThreadPoolRunnable o, String name) {
        if (!this.noLimit() && this.size() == this.maxSize) {
            return null;
        }
        ThreadPoolObject tpo = new ThreadPoolObject(tg, o, name);
        this.objects.addElement(tpo);
        return tpo;
    }
}

