# Project Includes

.SUFFIXES: .c .cpp

!ifndef CCD
CCD=\\bc5             # change these lines for your compiler
!endif

!ifndef CORBAD
CORBAD=\\ercorba      # and installation directory
!endif

# CODEGUARD=1
# DBF=-v

INCLH=-I$(CORBAD)\h;$(CCD)\include;.
CFLAGS=-c -w $(DBF) -r- -wpia- $(INCLH)
BIN=$(CCD)\bin
SLIBD=$(CCD)\lib
IMPLIB=$(BIN)\implib
CC=bcc32
RC=$(BIN)\brc32
RCFLAGS=-w32 -v $(INCLH) -r

CORBA_TCPIP_LIB     = $(CORBAD)\lib\orb.lib

SHELL_EX=.bat

LKFLAGS=-Tpe -c $(DBF) -S:10000
STARTOBJ = $(SLIBD)\c0x32
SLIB=$(SLIBD)\cw32.lib $(SLIBD)\import32.lib
SLIB_MT=$(SLIBD)\cw32mt.lib $(SLIBD)\import32.lib

!ifdef CODEGUARD
CFLAGS=$(CFLAGS) -vG 
SLIB=$(SLIBD)\cg32.lib $(SLIB)
SLIB_MT=$(SLIBD)\cg32.lib $(SLIB_MT)
!endif

SLIBDLL = $(SLIB)
CWE=-W
CWDLL=-WD

STARTOBJD = $(SLIBD)\c0d32

SDLL=$(SLIB)

LINKER=$(BIN)\tlink32
LKFLAGSD=-Tpd -aa -c -v

LKF=$(DBF)

LIBM=$(BIN)\tlib /P64
LIBFLAGS=-+
LIBFL1=
TYPE=type
COPY=copy
CREATE=echo >
TOUCH=touch
OEX=obj
OTRG=b3t
OOTRG=b3o
IM=im
BEFORE_FLAGS=$(CFLAGS)
AFTER_FLAGS=
COMPILE=$(CC) @$(CORBAD)\bci

RM=del

.c.obj:
    $(COMPILE) -o$*.obj $*.c > $*.err
    $(TYPE) $*.err

.cpp.obj:
    $(COMPILE) -o$*.obj $*.cpp > $*.err
    $(TYPE) $*.err

.rc.res:
    $(RC) $(RCFLAGS) $*.rc > $*.err
        $(TYPE) $*.err


